/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.tree;

import java.awt.Component;
import javax.swing.JMenuItem;
import org.robotframework.abbot.finder.BasicFinder;
import org.robotframework.abbot.finder.matchers.JMenuItemMatcher;
import org.robotframework.abbot.tester.ComponentTester;
import org.robotframework.abbot.tester.JComponentTester;
import org.robotframework.abbot.tester.JTreeLocation;
import org.robotframework.abbot.util.AWT;
import org.robotframework.swing.arguments.IdentifierHandler;
import org.robotframework.swing.tree.ITreePopupMenuItemFinder;
import org.robotframework.swing.tree.JTreeLocationFactory;

public class TreePopupMenuItemFinder
implements ITreePopupMenuItemFinder {
    private BasicFinder basicFinder = new BasicFinder();
    private ComponentTester componentTester = new JComponentTester();
    private IdentifierHandler<JTreeLocation> treeLocationFactory = new JTreeLocationFactory();
    private final Component tree;

    public TreePopupMenuItemFinder(Component tree) {
        this.tree = tree;
        AWT.POPUP_TIMEOUT = 250000;
    }

    public JMenuItem findMenu(String nodeIdentifier, String menuPath) {
        return this.findMenu((JTreeLocation)this.treeLocationFactory.parseArgument(nodeIdentifier), menuPath);
    }

    private JMenuItem findMenu(JTreeLocation treeLocation, String menuPath) {
        this.popupMenuOnContainer(treeLocation);
        return this.findMenu(menuPath);
    }

    private void popupMenuOnContainer(JTreeLocation nodeLocation) {
        this.componentTester.actionShowPopupMenu(this.tree, nodeLocation);
    }

    private JMenuItem findMenu(String menuPath) {
        try {
            return (JMenuItem)this.basicFinder.find(new JMenuItemMatcher(menuPath));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

