/* Generated by Pyrex 0.9.6.3 on Wed Nov 21 21:47:54 2007 */

#define PY_SSIZE_T_CLEAN
#include "Python.h"
#include "structmember.h"
#ifndef PY_LONG_LONG
  #define PY_LONG_LONG LONG_LONG
#endif
#if PY_VERSION_HEX < 0x02050000
  typedef int Py_ssize_t;
  #define PY_SSIZE_T_MAX INT_MAX
  #define PY_SSIZE_T_MIN INT_MIN
  #define PyInt_FromSsize_t(z) PyInt_FromLong(z)
  #define PyInt_AsSsize_t(o)	PyInt_AsLong(o)
#endif
#ifndef WIN32
  #define __stdcall
  #define __cdecl
#endif
#ifdef __cplusplus
#define __PYX_EXTERN_C extern "C"
#else
#define __PYX_EXTERN_C extern
#endif
#include <math.h>
#include "stdlib.h"
#include "op_loops.h"


typedef struct {PyObject **p; char *s;} __Pyx_InternTabEntry; /*proto*/
typedef struct {PyObject **p; char *s; long n;} __Pyx_StringTabEntry; /*proto*/

static PyObject *__pyx_m;
static PyObject *__pyx_b;
static int __pyx_lineno;
static char *__pyx_filename;
static char **__pyx_f;

static char __pyx_mdoc[] = "\nStructArray allows you to perform fast arithmetic operations on\narrays of structured (or unstructured) data.\n\nThere are two classes you need to worry about:  ``Array`` and ``StructArray``.\n\n``Array`` does most of the work.  It provides a simple array of numbers.  Any\noperation performed on the array will be done on each item in it, blazing\nfast.  Multiple arrays of the same length can be\nadded/subtracted/multiplied/divided together, with the result stored in another\narray.\n\n``StructArray`` provides an almost object-oriented approach.  You pass a list\nof attribute names and ``StructArray`` creates an ``Array`` for each one.\nHowever, getting an item from the ``StructArray`` returns an object mapping\neach array\'s value to it\'s attributes, making it easier to work with a single\nitem.  The data is also interleaved together, making it suitable for use as an\nOpenGL vertex array.\n\n\nNotes on multidimensional arrays:\n\nMultidimensional arrays are mostly just a painsaver for item indexes.\n``array[x, y]`` is identical to ``array[x+y*width]``.  If fact, both forms of\nare valid for a multidimensional array.  ``len(array)`` always returns the\nnumber of items in the array, not the length in any particular direction.\n\nThere is an additional restriction on multidimensional arrays: they cannot be\nresized.  (This restriction could be lifted if there is demand.)\n\n";

static int __Pyx_ArgTypeTest(PyObject *obj, PyTypeObject *type, int none_allowed, char *name); /*proto*/

static PyObject *__Pyx_GetName(PyObject *dict, PyObject *name); /*proto*/

static void __Pyx_Raise(PyObject *type, PyObject *value, PyObject *tb); /*proto*/

static void __Pyx_WriteUnraisable(char *name); /*proto*/

static int __Pyx_GetException(PyObject **type, PyObject **value, PyObject **tb); /*proto*/

static PyObject *__Pyx_UnpackItem(PyObject *); /*proto*/
static int __Pyx_EndUnpack(PyObject *); /*proto*/

static int __Pyx_TypeTest(PyObject *obj, PyTypeObject *type); /*proto*/

static int __Pyx_InternStrings(__Pyx_InternTabEntry *t); /*proto*/

static int __Pyx_InitStrings(__Pyx_StringTabEntry *t); /*proto*/

static int __Pyx_SetVtable(PyObject *dict, void *vtable); /*proto*/

static void __Pyx_AddTraceback(char *funcname); /*proto*/

/* Declarations from structarray */

struct __pyx_obj_11structarray__BaseArray {
  PyObject_HEAD
  struct __pyx_vtabstruct_11structarray__BaseArray *__pyx_vtab;
  float *_data;
  int _allocated_size;
  int _count;
  int _stride;
  int _is_data_owner;
  struct __pyx_obj_11structarray__BaseArray *data_owner;
  int _is_assignable;
  PyObject *_dimensions;
};

struct __pyx_obj_11structarray_StructArray {
  struct __pyx_obj_11structarray__BaseArray __pyx_base;
  PyObject *_attributes;
  PyObject *_attribute_arrays;
  PyObject *_column_arrays;
  PyObject *_swizzles;
  PyObject *_defaults;
};

struct __pyx_obj_11structarray__StructArrayIter {
  PyObject_HEAD
  int index;
  struct __pyx_obj_11structarray_StructArray *array;
};

struct __pyx_obj_11structarray_Array {
  struct __pyx_obj_11structarray__BaseArray __pyx_base;
  float _default;
};

struct __pyx_obj_11structarray__ArrayIter {
  PyObject_HEAD
  int index;
  struct __pyx_obj_11structarray_Array *array;
};

struct __pyx_obj_11structarray_OffsetArray {
  struct __pyx_obj_11structarray_Array __pyx_base;
  int _offset;
};

struct __pyx_obj_11structarray__ItemInfo {
  PyObject_HEAD
  struct __pyx_obj_11structarray_StructArray *array;
  int index;
};

struct __pyx_obj_11structarray__ArrayOp2 {
  PyObject_HEAD
  int operation;
  PyObject *arg1;
  PyObject *arg2;
};

struct __pyx_obj_11structarray_ArrayOpAdd {
  struct __pyx_obj_11structarray__ArrayOp2 __pyx_base;
};

struct __pyx_obj_11structarray_ArrayOpSub {
  struct __pyx_obj_11structarray__ArrayOp2 __pyx_base;
};

struct __pyx_obj_11structarray_ArrayOpMul {
  struct __pyx_obj_11structarray__ArrayOp2 __pyx_base;
};

struct __pyx_obj_11structarray_ArrayOpDiv {
  struct __pyx_obj_11structarray__ArrayOp2 __pyx_base;
};

struct __pyx_obj_11structarray_ArrayOpMod {
  struct __pyx_obj_11structarray__ArrayOp2 __pyx_base;
};

struct __pyx_obj_11structarray_ArrayOpMin {
  struct __pyx_obj_11structarray__ArrayOp2 __pyx_base;
};

struct __pyx_obj_11structarray_ArrayOpMax {
  struct __pyx_obj_11structarray__ArrayOp2 __pyx_base;
};


struct __pyx_vtabstruct_11structarray__BaseArray {
  void (*_sync_data_ptr)(struct __pyx_obj_11structarray__BaseArray *);
  float (*_getitem)(struct __pyx_obj_11structarray__BaseArray *,int);
  void (*_setitem)(struct __pyx_obj_11structarray__BaseArray *,int,float);
};
static struct __pyx_vtabstruct_11structarray__BaseArray *__pyx_vtabptr_11structarray__BaseArray;



struct __pyx_vtabstruct_11structarray_StructArray {
  struct __pyx_vtabstruct_11structarray__BaseArray __pyx_base;
};
static struct __pyx_vtabstruct_11structarray_StructArray *__pyx_vtabptr_11structarray_StructArray;



struct __pyx_vtabstruct_11structarray_Array {
  struct __pyx_vtabstruct_11structarray__BaseArray __pyx_base;
};
static struct __pyx_vtabstruct_11structarray_Array *__pyx_vtabptr_11structarray_Array;



struct __pyx_vtabstruct_11structarray_OffsetArray {
  struct __pyx_vtabstruct_11structarray_Array __pyx_base;
};
static struct __pyx_vtabstruct_11structarray_OffsetArray *__pyx_vtabptr_11structarray_OffsetArray;









static PyTypeObject *__pyx_ptype_11structarray__BaseArray = 0;
static PyTypeObject *__pyx_ptype_11structarray__ItemInfo = 0;
static PyTypeObject *__pyx_ptype_11structarray_StructArray = 0;
static PyTypeObject *__pyx_ptype_11structarray__StructArrayIter = 0;
static PyTypeObject *__pyx_ptype_11structarray_Array = 0;
static PyTypeObject *__pyx_ptype_11structarray__ArrayIter = 0;
static PyTypeObject *__pyx_ptype_11structarray_OffsetArray = 0;
static PyTypeObject *__pyx_ptype_11structarray__ArrayOp2 = 0;
static PyTypeObject *__pyx_ptype_11structarray_ArrayOpAdd = 0;
static PyTypeObject *__pyx_ptype_11structarray_ArrayOpSub = 0;
static PyTypeObject *__pyx_ptype_11structarray_ArrayOpMul = 0;
static PyTypeObject *__pyx_ptype_11structarray_ArrayOpDiv = 0;
static PyTypeObject *__pyx_ptype_11structarray_ArrayOpMod = 0;
static PyTypeObject *__pyx_ptype_11structarray_ArrayOpMin = 0;
static PyTypeObject *__pyx_ptype_11structarray_ArrayOpMax = 0;
static PyObject *__pyx_k4;
static PyObject *__pyx_k5;
static PyObject *__pyx_k6;
static PyObject *__pyx_k7;
static PyObject *__pyx_k8;
static PyObject *__pyx_k9;
static PyObject *__pyx_k10;
static PyObject *__pyx_f_11structarray__do_op2_a_a(int,int,int,struct __pyx_obj_11structarray__BaseArray *,struct __pyx_obj_11structarray__BaseArray *,struct __pyx_obj_11structarray__BaseArray *); /*proto*/
static PyObject *__pyx_f_11structarray__do_op2_a_f(int,int,int,struct __pyx_obj_11structarray__BaseArray *,struct __pyx_obj_11structarray__BaseArray *,float); /*proto*/
static PyObject *__pyx_f_11structarray__do_op2_f_a(int,int,int,struct __pyx_obj_11structarray__BaseArray *,float,struct __pyx_obj_11structarray__BaseArray *); /*proto*/


/* Implementation of structarray */

static char __pyx_k1[] = "\nCopyright (C) 2007  Matthew Marshall\n\nPermission is hereby granted, free of charge, to any person obtaining a copy\nof this software and associated documentation files (the \"Software\"), to deal\nin the Software without restriction, including without limitation the rights\nto use, copy, modify, merge, publish, distribute, sublicense, and/or sell\ncopies of the Software, and to permit persons to whom the Software is\nfurnished to do so, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in\nall copies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\nIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\nFITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\nAUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\nLIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\nOUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN\nTHE SOFTWARE.\n";
static char __pyx_k2[] = "Matthew Marshall <matthew@matthewmarshall.org>";
static char __pyx_k3[] = "0.1";

static PyObject *__pyx_n___credits__;
static PyObject *__pyx_n___author__;
static PyObject *__pyx_n___version__;
static PyObject *__pyx_n_Array;
static PyObject *__pyx_n_StructArray;
static PyObject *__pyx_n_array_max;
static PyObject *__pyx_n_array_min;
static PyObject *__pyx_n___all__;
static PyObject *__pyx_n___docs_all__;

static PyObject *__pyx_k1p;
static PyObject *__pyx_k2p;
static PyObject *__pyx_k3p;

static void __pyx_f_11structarray_10_BaseArray__sync_data_ptr(struct __pyx_obj_11structarray__BaseArray *__pyx_v_self) {
  int __pyx_1;
  Py_INCREF(__pyx_v_self);
  __pyx_1 = (!__pyx_v_self->_is_data_owner);
  if (__pyx_1) {

    /* "/home/mmarshall/projects/structarray/structarray.pyx":87 */
    ((struct __pyx_vtabstruct_11structarray__BaseArray *)__pyx_v_self->data_owner->__pyx_vtab)->_sync_data_ptr(__pyx_v_self->data_owner);

    /* "/home/mmarshall/projects/structarray/structarray.pyx":88 */
    __pyx_v_self->_data = __pyx_v_self->data_owner->_data;

    /* "/home/mmarshall/projects/structarray/structarray.pyx":89 */
    __pyx_v_self->_count = __pyx_v_self->data_owner->_count;

    /* "/home/mmarshall/projects/structarray/structarray.pyx":90 */
    Py_INCREF(__pyx_v_self->data_owner->_dimensions);
    Py_DECREF(__pyx_v_self->_dimensions);
    __pyx_v_self->_dimensions = __pyx_v_self->data_owner->_dimensions;
    goto __pyx_L2;
  }
  __pyx_L2:;

  Py_DECREF(__pyx_v_self);
}

static float __pyx_f_11structarray_10_BaseArray__getitem(struct __pyx_obj_11structarray__BaseArray *__pyx_v_self,int __pyx_v_index) {
  float __pyx_r;
  Py_INCREF(__pyx_v_self);
  __pyx_r = (__pyx_v_self->_data[(__pyx_v_index * __pyx_v_self->_stride)]);
  goto __pyx_L0;

  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_n_NotImplemented;

static void __pyx_f_11structarray_10_BaseArray__setitem(struct __pyx_obj_11structarray__BaseArray *__pyx_v_self,int __pyx_v_index,float __pyx_v_value) {
  PyObject *__pyx_1 = 0;
  Py_INCREF(__pyx_v_self);
  __pyx_1 = __Pyx_GetName(__pyx_b, __pyx_n_NotImplemented); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 96; goto __pyx_L1;}
  __Pyx_Raise(__pyx_1, 0, 0);
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  {__pyx_filename = __pyx_f[0]; __pyx_lineno = 96; goto __pyx_L1;}

  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_WriteUnraisable("structarray._BaseArray._setitem");
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
}

static void __pyx_f_11structarray_10_BaseArray___dealloc__(PyObject *__pyx_v_self); /*proto*/
static void __pyx_f_11structarray_10_BaseArray___dealloc__(PyObject *__pyx_v_self) {
  int __pyx_1;
  Py_INCREF(__pyx_v_self);
  __pyx_1 = ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_is_data_owner;
  if (__pyx_1) {

    /* "/home/mmarshall/projects/structarray/structarray.pyx":103 */
    free(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_data);

    /* "/home/mmarshall/projects/structarray/structarray.pyx":104 */
    ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_data = NULL;
    goto __pyx_L2;
  }
  __pyx_L2:;

  Py_DECREF(__pyx_v_self);
}

static PyObject *__pyx_n_False;
static PyObject *__pyx_n_True;

static int __pyx_f_11structarray_10_BaseArray___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_11structarray_10_BaseArray___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  struct __pyx_obj_11structarray__BaseArray *__pyx_v_data_owner = 0;
  int __pyx_r;
  PyObject *__pyx_1 = 0;
  int __pyx_2;
  static char *__pyx_argnames[] = {"data_owner",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_data_owner)) return -1;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_data_owner);
  if (!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_data_owner), __pyx_ptype_11structarray__BaseArray, 1, "data_owner")) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 106; goto __pyx_L1;}

  /* "/home/mmarshall/projects/structarray/structarray.pyx":107 */
  __pyx_1 = __Pyx_GetName(__pyx_b, __pyx_n_False); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 107; goto __pyx_L1;}
  __pyx_2 = PyInt_AsLong(__pyx_1); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 107; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_is_assignable = __pyx_2;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":109 */
  Py_INCREF(((PyObject *)__pyx_v_data_owner));
  Py_DECREF(((PyObject *)((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->data_owner));
  ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->data_owner = __pyx_v_data_owner;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":110 */
  if (PyObject_Cmp(((PyObject *)__pyx_v_data_owner), __pyx_v_self, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 110; goto __pyx_L1;}
  __pyx_2 = __pyx_2 == 0;
  if (__pyx_2) {

    /* "/home/mmarshall/projects/structarray/structarray.pyx":111 */
    __pyx_1 = __Pyx_GetName(__pyx_b, __pyx_n_True); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 111; goto __pyx_L1;}
    __pyx_2 = PyInt_AsLong(__pyx_1); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 111; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_is_data_owner = __pyx_2;

    /* "/home/mmarshall/projects/structarray/structarray.pyx":112 */
    ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_data = NULL;

    /* "/home/mmarshall/projects/structarray/structarray.pyx":113 */
    ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_allocated_size = 0;
    goto __pyx_L2;
  }
  /*else*/ {

    /* "/home/mmarshall/projects/structarray/structarray.pyx":115 */
    __pyx_1 = __Pyx_GetName(__pyx_b, __pyx_n_False); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 115; goto __pyx_L1;}
    __pyx_2 = PyInt_AsLong(__pyx_1); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 115; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_is_data_owner = __pyx_2;

    /* "/home/mmarshall/projects/structarray/structarray.pyx":116 */
    ((struct __pyx_vtabstruct_11structarray__BaseArray *)((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->__pyx_vtab)->_sync_data_ptr(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self));

    /* "/home/mmarshall/projects/structarray/structarray.pyx":117 */
    ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_stride = __pyx_v_data_owner->_stride;
  }
  __pyx_L2:;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("structarray._BaseArray.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_data_owner);
  return __pyx_r;
}

static Py_ssize_t __pyx_f_11structarray_10_BaseArray___len__(PyObject *__pyx_v_self); /*proto*/
static Py_ssize_t __pyx_f_11structarray_10_BaseArray___len__(PyObject *__pyx_v_self) {
  Py_ssize_t __pyx_r;
  Py_INCREF(__pyx_v_self);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":120 */
  ((struct __pyx_vtabstruct_11structarray__BaseArray *)((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->__pyx_vtab)->_sync_data_ptr(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self));

  /* "/home/mmarshall/projects/structarray/structarray.pyx":121 */
  __pyx_r = ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_count;
  goto __pyx_L0;

  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_n_RuntimeError;

static PyObject *__pyx_k15p;

static char __pyx_k15[] = "Unable to allocate memory for array!";

static PyObject *__pyx_f_11structarray_10_BaseArray__grow(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static PyObject *__pyx_f_11structarray_10_BaseArray__grow(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  int __pyx_v_additional_size;
  PyObject *__pyx_v_exact = 0;
  int __pyx_v_new_size;
  void *__pyx_v_ptr;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  static char *__pyx_argnames[] = {"additional_size","exact",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "iO", __pyx_argnames, &__pyx_v_additional_size, &__pyx_v_exact)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_exact);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":126 */
  ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_count = (((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_count + __pyx_v_additional_size);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":127 */
  __pyx_1 = PyObject_IsTrue(__pyx_v_exact); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 127; goto __pyx_L1;}
  if (__pyx_1) {
    __pyx_v_new_size = ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_count;
    goto __pyx_L2;
  }
  /*else*/ {

    /* "/home/mmarshall/projects/structarray/structarray.pyx":130 */
    __pyx_v_new_size = ((((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_allocated_size / (sizeof(float))) + 1);

    /* "/home/mmarshall/projects/structarray/structarray.pyx":131 */
    while (1) {
      __pyx_1 = (((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_count > __pyx_v_new_size);
      if (!__pyx_1) break;
      __pyx_v_new_size = (__pyx_v_new_size * 2);
    }
  }
  __pyx_L2:;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":133 */
  __pyx_1 = ((__pyx_v_new_size * (sizeof(float))) > ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_allocated_size);
  if (__pyx_1) {

    /* "/home/mmarshall/projects/structarray/structarray.pyx":134 */
    __pyx_v_ptr = realloc(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_data,(((sizeof(float)) * ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_stride) * __pyx_v_new_size));

    /* "/home/mmarshall/projects/structarray/structarray.pyx":136 */
    __pyx_1 = (__pyx_v_ptr == NULL);
    if (__pyx_1) {
      __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_RuntimeError); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 137; goto __pyx_L1;}
      __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 137; goto __pyx_L1;}
      Py_INCREF(__pyx_k15p);
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_k15p);
      __pyx_4 = PyObject_CallObject(__pyx_2, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 137; goto __pyx_L1;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __Pyx_Raise(__pyx_4, 0, 0);
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      {__pyx_filename = __pyx_f[0]; __pyx_lineno = 137; goto __pyx_L1;}
      goto __pyx_L6;
    }
    __pyx_L6:;

    /* "/home/mmarshall/projects/structarray/structarray.pyx":138 */
    ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_data = ((float *)__pyx_v_ptr);

    /* "/home/mmarshall/projects/structarray/structarray.pyx":139 */
    ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_allocated_size = (((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_stride * __pyx_v_new_size);
    goto __pyx_L5;
  }
  __pyx_L5:;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("structarray._BaseArray._grow");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_exact);
  return __pyx_r;
}

static PyObject *__pyx_n_ValueError;
static PyObject *__pyx_n__is_resizeable;
static PyObject *__pyx_n__grow;

static PyObject *__pyx_k16p;
static PyObject *__pyx_k17p;
static PyObject *__pyx_k18p;
static PyObject *__pyx_k19p;

static char __pyx_k16[] = "Not data owner";
static char __pyx_k17[] = "Cannot resize a multidimensional array";
static char __pyx_k18[] = "Cannot resize this array";
static char __pyx_k19[] = "Error in realloc!";

static PyObject *__pyx_f_11structarray_10_BaseArray_set_length(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_11structarray_10_BaseArray_set_length[] = "\n        ``set_length(length)``\n\n        Sets the length explicitly.\n\n        This is an alternative to using ``append`` and ``extend``.  (It should\n        be a little faster.)\n        ";
static PyObject *__pyx_f_11structarray_10_BaseArray_set_length(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_length = 0;
  void *__pyx_v_ptr;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  int __pyx_5;
  PyObject *__pyx_6 = 0;
  static char *__pyx_argnames[] = {"length",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_length)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_length);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":151 */
  __pyx_1 = ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->data_owner != ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self);
  if (__pyx_1) {
    __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_RuntimeError); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 152; goto __pyx_L1;}
    __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 152; goto __pyx_L1;}
    Py_INCREF(__pyx_k16p);
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_k16p);
    __pyx_4 = PyObject_CallObject(__pyx_2, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 152; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __Pyx_Raise(__pyx_4, 0, 0);
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 152; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":153 */
  __pyx_1 = (PyObject_Length(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_dimensions) > 1);
  if (__pyx_1) {
    __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_ValueError); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 154; goto __pyx_L1;}
    __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 154; goto __pyx_L1;}
    Py_INCREF(__pyx_k17p);
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_k17p);
    __pyx_4 = PyObject_CallObject(__pyx_2, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 154; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __Pyx_Raise(__pyx_4, 0, 0);
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 154; goto __pyx_L1;}
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":155 */
  __pyx_2 = PyObject_GetAttr(__pyx_v_self, __pyx_n__is_resizeable); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 155; goto __pyx_L1;}
  __pyx_3 = PyObject_CallObject(__pyx_2, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 155; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_1 = PyObject_IsTrue(__pyx_3); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 155; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_5 = (!__pyx_1);
  if (__pyx_5) {
    __pyx_4 = __Pyx_GetName(__pyx_b, __pyx_n_ValueError); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 156; goto __pyx_L1;}
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 156; goto __pyx_L1;}
    Py_INCREF(__pyx_k18p);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_k18p);
    __pyx_3 = PyObject_CallObject(__pyx_4, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 156; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 156; goto __pyx_L1;}
    goto __pyx_L4;
  }
  __pyx_L4:;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":157 */
  __pyx_4 = PyInt_FromLong(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_count); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 157; goto __pyx_L1;}
  if (PyObject_Cmp(__pyx_v_length, __pyx_4, &__pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 157; goto __pyx_L1;}
  __pyx_1 = __pyx_1 > 0;
  Py_DECREF(__pyx_4); __pyx_4 = 0;
  if (__pyx_1) {
    __pyx_2 = PyObject_GetAttr(__pyx_v_self, __pyx_n__grow); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 158; goto __pyx_L1;}
    __pyx_3 = PyInt_FromLong(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_count); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 158; goto __pyx_L1;}
    __pyx_4 = PyNumber_Subtract(__pyx_v_length, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 158; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __pyx_3 = __Pyx_GetName(__pyx_b, __pyx_n_True); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 158; goto __pyx_L1;}
    __pyx_6 = PyTuple_New(2); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 158; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_6, 0, __pyx_4);
    PyTuple_SET_ITEM(__pyx_6, 1, __pyx_3);
    __pyx_4 = 0;
    __pyx_3 = 0;
    __pyx_4 = PyObject_CallObject(__pyx_2, __pyx_6); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 158; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_6); __pyx_6 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    goto __pyx_L5;
  }
  __pyx_3 = PyInt_FromLong(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_count); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 160; goto __pyx_L1;}
  if (PyObject_Cmp(__pyx_v_length, __pyx_3, &__pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 160; goto __pyx_L1;}
  __pyx_5 = __pyx_5 < 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  if (__pyx_5) {

    /* "/home/mmarshall/projects/structarray/structarray.pyx":161 */
    __pyx_1 = PyInt_AsLong(__pyx_v_length); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 161; goto __pyx_L1;}
    ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_count = __pyx_1;

    /* "/home/mmarshall/projects/structarray/structarray.pyx":162 */
    __pyx_2 = PyInt_FromLong(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_stride); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 162; goto __pyx_L1;}
    __pyx_6 = PyNumber_Multiply(__pyx_2, __pyx_v_length); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 162; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_5 = PyInt_AsLong(__pyx_6); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 162; goto __pyx_L1;}
    Py_DECREF(__pyx_6); __pyx_6 = 0;
    ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_allocated_size = __pyx_5;

    /* "/home/mmarshall/projects/structarray/structarray.pyx":163 */
    __pyx_v_ptr = realloc(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_data,((sizeof(float)) * ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_allocated_size));

    /* "/home/mmarshall/projects/structarray/structarray.pyx":165 */
    __pyx_1 = (__pyx_v_ptr == NULL);
    if (__pyx_1) {
      __pyx_4 = __Pyx_GetName(__pyx_b, __pyx_n_RuntimeError); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 166; goto __pyx_L1;}
      __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 166; goto __pyx_L1;}
      Py_INCREF(__pyx_k19p);
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_k19p);
      __pyx_2 = PyObject_CallObject(__pyx_4, __pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 166; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __Pyx_Raise(__pyx_2, 0, 0);
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      {__pyx_filename = __pyx_f[0]; __pyx_lineno = 166; goto __pyx_L1;}
      goto __pyx_L6;
    }
    __pyx_L6:;

    /* "/home/mmarshall/projects/structarray/structarray.pyx":167 */
    ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_data = ((float *)__pyx_v_ptr);
    goto __pyx_L5;
  }
  __pyx_L5:;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":168 */
  __pyx_6 = PyInt_FromLong(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_count); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 168; goto __pyx_L1;}
  __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 168; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_4, 0, __pyx_6);
  __pyx_6 = 0;
  Py_DECREF(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_dimensions);
  ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_dimensions = __pyx_4;
  __pyx_4 = 0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  Py_XDECREF(__pyx_6);
  __Pyx_AddTraceback("structarray._BaseArray.set_length");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_length);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_10_BaseArray_get_dimensions(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_11structarray_10_BaseArray_get_dimensions[] = "\n        ``get_size()``\n\n        Returns a tuple of this array\'s dimensional size.\n\n        If it is a single dimension array, a tuple containing the length will\n        be returned.\n        ";
static PyObject *__pyx_f_11structarray_10_BaseArray_get_dimensions(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_r;
  static char *__pyx_argnames[] = {0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "", __pyx_argnames)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_dimensions);
  __pyx_r = ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_dimensions;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_10_BaseArray__is_resizeable(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static PyObject *__pyx_f_11structarray_10_BaseArray__is_resizeable(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  static char *__pyx_argnames[] = {0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "", __pyx_argnames)) return 0;
  Py_INCREF(__pyx_v_self);
  __pyx_1 = ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self) == ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->data_owner;
  if (__pyx_1) {
    __pyx_1 = (PyObject_Length(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_dimensions) == 1);
  }
  __pyx_2 = PyInt_FromLong(__pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 182; goto __pyx_L1;}
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("structarray._BaseArray._is_resizeable");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_k20p;
static PyObject *__pyx_k21p;

static char __pyx_k20[] = "Not data owner";
static char __pyx_k21[] = "Cannot resize this array.";

static PyObject *__pyx_f_11structarray_10_BaseArray_append(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_11structarray_10_BaseArray_append[] = "\n        ``append(item)``\n\n        Appends an item to the array.\n        ";
static PyObject *__pyx_f_11structarray_10_BaseArray_append(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_item = 0;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  int __pyx_5;
  PyObject *__pyx_6 = 0;
  PyObject *__pyx_7 = 0;
  static char *__pyx_argnames[] = {"item",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_item)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_item);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":190 */
  __pyx_1 = ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self) != ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->data_owner;
  if (__pyx_1) {
    __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_RuntimeError); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 191; goto __pyx_L1;}
    __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 191; goto __pyx_L1;}
    Py_INCREF(__pyx_k20p);
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_k20p);
    __pyx_4 = PyObject_CallObject(__pyx_2, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 191; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __Pyx_Raise(__pyx_4, 0, 0);
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 191; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":192 */
  __pyx_2 = PyObject_GetAttr(__pyx_v_self, __pyx_n__is_resizeable); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 192; goto __pyx_L1;}
  __pyx_3 = PyObject_CallObject(__pyx_2, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 192; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_1 = PyObject_IsTrue(__pyx_3); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 192; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_5 = (!__pyx_1);
  if (__pyx_5) {
    __pyx_4 = __Pyx_GetName(__pyx_b, __pyx_n_ValueError); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 193; goto __pyx_L1;}
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 193; goto __pyx_L1;}
    Py_INCREF(__pyx_k21p);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_k21p);
    __pyx_3 = PyObject_CallObject(__pyx_4, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 193; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 193; goto __pyx_L1;}
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":194 */
  __pyx_4 = PyObject_GetAttr(__pyx_v_self, __pyx_n__grow); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 194; goto __pyx_L1;}
  __pyx_2 = PyInt_FromLong(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 194; goto __pyx_L1;}
  __pyx_3 = __Pyx_GetName(__pyx_b, __pyx_n_False); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 194; goto __pyx_L1;}
  __pyx_6 = PyTuple_New(2); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 194; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_6, 0, __pyx_2);
  PyTuple_SET_ITEM(__pyx_6, 1, __pyx_3);
  __pyx_2 = 0;
  __pyx_3 = 0;
  __pyx_2 = PyObject_CallObject(__pyx_4, __pyx_6); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 194; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;
  Py_DECREF(__pyx_6); __pyx_6 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":195 */
  __pyx_3 = PyInt_FromLong(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_count); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 195; goto __pyx_L1;}
  __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 195; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_4, 0, __pyx_3);
  __pyx_3 = 0;
  Py_DECREF(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_dimensions);
  ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_dimensions = __pyx_4;
  __pyx_4 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":196 */
  /*try:*/ {
    __pyx_6 = PyInt_FromLong((((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_count - 1)); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 197; goto __pyx_L4;}
    if (PyObject_SetItem(__pyx_v_self, __pyx_6, __pyx_v_item) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 197; goto __pyx_L4;}
    Py_DECREF(__pyx_6); __pyx_6 = 0;
  }
  goto __pyx_L5;
  __pyx_L4:;
  Py_XDECREF(__pyx_2); __pyx_2 = 0;
  Py_XDECREF(__pyx_3); __pyx_3 = 0;
  Py_XDECREF(__pyx_4); __pyx_4 = 0;
  Py_XDECREF(__pyx_6); __pyx_6 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":198 */
  /*except:*/ {
    __Pyx_AddTraceback("structarray.append");
    if (__Pyx_GetException(&__pyx_2, &__pyx_3, &__pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 198; goto __pyx_L1;}

    /* "/home/mmarshall/projects/structarray/structarray.pyx":201 */
    ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_count = (((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_count - 1);

    /* "/home/mmarshall/projects/structarray/structarray.pyx":202 */
    __pyx_6 = PyInt_FromLong(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_count); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 202; goto __pyx_L1;}
    __pyx_7 = PyTuple_New(1); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 202; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_7, 0, __pyx_6);
    __pyx_6 = 0;
    Py_DECREF(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_dimensions);
    ((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_dimensions = __pyx_7;
    __pyx_7 = 0;

    /* "/home/mmarshall/projects/structarray/structarray.pyx":203 */
    __Pyx_Raise(__pyx_2, __pyx_3, __pyx_4);
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 203; goto __pyx_L1;}
    Py_DECREF(__pyx_2);
    Py_DECREF(__pyx_3);
    Py_DECREF(__pyx_4);
    goto __pyx_L5;
  }
  __pyx_L5:;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  Py_XDECREF(__pyx_6);
  Py_XDECREF(__pyx_7);
  __Pyx_AddTraceback("structarray._BaseArray.append");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_item);
  return __pyx_r;
}

static PyObject *__pyx_n_append;

static PyObject *__pyx_f_11structarray_10_BaseArray_extend(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_11structarray_10_BaseArray_extend[] = "\n        ``extend(items)``\n\n        Iterates over ``items``, calling ``append()`` on each one.\n        ";
static PyObject *__pyx_f_11structarray_10_BaseArray_extend(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_items = 0;
  PyObject *__pyx_v_i;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  static char *__pyx_argnames[] = {"items",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_items)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_items);
  __pyx_v_i = Py_None; Py_INCREF(Py_None);
  __pyx_1 = PyObject_GetIter(__pyx_v_items); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 211; goto __pyx_L1;}
  for (;;) {
    __pyx_2 = PyIter_Next(__pyx_1);
    if (!__pyx_2) {
      if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 211; goto __pyx_L1;}
      break;
    }
    Py_DECREF(__pyx_v_i);
    __pyx_v_i = __pyx_2;
    __pyx_2 = 0;
    __pyx_2 = PyObject_GetAttr(__pyx_v_self, __pyx_n_append); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 212; goto __pyx_L1;}
    __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 212; goto __pyx_L1;}
    Py_INCREF(__pyx_v_i);
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_i);
    __pyx_4 = PyObject_CallObject(__pyx_2, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 212; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
  }
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("structarray._BaseArray.extend");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_i);
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_items);
  return __pyx_r;
}

static PyObject *__pyx_n_int;
static PyObject *__pyx_n_long;
static PyObject *__pyx_n_IndexError;
static PyObject *__pyx_n_slice;
static PyObject *__pyx_n_NotImplementedError;
static PyObject *__pyx_n___len__;
static PyObject *__pyx_n_tuple;
static PyObject *__pyx_n_enumerate;
static PyObject *__pyx_n_range;

static PyObject *__pyx_k22p;
static PyObject *__pyx_k23p;
static PyObject *__pyx_k25p;
static PyObject *__pyx_k26p;

static char __pyx_k22[] = "array index out of range";
static char __pyx_k23[] = "slicing arrays isn't implemented yet.";
static char __pyx_k25[] = "multidimensional index should have a length of %d";
static char __pyx_k26[] = "array index out of range";

static PyObject *__pyx_f_11structarray_10_BaseArray_sanitize_index(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_11structarray_10_BaseArray_sanitize_index[] = "\n        ``sanitize_index(index)`` -> sanitized index\n\n        This method takes an index, such as passed to __getitem__, and  returns\n        an index that is between 0 and len(self).  (So that it can be used with\n        the underlying C array.)  This includes handling negitive and/or\n        multidimensional indexes.\n\n        Slices are currently not supported.\n        ";
static PyObject *__pyx_f_11structarray_10_BaseArray_sanitize_index(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_index = 0;
  PyObject *__pyx_v_converted_index;
  PyObject *__pyx_v_dim;
  PyObject *__pyx_v_i;
  PyObject *__pyx_v_j;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  int __pyx_4;
  PyObject *__pyx_5 = 0;
  static char *__pyx_argnames[] = {"index",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_index)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_index);
  __pyx_v_converted_index = Py_None; Py_INCREF(Py_None);
  __pyx_v_dim = Py_None; Py_INCREF(Py_None);
  __pyx_v_i = Py_None; Py_INCREF(Py_None);
  __pyx_v_j = Py_None; Py_INCREF(Py_None);
  __pyx_1 = __Pyx_GetName(__pyx_b, __pyx_n_int); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 225; goto __pyx_L1;}
  __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_long); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 225; goto __pyx_L1;}
  __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 225; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_1);
  PyTuple_SET_ITEM(__pyx_3, 1, __pyx_2);
  __pyx_1 = 0;
  __pyx_2 = 0;
  __pyx_4 = PyObject_IsInstance(__pyx_v_index,__pyx_3); if (__pyx_4 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 225; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  if (__pyx_4) {

    /* "/home/mmarshall/projects/structarray/structarray.pyx":226 */
    __pyx_1 = PyInt_FromLong(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 226; goto __pyx_L1;}
    if (PyObject_Cmp(__pyx_v_index, __pyx_1, &__pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 226; goto __pyx_L1;}
    __pyx_4 = __pyx_4 < 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    if (__pyx_4) {
      __pyx_2 = PyInt_FromSsize_t(PyObject_Length(__pyx_v_self)); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 227; goto __pyx_L1;}
      __pyx_3 = PyNumber_Add(__pyx_v_index, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 227; goto __pyx_L1;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      Py_DECREF(__pyx_v_index);
      __pyx_v_index = __pyx_3;
      __pyx_3 = 0;
      goto __pyx_L3;
    }
    __pyx_L3:;

    /* "/home/mmarshall/projects/structarray/structarray.pyx":228 */
    __pyx_1 = PyInt_FromLong(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 228; goto __pyx_L1;}
    if (PyObject_Cmp(__pyx_v_index, __pyx_1, &__pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 228; goto __pyx_L1;}
    __pyx_4 = __pyx_4 < 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    if (!__pyx_4) {
      __pyx_2 = PyInt_FromSsize_t(PyObject_Length(__pyx_v_self)); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 228; goto __pyx_L1;}
      if (PyObject_Cmp(__pyx_v_index, __pyx_2, &__pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 228; goto __pyx_L1;}
      __pyx_4 = __pyx_4 >= 0;
      Py_DECREF(__pyx_2); __pyx_2 = 0;
    }
    if (__pyx_4) {
      __pyx_3 = __Pyx_GetName(__pyx_b, __pyx_n_IndexError); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 229; goto __pyx_L1;}
      __pyx_1 = PyTuple_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 229; goto __pyx_L1;}
      Py_INCREF(__pyx_k22p);
      PyTuple_SET_ITEM(__pyx_1, 0, __pyx_k22p);
      __pyx_2 = PyObject_CallObject(__pyx_3, __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 229; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      __Pyx_Raise(__pyx_2, 0, 0);
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      {__pyx_filename = __pyx_f[0]; __pyx_lineno = 229; goto __pyx_L1;}
      goto __pyx_L4;
    }
    /*else*/ {
      Py_INCREF(__pyx_v_index);
      __pyx_r = __pyx_v_index;
      goto __pyx_L0;
    }
    __pyx_L4:;
    goto __pyx_L2;
  }
  __pyx_3 = __Pyx_GetName(__pyx_b, __pyx_n_slice); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 232; goto __pyx_L1;}
  __pyx_4 = PyObject_IsInstance(__pyx_v_index,__pyx_3); if (__pyx_4 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 232; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  if (__pyx_4) {
    __pyx_1 = __Pyx_GetName(__pyx_b, __pyx_n_NotImplementedError); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 233; goto __pyx_L1;}
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 233; goto __pyx_L1;}
    Py_INCREF(__pyx_k23p);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_k23p);
    __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 233; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 233; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_4 = PyObject_HasAttr(__pyx_v_index,__pyx_n___len__); if (__pyx_4 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 234; goto __pyx_L1;}
  if (__pyx_4) {
    __pyx_1 = __Pyx_GetName(__pyx_b, __pyx_n_tuple); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 234; goto __pyx_L1;}
    __pyx_4 = PyObject_IsInstance(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_dimensions,__pyx_1); if (__pyx_4 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 234; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
  }
  if (__pyx_4) {
    __pyx_4 = (PyObject_Length(__pyx_v_index) != PyObject_Length(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_dimensions));
    if (__pyx_4) {
      __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_IndexError); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 236; goto __pyx_L1;}
      __pyx_3 = PyInt_FromSsize_t(PyObject_Length(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_dimensions)); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 237; goto __pyx_L1;}
      __pyx_1 = PyNumber_Remainder(__pyx_k25p, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 237; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 236; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_3, 0, __pyx_1);
      __pyx_1 = 0;
      __pyx_1 = PyObject_CallObject(__pyx_2, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 236; goto __pyx_L1;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      __Pyx_Raise(__pyx_1, 0, 0);
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      {__pyx_filename = __pyx_f[0]; __pyx_lineno = 236; goto __pyx_L1;}
      goto __pyx_L5;
    }
    /*else*/ {

      /* "/home/mmarshall/projects/structarray/structarray.pyx":239 */
      __pyx_2 = PyInt_FromLong(0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 239; goto __pyx_L1;}
      Py_DECREF(__pyx_v_converted_index);
      __pyx_v_converted_index = __pyx_2;
      __pyx_2 = 0;

      /* "/home/mmarshall/projects/structarray/structarray.pyx":240 */
      __pyx_3 = __Pyx_GetName(__pyx_b, __pyx_n_enumerate); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 240; goto __pyx_L1;}
      __pyx_1 = PyTuple_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 240; goto __pyx_L1;}
      Py_INCREF(__pyx_v_index);
      PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_index);
      __pyx_2 = PyObject_CallObject(__pyx_3, __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 240; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      __pyx_3 = PyObject_GetIter(__pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 240; goto __pyx_L1;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      for (;;) {
        __pyx_1 = PyIter_Next(__pyx_3);
        if (!__pyx_1) {
          if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 240; goto __pyx_L1;}
          break;
        }
        __pyx_2 = PyObject_GetIter(__pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 240; goto __pyx_L1;}
        Py_DECREF(__pyx_1); __pyx_1 = 0;
        __pyx_1 = __Pyx_UnpackItem(__pyx_2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 240; goto __pyx_L1;}
        Py_DECREF(__pyx_v_dim);
        __pyx_v_dim = __pyx_1;
        __pyx_1 = 0;
        __pyx_1 = __Pyx_UnpackItem(__pyx_2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 240; goto __pyx_L1;}
        Py_DECREF(__pyx_v_i);
        __pyx_v_i = __pyx_1;
        __pyx_1 = 0;
        if (__Pyx_EndUnpack(__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 240; goto __pyx_L1;}
        Py_DECREF(__pyx_2); __pyx_2 = 0;

        /* "/home/mmarshall/projects/structarray/structarray.pyx":241 */
        __pyx_1 = PyInt_FromLong(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 241; goto __pyx_L1;}
        if (PyObject_Cmp(__pyx_v_i, __pyx_1, &__pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 241; goto __pyx_L1;}
        __pyx_4 = __pyx_4 < 0;
        Py_DECREF(__pyx_1); __pyx_1 = 0;
        if (__pyx_4) {
          __pyx_2 = PyObject_GetItem(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_dimensions, __pyx_v_dim); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 242; goto __pyx_L1;}
          __pyx_1 = PyNumber_Add(__pyx_v_i, __pyx_2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 242; goto __pyx_L1;}
          Py_DECREF(__pyx_2); __pyx_2 = 0;
          Py_DECREF(__pyx_v_i);
          __pyx_v_i = __pyx_1;
          __pyx_1 = 0;
          goto __pyx_L8;
        }
        __pyx_L8:;

        /* "/home/mmarshall/projects/structarray/structarray.pyx":243 */
        __pyx_2 = PyInt_FromLong(0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 243; goto __pyx_L1;}
        if (PyObject_Cmp(__pyx_v_i, __pyx_2, &__pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 243; goto __pyx_L1;}
        __pyx_4 = __pyx_4 < 0;
        Py_DECREF(__pyx_2); __pyx_2 = 0;
        if (!__pyx_4) {
          __pyx_1 = PyObject_GetItem(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_dimensions, __pyx_v_dim); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 243; goto __pyx_L1;}
          if (PyObject_Cmp(__pyx_v_i, __pyx_1, &__pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 243; goto __pyx_L1;}
          __pyx_4 = __pyx_4 >= 0;
          Py_DECREF(__pyx_1); __pyx_1 = 0;
        }
        if (__pyx_4) {
          __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_IndexError); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 244; goto __pyx_L1;}
          __pyx_1 = PyTuple_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 244; goto __pyx_L1;}
          Py_INCREF(__pyx_k26p);
          PyTuple_SET_ITEM(__pyx_1, 0, __pyx_k26p);
          __pyx_5 = PyObject_CallObject(__pyx_2, __pyx_1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 244; goto __pyx_L1;}
          Py_DECREF(__pyx_2); __pyx_2 = 0;
          Py_DECREF(__pyx_1); __pyx_1 = 0;
          __Pyx_Raise(__pyx_5, 0, 0);
          Py_DECREF(__pyx_5); __pyx_5 = 0;
          {__pyx_filename = __pyx_f[0]; __pyx_lineno = 244; goto __pyx_L1;}
          goto __pyx_L9;
        }
        __pyx_L9:;

        /* "/home/mmarshall/projects/structarray/structarray.pyx":245 */
        __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_range); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 245; goto __pyx_L1;}
        __pyx_1 = PyInt_FromLong(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 245; goto __pyx_L1;}
        __pyx_5 = PyTuple_New(2); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 245; goto __pyx_L1;}
        PyTuple_SET_ITEM(__pyx_5, 0, __pyx_1);
        Py_INCREF(__pyx_v_dim);
        PyTuple_SET_ITEM(__pyx_5, 1, __pyx_v_dim);
        __pyx_1 = 0;
        __pyx_1 = PyObject_CallObject(__pyx_2, __pyx_5); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 245; goto __pyx_L1;}
        Py_DECREF(__pyx_2); __pyx_2 = 0;
        Py_DECREF(__pyx_5); __pyx_5 = 0;
        __pyx_2 = PyObject_GetIter(__pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 245; goto __pyx_L1;}
        Py_DECREF(__pyx_1); __pyx_1 = 0;
        for (;;) {
          __pyx_5 = PyIter_Next(__pyx_2);
          if (!__pyx_5) {
            if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 245; goto __pyx_L1;}
            break;
          }
          Py_DECREF(__pyx_v_j);
          __pyx_v_j = __pyx_5;
          __pyx_5 = 0;
          __pyx_1 = PyObject_GetItem(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_dimensions, __pyx_v_j); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 246; goto __pyx_L1;}
          __pyx_5 = PyNumber_Multiply(__pyx_v_i, __pyx_1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 246; goto __pyx_L1;}
          Py_DECREF(__pyx_1); __pyx_1 = 0;
          Py_DECREF(__pyx_v_i);
          __pyx_v_i = __pyx_5;
          __pyx_5 = 0;
        }
        Py_DECREF(__pyx_2); __pyx_2 = 0;

        /* "/home/mmarshall/projects/structarray/structarray.pyx":247 */
        __pyx_1 = PyNumber_Add(__pyx_v_converted_index, __pyx_v_i); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 247; goto __pyx_L1;}
        Py_DECREF(__pyx_v_converted_index);
        __pyx_v_converted_index = __pyx_1;
        __pyx_1 = 0;
      }
      Py_DECREF(__pyx_3); __pyx_3 = 0;

      /* "/home/mmarshall/projects/structarray/structarray.pyx":248 */
      #ifndef PYREX_WITHOUT_ASSERTIONS
      __pyx_5 = PyInt_FromSsize_t(PyObject_Length(__pyx_v_self)); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 248; goto __pyx_L1;}
      if (PyObject_Cmp(__pyx_v_converted_index, __pyx_5, &__pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 248; goto __pyx_L1;}
      __pyx_4 = __pyx_4 < 0;
      Py_DECREF(__pyx_5); __pyx_5 = 0;
      if (!__pyx_4) {
        PyErr_SetNone(PyExc_AssertionError);
        {__pyx_filename = __pyx_f[0]; __pyx_lineno = 248; goto __pyx_L1;}
      }
      #endif

      /* "/home/mmarshall/projects/structarray/structarray.pyx":249 */
      Py_INCREF(__pyx_v_converted_index);
      __pyx_r = __pyx_v_converted_index;
      goto __pyx_L0;
    }
    __pyx_L5:;
    goto __pyx_L2;
  }
  __pyx_L2:;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_5);
  __Pyx_AddTraceback("structarray._BaseArray.sanitize_index");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_converted_index);
  Py_DECREF(__pyx_v_dim);
  Py_DECREF(__pyx_v_i);
  Py_DECREF(__pyx_v_j);
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_index);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_10_BaseArray_get_data_addr(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_11structarray_10_BaseArray_get_data_addr[] = "\n        ``get_data_addr()``\n\n        Gets the memory address of the data.\n\n        This, together with ``get_data_stride()``, can be used with PyOpenGL\n        or Pyglet for OpenGL vertex arrays.  For example:\n\n        >>> array = StructArray((\"x\", \"y\"), size=100, defaults=(0,0))\n        >>> glVertexPointer(2, GL_FLOAT,\n        ...     array.get_data_stride(),\n        ...     array.get_data_addr())\n        ";
static PyObject *__pyx_f_11structarray_10_BaseArray_get_data_addr(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  static char *__pyx_argnames[] = {0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "", __pyx_argnames)) return 0;
  Py_INCREF(__pyx_v_self);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":265 */
  ((struct __pyx_vtabstruct_11structarray__BaseArray *)((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->__pyx_vtab)->_sync_data_ptr(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self));

  /* "/home/mmarshall/projects/structarray/structarray.pyx":266 */
  __pyx_1 = PyLong_FromUnsignedLong(((unsigned long)((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_data)); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 266; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("structarray._BaseArray.get_data_addr");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_10_BaseArray_get_data_stride(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_11structarray_10_BaseArray_get_data_stride[] = "\n        ``get_data_stride()``\n\n        Gets the number of bytes between the begining of each array element.\n        ";
static PyObject *__pyx_f_11structarray_10_BaseArray_get_data_stride(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  static char *__pyx_argnames[] = {0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "", __pyx_argnames)) return 0;
  Py_INCREF(__pyx_v_self);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":274 */
  ((struct __pyx_vtabstruct_11structarray__BaseArray *)((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->__pyx_vtab)->_sync_data_ptr(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self));

  /* "/home/mmarshall/projects/structarray/structarray.pyx":275 */
  __pyx_1 = PyInt_FromLong((((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self)->_stride * (sizeof(float)))); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 275; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("structarray._BaseArray.get_data_stride");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_n___init__;
static PyObject *__pyx_n_data_owner;
static PyObject *__pyx_n_list;
static PyObject *__pyx_n_max;
static PyObject *__pyx_n_set_length;
static PyObject *__pyx_n_min;


static int __pyx_f_11structarray_11StructArray___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_11structarray_11StructArray___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_attributes = 0;
  PyObject *__pyx_v_initial_data = 0;
  PyObject *__pyx_v_swizzles = 0;
  PyObject *__pyx_v_size = 0;
  PyObject *__pyx_v_defaults = 0;
  int __pyx_v_i;
  PyObject *__pyx_v_length;
  PyObject *__pyx_v_name;
  PyObject *__pyx_v_array;
  PyObject *__pyx_v_initial_len;
  int __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  int __pyx_5;
  int __pyx_6;
  long __pyx_7;
  static char *__pyx_argnames[] = {"attributes","initial_data","swizzles","size","defaults",0};
  __pyx_v_initial_data = __pyx_k4;
  __pyx_v_swizzles = __pyx_k5;
  __pyx_v_size = __pyx_k6;
  __pyx_v_defaults = __pyx_k7;
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O|OOOO", __pyx_argnames, &__pyx_v_attributes, &__pyx_v_initial_data, &__pyx_v_swizzles, &__pyx_v_size, &__pyx_v_defaults)) return -1;
  Py_INCREF((PyObject *)__pyx_v_self);
  Py_INCREF(__pyx_v_attributes);
  Py_INCREF(__pyx_v_initial_data);
  Py_INCREF(__pyx_v_swizzles);
  Py_INCREF(__pyx_v_size);
  Py_INCREF(__pyx_v_defaults);
  __pyx_v_length = Py_None; Py_INCREF(Py_None);
  __pyx_v_name = Py_None; Py_INCREF(Py_None);
  __pyx_v_array = Py_None; Py_INCREF(Py_None);
  __pyx_v_initial_len = Py_None; Py_INCREF(Py_None);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":357 */
  __pyx_1 = PyObject_GetAttr(((PyObject*)__pyx_ptype_11structarray__BaseArray), __pyx_n___init__); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 357; goto __pyx_L1;}
  __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 357; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_self);
  __pyx_3 = PyDict_New(); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 357; goto __pyx_L1;}
  if (PyDict_SetItem(__pyx_3, __pyx_n_data_owner, __pyx_v_self) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 357; goto __pyx_L1;}
  __pyx_4 = PyEval_CallObjectWithKeywords(__pyx_1, __pyx_2, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 357; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_4); __pyx_4 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":359 */
  ((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->__pyx_base._stride = PyObject_Length(__pyx_v_attributes);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":360 */
  __pyx_1 = __Pyx_GetName(__pyx_b, __pyx_n_list); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 360; goto __pyx_L1;}
  __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 360; goto __pyx_L1;}
  Py_INCREF(__pyx_v_attributes);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_attributes);
  __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 360; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->_attributes);
  ((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->_attributes = __pyx_3;
  __pyx_3 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":361 */
  Py_INCREF(__pyx_v_swizzles);
  Py_DECREF(((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->_swizzles);
  ((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->_swizzles = __pyx_v_swizzles;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":363 */
  __pyx_4 = __Pyx_GetName(__pyx_b, __pyx_n_False); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 363; goto __pyx_L1;}
  __pyx_5 = PyInt_AsLong(__pyx_4); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 363; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;
  ((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->__pyx_base._is_assignable = __pyx_5;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":365 */
  __pyx_5 = PyObject_IsTrue(__pyx_v_defaults); if (__pyx_5 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 365; goto __pyx_L1;}
  __pyx_6 = (!__pyx_5);
  if (__pyx_6) {
    __pyx_1 = PyInt_FromLong(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 366; goto __pyx_L1;}
    __pyx_2 = PyList_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 366; goto __pyx_L1;}
    PyList_SET_ITEM(__pyx_2, 0, __pyx_1);
    __pyx_1 = 0;
    __pyx_3 = PyInt_FromSsize_t(PyObject_Length(((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->_attributes)); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 366; goto __pyx_L1;}
    __pyx_4 = PyNumber_Multiply(__pyx_2, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 366; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->_defaults);
    ((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->_defaults = __pyx_4;
    __pyx_4 = 0;
    goto __pyx_L2;
  }
  /*else*/ {
    Py_INCREF(__pyx_v_defaults);
    Py_DECREF(((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->_defaults);
    ((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->_defaults = __pyx_v_defaults;
  }
  __pyx_L2:;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":370 */
  __pyx_1 = PyInt_FromLong(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 370; goto __pyx_L1;}
  __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 370; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_1);
  __pyx_1 = 0;
  Py_DECREF(((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->__pyx_base._dimensions);
  ((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->__pyx_base._dimensions = __pyx_2;
  __pyx_2 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":372 */
  __pyx_3 = __Pyx_GetName(__pyx_b, __pyx_n_int); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 372; goto __pyx_L1;}
  __pyx_4 = __Pyx_GetName(__pyx_b, __pyx_n_long); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 372; goto __pyx_L1;}
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 372; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_3);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_4);
  __pyx_3 = 0;
  __pyx_4 = 0;
  __pyx_5 = PyObject_IsInstance(__pyx_v_size,__pyx_1); if (__pyx_5 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 372; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  if (__pyx_5) {

    /* "/home/mmarshall/projects/structarray/structarray.pyx":373 */
    __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_max); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 373; goto __pyx_L1;}
    __pyx_3 = PyInt_FromSsize_t(PyObject_Length(__pyx_v_initial_data)); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 373; goto __pyx_L1;}
    __pyx_4 = PyTuple_New(2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 373; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_4, 0, __pyx_3);
    Py_INCREF(__pyx_v_size);
    PyTuple_SET_ITEM(__pyx_4, 1, __pyx_v_size);
    __pyx_3 = 0;
    __pyx_1 = PyObject_CallObject(__pyx_2, __pyx_4); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 373; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    Py_DECREF(__pyx_v_size);
    __pyx_v_size = __pyx_1;
    __pyx_1 = 0;

    /* "/home/mmarshall/projects/structarray/structarray.pyx":374 */
    __pyx_3 = PyObject_GetAttr(__pyx_v_self, __pyx_n_set_length); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 374; goto __pyx_L1;}
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 374; goto __pyx_L1;}
    Py_INCREF(__pyx_v_size);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_size);
    __pyx_4 = PyObject_CallObject(__pyx_3, __pyx_2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 374; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    goto __pyx_L3;
  }
  __pyx_6 = (PyObject_Length(__pyx_v_size) == 1);
  if (__pyx_6) {

    /* "/home/mmarshall/projects/structarray/structarray.pyx":376 */
    __pyx_1 = __Pyx_GetName(__pyx_b, __pyx_n_max); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 376; goto __pyx_L1;}
    __pyx_3 = PyInt_FromSsize_t(PyObject_Length(__pyx_v_initial_data)); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 376; goto __pyx_L1;}
    __pyx_2 = PyInt_FromLong(0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 376; goto __pyx_L1;}
    __pyx_4 = PyObject_GetItem(__pyx_v_size, __pyx_2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 376; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 376; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_3);
    PyTuple_SET_ITEM(__pyx_2, 1, __pyx_4);
    __pyx_3 = 0;
    __pyx_4 = 0;
    __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 376; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_v_size);
    __pyx_v_size = __pyx_3;
    __pyx_3 = 0;

    /* "/home/mmarshall/projects/structarray/structarray.pyx":377 */
    __pyx_4 = PyObject_GetAttr(__pyx_v_self, __pyx_n_set_length); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 377; goto __pyx_L1;}
    __pyx_1 = PyTuple_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 377; goto __pyx_L1;}
    Py_INCREF(__pyx_v_size);
    PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_size);
    __pyx_2 = PyObject_CallObject(__pyx_4, __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 377; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    goto __pyx_L3;
  }
  /*else*/ {

    /* "/home/mmarshall/projects/structarray/structarray.pyx":379 */
    __pyx_3 = __Pyx_GetName(__pyx_b, __pyx_n_tuple); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 379; goto __pyx_L1;}
    __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 379; goto __pyx_L1;}
    Py_INCREF(__pyx_v_size);
    PyTuple_SET_ITEM(__pyx_4, 0, __pyx_v_size);
    __pyx_1 = PyObject_CallObject(__pyx_3, __pyx_4); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 379; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    Py_DECREF(__pyx_v_size);
    __pyx_v_size = __pyx_1;
    __pyx_1 = 0;

    /* "/home/mmarshall/projects/structarray/structarray.pyx":380 */
    __pyx_2 = PyInt_FromLong(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 380; goto __pyx_L1;}
    Py_DECREF(__pyx_v_length);
    __pyx_v_length = __pyx_2;
    __pyx_2 = 0;

    /* "/home/mmarshall/projects/structarray/structarray.pyx":381 */
    __pyx_3 = PyObject_GetIter(__pyx_v_size); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 381; goto __pyx_L1;}
    for (;;) {
      __pyx_4 = PyIter_Next(__pyx_3);
      if (!__pyx_4) {
        if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 381; goto __pyx_L1;}
        break;
      }
      __pyx_5 = PyInt_AsLong(__pyx_4); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 381; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      __pyx_v_i = __pyx_5;
      __pyx_1 = PyInt_FromLong(__pyx_v_i); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 382; goto __pyx_L1;}
      __pyx_2 = PyNumber_Multiply(__pyx_v_length, __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 382; goto __pyx_L1;}
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      Py_DECREF(__pyx_v_length);
      __pyx_v_length = __pyx_2;
      __pyx_2 = 0;
    }
    Py_DECREF(__pyx_3); __pyx_3 = 0;

    /* "/home/mmarshall/projects/structarray/structarray.pyx":383 */
    __pyx_4 = PyObject_GetAttr(__pyx_v_self, __pyx_n__grow); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 383; goto __pyx_L1;}
    __pyx_1 = __Pyx_GetName(__pyx_b, __pyx_n_True); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 383; goto __pyx_L1;}
    __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 383; goto __pyx_L1;}
    Py_INCREF(__pyx_v_length);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_length);
    PyTuple_SET_ITEM(__pyx_2, 1, __pyx_1);
    __pyx_1 = 0;
    __pyx_3 = PyObject_CallObject(__pyx_4, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 383; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;

    /* "/home/mmarshall/projects/structarray/structarray.pyx":384 */
    Py_INCREF(__pyx_v_size);
    Py_DECREF(((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->__pyx_base._dimensions);
    ((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->__pyx_base._dimensions = __pyx_v_size;
  }
  __pyx_L3:;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":386 */
  __pyx_1 = PyDict_New(); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 386; goto __pyx_L1;}
  Py_DECREF(((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->_attribute_arrays);
  ((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->_attribute_arrays = __pyx_1;
  __pyx_1 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":387 */
  __pyx_4 = PyList_New(0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 387; goto __pyx_L1;}
  Py_DECREF(((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->_column_arrays);
  ((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->_column_arrays = __pyx_4;
  __pyx_4 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":388 */
  __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_enumerate); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 388; goto __pyx_L1;}
  __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 388; goto __pyx_L1;}
  Py_INCREF(((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->_attributes);
  PyTuple_SET_ITEM(__pyx_3, 0, ((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->_attributes);
  __pyx_1 = PyObject_CallObject(__pyx_2, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 388; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_4 = PyObject_GetIter(__pyx_1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 388; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  for (;;) {
    __pyx_2 = PyIter_Next(__pyx_4);
    if (!__pyx_2) {
      if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 388; goto __pyx_L1;}
      break;
    }
    __pyx_3 = PyObject_GetIter(__pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 388; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_1 = __Pyx_UnpackItem(__pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 388; goto __pyx_L1;}
    __pyx_6 = PyInt_AsLong(__pyx_1); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 388; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_v_i = __pyx_6;
    __pyx_2 = __Pyx_UnpackItem(__pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 388; goto __pyx_L1;}
    Py_DECREF(__pyx_v_name);
    __pyx_v_name = __pyx_2;
    __pyx_2 = 0;
    if (__Pyx_EndUnpack(__pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 388; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;

    /* "/home/mmarshall/projects/structarray/structarray.pyx":389 */
    __pyx_1 = PyInt_FromLong(__pyx_v_i); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 389; goto __pyx_L1;}
    __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 389; goto __pyx_L1;}
    Py_INCREF(__pyx_v_self);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_self);
    PyTuple_SET_ITEM(__pyx_2, 1, __pyx_1);
    __pyx_1 = 0;
    __pyx_3 = PyObject_CallObject(((PyObject*)__pyx_ptype_11structarray_OffsetArray), __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 389; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_v_array);
    __pyx_v_array = __pyx_3;
    __pyx_3 = 0;

    /* "/home/mmarshall/projects/structarray/structarray.pyx":390 */
    if (PyObject_SetItem(((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->_attribute_arrays, __pyx_v_name, __pyx_v_array) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 390; goto __pyx_L1;}

    /* "/home/mmarshall/projects/structarray/structarray.pyx":391 */
    __pyx_1 = PyObject_GetAttr(((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->_column_arrays, __pyx_n_append); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 391; goto __pyx_L1;}
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 391; goto __pyx_L1;}
    Py_INCREF(__pyx_v_array);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_array);
    __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 391; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
  }
  Py_DECREF(__pyx_4); __pyx_4 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":396 */
  __pyx_1 = __Pyx_GetName(__pyx_b, __pyx_n_min); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 396; goto __pyx_L1;}
  __pyx_2 = PyInt_FromSsize_t(PyObject_Length(__pyx_v_initial_data)); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 396; goto __pyx_L1;}
  __pyx_3 = PyInt_FromLong(((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->__pyx_base._count); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 396; goto __pyx_L1;}
  __pyx_4 = PyTuple_New(2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 396; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_4, 0, __pyx_2);
  PyTuple_SET_ITEM(__pyx_4, 1, __pyx_3);
  __pyx_2 = 0;
  __pyx_3 = 0;
  __pyx_2 = PyObject_CallObject(__pyx_1, __pyx_4); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 396; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_4); __pyx_4 = 0;
  Py_DECREF(__pyx_v_initial_len);
  __pyx_v_initial_len = __pyx_2;
  __pyx_2 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":397 */
  __pyx_7 = PyInt_AsLong(__pyx_v_initial_len); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 397; goto __pyx_L1;}
  for (__pyx_v_i = 0; __pyx_v_i < __pyx_7; ++__pyx_v_i) {
    __pyx_3 = PyInt_FromLong(__pyx_v_i); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 398; goto __pyx_L1;}
    __pyx_1 = PyObject_GetItem(__pyx_v_initial_data, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 398; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __pyx_4 = PyInt_FromLong(__pyx_v_i); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 398; goto __pyx_L1;}
    if (PyObject_SetItem(__pyx_v_self, __pyx_4, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 398; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
  }

  /* "/home/mmarshall/projects/structarray/structarray.pyx":399 */
  __pyx_7 = PyInt_AsLong(__pyx_v_initial_len); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 399; goto __pyx_L1;}
  __pyx_5 = ((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->__pyx_base._count;
  for (__pyx_v_i = __pyx_7; __pyx_v_i < __pyx_5; ++__pyx_v_i) {
    __pyx_2 = PyInt_FromLong(__pyx_v_i); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 400; goto __pyx_L1;}
    if (PyObject_SetItem(__pyx_v_self, __pyx_2, ((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->_defaults) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 400; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
  }

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("structarray.StructArray.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_length);
  Py_DECREF(__pyx_v_name);
  Py_DECREF(__pyx_v_array);
  Py_DECREF(__pyx_v_initial_len);
  Py_DECREF((PyObject *)__pyx_v_self);
  Py_DECREF(__pyx_v_attributes);
  Py_DECREF(__pyx_v_initial_data);
  Py_DECREF(__pyx_v_swizzles);
  Py_DECREF(__pyx_v_size);
  Py_DECREF(__pyx_v_defaults);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_11StructArray___getattr__(PyObject *__pyx_v_self, PyObject *__pyx_v_name); /*proto*/
static PyObject *__pyx_f_11structarray_11StructArray___getattr__(PyObject *__pyx_v_self, PyObject *__pyx_v_name) {
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  Py_INCREF((PyObject *)__pyx_v_self);
  Py_INCREF(__pyx_v_name);
  __pyx_1 = ((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->_attribute_arrays != Py_None;
  if (__pyx_1) {
    __pyx_1 = PySequence_Contains(((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->_attribute_arrays, __pyx_v_name); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 404; goto __pyx_L1;}
  }
  if (__pyx_1) {
    __pyx_2 = PyObject_GetItem(((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->_attribute_arrays, __pyx_v_name); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 405; goto __pyx_L1;}
    __pyx_r = __pyx_2;
    __pyx_2 = 0;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  /*else*/ {
    __pyx_2 = PyObject_GenericGetAttr(__pyx_v_self,__pyx_v_name); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 407; goto __pyx_L1;}
    __pyx_r = __pyx_2;
    __pyx_2 = 0;
    goto __pyx_L0;
  }
  __pyx_L2:;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("structarray.StructArray.__getattr__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF((PyObject *)__pyx_v_self);
  Py_DECREF(__pyx_v_name);
  return __pyx_r;
}

static PyObject *__pyx_n_assign_from;

static int __pyx_f_11structarray_11StructArray___setattr__(PyObject *__pyx_v_self, PyObject *__pyx_v_name, PyObject *__pyx_v_value); /*proto*/
static int __pyx_f_11structarray_11StructArray___setattr__(PyObject *__pyx_v_self, PyObject *__pyx_v_name, PyObject *__pyx_v_value) {
  int __pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  Py_INCREF((PyObject *)__pyx_v_self);
  Py_INCREF(__pyx_v_name);
  Py_INCREF(__pyx_v_value);
  __pyx_1 = ((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->_attribute_arrays != Py_None;
  if (__pyx_1) {
    __pyx_1 = PySequence_Contains(((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->_attribute_arrays, __pyx_v_name); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 411; goto __pyx_L1;}
  }
  if (__pyx_1) {
    __pyx_2 = PyObject_GetItem(((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->_attribute_arrays, __pyx_v_name); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 412; goto __pyx_L1;}
    __pyx_3 = PyObject_GetAttr(__pyx_2, __pyx_n_assign_from); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 412; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 412; goto __pyx_L1;}
    Py_INCREF(__pyx_v_value);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_value);
    __pyx_4 = PyObject_CallObject(__pyx_3, __pyx_2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 412; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    goto __pyx_L2;
  }
  __pyx_1 = ((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->_swizzles != Py_None;
  if (__pyx_1) {
    __pyx_1 = PySequence_Contains(((struct __pyx_obj_11structarray_StructArray *)__pyx_v_self)->_swizzles, __pyx_v_name); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 413; goto __pyx_L1;}
  }
  if (__pyx_1) {
    __pyx_3 = __Pyx_GetName(__pyx_b, __pyx_n_NotImplemented); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 414; goto __pyx_L1;}
    __Pyx_Raise(__pyx_3, 0, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 414; goto __pyx_L1;}
    goto __pyx_L2;
  }
  /*else*/ {
    PyObject_GenericSetAttr(__pyx_v_self,__pyx_v_name,__pyx_v_value);
  }
  __pyx_L2:;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("structarray.StructArray.__setattr__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF((PyObject *)__pyx_v_self);
  Py_DECREF(__pyx_v_name);
  Py_DECREF(__pyx_v_value);
  return __pyx_r;
}

static PyObject *__pyx_n_sanitize_index;

static PyObject *__pyx_f_11structarray_11StructArray___getitem__(PyObject *__pyx_v_self, PyObject *__pyx_v_index); /*proto*/
static PyObject *__pyx_f_11structarray_11StructArray___getitem__(PyObject *__pyx_v_self, PyObject *__pyx_v_index) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  Py_INCREF((PyObject *)__pyx_v_self);
  Py_INCREF(__pyx_v_index);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":419 */
  __pyx_1 = PyObject_GetAttr(__pyx_v_self, __pyx_n_sanitize_index); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 419; goto __pyx_L1;}
  __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 419; goto __pyx_L1;}
  Py_INCREF(__pyx_v_index);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_index);
  __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 419; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_v_index);
  __pyx_v_index = __pyx_3;
  __pyx_3 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":420 */
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 420; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_self);
  Py_INCREF(__pyx_v_index);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_index);
  __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_11structarray__ItemInfo), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 420; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("structarray.StructArray.__getitem__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF((PyObject *)__pyx_v_self);
  Py_DECREF(__pyx_v_index);
  return __pyx_r;
}

static PyObject *__pyx_n__update;

static int __pyx_f_11structarray_11StructArray___setitem__(PyObject *__pyx_v_self, PyObject *__pyx_v_index, PyObject *__pyx_v_value); /*proto*/
static int __pyx_f_11structarray_11StructArray___setitem__(PyObject *__pyx_v_self, PyObject *__pyx_v_index, PyObject *__pyx_v_value) {
  int __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  Py_INCREF((PyObject *)__pyx_v_self);
  Py_INCREF(__pyx_v_index);
  Py_INCREF(__pyx_v_value);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":423 */
  __pyx_1 = PyObject_GetAttr(__pyx_v_self, __pyx_n_sanitize_index); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 423; goto __pyx_L1;}
  __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 423; goto __pyx_L1;}
  Py_INCREF(__pyx_v_index);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_index);
  __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 423; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_v_index);
  __pyx_v_index = __pyx_3;
  __pyx_3 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":424 */
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 424; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_self);
  Py_INCREF(__pyx_v_index);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_index);
  __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_11structarray__ItemInfo), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 424; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_3 = PyObject_GetAttr(__pyx_2, __pyx_n__update); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 424; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_1 = PyTuple_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 424; goto __pyx_L1;}
  Py_INCREF(__pyx_v_value);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_value);
  __pyx_2 = PyObject_CallObject(__pyx_3, __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 424; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("structarray.StructArray.__setitem__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF((PyObject *)__pyx_v_self);
  Py_DECREF(__pyx_v_index);
  Py_DECREF(__pyx_v_value);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_11StructArray___iter__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_11structarray_11StructArray___iter__(PyObject *__pyx_v_self) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  Py_INCREF((PyObject *)__pyx_v_self);
  __pyx_1 = PyTuple_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 427; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_self);
  __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_11structarray__StructArrayIter), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 427; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("structarray.StructArray.__iter__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF((PyObject *)__pyx_v_self);
  return __pyx_r;
}

static int __pyx_f_11structarray_16_StructArrayIter___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_11structarray_16_StructArrayIter___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  struct __pyx_obj_11structarray_StructArray *__pyx_v_array = 0;
  int __pyx_r;
  static char *__pyx_argnames[] = {"array",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_array)) return -1;
  Py_INCREF(__pyx_v_self);
  Py_INCREF((PyObject *)__pyx_v_array);
  if (!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_array), __pyx_ptype_11structarray_StructArray, 0, "array")) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 432; goto __pyx_L1;}
  Py_INCREF(((PyObject *)__pyx_v_array));
  Py_DECREF(((PyObject *)((struct __pyx_obj_11structarray__StructArrayIter *)__pyx_v_self)->array));
  ((struct __pyx_obj_11structarray__StructArrayIter *)__pyx_v_self)->array = __pyx_v_array;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  __Pyx_AddTraceback("structarray._StructArrayIter.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF((PyObject *)__pyx_v_array);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_16_StructArrayIter___iter__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_11structarray_16_StructArrayIter___iter__(PyObject *__pyx_v_self) {
  PyObject *__pyx_r;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_self);
  __pyx_r = __pyx_v_self;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_n_StopIteration;

static PyObject *__pyx_f_11structarray_16_StructArrayIter___next__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_11structarray_16_StructArrayIter___next__(PyObject *__pyx_v_self) {
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  Py_INCREF(__pyx_v_self);
  __pyx_1 = (((struct __pyx_obj_11structarray__StructArrayIter *)__pyx_v_self)->index >= ((struct __pyx_obj_11structarray__StructArrayIter *)__pyx_v_self)->array->__pyx_base._count);
  if (__pyx_1) {
    __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_StopIteration); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 438; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, 0, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 438; goto __pyx_L1;}
    goto __pyx_L2;
  }
  /*else*/ {

    /* "/home/mmarshall/projects/structarray/structarray.pyx":440 */
    ((struct __pyx_obj_11structarray__StructArrayIter *)__pyx_v_self)->index = (((struct __pyx_obj_11structarray__StructArrayIter *)__pyx_v_self)->index + 1);

    /* "/home/mmarshall/projects/structarray/structarray.pyx":441 */
    __pyx_2 = PyInt_FromLong((((struct __pyx_obj_11structarray__StructArrayIter *)__pyx_v_self)->index - 1)); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 441; goto __pyx_L1;}
    __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 441; goto __pyx_L1;}
    Py_INCREF(((PyObject *)((struct __pyx_obj_11structarray__StructArrayIter *)__pyx_v_self)->array));
    PyTuple_SET_ITEM(__pyx_3, 0, ((PyObject *)((struct __pyx_obj_11structarray__StructArrayIter *)__pyx_v_self)->array));
    PyTuple_SET_ITEM(__pyx_3, 1, __pyx_2);
    __pyx_2 = 0;
    __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_11structarray__ItemInfo), __pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 441; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __pyx_r = __pyx_2;
    __pyx_2 = 0;
    goto __pyx_L0;
  }
  __pyx_L2:;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("structarray._StructArrayIter.__next__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static int __pyx_f_11structarray_5Array___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_11structarray_5Array___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_initial_data = 0;
  PyObject *__pyx_v_size = 0;
  PyObject *__pyx_v_default = 0;
  int __pyx_v_i;
  int __pyx_v_initial_len;
  PyObject *__pyx_v_length;
  PyObject *__pyx_v_d;
  int __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  int __pyx_5;
  float __pyx_6;
  static char *__pyx_argnames[] = {"initial_data","size","default",0};
  __pyx_v_initial_data = __pyx_k8;
  __pyx_v_size = __pyx_k9;
  __pyx_v_default = __pyx_k10;
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "|OOO", __pyx_argnames, &__pyx_v_initial_data, &__pyx_v_size, &__pyx_v_default)) return -1;
  Py_INCREF((PyObject *)__pyx_v_self);
  Py_INCREF(__pyx_v_initial_data);
  Py_INCREF(__pyx_v_size);
  Py_INCREF(__pyx_v_default);
  __pyx_v_length = Py_None; Py_INCREF(Py_None);
  __pyx_v_d = Py_None; Py_INCREF(Py_None);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":493 */
  __pyx_1 = PyObject_GetAttr(((PyObject*)__pyx_ptype_11structarray__BaseArray), __pyx_n___init__); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 493; goto __pyx_L1;}
  __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 493; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_self);
  __pyx_3 = PyDict_New(); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 493; goto __pyx_L1;}
  if (PyDict_SetItem(__pyx_3, __pyx_n_data_owner, __pyx_v_self) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 493; goto __pyx_L1;}
  __pyx_4 = PyEval_CallObjectWithKeywords(__pyx_1, __pyx_2, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 493; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_4); __pyx_4 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":496 */
  ((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->__pyx_base._stride = 1;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":497 */
  __pyx_1 = __Pyx_GetName(__pyx_b, __pyx_n_True); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 497; goto __pyx_L1;}
  __pyx_5 = PyInt_AsLong(__pyx_1); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 497; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  ((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->__pyx_base._is_assignable = __pyx_5;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":499 */
  __pyx_2 = __pyx_v_default;
  Py_INCREF(__pyx_2);
  __pyx_5 = PyObject_IsTrue(__pyx_2); if (__pyx_5 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 499; goto __pyx_L1;}
  if (!__pyx_5) {
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyInt_FromLong(0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 499; goto __pyx_L1;}
  }
  __pyx_6 = PyFloat_AsDouble(__pyx_2); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 499; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  ((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->_default = __pyx_6;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":501 */
  __pyx_3 = PyInt_FromLong(0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 501; goto __pyx_L1;}
  __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 501; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_4, 0, __pyx_3);
  __pyx_3 = 0;
  Py_DECREF(((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->__pyx_base._dimensions);
  ((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->__pyx_base._dimensions = __pyx_4;
  __pyx_4 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":503 */
  __pyx_1 = __Pyx_GetName(__pyx_b, __pyx_n_int); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 503; goto __pyx_L1;}
  __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_long); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 503; goto __pyx_L1;}
  __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 503; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_1);
  PyTuple_SET_ITEM(__pyx_3, 1, __pyx_2);
  __pyx_1 = 0;
  __pyx_2 = 0;
  __pyx_5 = PyObject_IsInstance(__pyx_v_size,__pyx_3); if (__pyx_5 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 503; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  if (__pyx_5) {

    /* "/home/mmarshall/projects/structarray/structarray.pyx":504 */
    __pyx_4 = __Pyx_GetName(__pyx_b, __pyx_n_max); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 504; goto __pyx_L1;}
    __pyx_1 = PyInt_FromSsize_t(PyObject_Length(__pyx_v_initial_data)); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 504; goto __pyx_L1;}
    __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 504; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_1);
    Py_INCREF(__pyx_v_size);
    PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_size);
    __pyx_1 = 0;
    __pyx_3 = PyObject_CallObject(__pyx_4, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 504; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_v_size);
    __pyx_v_size = __pyx_3;
    __pyx_3 = 0;

    /* "/home/mmarshall/projects/structarray/structarray.pyx":505 */
    __pyx_1 = PyObject_GetAttr(__pyx_v_self, __pyx_n_set_length); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 505; goto __pyx_L1;}
    __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 505; goto __pyx_L1;}
    Py_INCREF(__pyx_v_size);
    PyTuple_SET_ITEM(__pyx_4, 0, __pyx_v_size);
    __pyx_2 = PyObject_CallObject(__pyx_1, __pyx_4); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 505; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    goto __pyx_L2;
  }
  __pyx_5 = (PyObject_Length(__pyx_v_size) == 1);
  if (__pyx_5) {

    /* "/home/mmarshall/projects/structarray/structarray.pyx":507 */
    __pyx_3 = __Pyx_GetName(__pyx_b, __pyx_n_max); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 507; goto __pyx_L1;}
    __pyx_1 = PyInt_FromSsize_t(PyObject_Length(__pyx_v_initial_data)); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 507; goto __pyx_L1;}
    __pyx_4 = PyInt_FromLong(0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 507; goto __pyx_L1;}
    __pyx_2 = PyObject_GetItem(__pyx_v_size, __pyx_4); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 507; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    __pyx_4 = PyTuple_New(2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 507; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_4, 0, __pyx_1);
    PyTuple_SET_ITEM(__pyx_4, 1, __pyx_2);
    __pyx_1 = 0;
    __pyx_2 = 0;
    __pyx_1 = PyObject_CallObject(__pyx_3, __pyx_4); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 507; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    Py_DECREF(__pyx_v_size);
    __pyx_v_size = __pyx_1;
    __pyx_1 = 0;

    /* "/home/mmarshall/projects/structarray/structarray.pyx":508 */
    __pyx_2 = PyObject_GetAttr(__pyx_v_self, __pyx_n_set_length); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 508; goto __pyx_L1;}
    __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 508; goto __pyx_L1;}
    Py_INCREF(__pyx_v_size);
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_size);
    __pyx_4 = PyObject_CallObject(__pyx_2, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 508; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    goto __pyx_L2;
  }
  /*else*/ {

    /* "/home/mmarshall/projects/structarray/structarray.pyx":510 */
    __pyx_1 = __Pyx_GetName(__pyx_b, __pyx_n_tuple); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 510; goto __pyx_L1;}
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 510; goto __pyx_L1;}
    Py_INCREF(__pyx_v_size);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_size);
    __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 510; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_v_size);
    __pyx_v_size = __pyx_3;
    __pyx_3 = 0;

    /* "/home/mmarshall/projects/structarray/structarray.pyx":511 */
    __pyx_4 = PyInt_FromLong(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 511; goto __pyx_L1;}
    Py_DECREF(__pyx_v_length);
    __pyx_v_length = __pyx_4;
    __pyx_4 = 0;

    /* "/home/mmarshall/projects/structarray/structarray.pyx":512 */
    __pyx_1 = PyObject_GetIter(__pyx_v_size); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 512; goto __pyx_L1;}
    for (;;) {
      __pyx_2 = PyIter_Next(__pyx_1);
      if (!__pyx_2) {
        if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 512; goto __pyx_L1;}
        break;
      }
      Py_DECREF(__pyx_v_d);
      __pyx_v_d = __pyx_2;
      __pyx_2 = 0;
      __pyx_3 = PyNumber_Multiply(__pyx_v_length, __pyx_v_d); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 513; goto __pyx_L1;}
      Py_DECREF(__pyx_v_length);
      __pyx_v_length = __pyx_3;
      __pyx_3 = 0;
    }
    Py_DECREF(__pyx_1); __pyx_1 = 0;

    /* "/home/mmarshall/projects/structarray/structarray.pyx":514 */
    __pyx_4 = PyObject_GetAttr(__pyx_v_self, __pyx_n__grow); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 514; goto __pyx_L1;}
    __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_True); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 514; goto __pyx_L1;}
    __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 514; goto __pyx_L1;}
    Py_INCREF(__pyx_v_length);
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_length);
    PyTuple_SET_ITEM(__pyx_3, 1, __pyx_2);
    __pyx_2 = 0;
    __pyx_1 = PyObject_CallObject(__pyx_4, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 514; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;

    /* "/home/mmarshall/projects/structarray/structarray.pyx":515 */
    Py_INCREF(__pyx_v_size);
    Py_DECREF(((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->__pyx_base._dimensions);
    ((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->__pyx_base._dimensions = __pyx_v_size;
  }
  __pyx_L2:;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":517 */
  __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_min); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 517; goto __pyx_L1;}
  __pyx_4 = PyInt_FromSsize_t(PyObject_Length(__pyx_v_initial_data)); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 517; goto __pyx_L1;}
  __pyx_3 = PyInt_FromLong(((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->__pyx_base._count); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 517; goto __pyx_L1;}
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 517; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_4);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_3);
  __pyx_4 = 0;
  __pyx_3 = 0;
  __pyx_4 = PyObject_CallObject(__pyx_2, __pyx_1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 517; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_5 = PyInt_AsLong(__pyx_4); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 517; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;
  __pyx_v_initial_len = __pyx_5;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":518 */
  for (__pyx_v_i = 0; __pyx_v_i < __pyx_v_initial_len; ++__pyx_v_i) {
    __pyx_3 = PyInt_FromLong(__pyx_v_i); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 519; goto __pyx_L1;}
    __pyx_2 = PyObject_GetItem(__pyx_v_initial_data, __pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 519; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __pyx_6 = PyFloat_AsDouble(__pyx_2); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 519; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    (((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->__pyx_base._data[__pyx_v_i]) = __pyx_6;
  }

  /* "/home/mmarshall/projects/structarray/structarray.pyx":520 */
  __pyx_5 = __pyx_v_default != Py_None;
  if (__pyx_5) {
    __pyx_5 = ((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->__pyx_base._count;
    for (__pyx_v_i = __pyx_v_initial_len; __pyx_v_i < __pyx_5; ++__pyx_v_i) {
      (((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->__pyx_base._data[__pyx_v_i]) = ((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->_default;
    }
    goto __pyx_L7;
  }
  __pyx_L7:;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("structarray.Array.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_length);
  Py_DECREF(__pyx_v_d);
  Py_DECREF((PyObject *)__pyx_v_self);
  Py_DECREF(__pyx_v_initial_data);
  Py_DECREF(__pyx_v_size);
  Py_DECREF(__pyx_v_default);
  return __pyx_r;
}

static void __pyx_f_11structarray_5Array__setitem(struct __pyx_obj_11structarray_Array *__pyx_v_self,int __pyx_v_index,float __pyx_v_value) {
  Py_INCREF((PyObject *)__pyx_v_self);
  (__pyx_v_self->__pyx_base._data[(__pyx_v_index * __pyx_v_self->__pyx_base._stride)]) = __pyx_v_value;

  Py_DECREF((PyObject *)__pyx_v_self);
}

static float __pyx_f_11structarray_5Array__getitem(struct __pyx_obj_11structarray_Array *__pyx_v_self,int __pyx_v_index) {
  float __pyx_r;
  Py_INCREF((PyObject *)__pyx_v_self);
  __pyx_r = (__pyx_v_self->__pyx_base._data[(__pyx_v_index * __pyx_v_self->__pyx_base._stride)]);
  goto __pyx_L0;

  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF((PyObject *)__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_k29p;

static char __pyx_k29[] = "This array is not assignable.";

static int __pyx_f_11structarray_5Array___setitem__(PyObject *__pyx_v_self, PyObject *__pyx_v_index, PyObject *__pyx_arg_value); /*proto*/
static int __pyx_f_11structarray_5Array___setitem__(PyObject *__pyx_v_self, PyObject *__pyx_v_index, PyObject *__pyx_arg_value) {
  float __pyx_v_value;
  int __pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  Py_INCREF((PyObject *)__pyx_v_self);
  Py_INCREF(__pyx_v_index);
  __pyx_v_value = PyFloat_AsDouble(__pyx_arg_value); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 530; goto __pyx_L1;}

  /* "/home/mmarshall/projects/structarray/structarray.pyx":531 */
  ((struct __pyx_vtabstruct_11structarray_Array *)((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->__pyx_base.__pyx_vtab)->__pyx_base._sync_data_ptr(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self));

  /* "/home/mmarshall/projects/structarray/structarray.pyx":532 */
  __pyx_1 = (!((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->__pyx_base._is_assignable);
  if (__pyx_1) {
    __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_ValueError); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 533; goto __pyx_L1;}
    __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 533; goto __pyx_L1;}
    Py_INCREF(__pyx_k29p);
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_k29p);
    __pyx_4 = PyObject_CallObject(__pyx_2, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 533; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __Pyx_Raise(__pyx_4, 0, 0);
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 533; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":534 */
  __pyx_2 = PyObject_GetAttr(__pyx_v_self, __pyx_n_sanitize_index); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 534; goto __pyx_L1;}
  __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 534; goto __pyx_L1;}
  Py_INCREF(__pyx_v_index);
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_index);
  __pyx_4 = PyObject_CallObject(__pyx_2, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 534; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_v_index);
  __pyx_v_index = __pyx_4;
  __pyx_4 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":535 */
  __pyx_1 = PyInt_AsLong(__pyx_v_index); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 535; goto __pyx_L1;}
  ((struct __pyx_vtabstruct_11structarray_Array *)((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->__pyx_base.__pyx_vtab)->__pyx_base._setitem(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self),__pyx_1,__pyx_v_value);

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("structarray.Array.__setitem__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF((PyObject *)__pyx_v_self);
  Py_DECREF(__pyx_v_index);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_5Array___getitem__(PyObject *__pyx_v_self, PyObject *__pyx_v_index); /*proto*/
static PyObject *__pyx_f_11structarray_5Array___getitem__(PyObject *__pyx_v_self, PyObject *__pyx_v_index) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  int __pyx_4;
  Py_INCREF((PyObject *)__pyx_v_self);
  Py_INCREF(__pyx_v_index);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":538 */
  ((struct __pyx_vtabstruct_11structarray_Array *)((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->__pyx_base.__pyx_vtab)->__pyx_base._sync_data_ptr(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self));

  /* "/home/mmarshall/projects/structarray/structarray.pyx":539 */
  __pyx_1 = PyObject_GetAttr(__pyx_v_self, __pyx_n_sanitize_index); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 539; goto __pyx_L1;}
  __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 539; goto __pyx_L1;}
  Py_INCREF(__pyx_v_index);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_index);
  __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 539; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_v_index);
  __pyx_v_index = __pyx_3;
  __pyx_3 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":540 */
  __pyx_4 = PyInt_AsLong(__pyx_v_index); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 540; goto __pyx_L1;}
  __pyx_1 = PyFloat_FromDouble(((struct __pyx_vtabstruct_11structarray_Array *)((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->__pyx_base.__pyx_vtab)->__pyx_base._getitem(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self),__pyx_4)); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 540; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("structarray.Array.__getitem__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF((PyObject *)__pyx_v_self);
  Py_DECREF(__pyx_v_index);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_5Array___add__(PyObject *__pyx_v_self, PyObject *__pyx_v_other); /*proto*/
static PyObject *__pyx_f_11structarray_5Array___add__(PyObject *__pyx_v_self, PyObject *__pyx_v_other) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_other);
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 543; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_self);
  Py_INCREF(__pyx_v_other);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_other);
  __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_11structarray_ArrayOpAdd), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 543; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("structarray.Array.__add__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_other);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_5Array___sub__(PyObject *__pyx_v_self, PyObject *__pyx_v_other); /*proto*/
static PyObject *__pyx_f_11structarray_5Array___sub__(PyObject *__pyx_v_self, PyObject *__pyx_v_other) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_other);
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 546; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_self);
  Py_INCREF(__pyx_v_other);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_other);
  __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_11structarray_ArrayOpSub), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 546; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("structarray.Array.__sub__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_other);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_5Array___mul__(PyObject *__pyx_v_self, PyObject *__pyx_v_other); /*proto*/
static PyObject *__pyx_f_11structarray_5Array___mul__(PyObject *__pyx_v_self, PyObject *__pyx_v_other) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_other);
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 549; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_self);
  Py_INCREF(__pyx_v_other);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_other);
  __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_11structarray_ArrayOpMul), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 549; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("structarray.Array.__mul__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_other);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_5Array___div__(PyObject *__pyx_v_self, PyObject *__pyx_v_other); /*proto*/
static PyObject *__pyx_f_11structarray_5Array___div__(PyObject *__pyx_v_self, PyObject *__pyx_v_other) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_other);
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 552; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_self);
  Py_INCREF(__pyx_v_other);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_other);
  __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_11structarray_ArrayOpDiv), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 552; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("structarray.Array.__div__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_other);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_5Array___truediv__(PyObject *__pyx_v_self, PyObject *__pyx_v_other); /*proto*/
static PyObject *__pyx_f_11structarray_5Array___truediv__(PyObject *__pyx_v_self, PyObject *__pyx_v_other) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_other);
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 555; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_self);
  Py_INCREF(__pyx_v_other);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_other);
  __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_11structarray_ArrayOpDiv), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 555; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("structarray.Array.__truediv__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_other);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_5Array___mod__(PyObject *__pyx_v_self, PyObject *__pyx_v_other); /*proto*/
static PyObject *__pyx_f_11structarray_5Array___mod__(PyObject *__pyx_v_self, PyObject *__pyx_v_other) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_other);
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 558; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_self);
  Py_INCREF(__pyx_v_other);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_other);
  __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_11structarray_ArrayOpMod), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 558; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("structarray.Array.__mod__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_other);
  return __pyx_r;
}

static PyObject *__pyx_n_assign_to;

static PyObject *__pyx_f_11structarray_5Array___iadd__(PyObject *__pyx_v_self, PyObject *__pyx_v_other); /*proto*/
static PyObject *__pyx_f_11structarray_5Array___iadd__(PyObject *__pyx_v_self, PyObject *__pyx_v_other) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  Py_INCREF((PyObject *)__pyx_v_self);
  Py_INCREF(__pyx_v_other);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":561 */
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 561; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_self);
  Py_INCREF(__pyx_v_other);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_other);
  __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_11structarray_ArrayOpAdd), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 561; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_1 = PyObject_GetAttr(__pyx_2, __pyx_n_assign_to); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 561; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 561; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_self);
  __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 561; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":562 */
  Py_INCREF(__pyx_v_self);
  __pyx_r = __pyx_v_self;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("structarray.Array.__iadd__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF((PyObject *)__pyx_v_self);
  Py_DECREF(__pyx_v_other);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_5Array___isub__(PyObject *__pyx_v_self, PyObject *__pyx_v_other); /*proto*/
static PyObject *__pyx_f_11structarray_5Array___isub__(PyObject *__pyx_v_self, PyObject *__pyx_v_other) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  Py_INCREF((PyObject *)__pyx_v_self);
  Py_INCREF(__pyx_v_other);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":565 */
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 565; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_self);
  Py_INCREF(__pyx_v_other);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_other);
  __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_11structarray_ArrayOpSub), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 565; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_1 = PyObject_GetAttr(__pyx_2, __pyx_n_assign_to); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 565; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 565; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_self);
  __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 565; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":566 */
  Py_INCREF(__pyx_v_self);
  __pyx_r = __pyx_v_self;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("structarray.Array.__isub__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF((PyObject *)__pyx_v_self);
  Py_DECREF(__pyx_v_other);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_5Array___imul__(PyObject *__pyx_v_self, PyObject *__pyx_v_other); /*proto*/
static PyObject *__pyx_f_11structarray_5Array___imul__(PyObject *__pyx_v_self, PyObject *__pyx_v_other) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  Py_INCREF((PyObject *)__pyx_v_self);
  Py_INCREF(__pyx_v_other);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":569 */
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 569; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_self);
  Py_INCREF(__pyx_v_other);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_other);
  __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_11structarray_ArrayOpMul), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 569; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_1 = PyObject_GetAttr(__pyx_2, __pyx_n_assign_to); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 569; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 569; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_self);
  __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 569; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":570 */
  Py_INCREF(__pyx_v_self);
  __pyx_r = __pyx_v_self;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("structarray.Array.__imul__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF((PyObject *)__pyx_v_self);
  Py_DECREF(__pyx_v_other);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_5Array___idiv__(PyObject *__pyx_v_self, PyObject *__pyx_v_other); /*proto*/
static PyObject *__pyx_f_11structarray_5Array___idiv__(PyObject *__pyx_v_self, PyObject *__pyx_v_other) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  Py_INCREF((PyObject *)__pyx_v_self);
  Py_INCREF(__pyx_v_other);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":573 */
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 573; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_self);
  Py_INCREF(__pyx_v_other);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_other);
  __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_11structarray_ArrayOpDiv), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 573; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_1 = PyObject_GetAttr(__pyx_2, __pyx_n_assign_to); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 573; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 573; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_self);
  __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 573; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":574 */
  Py_INCREF(__pyx_v_self);
  __pyx_r = __pyx_v_self;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("structarray.Array.__idiv__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF((PyObject *)__pyx_v_self);
  Py_DECREF(__pyx_v_other);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_5Array___imod__(PyObject *__pyx_v_self, PyObject *__pyx_v_other); /*proto*/
static PyObject *__pyx_f_11structarray_5Array___imod__(PyObject *__pyx_v_self, PyObject *__pyx_v_other) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  Py_INCREF((PyObject *)__pyx_v_self);
  Py_INCREF(__pyx_v_other);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":577 */
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 577; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_self);
  Py_INCREF(__pyx_v_other);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_other);
  __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_11structarray_ArrayOpMod), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 577; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_1 = PyObject_GetAttr(__pyx_2, __pyx_n_assign_to); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 577; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 577; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_self);
  __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 577; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":578 */
  Py_INCREF(__pyx_v_self);
  __pyx_r = __pyx_v_self;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("structarray.Array.__imod__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF((PyObject *)__pyx_v_self);
  Py_DECREF(__pyx_v_other);
  return __pyx_r;
}

static PyObject *__pyx_n_float;
static PyObject *__pyx_n_TypeError;

static PyObject *__pyx_k30p;
static PyObject *__pyx_k31p;

static char __pyx_k30[] = "This array is not assignable";
static char __pyx_k31[] = "Mismatched lengths";

static PyObject *__pyx_f_11structarray_5Array_assign_from(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_11structarray_5Array_assign_from[] = "\n        ``assign_from(source)``\n\n        Reassigns our value from another array.\n\n        ``source`` can be another ``Array`` instance, or any iterable of the\n        correct length.  It can also me a single number, in which case it will\n        be assigned to each item.\n        ";
static PyObject *__pyx_f_11structarray_5Array_assign_from(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_source = 0;
  int __pyx_v_i;
  float __pyx_v_f;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  float __pyx_5;
  static char *__pyx_argnames[] = {"source",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_source)) return 0;
  Py_INCREF((PyObject *)__pyx_v_self);
  Py_INCREF(__pyx_v_source);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":591 */
  ((struct __pyx_vtabstruct_11structarray_Array *)((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->__pyx_base.__pyx_vtab)->__pyx_base._sync_data_ptr(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self));

  /* "/home/mmarshall/projects/structarray/structarray.pyx":592 */
  __pyx_1 = (!((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->__pyx_base._is_assignable);
  if (__pyx_1) {
    __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_ValueError); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 593; goto __pyx_L1;}
    __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 593; goto __pyx_L1;}
    Py_INCREF(__pyx_k30p);
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_k30p);
    __pyx_4 = PyObject_CallObject(__pyx_2, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 593; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __Pyx_Raise(__pyx_4, 0, 0);
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 593; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":596 */
  /*try:*/ {

    /* "/home/mmarshall/projects/structarray/structarray.pyx":597 */
    __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_float); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 597; goto __pyx_L3;}
    __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 597; goto __pyx_L3;}
    Py_INCREF(__pyx_v_source);
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_source);
    __pyx_4 = PyObject_CallObject(__pyx_2, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 597; goto __pyx_L3;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __pyx_5 = PyFloat_AsDouble(__pyx_4); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 597; goto __pyx_L3;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    __pyx_v_f = __pyx_5;

    /* "/home/mmarshall/projects/structarray/structarray.pyx":598 */
    __pyx_1 = ((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->__pyx_base._count;
    for (__pyx_v_i = 0; __pyx_v_i < __pyx_1; ++__pyx_v_i) {
      ((struct __pyx_vtabstruct_11structarray_Array *)((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->__pyx_base.__pyx_vtab)->__pyx_base._setitem(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self),__pyx_v_i,__pyx_v_f);
    }

    /* "/home/mmarshall/projects/structarray/structarray.pyx":600 */
    __pyx_r = Py_None; Py_INCREF(Py_None);
    goto __pyx_L0;
  }
  goto __pyx_L4;
  __pyx_L3:;
  Py_XDECREF(__pyx_2); __pyx_2 = 0;
  Py_XDECREF(__pyx_3); __pyx_3 = 0;
  Py_XDECREF(__pyx_4); __pyx_4 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":601 */
  __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_TypeError); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 601; goto __pyx_L1;}
  __pyx_1 = PyErr_ExceptionMatches(__pyx_2);
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  if (__pyx_1) {
    __Pyx_AddTraceback("structarray.assign_from");
    if (__Pyx_GetException(&__pyx_3, &__pyx_4, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 601; goto __pyx_L1;}
    Py_DECREF(__pyx_3);
    Py_DECREF(__pyx_4);
    Py_DECREF(__pyx_2);
    goto __pyx_L4;
  }
  goto __pyx_L1;
  __pyx_L4:;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":604 */
  __pyx_1 = (!(PyObject_Length(__pyx_v_source) == PyObject_Length(__pyx_v_self)));
  if (__pyx_1) {
    __pyx_3 = __Pyx_GetName(__pyx_b, __pyx_n_ValueError); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 605; goto __pyx_L1;}
    __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 605; goto __pyx_L1;}
    Py_INCREF(__pyx_k31p);
    PyTuple_SET_ITEM(__pyx_4, 0, __pyx_k31p);
    __pyx_2 = PyObject_CallObject(__pyx_3, __pyx_4); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 605; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    __Pyx_Raise(__pyx_2, 0, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 605; goto __pyx_L1;}
    goto __pyx_L7;
  }
  __pyx_L7:;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":606 */
  __pyx_1 = PyObject_HasAttr(__pyx_v_source,__pyx_n_assign_to); if (__pyx_1 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 606; goto __pyx_L1;}
  if (__pyx_1) {
    __pyx_3 = PyObject_GetAttr(__pyx_v_source, __pyx_n_assign_to); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 607; goto __pyx_L1;}
    __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 607; goto __pyx_L1;}
    Py_INCREF(__pyx_v_self);
    PyTuple_SET_ITEM(__pyx_4, 0, __pyx_v_self);
    __pyx_2 = PyObject_CallObject(__pyx_3, __pyx_4); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 607; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    goto __pyx_L8;
  }
  /*else*/ {
    __pyx_1 = ((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->__pyx_base._count;
    for (__pyx_v_i = 0; __pyx_v_i < __pyx_1; ++__pyx_v_i) {
      __pyx_3 = __Pyx_GetName(__pyx_b, __pyx_n_float); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 610; goto __pyx_L1;}
      __pyx_4 = PyInt_FromLong(__pyx_v_i); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 610; goto __pyx_L1;}
      __pyx_2 = PyObject_GetItem(__pyx_v_source, __pyx_4); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 610; goto __pyx_L1;}
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 610; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_4, 0, __pyx_2);
      __pyx_2 = 0;
      __pyx_2 = PyObject_CallObject(__pyx_3, __pyx_4); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 610; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      Py_DECREF(__pyx_4); __pyx_4 = 0;
      __pyx_5 = PyFloat_AsDouble(__pyx_2); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 610; goto __pyx_L1;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      ((struct __pyx_vtabstruct_11structarray_Array *)((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->__pyx_base.__pyx_vtab)->__pyx_base._setitem(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self),__pyx_v_i,__pyx_5);
    }
  }
  __pyx_L8:;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("structarray.Array.assign_from");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF((PyObject *)__pyx_v_self);
  Py_DECREF(__pyx_v_source);
  return __pyx_r;
}

static PyObject *__pyx_k33p;
static PyObject *__pyx_k34p;

static char __pyx_k33[] = "Mismatched lengths";
static char __pyx_k34[] = "Array is not assignable";

static PyObject *__pyx_f_11structarray_5Array_assign_to(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_11structarray_5Array_assign_to[] = "\n        ``assign_to(target)``\n\n        Assigns our value *to* another array.\n\n        ``target`` must be another ``Array`` instance.  (Not a ``StructArray``,\n        but a ``StructArray`` attribute works fine.)\n        ";
static PyObject *__pyx_f_11structarray_5Array_assign_to(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  struct __pyx_obj_11structarray_Array *__pyx_v_target = 0;
  int __pyx_v_i;
  float *__pyx_v_from_;
  float *__pyx_v_to_;
  int __pyx_v_from_stride;
  int __pyx_v_to_stride;
  int __pyx_v_count;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  static char *__pyx_argnames[] = {"target",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_target)) return 0;
  Py_INCREF((PyObject *)__pyx_v_self);
  Py_INCREF((PyObject *)__pyx_v_target);
  if (!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_target), __pyx_ptype_11structarray_Array, 0, "target")) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 612; goto __pyx_L1;}

  /* "/home/mmarshall/projects/structarray/structarray.pyx":621 */
  ((struct __pyx_vtabstruct_11structarray_Array *)((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->__pyx_base.__pyx_vtab)->__pyx_base._sync_data_ptr(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self));

  /* "/home/mmarshall/projects/structarray/structarray.pyx":622 */
  ((struct __pyx_vtabstruct_11structarray_Array *)__pyx_v_target->__pyx_base.__pyx_vtab)->__pyx_base._sync_data_ptr(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_target));

  /* "/home/mmarshall/projects/structarray/structarray.pyx":623 */
  __pyx_1 = (!(PyObject_Length(((PyObject *)__pyx_v_target)) == PyObject_Length(__pyx_v_self)));
  if (__pyx_1) {
    __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_ValueError); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 624; goto __pyx_L1;}
    __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 624; goto __pyx_L1;}
    Py_INCREF(__pyx_k33p);
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_k33p);
    __pyx_4 = PyObject_CallObject(__pyx_2, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 624; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __Pyx_Raise(__pyx_4, 0, 0);
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 624; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":625 */
  __pyx_1 = (!__pyx_v_target->__pyx_base._is_assignable);
  if (__pyx_1) {
    __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_ValueError); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 626; goto __pyx_L1;}
    __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 626; goto __pyx_L1;}
    Py_INCREF(__pyx_k34p);
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_k34p);
    __pyx_4 = PyObject_CallObject(__pyx_2, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 626; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __Pyx_Raise(__pyx_4, 0, 0);
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 626; goto __pyx_L1;}
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":630 */
  __pyx_v_from_ = ((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->__pyx_base._data;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":631 */
  __pyx_v_from_stride = ((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->__pyx_base._stride;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":632 */
  __pyx_v_to_ = __pyx_v_target->__pyx_base._data;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":633 */
  __pyx_v_to_stride = __pyx_v_target->__pyx_base._stride;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":634 */
  __pyx_v_count = __pyx_v_target->__pyx_base._count;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":635 */
  for (__pyx_v_i = 0; __pyx_v_i < __pyx_v_count; ++__pyx_v_i) {
    (__pyx_v_to_[(__pyx_v_i * __pyx_v_to_stride)]) = (__pyx_v_from_[(__pyx_v_i * __pyx_v_from_stride)]);
  }

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("structarray.Array.assign_to");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF((PyObject *)__pyx_v_self);
  Py_DECREF((PyObject *)__pyx_v_target);
  return __pyx_r;
}

static PyObject *__pyx_n_str;
static PyObject *__pyx_n___class__;
static PyObject *__pyx_n___name__;
static PyObject *__pyx_n_join;

static PyObject *__pyx_k36p;
static PyObject *__pyx_k35p;

static char __pyx_k35[] = "<%s [%s]>";
static char __pyx_k36[] = ", ";

static PyObject *__pyx_f_11structarray_5Array___repr__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_11structarray_5Array___repr__(PyObject *__pyx_v_self) {
  PyObject *__pyx_v_items;
  PyObject *__pyx_v_f;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  PyObject *__pyx_5 = 0;
  Py_INCREF((PyObject *)__pyx_v_self);
  __pyx_v_items = Py_None; Py_INCREF(Py_None);
  __pyx_v_f = Py_None; Py_INCREF(Py_None);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":639 */
  __pyx_1 = PyList_New(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 639; goto __pyx_L1;}
  Py_DECREF(__pyx_v_items);
  __pyx_v_items = __pyx_1;
  __pyx_1 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":640 */
  __pyx_1 = PyObject_GetIter(__pyx_v_self); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 640; goto __pyx_L1;}
  for (;;) {
    __pyx_2 = PyIter_Next(__pyx_1);
    if (!__pyx_2) {
      if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 640; goto __pyx_L1;}
      break;
    }
    Py_DECREF(__pyx_v_f);
    __pyx_v_f = __pyx_2;
    __pyx_2 = 0;
    __pyx_2 = PyObject_GetAttr(__pyx_v_items, __pyx_n_append); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 641; goto __pyx_L1;}
    __pyx_3 = __Pyx_GetName(__pyx_b, __pyx_n_str); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 641; goto __pyx_L1;}
    __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 641; goto __pyx_L1;}
    Py_INCREF(__pyx_v_f);
    PyTuple_SET_ITEM(__pyx_4, 0, __pyx_v_f);
    __pyx_5 = PyObject_CallObject(__pyx_3, __pyx_4); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 641; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 641; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_5);
    __pyx_5 = 0;
    __pyx_4 = PyObject_CallObject(__pyx_2, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 641; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
  }
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":642 */
  __pyx_5 = PyObject_GetAttr(__pyx_v_self, __pyx_n___class__); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 642; goto __pyx_L1;}
  __pyx_2 = PyObject_GetAttr(__pyx_5, __pyx_n___name__); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 642; goto __pyx_L1;}
  Py_DECREF(__pyx_5); __pyx_5 = 0;
  __pyx_3 = PyObject_GetAttr(__pyx_k36p, __pyx_n_join); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 642; goto __pyx_L1;}
  __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 642; goto __pyx_L1;}
  Py_INCREF(__pyx_v_items);
  PyTuple_SET_ITEM(__pyx_4, 0, __pyx_v_items);
  __pyx_1 = PyObject_CallObject(__pyx_3, __pyx_4); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 642; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_4); __pyx_4 = 0;
  __pyx_5 = PyTuple_New(2); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 642; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_5, 0, __pyx_2);
  PyTuple_SET_ITEM(__pyx_5, 1, __pyx_1);
  __pyx_2 = 0;
  __pyx_1 = 0;
  __pyx_3 = PyNumber_Remainder(__pyx_k35p, __pyx_5); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 642; goto __pyx_L1;}
  Py_DECREF(__pyx_5); __pyx_5 = 0;
  __pyx_r = __pyx_3;
  __pyx_3 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  Py_XDECREF(__pyx_5);
  __Pyx_AddTraceback("structarray.Array.__repr__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_items);
  Py_DECREF(__pyx_v_f);
  Py_DECREF((PyObject *)__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_n_size;


static PyObject *__pyx_f_11structarray_5Array_stretch(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_11structarray_5Array_stretch[] = "\n        ``stretch(times)``\n\n        Returns a stretched copy this array.  Each item is\n        duplicated ``times`` times.\n\n        For example, ``Array([1,2,3]).stretch(3)`` will return\n        ``Array([1,1,1,2,2,2,3,3,3])``.\n\n        This operation is not lazy.\n        ";
static PyObject *__pyx_f_11structarray_5Array_stretch(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  int __pyx_v_times;
  struct __pyx_obj_11structarray_Array *__pyx_v_new;
  int __pyx_v_i;
  int __pyx_v_j;
  int __pyx_v_length;
  int __pyx_v_stride;
  float __pyx_v_temp;
  float *__pyx_v_new_data;
  float *__pyx_v__data;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"times",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "i", __pyx_argnames, &__pyx_v_times)) return 0;
  Py_INCREF((PyObject *)__pyx_v_self);
  __pyx_v_new = ((struct __pyx_obj_11structarray_Array *)Py_None); Py_INCREF(Py_None);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":657 */
  __pyx_1 = PyTuple_New(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 657; goto __pyx_L1;}
  __pyx_2 = PyDict_New(); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 657; goto __pyx_L1;}
  __pyx_3 = PyInt_FromSsize_t((PyObject_Length(__pyx_v_self) * __pyx_v_times)); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 657; goto __pyx_L1;}
  if (PyDict_SetItem(__pyx_2, __pyx_n_size, __pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 657; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_3 = PyEval_CallObjectWithKeywords(((PyObject*)__pyx_ptype_11structarray_Array), __pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 657; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  if (!__Pyx_TypeTest(__pyx_3, __pyx_ptype_11structarray_Array)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 657; goto __pyx_L1;}
  Py_DECREF(((PyObject *)__pyx_v_new));
  __pyx_v_new = ((struct __pyx_obj_11structarray_Array *)__pyx_3);
  __pyx_3 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":661 */
  __pyx_v_length = PyObject_Length(__pyx_v_self);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":662 */
  __pyx_v_new_data = __pyx_v_new->__pyx_base._data;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":663 */
  __pyx_v__data = ((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->__pyx_base._data;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":664 */
  __pyx_v_stride = ((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->__pyx_base._stride;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":666 */
  for (__pyx_v_i = 0; __pyx_v_i < __pyx_v_length; ++__pyx_v_i) {

    /* "/home/mmarshall/projects/structarray/structarray.pyx":667 */
    __pyx_v_temp = (__pyx_v__data[(__pyx_v_i * __pyx_v_stride)]);

    /* "/home/mmarshall/projects/structarray/structarray.pyx":668 */
    for (__pyx_v_j = 0; __pyx_v_j < __pyx_v_times; ++__pyx_v_j) {
      (__pyx_v_new_data[((__pyx_v_i * __pyx_v_times) + __pyx_v_j)]) = __pyx_v_temp;
    }
  }

  /* "/home/mmarshall/projects/structarray/structarray.pyx":670 */
  Py_INCREF(((PyObject *)__pyx_v_new));
  __pyx_r = ((PyObject *)__pyx_v_new);
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("structarray.Array.stretch");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF((PyObject *)__pyx_v_new);
  Py_DECREF((PyObject *)__pyx_v_self);
  return __pyx_r;
}


static PyObject *__pyx_f_11structarray_5Array_repeat(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_11structarray_5Array_repeat[] = "\n        ``repeat(times)``\n\n        Returns a repeated copy of this array.\n\n        For example, ``Array([1,2,3]).repeat(3)`` will return\n        ``Array([1,2,3,1,2,3,1,2,3])``.\n\n        This operation is not lazy.\n        ";
static PyObject *__pyx_f_11structarray_5Array_repeat(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  int __pyx_v_times;
  int __pyx_v_stride;
  int __pyx_v_i;
  int __pyx_v_j;
  int __pyx_v_length;
  struct __pyx_obj_11structarray_Array *__pyx_v_new;
  float *__pyx_v_new_data;
  float *__pyx_v__data;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  int __pyx_4;
  int __pyx_5;
  static char *__pyx_argnames[] = {"times",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "i", __pyx_argnames, &__pyx_v_times)) return 0;
  Py_INCREF((PyObject *)__pyx_v_self);
  __pyx_v_new = ((struct __pyx_obj_11structarray_Array *)Py_None); Py_INCREF(Py_None);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":684 */
  __pyx_v_length = PyObject_Length(__pyx_v_self);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":685 */
  __pyx_v_stride = ((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->__pyx_base._stride;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":687 */
  __pyx_1 = PyTuple_New(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 687; goto __pyx_L1;}
  __pyx_2 = PyDict_New(); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 687; goto __pyx_L1;}
  __pyx_3 = PyInt_FromSsize_t((PyObject_Length(__pyx_v_self) * __pyx_v_times)); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 687; goto __pyx_L1;}
  if (PyDict_SetItem(__pyx_2, __pyx_n_size, __pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 687; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_3 = PyEval_CallObjectWithKeywords(((PyObject*)__pyx_ptype_11structarray_Array), __pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 687; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  if (!__Pyx_TypeTest(__pyx_3, __pyx_ptype_11structarray_Array)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 687; goto __pyx_L1;}
  Py_DECREF(((PyObject *)__pyx_v_new));
  __pyx_v_new = ((struct __pyx_obj_11structarray_Array *)__pyx_3);
  __pyx_3 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":690 */
  __pyx_v_new_data = __pyx_v_new->__pyx_base._data;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":691 */
  __pyx_v__data = ((struct __pyx_obj_11structarray_Array *)__pyx_v_self)->__pyx_base._data;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":693 */
  __pyx_v_j = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":694 */
  __pyx_4 = (__pyx_v_length * __pyx_v_times);
  for (__pyx_v_i = 0; __pyx_v_i < __pyx_4; ++__pyx_v_i) {

    /* "/home/mmarshall/projects/structarray/structarray.pyx":695 */
    (__pyx_v_new_data[__pyx_v_i]) = (__pyx_v__data[(__pyx_v_j * __pyx_v_stride)]);

    /* "/home/mmarshall/projects/structarray/structarray.pyx":696 */
    __pyx_v_j = (__pyx_v_j + 1);

    /* "/home/mmarshall/projects/structarray/structarray.pyx":697 */
    __pyx_5 = (__pyx_v_j == __pyx_v_length);
    if (__pyx_5) {
      __pyx_v_j = 0;
      goto __pyx_L4;
    }
    __pyx_L4:;
  }

  /* "/home/mmarshall/projects/structarray/structarray.pyx":699 */
  Py_INCREF(((PyObject *)__pyx_v_new));
  __pyx_r = ((PyObject *)__pyx_v_new);
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("structarray.Array.repeat");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF((PyObject *)__pyx_v_new);
  Py_DECREF((PyObject *)__pyx_v_self);
  return __pyx_r;
}


static PyObject *__pyx_f_11structarray_5Array_copy(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_11structarray_5Array_copy[] = "\n        ``copy()``\n\n        Returns a new ``Array`` with a copy of our data.  (The data is\n        copied immediately; there\'s nothing lazy here.)\n        ";
static PyObject *__pyx_f_11structarray_5Array_copy(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_s;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "", __pyx_argnames)) return 0;
  Py_INCREF((PyObject *)__pyx_v_self);
  __pyx_v_s = Py_None; Py_INCREF(Py_None);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":708 */
  __pyx_1 = PyTuple_New(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 708; goto __pyx_L1;}
  __pyx_2 = PyDict_New(); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 708; goto __pyx_L1;}
  __pyx_3 = PyInt_FromSsize_t(PyObject_Length(__pyx_v_self)); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 708; goto __pyx_L1;}
  if (PyDict_SetItem(__pyx_2, __pyx_n_size, __pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 708; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_3 = PyEval_CallObjectWithKeywords(((PyObject*)__pyx_ptype_11structarray_Array), __pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 708; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_v_s);
  __pyx_v_s = __pyx_3;
  __pyx_3 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":709 */
  __pyx_1 = PyObject_GetAttr(__pyx_v_self, __pyx_n_assign_to); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 709; goto __pyx_L1;}
  __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 709; goto __pyx_L1;}
  Py_INCREF(__pyx_v_s);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_s);
  __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 709; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":710 */
  Py_INCREF(__pyx_v_s);
  __pyx_r = __pyx_v_s;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("structarray.Array.copy");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_s);
  Py_DECREF((PyObject *)__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_5Array___iter__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_11structarray_5Array___iter__(PyObject *__pyx_v_self) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  Py_INCREF((PyObject *)__pyx_v_self);
  __pyx_1 = PyTuple_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 713; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_self);
  __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_11structarray__ArrayIter), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 713; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("structarray.Array.__iter__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF((PyObject *)__pyx_v_self);
  return __pyx_r;
}

static int __pyx_f_11structarray_10_ArrayIter___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_11structarray_10_ArrayIter___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  struct __pyx_obj_11structarray_Array *__pyx_v_array = 0;
  int __pyx_r;
  static char *__pyx_argnames[] = {"array",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_array)) return -1;
  Py_INCREF(__pyx_v_self);
  Py_INCREF((PyObject *)__pyx_v_array);
  if (!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_array), __pyx_ptype_11structarray_Array, 0, "array")) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 718; goto __pyx_L1;}
  Py_INCREF(((PyObject *)__pyx_v_array));
  Py_DECREF(((PyObject *)((struct __pyx_obj_11structarray__ArrayIter *)__pyx_v_self)->array));
  ((struct __pyx_obj_11structarray__ArrayIter *)__pyx_v_self)->array = __pyx_v_array;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  __Pyx_AddTraceback("structarray._ArrayIter.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF((PyObject *)__pyx_v_array);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_10_ArrayIter___iter__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_11structarray_10_ArrayIter___iter__(PyObject *__pyx_v_self) {
  PyObject *__pyx_r;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_self);
  __pyx_r = __pyx_v_self;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_10_ArrayIter___next__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_11structarray_10_ArrayIter___next__(PyObject *__pyx_v_self) {
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  Py_INCREF(__pyx_v_self);
  __pyx_1 = (((struct __pyx_obj_11structarray__ArrayIter *)__pyx_v_self)->index >= ((struct __pyx_obj_11structarray__ArrayIter *)__pyx_v_self)->array->__pyx_base._count);
  if (__pyx_1) {
    __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_StopIteration); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 724; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, 0, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 724; goto __pyx_L1;}
    goto __pyx_L2;
  }
  /*else*/ {

    /* "/home/mmarshall/projects/structarray/structarray.pyx":726 */
    ((struct __pyx_obj_11structarray__ArrayIter *)__pyx_v_self)->index = (((struct __pyx_obj_11structarray__ArrayIter *)__pyx_v_self)->index + 1);

    /* "/home/mmarshall/projects/structarray/structarray.pyx":727 */
    __pyx_2 = PyFloat_FromDouble(((struct __pyx_vtabstruct_11structarray_Array *)((struct __pyx_obj_11structarray__ArrayIter *)__pyx_v_self)->array->__pyx_base.__pyx_vtab)->__pyx_base._getitem(((struct __pyx_obj_11structarray__BaseArray *)((struct __pyx_obj_11structarray__ArrayIter *)__pyx_v_self)->array),(((struct __pyx_obj_11structarray__ArrayIter *)__pyx_v_self)->index - 1))); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 727; goto __pyx_L1;}
    __pyx_r = __pyx_2;
    __pyx_2 = 0;
    goto __pyx_L0;
  }
  __pyx_L2:;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("structarray._ArrayIter.__next__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static int __pyx_f_11structarray_11OffsetArray___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_11structarray_11OffsetArray___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  struct __pyx_obj_11structarray__BaseArray *__pyx_v_array = 0;
  int __pyx_v_offset;
  int __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  int __pyx_5;
  static char *__pyx_argnames[] = {"array","offset",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "Oi", __pyx_argnames, &__pyx_v_array, &__pyx_v_offset)) return -1;
  Py_INCREF((PyObject *)__pyx_v_self);
  Py_INCREF(__pyx_v_array);
  if (!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_array), __pyx_ptype_11structarray__BaseArray, 0, "array")) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 739; goto __pyx_L1;}

  /* "/home/mmarshall/projects/structarray/structarray.pyx":740 */
  ((struct __pyx_obj_11structarray_OffsetArray *)__pyx_v_self)->_offset = __pyx_v_offset;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":741 */
  __pyx_1 = PyObject_GetAttr(((PyObject*)__pyx_ptype_11structarray__BaseArray), __pyx_n___init__); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 741; goto __pyx_L1;}
  __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 741; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_self);
  __pyx_3 = PyDict_New(); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 741; goto __pyx_L1;}
  if (PyDict_SetItem(__pyx_3, __pyx_n_data_owner, ((PyObject *)__pyx_v_array)) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 741; goto __pyx_L1;}
  __pyx_4 = PyEval_CallObjectWithKeywords(__pyx_1, __pyx_2, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 741; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_4); __pyx_4 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":742 */
  __pyx_1 = __Pyx_GetName(__pyx_b, __pyx_n_True); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 742; goto __pyx_L1;}
  __pyx_5 = PyInt_AsLong(__pyx_1); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 742; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  ((struct __pyx_obj_11structarray_OffsetArray *)__pyx_v_self)->__pyx_base.__pyx_base._is_assignable = __pyx_5;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("structarray.OffsetArray.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF((PyObject *)__pyx_v_self);
  Py_DECREF(__pyx_v_array);
  return __pyx_r;
}

static void __pyx_f_11structarray_11OffsetArray__sync_data_ptr(struct __pyx_obj_11structarray_OffsetArray *__pyx_v_self) {
  int __pyx_1;
  Py_INCREF((PyObject *)__pyx_v_self);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":745 */
  __pyx_vtabptr_11structarray_Array->__pyx_base._sync_data_ptr(((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_self));

  /* "/home/mmarshall/projects/structarray/structarray.pyx":746 */
  __pyx_1 = (!__pyx_v_self->__pyx_base.__pyx_base._is_data_owner);
  if (__pyx_1) {
    __pyx_v_self->__pyx_base.__pyx_base._data = (__pyx_v_self->__pyx_base.__pyx_base.data_owner->_data + __pyx_v_self->_offset);
    goto __pyx_L2;
  }
  __pyx_L2:;

  Py_DECREF((PyObject *)__pyx_v_self);
}

static int __pyx_f_11structarray_9_ItemInfo___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_11structarray_9_ItemInfo___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  struct __pyx_obj_11structarray_StructArray *__pyx_v_array = 0;
  int __pyx_v_index;
  int __pyx_r;
  static char *__pyx_argnames[] = {"array","index",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "Oi", __pyx_argnames, &__pyx_v_array, &__pyx_v_index)) return -1;
  Py_INCREF(__pyx_v_self);
  Py_INCREF((PyObject *)__pyx_v_array);
  if (!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_array), __pyx_ptype_11structarray_StructArray, 0, "array")) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 759; goto __pyx_L1;}

  /* "/home/mmarshall/projects/structarray/structarray.pyx":760 */
  Py_INCREF(((PyObject *)__pyx_v_array));
  Py_DECREF(((PyObject *)((struct __pyx_obj_11structarray__ItemInfo *)__pyx_v_self)->array));
  ((struct __pyx_obj_11structarray__ItemInfo *)__pyx_v_self)->array = __pyx_v_array;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":761 */
  ((struct __pyx_obj_11structarray__ItemInfo *)__pyx_v_self)->index = __pyx_v_index;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  __Pyx_AddTraceback("structarray._ItemInfo.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF((PyObject *)__pyx_v_array);
  return __pyx_r;
}

static PyObject *__pyx_n_AttributeError;

static int __pyx_f_11structarray_9_ItemInfo___setattr__(PyObject *__pyx_v_self, PyObject *__pyx_v_name, PyObject *__pyx_arg_value); /*proto*/
static int __pyx_f_11structarray_9_ItemInfo___setattr__(PyObject *__pyx_v_self, PyObject *__pyx_v_name, PyObject *__pyx_arg_value) {
  float __pyx_v_value;
  int __pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_name);
  __pyx_v_value = PyFloat_AsDouble(__pyx_arg_value); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 763; goto __pyx_L1;}

  /* "/home/mmarshall/projects/structarray/structarray.pyx":764 */
  __pyx_1 = PySequence_Contains(((struct __pyx_obj_11structarray__ItemInfo *)__pyx_v_self)->array->_attribute_arrays, __pyx_v_name); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 764; goto __pyx_L1;}
  __pyx_1 = !__pyx_1;
  if (__pyx_1) {
    __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_AttributeError); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 765; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, 0, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 765; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":766 */
  __pyx_2 = PyFloat_FromDouble(__pyx_v_value); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 766; goto __pyx_L1;}
  __pyx_3 = PyObject_GetItem(((struct __pyx_obj_11structarray__ItemInfo *)__pyx_v_self)->array->_attribute_arrays, __pyx_v_name); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 766; goto __pyx_L1;}
  __pyx_4 = PyInt_FromLong(((struct __pyx_obj_11structarray__ItemInfo *)__pyx_v_self)->index); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 766; goto __pyx_L1;}
  if (PyObject_SetItem(__pyx_3, __pyx_4, __pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 766; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_4); __pyx_4 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("structarray._ItemInfo.__setattr__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_name);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_9_ItemInfo___getattr__(PyObject *__pyx_v_self, PyObject *__pyx_v_name); /*proto*/
static PyObject *__pyx_f_11structarray_9_ItemInfo___getattr__(PyObject *__pyx_v_self, PyObject *__pyx_v_name) {
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_name);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":769 */
  __pyx_1 = PySequence_Contains(((struct __pyx_obj_11structarray__ItemInfo *)__pyx_v_self)->array->_attribute_arrays, __pyx_v_name); if (__pyx_1 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 769; goto __pyx_L1;}
  __pyx_1 = !__pyx_1;
  if (__pyx_1) {
    __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_AttributeError); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 770; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, 0, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 770; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":771 */
  __pyx_2 = PyObject_GetItem(((struct __pyx_obj_11structarray__ItemInfo *)__pyx_v_self)->array->_attribute_arrays, __pyx_v_name); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 771; goto __pyx_L1;}
  __pyx_3 = PyInt_FromLong(((struct __pyx_obj_11structarray__ItemInfo *)__pyx_v_self)->index); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 771; goto __pyx_L1;}
  __pyx_4 = PyObject_GetItem(__pyx_2, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 771; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_r = __pyx_4;
  __pyx_4 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("structarray._ItemInfo.__getattr__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_name);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_9_ItemInfo___getitem__(PyObject *__pyx_v_self, PyObject *__pyx_v_index); /*proto*/
static PyObject *__pyx_f_11structarray_9_ItemInfo___getitem__(PyObject *__pyx_v_self, PyObject *__pyx_v_index) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_index);
  __pyx_1 = PyObject_GetItem(((struct __pyx_obj_11structarray__ItemInfo *)__pyx_v_self)->array->_column_arrays, __pyx_v_index); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 774; goto __pyx_L1;}
  __pyx_2 = PyInt_FromLong(((struct __pyx_obj_11structarray__ItemInfo *)__pyx_v_self)->index); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 774; goto __pyx_L1;}
  __pyx_3 = PyObject_GetItem(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 774; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_r = __pyx_3;
  __pyx_3 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("structarray._ItemInfo.__getitem__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_index);
  return __pyx_r;
}

static int __pyx_f_11structarray_9_ItemInfo___setitem__(PyObject *__pyx_v_self, PyObject *__pyx_v_index, PyObject *__pyx_arg_value); /*proto*/
static int __pyx_f_11structarray_9_ItemInfo___setitem__(PyObject *__pyx_v_self, PyObject *__pyx_v_index, PyObject *__pyx_arg_value) {
  float __pyx_v_value;
  int __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_index);
  __pyx_v_value = PyFloat_AsDouble(__pyx_arg_value); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 776; goto __pyx_L1;}
  __pyx_1 = PyFloat_FromDouble(__pyx_v_value); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 777; goto __pyx_L1;}
  __pyx_2 = PyObject_GetItem(((struct __pyx_obj_11structarray__ItemInfo *)__pyx_v_self)->array->_column_arrays, __pyx_v_index); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 777; goto __pyx_L1;}
  __pyx_3 = PyInt_FromLong(((struct __pyx_obj_11structarray__ItemInfo *)__pyx_v_self)->index); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 777; goto __pyx_L1;}
  if (PyObject_SetItem(__pyx_2, __pyx_3, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 777; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("structarray._ItemInfo.__setitem__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_index);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_9_ItemInfo__update(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static PyObject *__pyx_f_11structarray_9_ItemInfo__update(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_new_data = 0;
  int __pyx_v_i;
  int __pyx_v_length;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  static char *__pyx_argnames[] = {"new_data",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_new_data)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_new_data);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":782 */
  __pyx_v_length = PyObject_Length(__pyx_v_new_data);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":783 */
  __pyx_1 = (((struct __pyx_obj_11structarray__ItemInfo *)__pyx_v_self)->index >= PyObject_Length(((PyObject *)((struct __pyx_obj_11structarray__ItemInfo *)__pyx_v_self)->array)));
  if (__pyx_1) {
    __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_IndexError); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 784; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, 0, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 784; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":785 */
  __pyx_1 = (__pyx_v_length > PyObject_Length(((struct __pyx_obj_11structarray__ItemInfo *)__pyx_v_self)->array->_column_arrays));
  if (__pyx_1) {
    __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_ValueError); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 786; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, 0, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 786; goto __pyx_L1;}
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":787 */
  for (__pyx_v_i = 0; __pyx_v_i < __pyx_v_length; ++__pyx_v_i) {
    __pyx_2 = PyInt_FromLong(__pyx_v_i); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 788; goto __pyx_L1;}
    __pyx_3 = PyObject_GetItem(__pyx_v_new_data, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 788; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyInt_FromLong(__pyx_v_i); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 788; goto __pyx_L1;}
    __pyx_4 = PyObject_GetItem(((struct __pyx_obj_11structarray__ItemInfo *)__pyx_v_self)->array->_column_arrays, __pyx_2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 788; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyInt_FromLong(((struct __pyx_obj_11structarray__ItemInfo *)__pyx_v_self)->index); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 788; goto __pyx_L1;}
    if (PyObject_SetItem(__pyx_4, __pyx_2, __pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 788; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
  }

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("structarray._ItemInfo._update");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_new_data);
  return __pyx_r;
}

static Py_ssize_t __pyx_f_11structarray_9_ItemInfo___len__(PyObject *__pyx_v_self); /*proto*/
static Py_ssize_t __pyx_f_11structarray_9_ItemInfo___len__(PyObject *__pyx_v_self) {
  Py_ssize_t __pyx_r;
  Py_INCREF(__pyx_v_self);
  __pyx_r = PyObject_Length(((struct __pyx_obj_11structarray__ItemInfo *)__pyx_v_self)->array->_column_arrays);
  goto __pyx_L0;

  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_k41p;

static char __pyx_k41[] = "<item at index %d %r>";

static PyObject *__pyx_f_11structarray_9_ItemInfo___repr__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_11structarray_9_ItemInfo___repr__(PyObject *__pyx_v_self) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  Py_INCREF(__pyx_v_self);
  __pyx_1 = PyInt_FromLong(((struct __pyx_obj_11structarray__ItemInfo *)__pyx_v_self)->index); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 794; goto __pyx_L1;}
  __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_tuple); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 794; goto __pyx_L1;}
  __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 794; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_self);
  __pyx_4 = PyObject_CallObject(__pyx_2, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 794; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_2 = PyTuple_New(2); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 794; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_1);
  PyTuple_SET_ITEM(__pyx_2, 1, __pyx_4);
  __pyx_1 = 0;
  __pyx_4 = 0;
  __pyx_3 = PyNumber_Remainder(__pyx_k41p, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 794; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_r = __pyx_3;
  __pyx_3 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("structarray._ItemInfo.__repr__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static int __pyx_f_11structarray_9_ArrayOp2___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_11structarray_9_ArrayOp2___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_arg1 = 0;
  PyObject *__pyx_v_arg2 = 0;
  int __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  int __pyx_5;
  static char *__pyx_argnames[] = {"arg1","arg2",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO", __pyx_argnames, &__pyx_v_arg1, &__pyx_v_arg2)) return -1;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_arg1);
  Py_INCREF(__pyx_v_arg2);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":800 */
  #ifndef PYREX_WITHOUT_ASSERTIONS
  __pyx_1 = __Pyx_GetName(__pyx_b, __pyx_n_float); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 800; goto __pyx_L1;}
  __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_long); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 800; goto __pyx_L1;}
  __pyx_3 = __Pyx_GetName(__pyx_b, __pyx_n_int); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 800; goto __pyx_L1;}
  __pyx_4 = PyTuple_New(5); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 800; goto __pyx_L1;}
  Py_INCREF(((PyObject*)__pyx_ptype_11structarray__ArrayOp2));
  PyTuple_SET_ITEM(__pyx_4, 0, ((PyObject*)__pyx_ptype_11structarray__ArrayOp2));
  Py_INCREF(((PyObject*)__pyx_ptype_11structarray__BaseArray));
  PyTuple_SET_ITEM(__pyx_4, 1, ((PyObject*)__pyx_ptype_11structarray__BaseArray));
  PyTuple_SET_ITEM(__pyx_4, 2, __pyx_1);
  PyTuple_SET_ITEM(__pyx_4, 3, __pyx_2);
  PyTuple_SET_ITEM(__pyx_4, 4, __pyx_3);
  __pyx_1 = 0;
  __pyx_2 = 0;
  __pyx_3 = 0;
  __pyx_5 = PyObject_IsInstance(__pyx_v_arg1,__pyx_4); if (__pyx_5 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 800; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;
  if (!__pyx_5) {
    PyErr_SetNone(PyExc_AssertionError);
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 800; goto __pyx_L1;}
  }
  #endif

  /* "/home/mmarshall/projects/structarray/structarray.pyx":801 */
  #ifndef PYREX_WITHOUT_ASSERTIONS
  __pyx_1 = __Pyx_GetName(__pyx_b, __pyx_n_float); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 801; goto __pyx_L1;}
  __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_long); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 801; goto __pyx_L1;}
  __pyx_3 = __Pyx_GetName(__pyx_b, __pyx_n_int); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 801; goto __pyx_L1;}
  __pyx_4 = PyTuple_New(5); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 801; goto __pyx_L1;}
  Py_INCREF(((PyObject*)__pyx_ptype_11structarray__ArrayOp2));
  PyTuple_SET_ITEM(__pyx_4, 0, ((PyObject*)__pyx_ptype_11structarray__ArrayOp2));
  Py_INCREF(((PyObject*)__pyx_ptype_11structarray__BaseArray));
  PyTuple_SET_ITEM(__pyx_4, 1, ((PyObject*)__pyx_ptype_11structarray__BaseArray));
  PyTuple_SET_ITEM(__pyx_4, 2, __pyx_1);
  PyTuple_SET_ITEM(__pyx_4, 3, __pyx_2);
  PyTuple_SET_ITEM(__pyx_4, 4, __pyx_3);
  __pyx_1 = 0;
  __pyx_2 = 0;
  __pyx_3 = 0;
  __pyx_5 = PyObject_IsInstance(__pyx_v_arg2,__pyx_4); if (__pyx_5 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 801; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;
  if (!__pyx_5) {
    PyErr_SetNone(PyExc_AssertionError);
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 801; goto __pyx_L1;}
  }
  #endif

  /* "/home/mmarshall/projects/structarray/structarray.pyx":802 */
  Py_INCREF(__pyx_v_arg1);
  Py_DECREF(((struct __pyx_obj_11structarray__ArrayOp2 *)__pyx_v_self)->arg1);
  ((struct __pyx_obj_11structarray__ArrayOp2 *)__pyx_v_self)->arg1 = __pyx_v_arg1;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":803 */
  Py_INCREF(__pyx_v_arg2);
  Py_DECREF(((struct __pyx_obj_11structarray__ArrayOp2 *)__pyx_v_self)->arg2);
  ((struct __pyx_obj_11structarray__ArrayOp2 *)__pyx_v_self)->arg2 = __pyx_v_arg2;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("structarray._ArrayOp2.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_arg1);
  Py_DECREF(__pyx_v_arg2);
  return __pyx_r;
}

static PyObject *__pyx_n_copy;

static PyObject *__pyx_f_11structarray_9_ArrayOp2_assign_to(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_11structarray_9_ArrayOp2_assign_to[] = "\n        ``assign_to(target)``\n\n        Performs the operation, saving the result in ``target``.\n        ";
static PyObject *__pyx_f_11structarray_9_ArrayOp2_assign_to(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  struct __pyx_obj_11structarray__BaseArray *__pyx_v_target = 0;
  PyObject *__pyx_v_arg1;
  PyObject *__pyx_v_arg2;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  float __pyx_5;
  static char *__pyx_argnames[] = {"target",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_target)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_target);
  __pyx_v_arg1 = Py_None; Py_INCREF(Py_None);
  __pyx_v_arg2 = Py_None; Py_INCREF(Py_None);
  if (!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_target), __pyx_ptype_11structarray__BaseArray, 1, "target")) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 804; goto __pyx_L1;}

  /* "/home/mmarshall/projects/structarray/structarray.pyx":810 */
  __pyx_1 = PyObject_IsInstance(((struct __pyx_obj_11structarray__ArrayOp2 *)__pyx_v_self)->arg1,((PyObject*)__pyx_ptype_11structarray__ArrayOp2)); if (__pyx_1 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 810; goto __pyx_L1;}
  if (__pyx_1) {
    __pyx_2 = PyObject_GetAttr(((struct __pyx_obj_11structarray__ArrayOp2 *)__pyx_v_self)->arg1, __pyx_n_copy); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 811; goto __pyx_L1;}
    __pyx_3 = PyObject_CallObject(__pyx_2, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 811; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_v_arg1);
    __pyx_v_arg1 = __pyx_3;
    __pyx_3 = 0;
    goto __pyx_L2;
  }
  /*else*/ {
    Py_INCREF(((struct __pyx_obj_11structarray__ArrayOp2 *)__pyx_v_self)->arg1);
    Py_DECREF(__pyx_v_arg1);
    __pyx_v_arg1 = ((struct __pyx_obj_11structarray__ArrayOp2 *)__pyx_v_self)->arg1;
  }
  __pyx_L2:;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":814 */
  __pyx_1 = PyObject_IsInstance(((struct __pyx_obj_11structarray__ArrayOp2 *)__pyx_v_self)->arg2,((PyObject*)__pyx_ptype_11structarray__ArrayOp2)); if (__pyx_1 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 814; goto __pyx_L1;}
  if (__pyx_1) {
    __pyx_2 = PyObject_GetAttr(((struct __pyx_obj_11structarray__ArrayOp2 *)__pyx_v_self)->arg2, __pyx_n_copy); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 815; goto __pyx_L1;}
    __pyx_3 = PyObject_CallObject(__pyx_2, 0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 815; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_v_arg2);
    __pyx_v_arg2 = __pyx_3;
    __pyx_3 = 0;
    goto __pyx_L3;
  }
  /*else*/ {
    Py_INCREF(((struct __pyx_obj_11structarray__ArrayOp2 *)__pyx_v_self)->arg2);
    Py_DECREF(__pyx_v_arg2);
    __pyx_v_arg2 = ((struct __pyx_obj_11structarray__ArrayOp2 *)__pyx_v_self)->arg2;
  }
  __pyx_L3:;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":819 */
  __pyx_1 = PyObject_IsInstance(__pyx_v_arg1,((PyObject*)__pyx_ptype_11structarray__BaseArray)); if (__pyx_1 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 819; goto __pyx_L1;}
  if (__pyx_1) {
    __pyx_1 = PyObject_IsInstance(__pyx_v_arg2,((PyObject*)__pyx_ptype_11structarray__BaseArray)); if (__pyx_1 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 820; goto __pyx_L1;}
  }
  if (__pyx_1) {
    if (!__Pyx_TypeTest(__pyx_v_arg1, __pyx_ptype_11structarray__BaseArray)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 822; goto __pyx_L1;}
    if (!__Pyx_TypeTest(__pyx_v_arg2, __pyx_ptype_11structarray__BaseArray)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 822; goto __pyx_L1;}
    __pyx_2 = __pyx_f_11structarray__do_op2_a_a(((struct __pyx_obj_11structarray__ArrayOp2 *)__pyx_v_self)->operation,0,PyObject_Length(((PyObject *)__pyx_v_target)),__pyx_v_target,((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_arg1),((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_arg2)); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 821; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    goto __pyx_L4;
  }
  __pyx_1 = PyObject_IsInstance(__pyx_v_arg1,((PyObject*)__pyx_ptype_11structarray__BaseArray)); if (__pyx_1 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 823; goto __pyx_L1;}
  if (__pyx_1) {
    if (!__Pyx_TypeTest(__pyx_v_arg1, __pyx_ptype_11structarray__BaseArray)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 825; goto __pyx_L1;}
    __pyx_3 = __Pyx_GetName(__pyx_b, __pyx_n_float); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 825; goto __pyx_L1;}
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 825; goto __pyx_L1;}
    Py_INCREF(__pyx_v_arg2);
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_arg2);
    __pyx_4 = PyObject_CallObject(__pyx_3, __pyx_2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 825; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_5 = PyFloat_AsDouble(__pyx_4); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 825; goto __pyx_L1;}
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    __pyx_3 = __pyx_f_11structarray__do_op2_a_f(((struct __pyx_obj_11structarray__ArrayOp2 *)__pyx_v_self)->operation,0,PyObject_Length(((PyObject *)__pyx_v_target)),__pyx_v_target,((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_arg1),__pyx_5); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 824; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    goto __pyx_L4;
  }
  __pyx_1 = PyObject_IsInstance(__pyx_v_arg2,((PyObject*)__pyx_ptype_11structarray__BaseArray)); if (__pyx_1 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 826; goto __pyx_L1;}
  if (__pyx_1) {
    __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_float); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 828; goto __pyx_L1;}
    __pyx_4 = PyTuple_New(1); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 828; goto __pyx_L1;}
    Py_INCREF(__pyx_v_arg1);
    PyTuple_SET_ITEM(__pyx_4, 0, __pyx_v_arg1);
    __pyx_3 = PyObject_CallObject(__pyx_2, __pyx_4); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 828; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    __pyx_5 = PyFloat_AsDouble(__pyx_3); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 828; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    if (!__Pyx_TypeTest(__pyx_v_arg2, __pyx_ptype_11structarray__BaseArray)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 828; goto __pyx_L1;}
    __pyx_2 = __pyx_f_11structarray__do_op2_f_a(((struct __pyx_obj_11structarray__ArrayOp2 *)__pyx_v_self)->operation,0,PyObject_Length(((PyObject *)__pyx_v_target)),__pyx_v_target,__pyx_5,((struct __pyx_obj_11structarray__BaseArray *)__pyx_v_arg2)); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 827; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    goto __pyx_L4;
  }
  /*else*/ {
    __pyx_4 = __Pyx_GetName(__pyx_b, __pyx_n_RuntimeError); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 830; goto __pyx_L1;}
    __Pyx_Raise(__pyx_4, 0, 0);
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 830; goto __pyx_L1;}
  }
  __pyx_L4:;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("structarray._ArrayOp2.assign_to");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_arg1);
  Py_DECREF(__pyx_v_arg2);
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_target);
  return __pyx_r;
}


static Py_ssize_t __pyx_f_11structarray_9_ArrayOp2___len__(PyObject *__pyx_v_self); /*proto*/
static Py_ssize_t __pyx_f_11structarray_9_ArrayOp2___len__(PyObject *__pyx_v_self) {
  PyObject *__pyx_v_len1;
  PyObject *__pyx_v_len2;
  Py_ssize_t __pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  Py_ssize_t __pyx_5;
  Py_INCREF(__pyx_v_self);
  __pyx_v_len1 = Py_None; Py_INCREF(Py_None);
  __pyx_v_len2 = Py_None; Py_INCREF(Py_None);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":834 */
  __pyx_1 = PyObject_HasAttr(((struct __pyx_obj_11structarray__ArrayOp2 *)__pyx_v_self)->arg1,__pyx_n___len__); if (__pyx_1 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 834; goto __pyx_L1;}
  if (__pyx_1) {
    __pyx_2 = PyInt_FromSsize_t(PyObject_Length(((struct __pyx_obj_11structarray__ArrayOp2 *)__pyx_v_self)->arg1)); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 835; goto __pyx_L1;}
    Py_DECREF(__pyx_v_len1);
    __pyx_v_len1 = __pyx_2;
    __pyx_2 = 0;
    goto __pyx_L2;
  }
  /*else*/ {
    Py_INCREF(Py_None);
    Py_DECREF(__pyx_v_len1);
    __pyx_v_len1 = Py_None;
  }
  __pyx_L2:;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":838 */
  __pyx_1 = PyObject_HasAttr(((struct __pyx_obj_11structarray__ArrayOp2 *)__pyx_v_self)->arg2,__pyx_n___len__); if (__pyx_1 == -1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 838; goto __pyx_L1;}
  if (__pyx_1) {
    __pyx_2 = PyInt_FromSsize_t(PyObject_Length(((struct __pyx_obj_11structarray__ArrayOp2 *)__pyx_v_self)->arg2)); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 839; goto __pyx_L1;}
    Py_DECREF(__pyx_v_len2);
    __pyx_v_len2 = __pyx_2;
    __pyx_2 = 0;
    goto __pyx_L3;
  }
  /*else*/ {
    Py_INCREF(Py_None);
    Py_DECREF(__pyx_v_len2);
    __pyx_v_len2 = Py_None;
  }
  __pyx_L3:;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":842 */
  __pyx_1 = __pyx_v_len1 != Py_None;
  if (__pyx_1) {
    __pyx_1 = __pyx_v_len2 != Py_None;
    if (__pyx_1) {
      if (PyObject_Cmp(__pyx_v_len1, __pyx_v_len2, &__pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 842; goto __pyx_L1;}
      __pyx_1 = __pyx_1 != 0;
    }
  }
  if (__pyx_1) {
    __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_RuntimeError); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 843; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, 0, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 843; goto __pyx_L1;}
    goto __pyx_L4;
  }
  __pyx_L4:;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":844 */
  __pyx_2 = __Pyx_GetName(__pyx_b, __pyx_n_max); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 844; goto __pyx_L1;}
  __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 844; goto __pyx_L1;}
  Py_INCREF(__pyx_v_len1);
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_len1);
  Py_INCREF(__pyx_v_len2);
  PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_len2);
  __pyx_4 = PyObject_CallObject(__pyx_2, __pyx_3); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 844; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_5 = PyInt_AsSsize_t(__pyx_4); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 844; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;
  __pyx_r = __pyx_5;
  goto __pyx_L0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("structarray._ArrayOp2.__len__");
  __pyx_L0:;
  Py_DECREF(__pyx_v_len1);
  Py_DECREF(__pyx_v_len2);
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static PyObject *__pyx_f_11structarray_9_ArrayOp2_copy(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_11structarray_9_ArrayOp2_copy[] = "\n        ``copy()``\n\n        Creates a new array and saves the result of the operation into it.\n        ";
static PyObject *__pyx_f_11structarray_9_ArrayOp2_copy(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_s;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "", __pyx_argnames)) return 0;
  Py_INCREF(__pyx_v_self);
  __pyx_v_s = Py_None; Py_INCREF(Py_None);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":852 */
  __pyx_1 = PyTuple_New(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 852; goto __pyx_L1;}
  __pyx_2 = PyDict_New(); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 852; goto __pyx_L1;}
  __pyx_3 = PyInt_FromSsize_t(PyObject_Length(__pyx_v_self)); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 852; goto __pyx_L1;}
  if (PyDict_SetItem(__pyx_2, __pyx_n_size, __pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 852; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_3 = PyEval_CallObjectWithKeywords(((PyObject*)__pyx_ptype_11structarray_Array), __pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 852; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_v_s);
  __pyx_v_s = __pyx_3;
  __pyx_3 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":853 */
  __pyx_1 = PyObject_GetAttr(__pyx_v_self, __pyx_n_assign_to); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 853; goto __pyx_L1;}
  __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 853; goto __pyx_L1;}
  Py_INCREF(__pyx_v_s);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_s);
  __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 853; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":854 */
  Py_INCREF(__pyx_v_s);
  __pyx_r = __pyx_v_s;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("structarray._ArrayOp2.copy");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_s);
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_9_ArrayOp2___iter__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_11structarray_9_ArrayOp2___iter__(PyObject *__pyx_v_self) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  Py_INCREF(__pyx_v_self);
  __pyx_1 = PyObject_GetAttr(__pyx_v_self, __pyx_n_copy); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 857; goto __pyx_L1;}
  __pyx_2 = PyObject_CallObject(__pyx_1, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 857; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_1 = PyObject_GetIter(__pyx_2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 857; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("structarray._ArrayOp2.__iter__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_9_ArrayOp2___add__(PyObject *__pyx_v_self, PyObject *__pyx_v_other); /*proto*/
static PyObject *__pyx_f_11structarray_9_ArrayOp2___add__(PyObject *__pyx_v_self, PyObject *__pyx_v_other) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_other);
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 860; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_self);
  Py_INCREF(__pyx_v_other);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_other);
  __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_11structarray_ArrayOpAdd), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 860; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("structarray._ArrayOp2.__add__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_other);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_9_ArrayOp2___sub__(PyObject *__pyx_v_self, PyObject *__pyx_v_other); /*proto*/
static PyObject *__pyx_f_11structarray_9_ArrayOp2___sub__(PyObject *__pyx_v_self, PyObject *__pyx_v_other) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_other);
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 863; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_self);
  Py_INCREF(__pyx_v_other);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_other);
  __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_11structarray_ArrayOpSub), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 863; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("structarray._ArrayOp2.__sub__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_other);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_9_ArrayOp2___mul__(PyObject *__pyx_v_self, PyObject *__pyx_v_other); /*proto*/
static PyObject *__pyx_f_11structarray_9_ArrayOp2___mul__(PyObject *__pyx_v_self, PyObject *__pyx_v_other) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_other);
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 866; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_self);
  Py_INCREF(__pyx_v_other);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_other);
  __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_11structarray_ArrayOpMul), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 866; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("structarray._ArrayOp2.__mul__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_other);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_9_ArrayOp2___div__(PyObject *__pyx_v_self, PyObject *__pyx_v_other); /*proto*/
static PyObject *__pyx_f_11structarray_9_ArrayOp2___div__(PyObject *__pyx_v_self, PyObject *__pyx_v_other) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_other);
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 869; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_self);
  Py_INCREF(__pyx_v_other);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_other);
  __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_11structarray_ArrayOpDiv), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 869; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("structarray._ArrayOp2.__div__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_other);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_9_ArrayOp2___truediv__(PyObject *__pyx_v_self, PyObject *__pyx_v_other); /*proto*/
static PyObject *__pyx_f_11structarray_9_ArrayOp2___truediv__(PyObject *__pyx_v_self, PyObject *__pyx_v_other) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_other);
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 872; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_self);
  Py_INCREF(__pyx_v_other);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_other);
  __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_11structarray_ArrayOpDiv), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 872; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("structarray._ArrayOp2.__truediv__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_other);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_9_ArrayOp2___mod__(PyObject *__pyx_v_self, PyObject *__pyx_v_other); /*proto*/
static PyObject *__pyx_f_11structarray_9_ArrayOp2___mod__(PyObject *__pyx_v_self, PyObject *__pyx_v_other) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_other);
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 875; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_self);
  Py_INCREF(__pyx_v_other);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_other);
  __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_11structarray_ArrayOpMod), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 875; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("structarray._ArrayOp2.__mod__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_other);
  return __pyx_r;
}

static int __pyx_f_11structarray_10ArrayOpAdd___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_11structarray_10ArrayOpAdd___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_arg1 = 0;
  PyObject *__pyx_v_arg2 = 0;
  int __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"arg1","arg2",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO", __pyx_argnames, &__pyx_v_arg1, &__pyx_v_arg2)) return -1;
  Py_INCREF((PyObject *)__pyx_v_self);
  Py_INCREF(__pyx_v_arg1);
  Py_INCREF(__pyx_v_arg2);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":879 */
  ((struct __pyx_obj_11structarray_ArrayOpAdd *)__pyx_v_self)->__pyx_base.operation = Add;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":880 */
  __pyx_1 = PyObject_GetAttr(((PyObject*)__pyx_ptype_11structarray__ArrayOp2), __pyx_n___init__); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 880; goto __pyx_L1;}
  __pyx_2 = PyTuple_New(3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 880; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_self);
  Py_INCREF(__pyx_v_arg1);
  PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_arg1);
  Py_INCREF(__pyx_v_arg2);
  PyTuple_SET_ITEM(__pyx_2, 2, __pyx_v_arg2);
  __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 880; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("structarray.ArrayOpAdd.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF((PyObject *)__pyx_v_self);
  Py_DECREF(__pyx_v_arg1);
  Py_DECREF(__pyx_v_arg2);
  return __pyx_r;
}

static int __pyx_f_11structarray_10ArrayOpSub___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_11structarray_10ArrayOpSub___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_arg1 = 0;
  PyObject *__pyx_v_arg2 = 0;
  int __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"arg1","arg2",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO", __pyx_argnames, &__pyx_v_arg1, &__pyx_v_arg2)) return -1;
  Py_INCREF((PyObject *)__pyx_v_self);
  Py_INCREF(__pyx_v_arg1);
  Py_INCREF(__pyx_v_arg2);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":884 */
  ((struct __pyx_obj_11structarray_ArrayOpSub *)__pyx_v_self)->__pyx_base.operation = Sub;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":885 */
  __pyx_1 = PyObject_GetAttr(((PyObject*)__pyx_ptype_11structarray__ArrayOp2), __pyx_n___init__); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 885; goto __pyx_L1;}
  __pyx_2 = PyTuple_New(3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 885; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_self);
  Py_INCREF(__pyx_v_arg1);
  PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_arg1);
  Py_INCREF(__pyx_v_arg2);
  PyTuple_SET_ITEM(__pyx_2, 2, __pyx_v_arg2);
  __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 885; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("structarray.ArrayOpSub.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF((PyObject *)__pyx_v_self);
  Py_DECREF(__pyx_v_arg1);
  Py_DECREF(__pyx_v_arg2);
  return __pyx_r;
}

static int __pyx_f_11structarray_10ArrayOpMul___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_11structarray_10ArrayOpMul___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_arg1 = 0;
  PyObject *__pyx_v_arg2 = 0;
  int __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"arg1","arg2",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO", __pyx_argnames, &__pyx_v_arg1, &__pyx_v_arg2)) return -1;
  Py_INCREF((PyObject *)__pyx_v_self);
  Py_INCREF(__pyx_v_arg1);
  Py_INCREF(__pyx_v_arg2);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":889 */
  ((struct __pyx_obj_11structarray_ArrayOpMul *)__pyx_v_self)->__pyx_base.operation = Mul;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":890 */
  __pyx_1 = PyObject_GetAttr(((PyObject*)__pyx_ptype_11structarray__ArrayOp2), __pyx_n___init__); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 890; goto __pyx_L1;}
  __pyx_2 = PyTuple_New(3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 890; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_self);
  Py_INCREF(__pyx_v_arg1);
  PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_arg1);
  Py_INCREF(__pyx_v_arg2);
  PyTuple_SET_ITEM(__pyx_2, 2, __pyx_v_arg2);
  __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 890; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("structarray.ArrayOpMul.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF((PyObject *)__pyx_v_self);
  Py_DECREF(__pyx_v_arg1);
  Py_DECREF(__pyx_v_arg2);
  return __pyx_r;
}

static int __pyx_f_11structarray_10ArrayOpDiv___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_11structarray_10ArrayOpDiv___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_arg1 = 0;
  PyObject *__pyx_v_arg2 = 0;
  int __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"arg1","arg2",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO", __pyx_argnames, &__pyx_v_arg1, &__pyx_v_arg2)) return -1;
  Py_INCREF((PyObject *)__pyx_v_self);
  Py_INCREF(__pyx_v_arg1);
  Py_INCREF(__pyx_v_arg2);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":894 */
  ((struct __pyx_obj_11structarray_ArrayOpDiv *)__pyx_v_self)->__pyx_base.operation = Div;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":895 */
  __pyx_1 = PyObject_GetAttr(((PyObject*)__pyx_ptype_11structarray__ArrayOp2), __pyx_n___init__); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 895; goto __pyx_L1;}
  __pyx_2 = PyTuple_New(3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 895; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_self);
  Py_INCREF(__pyx_v_arg1);
  PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_arg1);
  Py_INCREF(__pyx_v_arg2);
  PyTuple_SET_ITEM(__pyx_2, 2, __pyx_v_arg2);
  __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 895; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("structarray.ArrayOpDiv.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF((PyObject *)__pyx_v_self);
  Py_DECREF(__pyx_v_arg1);
  Py_DECREF(__pyx_v_arg2);
  return __pyx_r;
}

static int __pyx_f_11structarray_10ArrayOpMod___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_11structarray_10ArrayOpMod___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_arg1 = 0;
  PyObject *__pyx_v_arg2 = 0;
  int __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"arg1","arg2",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO", __pyx_argnames, &__pyx_v_arg1, &__pyx_v_arg2)) return -1;
  Py_INCREF((PyObject *)__pyx_v_self);
  Py_INCREF(__pyx_v_arg1);
  Py_INCREF(__pyx_v_arg2);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":899 */
  ((struct __pyx_obj_11structarray_ArrayOpMod *)__pyx_v_self)->__pyx_base.operation = Mod;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":900 */
  __pyx_1 = PyObject_GetAttr(((PyObject*)__pyx_ptype_11structarray__ArrayOp2), __pyx_n___init__); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 900; goto __pyx_L1;}
  __pyx_2 = PyTuple_New(3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 900; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_self);
  Py_INCREF(__pyx_v_arg1);
  PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_arg1);
  Py_INCREF(__pyx_v_arg2);
  PyTuple_SET_ITEM(__pyx_2, 2, __pyx_v_arg2);
  __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 900; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("structarray.ArrayOpMod.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF((PyObject *)__pyx_v_self);
  Py_DECREF(__pyx_v_arg1);
  Py_DECREF(__pyx_v_arg2);
  return __pyx_r;
}

static int __pyx_f_11structarray_10ArrayOpMin___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_11structarray_10ArrayOpMin___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_arg1 = 0;
  PyObject *__pyx_v_arg2 = 0;
  int __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"arg1","arg2",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO", __pyx_argnames, &__pyx_v_arg1, &__pyx_v_arg2)) return -1;
  Py_INCREF((PyObject *)__pyx_v_self);
  Py_INCREF(__pyx_v_arg1);
  Py_INCREF(__pyx_v_arg2);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":904 */
  ((struct __pyx_obj_11structarray_ArrayOpMin *)__pyx_v_self)->__pyx_base.operation = Min;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":905 */
  __pyx_1 = PyObject_GetAttr(((PyObject*)__pyx_ptype_11structarray__ArrayOp2), __pyx_n___init__); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 905; goto __pyx_L1;}
  __pyx_2 = PyTuple_New(3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 905; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_self);
  Py_INCREF(__pyx_v_arg1);
  PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_arg1);
  Py_INCREF(__pyx_v_arg2);
  PyTuple_SET_ITEM(__pyx_2, 2, __pyx_v_arg2);
  __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 905; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("structarray.ArrayOpMin.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF((PyObject *)__pyx_v_self);
  Py_DECREF(__pyx_v_arg1);
  Py_DECREF(__pyx_v_arg2);
  return __pyx_r;
}

static int __pyx_f_11structarray_10ArrayOpMax___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_11structarray_10ArrayOpMax___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_arg1 = 0;
  PyObject *__pyx_v_arg2 = 0;
  int __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"arg1","arg2",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO", __pyx_argnames, &__pyx_v_arg1, &__pyx_v_arg2)) return -1;
  Py_INCREF((PyObject *)__pyx_v_self);
  Py_INCREF(__pyx_v_arg1);
  Py_INCREF(__pyx_v_arg2);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":909 */
  ((struct __pyx_obj_11structarray_ArrayOpMax *)__pyx_v_self)->__pyx_base.operation = Max;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":910 */
  __pyx_1 = PyObject_GetAttr(((PyObject*)__pyx_ptype_11structarray__ArrayOp2), __pyx_n___init__); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 910; goto __pyx_L1;}
  __pyx_2 = PyTuple_New(3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 910; goto __pyx_L1;}
  Py_INCREF(__pyx_v_self);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_self);
  Py_INCREF(__pyx_v_arg1);
  PyTuple_SET_ITEM(__pyx_2, 1, __pyx_v_arg1);
  Py_INCREF(__pyx_v_arg2);
  PyTuple_SET_ITEM(__pyx_2, 2, __pyx_v_arg2);
  __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 910; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("structarray.ArrayOpMax.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF((PyObject *)__pyx_v_self);
  Py_DECREF(__pyx_v_arg1);
  Py_DECREF(__pyx_v_arg2);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_array_max(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_11structarray_array_max[] = "\n    ``array_max(a, b)``\n\n    Finds the maximum of each item in ``a`` and ``b``.\n\n    Like the aritmetic operators, this doesn\'t return a new array, but an\n    operation object that you can assign to an array.  (Or call ``.copy()``\n    to create a new array)\n    ";
static PyObject *__pyx_f_11structarray_array_max(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_a = 0;
  PyObject *__pyx_v_b = 0;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  static char *__pyx_argnames[] = {"a","b",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO", __pyx_argnames, &__pyx_v_a, &__pyx_v_b)) return 0;
  Py_INCREF(__pyx_v_a);
  Py_INCREF(__pyx_v_b);
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 922; goto __pyx_L1;}
  Py_INCREF(__pyx_v_a);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_a);
  Py_INCREF(__pyx_v_b);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_b);
  __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_11structarray_ArrayOpMax), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 922; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("structarray.array_max");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_a);
  Py_DECREF(__pyx_v_b);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray_array_min(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_11structarray_array_min[] = "\n    ``array_max(a, b)``\n\n    Finds the minimum of each item in ``a`` and ``b``.\n\n    Like the aritmetic operators, this doesn\'t return a new array, but an\n    operation object that you can assign to an array.  (Or call ``.copy()``\n    to create a new array)\n    ";
static PyObject *__pyx_f_11structarray_array_min(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_a = 0;
  PyObject *__pyx_v_b = 0;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  static char *__pyx_argnames[] = {"a","b",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO", __pyx_argnames, &__pyx_v_a, &__pyx_v_b)) return 0;
  Py_INCREF(__pyx_v_a);
  Py_INCREF(__pyx_v_b);
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 934; goto __pyx_L1;}
  Py_INCREF(__pyx_v_a);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_a);
  Py_INCREF(__pyx_v_b);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_b);
  __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_11structarray_ArrayOpMin), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 934; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("structarray.array_min");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_a);
  Py_DECREF(__pyx_v_b);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray__do_op2_a_a(int __pyx_v_operation,int __pyx_v_start,int __pyx_v_end,struct __pyx_obj_11structarray__BaseArray *__pyx_v_result,struct __pyx_obj_11structarray__BaseArray *__pyx_v_arg1,struct __pyx_obj_11structarray__BaseArray *__pyx_v_arg2) {
  PyObject *__pyx_v_length;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  int __pyx_2;
  Py_INCREF(__pyx_v_result);
  Py_INCREF(__pyx_v_arg1);
  Py_INCREF(__pyx_v_arg2);
  __pyx_v_length = Py_None; Py_INCREF(Py_None);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":940 */
  ((struct __pyx_vtabstruct_11structarray__BaseArray *)__pyx_v_arg1->__pyx_vtab)->_sync_data_ptr(__pyx_v_arg1);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":941 */
  ((struct __pyx_vtabstruct_11structarray__BaseArray *)__pyx_v_arg2->__pyx_vtab)->_sync_data_ptr(__pyx_v_arg2);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":942 */
  __pyx_1 = PyInt_FromLong((__pyx_v_end - __pyx_v_start)); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 942; goto __pyx_L1;}
  Py_DECREF(__pyx_v_length);
  __pyx_v_length = __pyx_1;
  __pyx_1 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":943 */
  __pyx_2 = PyInt_AsLong(__pyx_v_length); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 943; goto __pyx_L1;}
  run_float_float(__pyx_2,__pyx_v_operation,(__pyx_v_result->_data + (__pyx_v_start * __pyx_v_result->_stride)),__pyx_v_result->_stride,(__pyx_v_arg1->_data + (__pyx_v_start * __pyx_v_result->_stride)),__pyx_v_arg1->_stride,(__pyx_v_arg2->_data + (__pyx_v_start * __pyx_v_result->_stride)),__pyx_v_arg2->_stride);

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("structarray._do_op2_a_a");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_length);
  Py_DECREF(__pyx_v_result);
  Py_DECREF(__pyx_v_arg1);
  Py_DECREF(__pyx_v_arg2);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray__do_op2_a_f(int __pyx_v_operation,int __pyx_v_start,int __pyx_v_end,struct __pyx_obj_11structarray__BaseArray *__pyx_v_result,struct __pyx_obj_11structarray__BaseArray *__pyx_v_arg1,float __pyx_v_arg2) {
  PyObject *__pyx_v_length;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  int __pyx_2;
  Py_INCREF(__pyx_v_result);
  Py_INCREF(__pyx_v_arg1);
  __pyx_v_length = Py_None; Py_INCREF(Py_None);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":952 */
  ((struct __pyx_vtabstruct_11structarray__BaseArray *)__pyx_v_arg1->__pyx_vtab)->_sync_data_ptr(__pyx_v_arg1);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":953 */
  __pyx_1 = PyInt_FromLong((__pyx_v_end - __pyx_v_start)); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 953; goto __pyx_L1;}
  Py_DECREF(__pyx_v_length);
  __pyx_v_length = __pyx_1;
  __pyx_1 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":954 */
  __pyx_2 = PyInt_AsLong(__pyx_v_length); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 954; goto __pyx_L1;}
  run_float_float(__pyx_2,__pyx_v_operation,(__pyx_v_result->_data + (__pyx_v_start * __pyx_v_result->_stride)),__pyx_v_result->_stride,(__pyx_v_arg1->_data + (__pyx_v_start * __pyx_v_arg1->_stride)),__pyx_v_arg1->_stride,(&__pyx_v_arg2),0);

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("structarray._do_op2_a_f");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_length);
  Py_DECREF(__pyx_v_result);
  Py_DECREF(__pyx_v_arg1);
  return __pyx_r;
}

static PyObject *__pyx_f_11structarray__do_op2_f_a(int __pyx_v_operation,int __pyx_v_start,int __pyx_v_end,struct __pyx_obj_11structarray__BaseArray *__pyx_v_result,float __pyx_v_arg1,struct __pyx_obj_11structarray__BaseArray *__pyx_v_arg2) {
  PyObject *__pyx_v_length;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  int __pyx_2;
  Py_INCREF(__pyx_v_result);
  Py_INCREF(__pyx_v_arg2);
  __pyx_v_length = Py_None; Py_INCREF(Py_None);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":963 */
  ((struct __pyx_vtabstruct_11structarray__BaseArray *)__pyx_v_arg2->__pyx_vtab)->_sync_data_ptr(__pyx_v_arg2);

  /* "/home/mmarshall/projects/structarray/structarray.pyx":964 */
  __pyx_1 = PyInt_FromLong((__pyx_v_end - __pyx_v_start)); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 964; goto __pyx_L1;}
  Py_DECREF(__pyx_v_length);
  __pyx_v_length = __pyx_1;
  __pyx_1 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":965 */
  __pyx_2 = PyInt_AsLong(__pyx_v_length); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 965; goto __pyx_L1;}
  run_float_float(__pyx_2,__pyx_v_operation,(__pyx_v_result->_data + (__pyx_v_start * __pyx_v_result->_stride)),__pyx_v_result->_stride,(&__pyx_v_arg1),0,(__pyx_v_arg2->_data + (__pyx_v_start * __pyx_v_arg2->_stride)),__pyx_v_arg2->_stride);

  __pyx_r = Py_None; Py_INCREF(Py_None);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("structarray._do_op2_f_a");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_length);
  Py_DECREF(__pyx_v_result);
  Py_DECREF(__pyx_v_arg2);
  return __pyx_r;
}

static __Pyx_InternTabEntry __pyx_intern_tab[] = {
  {&__pyx_n_Array, "Array"},
  {&__pyx_n_AttributeError, "AttributeError"},
  {&__pyx_n_False, "False"},
  {&__pyx_n_IndexError, "IndexError"},
  {&__pyx_n_NotImplemented, "NotImplemented"},
  {&__pyx_n_NotImplementedError, "NotImplementedError"},
  {&__pyx_n_RuntimeError, "RuntimeError"},
  {&__pyx_n_StopIteration, "StopIteration"},
  {&__pyx_n_StructArray, "StructArray"},
  {&__pyx_n_True, "True"},
  {&__pyx_n_TypeError, "TypeError"},
  {&__pyx_n_ValueError, "ValueError"},
  {&__pyx_n___all__, "__all__"},
  {&__pyx_n___author__, "__author__"},
  {&__pyx_n___class__, "__class__"},
  {&__pyx_n___credits__, "__credits__"},
  {&__pyx_n___docs_all__, "__docs_all__"},
  {&__pyx_n___init__, "__init__"},
  {&__pyx_n___len__, "__len__"},
  {&__pyx_n___name__, "__name__"},
  {&__pyx_n___version__, "__version__"},
  {&__pyx_n__grow, "_grow"},
  {&__pyx_n__is_resizeable, "_is_resizeable"},
  {&__pyx_n__update, "_update"},
  {&__pyx_n_append, "append"},
  {&__pyx_n_array_max, "array_max"},
  {&__pyx_n_array_min, "array_min"},
  {&__pyx_n_assign_from, "assign_from"},
  {&__pyx_n_assign_to, "assign_to"},
  {&__pyx_n_copy, "copy"},
  {&__pyx_n_data_owner, "data_owner"},
  {&__pyx_n_enumerate, "enumerate"},
  {&__pyx_n_float, "float"},
  {&__pyx_n_int, "int"},
  {&__pyx_n_join, "join"},
  {&__pyx_n_list, "list"},
  {&__pyx_n_long, "long"},
  {&__pyx_n_max, "max"},
  {&__pyx_n_min, "min"},
  {&__pyx_n_range, "range"},
  {&__pyx_n_sanitize_index, "sanitize_index"},
  {&__pyx_n_set_length, "set_length"},
  {&__pyx_n_size, "size"},
  {&__pyx_n_slice, "slice"},
  {&__pyx_n_str, "str"},
  {&__pyx_n_tuple, "tuple"},
  {0, 0}
};

static __Pyx_StringTabEntry __pyx_string_tab[] = {
  {&__pyx_k1p, __pyx_k1, sizeof(__pyx_k1)},
  {&__pyx_k2p, __pyx_k2, sizeof(__pyx_k2)},
  {&__pyx_k3p, __pyx_k3, sizeof(__pyx_k3)},
  {&__pyx_k15p, __pyx_k15, sizeof(__pyx_k15)},
  {&__pyx_k16p, __pyx_k16, sizeof(__pyx_k16)},
  {&__pyx_k17p, __pyx_k17, sizeof(__pyx_k17)},
  {&__pyx_k18p, __pyx_k18, sizeof(__pyx_k18)},
  {&__pyx_k19p, __pyx_k19, sizeof(__pyx_k19)},
  {&__pyx_k20p, __pyx_k20, sizeof(__pyx_k20)},
  {&__pyx_k21p, __pyx_k21, sizeof(__pyx_k21)},
  {&__pyx_k22p, __pyx_k22, sizeof(__pyx_k22)},
  {&__pyx_k23p, __pyx_k23, sizeof(__pyx_k23)},
  {&__pyx_k25p, __pyx_k25, sizeof(__pyx_k25)},
  {&__pyx_k26p, __pyx_k26, sizeof(__pyx_k26)},
  {&__pyx_k29p, __pyx_k29, sizeof(__pyx_k29)},
  {&__pyx_k30p, __pyx_k30, sizeof(__pyx_k30)},
  {&__pyx_k31p, __pyx_k31, sizeof(__pyx_k31)},
  {&__pyx_k33p, __pyx_k33, sizeof(__pyx_k33)},
  {&__pyx_k34p, __pyx_k34, sizeof(__pyx_k34)},
  {&__pyx_k36p, __pyx_k36, sizeof(__pyx_k36)},
  {&__pyx_k35p, __pyx_k35, sizeof(__pyx_k35)},
  {&__pyx_k41p, __pyx_k41, sizeof(__pyx_k41)},
  {0, 0, 0}
};
static struct __pyx_vtabstruct_11structarray__BaseArray __pyx_vtable_11structarray__BaseArray;

static PyObject *__pyx_tp_new_11structarray__BaseArray(PyTypeObject *t, PyObject *a, PyObject *k) {
  struct __pyx_obj_11structarray__BaseArray *p;
  PyObject *o = (*t->tp_alloc)(t, 0);
  if (!o) return 0;
  p = ((struct __pyx_obj_11structarray__BaseArray *)o);
  *(struct __pyx_vtabstruct_11structarray__BaseArray **)&p->__pyx_vtab = __pyx_vtabptr_11structarray__BaseArray;
  p->data_owner = ((struct __pyx_obj_11structarray__BaseArray *)Py_None); Py_INCREF(Py_None);
  p->_dimensions = Py_None; Py_INCREF(Py_None);
  return o;
}

static void __pyx_tp_dealloc_11structarray__BaseArray(PyObject *o) {
  struct __pyx_obj_11structarray__BaseArray *p = (struct __pyx_obj_11structarray__BaseArray *)o;
  {
    PyObject *etype, *eval, *etb;
    PyErr_Fetch(&etype, &eval, &etb);
    ++o->ob_refcnt;
    __pyx_f_11structarray_10_BaseArray___dealloc__(o);
    if (PyErr_Occurred()) PyErr_WriteUnraisable(o);
    --o->ob_refcnt;
    PyErr_Restore(etype, eval, etb);
  }
  Py_XDECREF(((PyObject *)p->data_owner));
  Py_XDECREF(p->_dimensions);
  (*o->ob_type->tp_free)(o);
}

static int __pyx_tp_traverse_11structarray__BaseArray(PyObject *o, visitproc v, void *a) {
  int e;
  struct __pyx_obj_11structarray__BaseArray *p = (struct __pyx_obj_11structarray__BaseArray *)o;
  if (p->data_owner) {
    e = (*v)(((PyObject*)p->data_owner), a); if (e) return e;
  }
  if (p->_dimensions) {
    e = (*v)(p->_dimensions, a); if (e) return e;
  }
  return 0;
}

static int __pyx_tp_clear_11structarray__BaseArray(PyObject *o) {
  struct __pyx_obj_11structarray__BaseArray *p = (struct __pyx_obj_11structarray__BaseArray *)o;
  Py_XDECREF(((PyObject *)p->data_owner));
  p->data_owner = ((struct __pyx_obj_11structarray__BaseArray *)Py_None); Py_INCREF(Py_None);
  Py_XDECREF(p->_dimensions);
  p->_dimensions = Py_None; Py_INCREF(Py_None);
  return 0;
}

static struct PyMethodDef __pyx_methods_11structarray__BaseArray[] = {
  {"_grow", (PyCFunction)__pyx_f_11structarray_10_BaseArray__grow, METH_VARARGS|METH_KEYWORDS, 0},
  {"set_length", (PyCFunction)__pyx_f_11structarray_10_BaseArray_set_length, METH_VARARGS|METH_KEYWORDS, __pyx_doc_11structarray_10_BaseArray_set_length},
  {"get_dimensions", (PyCFunction)__pyx_f_11structarray_10_BaseArray_get_dimensions, METH_VARARGS|METH_KEYWORDS, __pyx_doc_11structarray_10_BaseArray_get_dimensions},
  {"_is_resizeable", (PyCFunction)__pyx_f_11structarray_10_BaseArray__is_resizeable, METH_VARARGS|METH_KEYWORDS, 0},
  {"append", (PyCFunction)__pyx_f_11structarray_10_BaseArray_append, METH_VARARGS|METH_KEYWORDS, __pyx_doc_11structarray_10_BaseArray_append},
  {"extend", (PyCFunction)__pyx_f_11structarray_10_BaseArray_extend, METH_VARARGS|METH_KEYWORDS, __pyx_doc_11structarray_10_BaseArray_extend},
  {"sanitize_index", (PyCFunction)__pyx_f_11structarray_10_BaseArray_sanitize_index, METH_VARARGS|METH_KEYWORDS, __pyx_doc_11structarray_10_BaseArray_sanitize_index},
  {"get_data_addr", (PyCFunction)__pyx_f_11structarray_10_BaseArray_get_data_addr, METH_VARARGS|METH_KEYWORDS, __pyx_doc_11structarray_10_BaseArray_get_data_addr},
  {"get_data_stride", (PyCFunction)__pyx_f_11structarray_10_BaseArray_get_data_stride, METH_VARARGS|METH_KEYWORDS, __pyx_doc_11structarray_10_BaseArray_get_data_stride},
  {0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number__BaseArray = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
  #if Py_TPFLAGS_DEFAULT & Py_TPFLAGS_HAVE_INDEX
  0, /*nb_index*/
  #endif
};

static PySequenceMethods __pyx_tp_as_sequence__BaseArray = {
  __pyx_f_11structarray_10_BaseArray___len__, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping__BaseArray = {
  __pyx_f_11structarray_10_BaseArray___len__, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer__BaseArray = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

PyTypeObject __pyx_type_11structarray__BaseArray = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "structarray._BaseArray", /*tp_name*/
  sizeof(struct __pyx_obj_11structarray__BaseArray), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_11structarray__BaseArray, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number__BaseArray, /*tp_as_number*/
  &__pyx_tp_as_sequence__BaseArray, /*tp_as_sequence*/
  &__pyx_tp_as_mapping__BaseArray, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer__BaseArray, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC, /*tp_flags*/
  0, /*tp_doc*/
  __pyx_tp_traverse_11structarray__BaseArray, /*tp_traverse*/
  __pyx_tp_clear_11structarray__BaseArray, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  0, /*tp_iter*/
  0, /*tp_iternext*/
  __pyx_methods_11structarray__BaseArray, /*tp_methods*/
  0, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_11structarray_10_BaseArray___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_11structarray__BaseArray, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};

static PyObject *__pyx_tp_new_11structarray__ItemInfo(PyTypeObject *t, PyObject *a, PyObject *k) {
  struct __pyx_obj_11structarray__ItemInfo *p;
  PyObject *o = (*t->tp_alloc)(t, 0);
  if (!o) return 0;
  p = ((struct __pyx_obj_11structarray__ItemInfo *)o);
  p->array = ((struct __pyx_obj_11structarray_StructArray *)Py_None); Py_INCREF(Py_None);
  return o;
}

static void __pyx_tp_dealloc_11structarray__ItemInfo(PyObject *o) {
  struct __pyx_obj_11structarray__ItemInfo *p = (struct __pyx_obj_11structarray__ItemInfo *)o;
  Py_XDECREF(((PyObject *)p->array));
  (*o->ob_type->tp_free)(o);
}

static int __pyx_tp_traverse_11structarray__ItemInfo(PyObject *o, visitproc v, void *a) {
  int e;
  struct __pyx_obj_11structarray__ItemInfo *p = (struct __pyx_obj_11structarray__ItemInfo *)o;
  if (p->array) {
    e = (*v)(((PyObject*)p->array), a); if (e) return e;
  }
  return 0;
}

static int __pyx_tp_clear_11structarray__ItemInfo(PyObject *o) {
  struct __pyx_obj_11structarray__ItemInfo *p = (struct __pyx_obj_11structarray__ItemInfo *)o;
  Py_XDECREF(((PyObject *)p->array));
  p->array = ((struct __pyx_obj_11structarray_StructArray *)Py_None); Py_INCREF(Py_None);
  return 0;
}
static PyObject *__pyx_sq_item_11structarray__ItemInfo(PyObject *o, Py_ssize_t i) {
  PyObject *r;
  PyObject *x = PyInt_FromSsize_t(i); if(!x) return 0;
  r = o->ob_type->tp_as_mapping->mp_subscript(o, x);
  Py_DECREF(x);
  return r;
}

static int __pyx_mp_ass_subscript_11structarray__ItemInfo(PyObject *o, PyObject *i, PyObject *v) {
  if (v) {
    return __pyx_f_11structarray_9_ItemInfo___setitem__(o, i, v);
  }
  else {
    PyErr_Format(PyExc_NotImplementedError,
      "Subscript deletion not supported by %s", o->ob_type->tp_name);
    return -1;
  }
}

static PyObject *__pyx_tp_getattro_11structarray__ItemInfo(PyObject *o, PyObject *n) {
  PyObject *v = PyObject_GenericGetAttr(o, n);
  if (!v && PyErr_ExceptionMatches(PyExc_AttributeError)) {
    PyErr_Clear();
    v = __pyx_f_11structarray_9_ItemInfo___getattr__(o, n);
  }
  return v;
}

static int __pyx_tp_setattro_11structarray__ItemInfo(PyObject *o, PyObject *n, PyObject *v) {
  if (v) {
    return __pyx_f_11structarray_9_ItemInfo___setattr__(o, n, v);
  }
  else {
    return PyObject_GenericSetAttr(o, n, 0);
  }
}

static struct PyMethodDef __pyx_methods_11structarray__ItemInfo[] = {
  {"_update", (PyCFunction)__pyx_f_11structarray_9_ItemInfo__update, METH_VARARGS|METH_KEYWORDS, 0},
  {0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number__ItemInfo = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
  #if Py_TPFLAGS_DEFAULT & Py_TPFLAGS_HAVE_INDEX
  0, /*nb_index*/
  #endif
};

static PySequenceMethods __pyx_tp_as_sequence__ItemInfo = {
  __pyx_f_11structarray_9_ItemInfo___len__, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  __pyx_sq_item_11structarray__ItemInfo, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping__ItemInfo = {
  __pyx_f_11structarray_9_ItemInfo___len__, /*mp_length*/
  __pyx_f_11structarray_9_ItemInfo___getitem__, /*mp_subscript*/
  __pyx_mp_ass_subscript_11structarray__ItemInfo, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer__ItemInfo = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

PyTypeObject __pyx_type_11structarray__ItemInfo = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "structarray._ItemInfo", /*tp_name*/
  sizeof(struct __pyx_obj_11structarray__ItemInfo), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_11structarray__ItemInfo, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  __pyx_f_11structarray_9_ItemInfo___repr__, /*tp_repr*/
  &__pyx_tp_as_number__ItemInfo, /*tp_as_number*/
  &__pyx_tp_as_sequence__ItemInfo, /*tp_as_sequence*/
  &__pyx_tp_as_mapping__ItemInfo, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  __pyx_tp_getattro_11structarray__ItemInfo, /*tp_getattro*/
  __pyx_tp_setattro_11structarray__ItemInfo, /*tp_setattro*/
  &__pyx_tp_as_buffer__ItemInfo, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC, /*tp_flags*/
  "\n    Handles accessing data for a single item in an array.\n    ", /*tp_doc*/
  __pyx_tp_traverse_11structarray__ItemInfo, /*tp_traverse*/
  __pyx_tp_clear_11structarray__ItemInfo, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  0, /*tp_iter*/
  0, /*tp_iternext*/
  __pyx_methods_11structarray__ItemInfo, /*tp_methods*/
  0, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_11structarray_9_ItemInfo___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_11structarray__ItemInfo, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};
static struct __pyx_vtabstruct_11structarray_StructArray __pyx_vtable_11structarray_StructArray;

static PyObject *__pyx_tp_new_11structarray_StructArray(PyTypeObject *t, PyObject *a, PyObject *k) {
  struct __pyx_obj_11structarray_StructArray *p;
  PyObject *o = __pyx_ptype_11structarray__BaseArray->tp_new(t, a, k);
  if (!o) return 0;
  p = ((struct __pyx_obj_11structarray_StructArray *)o);
  *(struct __pyx_vtabstruct_11structarray_StructArray **)&p->__pyx_base.__pyx_vtab = __pyx_vtabptr_11structarray_StructArray;
  p->_attributes = Py_None; Py_INCREF(Py_None);
  p->_attribute_arrays = Py_None; Py_INCREF(Py_None);
  p->_column_arrays = Py_None; Py_INCREF(Py_None);
  p->_swizzles = Py_None; Py_INCREF(Py_None);
  p->_defaults = Py_None; Py_INCREF(Py_None);
  return o;
}

static void __pyx_tp_dealloc_11structarray_StructArray(PyObject *o) {
  struct __pyx_obj_11structarray_StructArray *p = (struct __pyx_obj_11structarray_StructArray *)o;
  Py_XDECREF(p->_attributes);
  Py_XDECREF(p->_attribute_arrays);
  Py_XDECREF(p->_column_arrays);
  Py_XDECREF(p->_swizzles);
  Py_XDECREF(p->_defaults);
  __pyx_ptype_11structarray__BaseArray->tp_dealloc(o);
}

static int __pyx_tp_traverse_11structarray_StructArray(PyObject *o, visitproc v, void *a) {
  int e;
  struct __pyx_obj_11structarray_StructArray *p = (struct __pyx_obj_11structarray_StructArray *)o;
  e = __pyx_ptype_11structarray__BaseArray->tp_traverse(o, v, a); if (e) return e;
  if (p->_attributes) {
    e = (*v)(p->_attributes, a); if (e) return e;
  }
  if (p->_attribute_arrays) {
    e = (*v)(p->_attribute_arrays, a); if (e) return e;
  }
  if (p->_column_arrays) {
    e = (*v)(p->_column_arrays, a); if (e) return e;
  }
  if (p->_swizzles) {
    e = (*v)(p->_swizzles, a); if (e) return e;
  }
  if (p->_defaults) {
    e = (*v)(p->_defaults, a); if (e) return e;
  }
  return 0;
}

static int __pyx_tp_clear_11structarray_StructArray(PyObject *o) {
  struct __pyx_obj_11structarray_StructArray *p = (struct __pyx_obj_11structarray_StructArray *)o;
  __pyx_ptype_11structarray__BaseArray->tp_clear(o);
  Py_XDECREF(p->_attributes);
  p->_attributes = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(p->_attribute_arrays);
  p->_attribute_arrays = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(p->_column_arrays);
  p->_column_arrays = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(p->_swizzles);
  p->_swizzles = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(p->_defaults);
  p->_defaults = Py_None; Py_INCREF(Py_None);
  return 0;
}
static PyObject *__pyx_sq_item_11structarray_StructArray(PyObject *o, Py_ssize_t i) {
  PyObject *r;
  PyObject *x = PyInt_FromSsize_t(i); if(!x) return 0;
  r = o->ob_type->tp_as_mapping->mp_subscript(o, x);
  Py_DECREF(x);
  return r;
}

static int __pyx_mp_ass_subscript_11structarray_StructArray(PyObject *o, PyObject *i, PyObject *v) {
  if (v) {
    return __pyx_f_11structarray_11StructArray___setitem__(o, i, v);
  }
  else {
    if (__pyx_ptype_11structarray__BaseArray->tp_as_mapping && __pyx_ptype_11structarray__BaseArray->tp_as_mapping->mp_ass_subscript)
      return __pyx_ptype_11structarray__BaseArray->tp_as_mapping->mp_ass_subscript(o, i, v);
    PyErr_Format(PyExc_NotImplementedError,
      "Subscript deletion not supported by %s", o->ob_type->tp_name);
    return -1;
  }
}

static PyObject *__pyx_tp_getattro_11structarray_StructArray(PyObject *o, PyObject *n) {
  PyObject *v = PyObject_GenericGetAttr(o, n);
  if (!v && PyErr_ExceptionMatches(PyExc_AttributeError)) {
    PyErr_Clear();
    v = __pyx_f_11structarray_11StructArray___getattr__(o, n);
  }
  return v;
}

static int __pyx_tp_setattro_11structarray_StructArray(PyObject *o, PyObject *n, PyObject *v) {
  if (v) {
    return __pyx_f_11structarray_11StructArray___setattr__(o, n, v);
  }
  else {
    if (__pyx_ptype_11structarray__BaseArray->tp_setattro)
      return __pyx_ptype_11structarray__BaseArray->tp_setattro(o, n, v);
    return PyObject_GenericSetAttr(o, n, 0);
  }
}

static struct PyMethodDef __pyx_methods_11structarray_StructArray[] = {
  {0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number_StructArray = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
  #if Py_TPFLAGS_DEFAULT & Py_TPFLAGS_HAVE_INDEX
  0, /*nb_index*/
  #endif
};

static PySequenceMethods __pyx_tp_as_sequence_StructArray = {
  0, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  __pyx_sq_item_11structarray_StructArray, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping_StructArray = {
  0, /*mp_length*/
  __pyx_f_11structarray_11StructArray___getitem__, /*mp_subscript*/
  __pyx_mp_ass_subscript_11structarray_StructArray, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer_StructArray = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

PyTypeObject __pyx_type_11structarray_StructArray = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "structarray.StructArray", /*tp_name*/
  sizeof(struct __pyx_obj_11structarray_StructArray), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_11structarray_StructArray, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number_StructArray, /*tp_as_number*/
  &__pyx_tp_as_sequence_StructArray, /*tp_as_sequence*/
  &__pyx_tp_as_mapping_StructArray, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  __pyx_tp_getattro_11structarray_StructArray, /*tp_getattro*/
  __pyx_tp_setattro_11structarray_StructArray, /*tp_setattro*/
  &__pyx_tp_as_buffer_StructArray, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC, /*tp_flags*/
  "\n    ``StructArray(attributes, [initial_data, swizzles, size, defaults])``\n\n    StructArray provides an array of structred data.\n\n    ``attributes`` the list of attribute names.\n    e.g., ``(\'x\', \'y\', \'dx\', \'dy\')``  An ``Array`` will be created for each of\n    these.\n\n    ``initial_data`` is a list of tuples to fill the array with.\n\n    ``swizzles`` provides shortcuts for accessing multiple attributes at a\n    time.  (This is currently not implemented.)\n\n    ``size`` is the initial length of the array.  If ``size`` is longer than\n    ``initial_data``, the remaining items will be filled in by ``defaults``.\n    If if ``initial_data`` is longer than ``size``, it\'s length will be used\n    instead.\n\n    If ``size`` is a tuple with more than one item, the array will be\n    multidimensional.  See the documentation for the ``structarray`` module\n    for more on multidimensional arrays.\n\n    ``defaults`` is a tuple of default values for the items.  (One value\n    corresponding to each attribute.)  This is used both for initially creating\n    the array, and when ``set_length()`` is called.\n\n    Item access on a ``StructArray`` returns an ``item`` object, which\n    has attributes corresponding to the attributes of the ``StructArray``.\n\n    This might make it clearer:\n\n        >>> particles = StructArray((\'x\', \'y\', \'dx\', \'dy\'), size=10)\n        >>> p = particles[1]\n        >>> print p\n        <item at index 1 (0.0, 0.0, 0.0, 0.0)>\n        >>> p.x, p.y = 0, 100\n        >>> p.dx, p.dy = 0, 5\n        >>> print particles[0]\n        <item at index 1 (0.0, 100.0, 0.0, 5.0)>\n\n    Additionally, an array is created for each attribute, allowing you to work\n    with the value of that attribute for all of the items:\n\n        >>> print particles.y\n        <OffsetArray [0.0, 100.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]>\n\n    (``OffsetArray`` is simply a subclass of ``Array`` that stores it\'s data\n    at an offset inside of another array.  It works just like ``Array``, only\n    you can\'t change the length.)\n\n    Assigning to an attribute will do the \'right thing\':\n\n        >>> particles.dx = 6.5\n        >>> particles.x += particles.dx*2\n        >>> print particles[1]\n        <item at index 1 (13.0, 100.0, 6.5, 5.0)>\n\n    You can also assign a tuple to an item:\n\n        >>> particles[2] = (15, 20, 0, 100)\n        >>> print particles[2]\n        <item at index 2 (15.0, 20.0, 0.0, 100.0)>\n\n    When assigning a tuple, you can ommit some values, leaving them as they are:\n\n        >>> particles[2] = (100, 200)\n        >>> print particles[2]\n        <item at index 2 (100.0, 200.0, 0.0, 100.0)>\n    ", /*tp_doc*/
  __pyx_tp_traverse_11structarray_StructArray, /*tp_traverse*/
  __pyx_tp_clear_11structarray_StructArray, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  __pyx_f_11structarray_11StructArray___iter__, /*tp_iter*/
  0, /*tp_iternext*/
  __pyx_methods_11structarray_StructArray, /*tp_methods*/
  0, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_11structarray_11StructArray___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_11structarray_StructArray, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};

static PyObject *__pyx_tp_new_11structarray__StructArrayIter(PyTypeObject *t, PyObject *a, PyObject *k) {
  struct __pyx_obj_11structarray__StructArrayIter *p;
  PyObject *o = (*t->tp_alloc)(t, 0);
  if (!o) return 0;
  p = ((struct __pyx_obj_11structarray__StructArrayIter *)o);
  p->array = ((struct __pyx_obj_11structarray_StructArray *)Py_None); Py_INCREF(Py_None);
  return o;
}

static void __pyx_tp_dealloc_11structarray__StructArrayIter(PyObject *o) {
  struct __pyx_obj_11structarray__StructArrayIter *p = (struct __pyx_obj_11structarray__StructArrayIter *)o;
  Py_XDECREF(((PyObject *)p->array));
  (*o->ob_type->tp_free)(o);
}

static int __pyx_tp_traverse_11structarray__StructArrayIter(PyObject *o, visitproc v, void *a) {
  int e;
  struct __pyx_obj_11structarray__StructArrayIter *p = (struct __pyx_obj_11structarray__StructArrayIter *)o;
  if (p->array) {
    e = (*v)(((PyObject*)p->array), a); if (e) return e;
  }
  return 0;
}

static int __pyx_tp_clear_11structarray__StructArrayIter(PyObject *o) {
  struct __pyx_obj_11structarray__StructArrayIter *p = (struct __pyx_obj_11structarray__StructArrayIter *)o;
  Py_XDECREF(((PyObject *)p->array));
  p->array = ((struct __pyx_obj_11structarray_StructArray *)Py_None); Py_INCREF(Py_None);
  return 0;
}

static struct PyMethodDef __pyx_methods_11structarray__StructArrayIter[] = {
  {0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number__StructArrayIter = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
  #if Py_TPFLAGS_DEFAULT & Py_TPFLAGS_HAVE_INDEX
  0, /*nb_index*/
  #endif
};

static PySequenceMethods __pyx_tp_as_sequence__StructArrayIter = {
  0, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping__StructArrayIter = {
  0, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer__StructArrayIter = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

PyTypeObject __pyx_type_11structarray__StructArrayIter = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "structarray._StructArrayIter", /*tp_name*/
  sizeof(struct __pyx_obj_11structarray__StructArrayIter), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_11structarray__StructArrayIter, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number__StructArrayIter, /*tp_as_number*/
  &__pyx_tp_as_sequence__StructArrayIter, /*tp_as_sequence*/
  &__pyx_tp_as_mapping__StructArrayIter, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer__StructArrayIter, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC, /*tp_flags*/
  0, /*tp_doc*/
  __pyx_tp_traverse_11structarray__StructArrayIter, /*tp_traverse*/
  __pyx_tp_clear_11structarray__StructArrayIter, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  __pyx_f_11structarray_16_StructArrayIter___iter__, /*tp_iter*/
  __pyx_f_11structarray_16_StructArrayIter___next__, /*tp_iternext*/
  __pyx_methods_11structarray__StructArrayIter, /*tp_methods*/
  0, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_11structarray_16_StructArrayIter___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_11structarray__StructArrayIter, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};
static struct __pyx_vtabstruct_11structarray_Array __pyx_vtable_11structarray_Array;

static PyObject *__pyx_tp_new_11structarray_Array(PyTypeObject *t, PyObject *a, PyObject *k) {
  struct __pyx_obj_11structarray_Array *p;
  PyObject *o = __pyx_ptype_11structarray__BaseArray->tp_new(t, a, k);
  if (!o) return 0;
  p = ((struct __pyx_obj_11structarray_Array *)o);
  *(struct __pyx_vtabstruct_11structarray_Array **)&p->__pyx_base.__pyx_vtab = __pyx_vtabptr_11structarray_Array;
  return o;
}

static void __pyx_tp_dealloc_11structarray_Array(PyObject *o) {
  __pyx_ptype_11structarray__BaseArray->tp_dealloc(o);
}

static int __pyx_tp_traverse_11structarray_Array(PyObject *o, visitproc v, void *a) {
  int e;
  e = __pyx_ptype_11structarray__BaseArray->tp_traverse(o, v, a); if (e) return e;
  return 0;
}

static int __pyx_tp_clear_11structarray_Array(PyObject *o) {
  __pyx_ptype_11structarray__BaseArray->tp_clear(o);
  return 0;
}
static PyObject *__pyx_sq_item_11structarray_Array(PyObject *o, Py_ssize_t i) {
  PyObject *r;
  PyObject *x = PyInt_FromSsize_t(i); if(!x) return 0;
  r = o->ob_type->tp_as_mapping->mp_subscript(o, x);
  Py_DECREF(x);
  return r;
}

static int __pyx_mp_ass_subscript_11structarray_Array(PyObject *o, PyObject *i, PyObject *v) {
  if (v) {
    return __pyx_f_11structarray_5Array___setitem__(o, i, v);
  }
  else {
    if (__pyx_ptype_11structarray__BaseArray->tp_as_mapping && __pyx_ptype_11structarray__BaseArray->tp_as_mapping->mp_ass_subscript)
      return __pyx_ptype_11structarray__BaseArray->tp_as_mapping->mp_ass_subscript(o, i, v);
    PyErr_Format(PyExc_NotImplementedError,
      "Subscript deletion not supported by %s", o->ob_type->tp_name);
    return -1;
  }
}

static struct PyMethodDef __pyx_methods_11structarray_Array[] = {
  {"assign_from", (PyCFunction)__pyx_f_11structarray_5Array_assign_from, METH_VARARGS|METH_KEYWORDS, __pyx_doc_11structarray_5Array_assign_from},
  {"assign_to", (PyCFunction)__pyx_f_11structarray_5Array_assign_to, METH_VARARGS|METH_KEYWORDS, __pyx_doc_11structarray_5Array_assign_to},
  {"stretch", (PyCFunction)__pyx_f_11structarray_5Array_stretch, METH_VARARGS|METH_KEYWORDS, __pyx_doc_11structarray_5Array_stretch},
  {"repeat", (PyCFunction)__pyx_f_11structarray_5Array_repeat, METH_VARARGS|METH_KEYWORDS, __pyx_doc_11structarray_5Array_repeat},
  {"copy", (PyCFunction)__pyx_f_11structarray_5Array_copy, METH_VARARGS|METH_KEYWORDS, __pyx_doc_11structarray_5Array_copy},
  {0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number_Array = {
  __pyx_f_11structarray_5Array___add__, /*nb_add*/
  __pyx_f_11structarray_5Array___sub__, /*nb_subtract*/
  __pyx_f_11structarray_5Array___mul__, /*nb_multiply*/
  __pyx_f_11structarray_5Array___div__, /*nb_divide*/
  __pyx_f_11structarray_5Array___mod__, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  __pyx_f_11structarray_5Array___iadd__, /*nb_inplace_add*/
  __pyx_f_11structarray_5Array___isub__, /*nb_inplace_subtract*/
  __pyx_f_11structarray_5Array___imul__, /*nb_inplace_multiply*/
  __pyx_f_11structarray_5Array___idiv__, /*nb_inplace_divide*/
  __pyx_f_11structarray_5Array___imod__, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  __pyx_f_11structarray_5Array___truediv__, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
  #if Py_TPFLAGS_DEFAULT & Py_TPFLAGS_HAVE_INDEX
  0, /*nb_index*/
  #endif
};

static PySequenceMethods __pyx_tp_as_sequence_Array = {
  0, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  __pyx_sq_item_11structarray_Array, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping_Array = {
  0, /*mp_length*/
  __pyx_f_11structarray_5Array___getitem__, /*mp_subscript*/
  __pyx_mp_ass_subscript_11structarray_Array, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer_Array = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

PyTypeObject __pyx_type_11structarray_Array = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "structarray.Array", /*tp_name*/
  sizeof(struct __pyx_obj_11structarray_Array), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_11structarray_Array, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  __pyx_f_11structarray_5Array___repr__, /*tp_repr*/
  &__pyx_tp_as_number_Array, /*tp_as_number*/
  &__pyx_tp_as_sequence_Array, /*tp_as_sequence*/
  &__pyx_tp_as_mapping_Array, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer_Array, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC, /*tp_flags*/
  "\n    ``Array(initial_data=[], size=0, default=0)``\n\n    This is a single dimensional array.\n\n    ``initial_data`` can be used to populate the array.  ``Array(range(10))``\n    works as you would expect :)\n\n    ``size`` is the initial size of the array.  (Unless the length of\n    ``initial_data`` is bigger, in which case it is used.)  If ``size`` is a\n    tuple with more than one item, the array will be multidimensional.  See the\n    ``structarray`` module documentation form more on multidimensional arrays.\n\n    ``default`` is the default value for the array items.\n\n    Note that you can use both ``initial_data`` and ``size`` at the same time.\n    If ``size`` larger than the length of ``initial_data``, the rest of the\n    array will be filled with ``default``.\n    ``Array(range(3), size=8, default=6)`` would result in\n    ``[0, 1, 2, 6, 6, 6, 6, 6]``.\n\n    (The exception to this is if you are a multidimensional array, in which\n    case ``initial_data`` will be truncated to fit, as multidimensional arrays\n    cannot currently be resized.)\n\n    ``Array`` supports basic arithmetic operations: addition, subtraction,\n    multiplication, division, and modulus.  Each of these operations can be\n    performed against a single number or another ``Array`` of the same length.\n\n    Arithmetic operations don\'t return an ``Array``.  Instead they return an\n    array operation object.  The operation will be carried out when you\n    assign this object to another array.  (You can also call it\'s ``copy()``\n    method to create a new array.)\n\n    For example::\n\n        >>> arg1 = Array(range(10))\n        >>> arg2 = Array(range(10,20))\n        >>> arg1 + arg2\n        <structarray.ArrayOpAdd object at 0xb7d4d66c>\n        >>> (arg1 + arg2).copy()\n        <Array [10.0, 12.0, 14.0, 16.0, 18.0, 20.0, 22.0, 24.0, 26.0, 28.0]>\n        >>> arg1.assign_from(arg1 + arg2)\n        >>> print arg1\n        <Array [10.0, 12.0, 14.0, 16.0, 18.0, 20.0, 22.0, 24.0, 26.0, 28.0]>\n    ", /*tp_doc*/
  __pyx_tp_traverse_11structarray_Array, /*tp_traverse*/
  __pyx_tp_clear_11structarray_Array, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  __pyx_f_11structarray_5Array___iter__, /*tp_iter*/
  0, /*tp_iternext*/
  __pyx_methods_11structarray_Array, /*tp_methods*/
  0, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_11structarray_5Array___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_11structarray_Array, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};

static PyObject *__pyx_tp_new_11structarray__ArrayIter(PyTypeObject *t, PyObject *a, PyObject *k) {
  struct __pyx_obj_11structarray__ArrayIter *p;
  PyObject *o = (*t->tp_alloc)(t, 0);
  if (!o) return 0;
  p = ((struct __pyx_obj_11structarray__ArrayIter *)o);
  p->array = ((struct __pyx_obj_11structarray_Array *)Py_None); Py_INCREF(Py_None);
  return o;
}

static void __pyx_tp_dealloc_11structarray__ArrayIter(PyObject *o) {
  struct __pyx_obj_11structarray__ArrayIter *p = (struct __pyx_obj_11structarray__ArrayIter *)o;
  Py_XDECREF(((PyObject *)p->array));
  (*o->ob_type->tp_free)(o);
}

static int __pyx_tp_traverse_11structarray__ArrayIter(PyObject *o, visitproc v, void *a) {
  int e;
  struct __pyx_obj_11structarray__ArrayIter *p = (struct __pyx_obj_11structarray__ArrayIter *)o;
  if (p->array) {
    e = (*v)(((PyObject*)p->array), a); if (e) return e;
  }
  return 0;
}

static int __pyx_tp_clear_11structarray__ArrayIter(PyObject *o) {
  struct __pyx_obj_11structarray__ArrayIter *p = (struct __pyx_obj_11structarray__ArrayIter *)o;
  Py_XDECREF(((PyObject *)p->array));
  p->array = ((struct __pyx_obj_11structarray_Array *)Py_None); Py_INCREF(Py_None);
  return 0;
}

static struct PyMethodDef __pyx_methods_11structarray__ArrayIter[] = {
  {0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number__ArrayIter = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
  #if Py_TPFLAGS_DEFAULT & Py_TPFLAGS_HAVE_INDEX
  0, /*nb_index*/
  #endif
};

static PySequenceMethods __pyx_tp_as_sequence__ArrayIter = {
  0, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping__ArrayIter = {
  0, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer__ArrayIter = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

PyTypeObject __pyx_type_11structarray__ArrayIter = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "structarray._ArrayIter", /*tp_name*/
  sizeof(struct __pyx_obj_11structarray__ArrayIter), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_11structarray__ArrayIter, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number__ArrayIter, /*tp_as_number*/
  &__pyx_tp_as_sequence__ArrayIter, /*tp_as_sequence*/
  &__pyx_tp_as_mapping__ArrayIter, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer__ArrayIter, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC, /*tp_flags*/
  0, /*tp_doc*/
  __pyx_tp_traverse_11structarray__ArrayIter, /*tp_traverse*/
  __pyx_tp_clear_11structarray__ArrayIter, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  __pyx_f_11structarray_10_ArrayIter___iter__, /*tp_iter*/
  __pyx_f_11structarray_10_ArrayIter___next__, /*tp_iternext*/
  __pyx_methods_11structarray__ArrayIter, /*tp_methods*/
  0, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_11structarray_10_ArrayIter___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_11structarray__ArrayIter, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};
static struct __pyx_vtabstruct_11structarray_OffsetArray __pyx_vtable_11structarray_OffsetArray;

static PyObject *__pyx_tp_new_11structarray_OffsetArray(PyTypeObject *t, PyObject *a, PyObject *k) {
  struct __pyx_obj_11structarray_OffsetArray *p;
  PyObject *o = __pyx_ptype_11structarray_Array->tp_new(t, a, k);
  if (!o) return 0;
  p = ((struct __pyx_obj_11structarray_OffsetArray *)o);
  *(struct __pyx_vtabstruct_11structarray_OffsetArray **)&p->__pyx_base.__pyx_base.__pyx_vtab = __pyx_vtabptr_11structarray_OffsetArray;
  return o;
}

static void __pyx_tp_dealloc_11structarray_OffsetArray(PyObject *o) {
  __pyx_ptype_11structarray_Array->tp_dealloc(o);
}

static int __pyx_tp_traverse_11structarray_OffsetArray(PyObject *o, visitproc v, void *a) {
  int e;
  e = __pyx_ptype_11structarray_Array->tp_traverse(o, v, a); if (e) return e;
  return 0;
}

static int __pyx_tp_clear_11structarray_OffsetArray(PyObject *o) {
  __pyx_ptype_11structarray_Array->tp_clear(o);
  return 0;
}

static struct PyMethodDef __pyx_methods_11structarray_OffsetArray[] = {
  {0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number_OffsetArray = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
  #if Py_TPFLAGS_DEFAULT & Py_TPFLAGS_HAVE_INDEX
  0, /*nb_index*/
  #endif
};

static PySequenceMethods __pyx_tp_as_sequence_OffsetArray = {
  0, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping_OffsetArray = {
  0, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer_OffsetArray = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

PyTypeObject __pyx_type_11structarray_OffsetArray = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "structarray.OffsetArray", /*tp_name*/
  sizeof(struct __pyx_obj_11structarray_OffsetArray), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_11structarray_OffsetArray, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number_OffsetArray, /*tp_as_number*/
  &__pyx_tp_as_sequence_OffsetArray, /*tp_as_sequence*/
  &__pyx_tp_as_mapping_OffsetArray, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer_OffsetArray, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC, /*tp_flags*/
  "\n    ``OffsetArray(array, offset)``\n\n    An array that accesses it\'s data from an offset inside of another array.\n\n    This class is used by StructArray for providing arrays of individual\n    attributes.  You probably don\'t want to create instances of it yourself.\n    ", /*tp_doc*/
  __pyx_tp_traverse_11structarray_OffsetArray, /*tp_traverse*/
  __pyx_tp_clear_11structarray_OffsetArray, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  0, /*tp_iter*/
  0, /*tp_iternext*/
  __pyx_methods_11structarray_OffsetArray, /*tp_methods*/
  0, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_11structarray_11OffsetArray___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_11structarray_OffsetArray, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};

static PyObject *__pyx_tp_new_11structarray__ArrayOp2(PyTypeObject *t, PyObject *a, PyObject *k) {
  struct __pyx_obj_11structarray__ArrayOp2 *p;
  PyObject *o = (*t->tp_alloc)(t, 0);
  if (!o) return 0;
  p = ((struct __pyx_obj_11structarray__ArrayOp2 *)o);
  p->arg1 = Py_None; Py_INCREF(Py_None);
  p->arg2 = Py_None; Py_INCREF(Py_None);
  return o;
}

static void __pyx_tp_dealloc_11structarray__ArrayOp2(PyObject *o) {
  struct __pyx_obj_11structarray__ArrayOp2 *p = (struct __pyx_obj_11structarray__ArrayOp2 *)o;
  Py_XDECREF(p->arg1);
  Py_XDECREF(p->arg2);
  (*o->ob_type->tp_free)(o);
}

static int __pyx_tp_traverse_11structarray__ArrayOp2(PyObject *o, visitproc v, void *a) {
  int e;
  struct __pyx_obj_11structarray__ArrayOp2 *p = (struct __pyx_obj_11structarray__ArrayOp2 *)o;
  if (p->arg1) {
    e = (*v)(p->arg1, a); if (e) return e;
  }
  if (p->arg2) {
    e = (*v)(p->arg2, a); if (e) return e;
  }
  return 0;
}

static int __pyx_tp_clear_11structarray__ArrayOp2(PyObject *o) {
  struct __pyx_obj_11structarray__ArrayOp2 *p = (struct __pyx_obj_11structarray__ArrayOp2 *)o;
  Py_XDECREF(p->arg1);
  p->arg1 = Py_None; Py_INCREF(Py_None);
  Py_XDECREF(p->arg2);
  p->arg2 = Py_None; Py_INCREF(Py_None);
  return 0;
}

static struct PyMethodDef __pyx_methods_11structarray__ArrayOp2[] = {
  {"assign_to", (PyCFunction)__pyx_f_11structarray_9_ArrayOp2_assign_to, METH_VARARGS|METH_KEYWORDS, __pyx_doc_11structarray_9_ArrayOp2_assign_to},
  {"copy", (PyCFunction)__pyx_f_11structarray_9_ArrayOp2_copy, METH_VARARGS|METH_KEYWORDS, __pyx_doc_11structarray_9_ArrayOp2_copy},
  {0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number__ArrayOp2 = {
  __pyx_f_11structarray_9_ArrayOp2___add__, /*nb_add*/
  __pyx_f_11structarray_9_ArrayOp2___sub__, /*nb_subtract*/
  __pyx_f_11structarray_9_ArrayOp2___mul__, /*nb_multiply*/
  __pyx_f_11structarray_9_ArrayOp2___div__, /*nb_divide*/
  __pyx_f_11structarray_9_ArrayOp2___mod__, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  __pyx_f_11structarray_9_ArrayOp2___truediv__, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
  #if Py_TPFLAGS_DEFAULT & Py_TPFLAGS_HAVE_INDEX
  0, /*nb_index*/
  #endif
};

static PySequenceMethods __pyx_tp_as_sequence__ArrayOp2 = {
  __pyx_f_11structarray_9_ArrayOp2___len__, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping__ArrayOp2 = {
  __pyx_f_11structarray_9_ArrayOp2___len__, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer__ArrayOp2 = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

PyTypeObject __pyx_type_11structarray__ArrayOp2 = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "structarray._ArrayOp2", /*tp_name*/
  sizeof(struct __pyx_obj_11structarray__ArrayOp2), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_11structarray__ArrayOp2, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number__ArrayOp2, /*tp_as_number*/
  &__pyx_tp_as_sequence__ArrayOp2, /*tp_as_sequence*/
  &__pyx_tp_as_mapping__ArrayOp2, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer__ArrayOp2, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC, /*tp_flags*/
  0, /*tp_doc*/
  __pyx_tp_traverse_11structarray__ArrayOp2, /*tp_traverse*/
  __pyx_tp_clear_11structarray__ArrayOp2, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  __pyx_f_11structarray_9_ArrayOp2___iter__, /*tp_iter*/
  0, /*tp_iternext*/
  __pyx_methods_11structarray__ArrayOp2, /*tp_methods*/
  0, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_11structarray_9_ArrayOp2___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_11structarray__ArrayOp2, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};

static PyObject *__pyx_tp_new_11structarray_ArrayOpAdd(PyTypeObject *t, PyObject *a, PyObject *k) {
  PyObject *o = __pyx_ptype_11structarray__ArrayOp2->tp_new(t, a, k);
  if (!o) return 0;
  return o;
}

static void __pyx_tp_dealloc_11structarray_ArrayOpAdd(PyObject *o) {
  __pyx_ptype_11structarray__ArrayOp2->tp_dealloc(o);
}

static int __pyx_tp_traverse_11structarray_ArrayOpAdd(PyObject *o, visitproc v, void *a) {
  int e;
  e = __pyx_ptype_11structarray__ArrayOp2->tp_traverse(o, v, a); if (e) return e;
  return 0;
}

static int __pyx_tp_clear_11structarray_ArrayOpAdd(PyObject *o) {
  __pyx_ptype_11structarray__ArrayOp2->tp_clear(o);
  return 0;
}

static struct PyMethodDef __pyx_methods_11structarray_ArrayOpAdd[] = {
  {0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number_ArrayOpAdd = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
  #if Py_TPFLAGS_DEFAULT & Py_TPFLAGS_HAVE_INDEX
  0, /*nb_index*/
  #endif
};

static PySequenceMethods __pyx_tp_as_sequence_ArrayOpAdd = {
  0, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping_ArrayOpAdd = {
  0, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer_ArrayOpAdd = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

PyTypeObject __pyx_type_11structarray_ArrayOpAdd = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "structarray.ArrayOpAdd", /*tp_name*/
  sizeof(struct __pyx_obj_11structarray_ArrayOpAdd), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_11structarray_ArrayOpAdd, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number_ArrayOpAdd, /*tp_as_number*/
  &__pyx_tp_as_sequence_ArrayOpAdd, /*tp_as_sequence*/
  &__pyx_tp_as_mapping_ArrayOpAdd, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer_ArrayOpAdd, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC, /*tp_flags*/
  0, /*tp_doc*/
  __pyx_tp_traverse_11structarray_ArrayOpAdd, /*tp_traverse*/
  __pyx_tp_clear_11structarray_ArrayOpAdd, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  0, /*tp_iter*/
  0, /*tp_iternext*/
  __pyx_methods_11structarray_ArrayOpAdd, /*tp_methods*/
  0, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_11structarray_10ArrayOpAdd___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_11structarray_ArrayOpAdd, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};

static PyObject *__pyx_tp_new_11structarray_ArrayOpSub(PyTypeObject *t, PyObject *a, PyObject *k) {
  PyObject *o = __pyx_ptype_11structarray__ArrayOp2->tp_new(t, a, k);
  if (!o) return 0;
  return o;
}

static void __pyx_tp_dealloc_11structarray_ArrayOpSub(PyObject *o) {
  __pyx_ptype_11structarray__ArrayOp2->tp_dealloc(o);
}

static int __pyx_tp_traverse_11structarray_ArrayOpSub(PyObject *o, visitproc v, void *a) {
  int e;
  e = __pyx_ptype_11structarray__ArrayOp2->tp_traverse(o, v, a); if (e) return e;
  return 0;
}

static int __pyx_tp_clear_11structarray_ArrayOpSub(PyObject *o) {
  __pyx_ptype_11structarray__ArrayOp2->tp_clear(o);
  return 0;
}

static struct PyMethodDef __pyx_methods_11structarray_ArrayOpSub[] = {
  {0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number_ArrayOpSub = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
  #if Py_TPFLAGS_DEFAULT & Py_TPFLAGS_HAVE_INDEX
  0, /*nb_index*/
  #endif
};

static PySequenceMethods __pyx_tp_as_sequence_ArrayOpSub = {
  0, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping_ArrayOpSub = {
  0, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer_ArrayOpSub = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

PyTypeObject __pyx_type_11structarray_ArrayOpSub = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "structarray.ArrayOpSub", /*tp_name*/
  sizeof(struct __pyx_obj_11structarray_ArrayOpSub), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_11structarray_ArrayOpSub, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number_ArrayOpSub, /*tp_as_number*/
  &__pyx_tp_as_sequence_ArrayOpSub, /*tp_as_sequence*/
  &__pyx_tp_as_mapping_ArrayOpSub, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer_ArrayOpSub, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC, /*tp_flags*/
  0, /*tp_doc*/
  __pyx_tp_traverse_11structarray_ArrayOpSub, /*tp_traverse*/
  __pyx_tp_clear_11structarray_ArrayOpSub, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  0, /*tp_iter*/
  0, /*tp_iternext*/
  __pyx_methods_11structarray_ArrayOpSub, /*tp_methods*/
  0, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_11structarray_10ArrayOpSub___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_11structarray_ArrayOpSub, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};

static PyObject *__pyx_tp_new_11structarray_ArrayOpMul(PyTypeObject *t, PyObject *a, PyObject *k) {
  PyObject *o = __pyx_ptype_11structarray__ArrayOp2->tp_new(t, a, k);
  if (!o) return 0;
  return o;
}

static void __pyx_tp_dealloc_11structarray_ArrayOpMul(PyObject *o) {
  __pyx_ptype_11structarray__ArrayOp2->tp_dealloc(o);
}

static int __pyx_tp_traverse_11structarray_ArrayOpMul(PyObject *o, visitproc v, void *a) {
  int e;
  e = __pyx_ptype_11structarray__ArrayOp2->tp_traverse(o, v, a); if (e) return e;
  return 0;
}

static int __pyx_tp_clear_11structarray_ArrayOpMul(PyObject *o) {
  __pyx_ptype_11structarray__ArrayOp2->tp_clear(o);
  return 0;
}

static struct PyMethodDef __pyx_methods_11structarray_ArrayOpMul[] = {
  {0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number_ArrayOpMul = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
  #if Py_TPFLAGS_DEFAULT & Py_TPFLAGS_HAVE_INDEX
  0, /*nb_index*/
  #endif
};

static PySequenceMethods __pyx_tp_as_sequence_ArrayOpMul = {
  0, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping_ArrayOpMul = {
  0, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer_ArrayOpMul = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

PyTypeObject __pyx_type_11structarray_ArrayOpMul = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "structarray.ArrayOpMul", /*tp_name*/
  sizeof(struct __pyx_obj_11structarray_ArrayOpMul), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_11structarray_ArrayOpMul, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number_ArrayOpMul, /*tp_as_number*/
  &__pyx_tp_as_sequence_ArrayOpMul, /*tp_as_sequence*/
  &__pyx_tp_as_mapping_ArrayOpMul, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer_ArrayOpMul, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC, /*tp_flags*/
  0, /*tp_doc*/
  __pyx_tp_traverse_11structarray_ArrayOpMul, /*tp_traverse*/
  __pyx_tp_clear_11structarray_ArrayOpMul, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  0, /*tp_iter*/
  0, /*tp_iternext*/
  __pyx_methods_11structarray_ArrayOpMul, /*tp_methods*/
  0, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_11structarray_10ArrayOpMul___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_11structarray_ArrayOpMul, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};

static PyObject *__pyx_tp_new_11structarray_ArrayOpDiv(PyTypeObject *t, PyObject *a, PyObject *k) {
  PyObject *o = __pyx_ptype_11structarray__ArrayOp2->tp_new(t, a, k);
  if (!o) return 0;
  return o;
}

static void __pyx_tp_dealloc_11structarray_ArrayOpDiv(PyObject *o) {
  __pyx_ptype_11structarray__ArrayOp2->tp_dealloc(o);
}

static int __pyx_tp_traverse_11structarray_ArrayOpDiv(PyObject *o, visitproc v, void *a) {
  int e;
  e = __pyx_ptype_11structarray__ArrayOp2->tp_traverse(o, v, a); if (e) return e;
  return 0;
}

static int __pyx_tp_clear_11structarray_ArrayOpDiv(PyObject *o) {
  __pyx_ptype_11structarray__ArrayOp2->tp_clear(o);
  return 0;
}

static struct PyMethodDef __pyx_methods_11structarray_ArrayOpDiv[] = {
  {0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number_ArrayOpDiv = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
  #if Py_TPFLAGS_DEFAULT & Py_TPFLAGS_HAVE_INDEX
  0, /*nb_index*/
  #endif
};

static PySequenceMethods __pyx_tp_as_sequence_ArrayOpDiv = {
  0, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping_ArrayOpDiv = {
  0, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer_ArrayOpDiv = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

PyTypeObject __pyx_type_11structarray_ArrayOpDiv = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "structarray.ArrayOpDiv", /*tp_name*/
  sizeof(struct __pyx_obj_11structarray_ArrayOpDiv), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_11structarray_ArrayOpDiv, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number_ArrayOpDiv, /*tp_as_number*/
  &__pyx_tp_as_sequence_ArrayOpDiv, /*tp_as_sequence*/
  &__pyx_tp_as_mapping_ArrayOpDiv, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer_ArrayOpDiv, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC, /*tp_flags*/
  0, /*tp_doc*/
  __pyx_tp_traverse_11structarray_ArrayOpDiv, /*tp_traverse*/
  __pyx_tp_clear_11structarray_ArrayOpDiv, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  0, /*tp_iter*/
  0, /*tp_iternext*/
  __pyx_methods_11structarray_ArrayOpDiv, /*tp_methods*/
  0, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_11structarray_10ArrayOpDiv___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_11structarray_ArrayOpDiv, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};

static PyObject *__pyx_tp_new_11structarray_ArrayOpMod(PyTypeObject *t, PyObject *a, PyObject *k) {
  PyObject *o = __pyx_ptype_11structarray__ArrayOp2->tp_new(t, a, k);
  if (!o) return 0;
  return o;
}

static void __pyx_tp_dealloc_11structarray_ArrayOpMod(PyObject *o) {
  __pyx_ptype_11structarray__ArrayOp2->tp_dealloc(o);
}

static int __pyx_tp_traverse_11structarray_ArrayOpMod(PyObject *o, visitproc v, void *a) {
  int e;
  e = __pyx_ptype_11structarray__ArrayOp2->tp_traverse(o, v, a); if (e) return e;
  return 0;
}

static int __pyx_tp_clear_11structarray_ArrayOpMod(PyObject *o) {
  __pyx_ptype_11structarray__ArrayOp2->tp_clear(o);
  return 0;
}

static struct PyMethodDef __pyx_methods_11structarray_ArrayOpMod[] = {
  {0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number_ArrayOpMod = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
  #if Py_TPFLAGS_DEFAULT & Py_TPFLAGS_HAVE_INDEX
  0, /*nb_index*/
  #endif
};

static PySequenceMethods __pyx_tp_as_sequence_ArrayOpMod = {
  0, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping_ArrayOpMod = {
  0, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer_ArrayOpMod = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

PyTypeObject __pyx_type_11structarray_ArrayOpMod = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "structarray.ArrayOpMod", /*tp_name*/
  sizeof(struct __pyx_obj_11structarray_ArrayOpMod), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_11structarray_ArrayOpMod, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number_ArrayOpMod, /*tp_as_number*/
  &__pyx_tp_as_sequence_ArrayOpMod, /*tp_as_sequence*/
  &__pyx_tp_as_mapping_ArrayOpMod, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer_ArrayOpMod, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC, /*tp_flags*/
  0, /*tp_doc*/
  __pyx_tp_traverse_11structarray_ArrayOpMod, /*tp_traverse*/
  __pyx_tp_clear_11structarray_ArrayOpMod, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  0, /*tp_iter*/
  0, /*tp_iternext*/
  __pyx_methods_11structarray_ArrayOpMod, /*tp_methods*/
  0, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_11structarray_10ArrayOpMod___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_11structarray_ArrayOpMod, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};

static PyObject *__pyx_tp_new_11structarray_ArrayOpMin(PyTypeObject *t, PyObject *a, PyObject *k) {
  PyObject *o = __pyx_ptype_11structarray__ArrayOp2->tp_new(t, a, k);
  if (!o) return 0;
  return o;
}

static void __pyx_tp_dealloc_11structarray_ArrayOpMin(PyObject *o) {
  __pyx_ptype_11structarray__ArrayOp2->tp_dealloc(o);
}

static int __pyx_tp_traverse_11structarray_ArrayOpMin(PyObject *o, visitproc v, void *a) {
  int e;
  e = __pyx_ptype_11structarray__ArrayOp2->tp_traverse(o, v, a); if (e) return e;
  return 0;
}

static int __pyx_tp_clear_11structarray_ArrayOpMin(PyObject *o) {
  __pyx_ptype_11structarray__ArrayOp2->tp_clear(o);
  return 0;
}

static struct PyMethodDef __pyx_methods_11structarray_ArrayOpMin[] = {
  {0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number_ArrayOpMin = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
  #if Py_TPFLAGS_DEFAULT & Py_TPFLAGS_HAVE_INDEX
  0, /*nb_index*/
  #endif
};

static PySequenceMethods __pyx_tp_as_sequence_ArrayOpMin = {
  0, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping_ArrayOpMin = {
  0, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer_ArrayOpMin = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

PyTypeObject __pyx_type_11structarray_ArrayOpMin = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "structarray.ArrayOpMin", /*tp_name*/
  sizeof(struct __pyx_obj_11structarray_ArrayOpMin), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_11structarray_ArrayOpMin, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number_ArrayOpMin, /*tp_as_number*/
  &__pyx_tp_as_sequence_ArrayOpMin, /*tp_as_sequence*/
  &__pyx_tp_as_mapping_ArrayOpMin, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer_ArrayOpMin, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC, /*tp_flags*/
  0, /*tp_doc*/
  __pyx_tp_traverse_11structarray_ArrayOpMin, /*tp_traverse*/
  __pyx_tp_clear_11structarray_ArrayOpMin, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  0, /*tp_iter*/
  0, /*tp_iternext*/
  __pyx_methods_11structarray_ArrayOpMin, /*tp_methods*/
  0, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_11structarray_10ArrayOpMin___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_11structarray_ArrayOpMin, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};

static PyObject *__pyx_tp_new_11structarray_ArrayOpMax(PyTypeObject *t, PyObject *a, PyObject *k) {
  PyObject *o = __pyx_ptype_11structarray__ArrayOp2->tp_new(t, a, k);
  if (!o) return 0;
  return o;
}

static void __pyx_tp_dealloc_11structarray_ArrayOpMax(PyObject *o) {
  __pyx_ptype_11structarray__ArrayOp2->tp_dealloc(o);
}

static int __pyx_tp_traverse_11structarray_ArrayOpMax(PyObject *o, visitproc v, void *a) {
  int e;
  e = __pyx_ptype_11structarray__ArrayOp2->tp_traverse(o, v, a); if (e) return e;
  return 0;
}

static int __pyx_tp_clear_11structarray_ArrayOpMax(PyObject *o) {
  __pyx_ptype_11structarray__ArrayOp2->tp_clear(o);
  return 0;
}

static struct PyMethodDef __pyx_methods_11structarray_ArrayOpMax[] = {
  {0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number_ArrayOpMax = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
  #if Py_TPFLAGS_DEFAULT & Py_TPFLAGS_HAVE_INDEX
  0, /*nb_index*/
  #endif
};

static PySequenceMethods __pyx_tp_as_sequence_ArrayOpMax = {
  0, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping_ArrayOpMax = {
  0, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer_ArrayOpMax = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

PyTypeObject __pyx_type_11structarray_ArrayOpMax = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "structarray.ArrayOpMax", /*tp_name*/
  sizeof(struct __pyx_obj_11structarray_ArrayOpMax), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_11structarray_ArrayOpMax, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number_ArrayOpMax, /*tp_as_number*/
  &__pyx_tp_as_sequence_ArrayOpMax, /*tp_as_sequence*/
  &__pyx_tp_as_mapping_ArrayOpMax, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer_ArrayOpMax, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC, /*tp_flags*/
  0, /*tp_doc*/
  __pyx_tp_traverse_11structarray_ArrayOpMax, /*tp_traverse*/
  __pyx_tp_clear_11structarray_ArrayOpMax, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  0, /*tp_iter*/
  0, /*tp_iternext*/
  __pyx_methods_11structarray_ArrayOpMax, /*tp_methods*/
  0, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_11structarray_10ArrayOpMax___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_11structarray_ArrayOpMax, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};

static struct PyMethodDef __pyx_methods[] = {
  {"array_max", (PyCFunction)__pyx_f_11structarray_array_max, METH_VARARGS|METH_KEYWORDS, __pyx_doc_11structarray_array_max},
  {"array_min", (PyCFunction)__pyx_f_11structarray_array_min, METH_VARARGS|METH_KEYWORDS, __pyx_doc_11structarray_array_min},
  {0, 0, 0, 0}
};

static void __pyx_init_filenames(void); /*proto*/

PyMODINIT_FUNC initstructarray(void); /*proto*/
PyMODINIT_FUNC initstructarray(void) {
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  PyObject *__pyx_5 = 0;
  PyObject *__pyx_6 = 0;
  __pyx_init_filenames();
  __pyx_m = Py_InitModule4("structarray", __pyx_methods, __pyx_mdoc, 0, PYTHON_API_VERSION);
  if (!__pyx_m) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; goto __pyx_L1;};
  __pyx_b = PyImport_AddModule("__builtin__");
  if (!__pyx_b) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; goto __pyx_L1;};
  if (PyObject_SetAttrString(__pyx_m, "__builtins__", __pyx_b) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; goto __pyx_L1;};
  if (__Pyx_InternStrings(__pyx_intern_tab) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; goto __pyx_L1;};
  if (__Pyx_InitStrings(__pyx_string_tab) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1; goto __pyx_L1;};
  __pyx_vtabptr_11structarray__BaseArray = &__pyx_vtable_11structarray__BaseArray;
  *(void(**)(void))&__pyx_vtable_11structarray__BaseArray._sync_data_ptr = (void(*)(void))__pyx_f_11structarray_10_BaseArray__sync_data_ptr;
  *(void(**)(void))&__pyx_vtable_11structarray__BaseArray._getitem = (void(*)(void))__pyx_f_11structarray_10_BaseArray__getitem;
  *(void(**)(void))&__pyx_vtable_11structarray__BaseArray._setitem = (void(*)(void))__pyx_f_11structarray_10_BaseArray__setitem;
  __pyx_type_11structarray__BaseArray.tp_free = _PyObject_GC_Del;
  if (PyType_Ready(&__pyx_type_11structarray__BaseArray) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 83; goto __pyx_L1;}
  if (__Pyx_SetVtable(__pyx_type_11structarray__BaseArray.tp_dict, __pyx_vtabptr_11structarray__BaseArray) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 83; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "_BaseArray", (PyObject *)&__pyx_type_11structarray__BaseArray) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 83; goto __pyx_L1;}
  __pyx_ptype_11structarray__BaseArray = &__pyx_type_11structarray__BaseArray;
  __pyx_type_11structarray__ItemInfo.tp_free = _PyObject_GC_Del;
  if (PyType_Ready(&__pyx_type_11structarray__ItemInfo) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 751; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "_ItemInfo", (PyObject *)&__pyx_type_11structarray__ItemInfo) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 751; goto __pyx_L1;}
  __pyx_ptype_11structarray__ItemInfo = &__pyx_type_11structarray__ItemInfo;
  __pyx_vtabptr_11structarray_StructArray = &__pyx_vtable_11structarray_StructArray;
  __pyx_vtable_11structarray_StructArray.__pyx_base = *__pyx_vtabptr_11structarray__BaseArray;
  __pyx_type_11structarray_StructArray.tp_base = __pyx_ptype_11structarray__BaseArray;
  __pyx_type_11structarray_StructArray.tp_free = _PyObject_GC_Del;
  if (PyType_Ready(&__pyx_type_11structarray_StructArray) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 279; goto __pyx_L1;}
  if (__Pyx_SetVtable(__pyx_type_11structarray_StructArray.tp_dict, __pyx_vtabptr_11structarray_StructArray) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 279; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "StructArray", (PyObject *)&__pyx_type_11structarray_StructArray) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 279; goto __pyx_L1;}
  __pyx_ptype_11structarray_StructArray = &__pyx_type_11structarray_StructArray;
  __pyx_type_11structarray__StructArrayIter.tp_free = _PyObject_GC_Del;
  if (PyType_Ready(&__pyx_type_11structarray__StructArrayIter) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 429; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "_StructArrayIter", (PyObject *)&__pyx_type_11structarray__StructArrayIter) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 429; goto __pyx_L1;}
  __pyx_ptype_11structarray__StructArrayIter = &__pyx_type_11structarray__StructArrayIter;
  __pyx_vtabptr_11structarray_Array = &__pyx_vtable_11structarray_Array;
  __pyx_vtable_11structarray_Array.__pyx_base = *__pyx_vtabptr_11structarray__BaseArray;
  *(void(**)(void))&__pyx_vtable_11structarray_Array.__pyx_base._getitem = (void(*)(void))__pyx_f_11structarray_5Array__getitem;
  *(void(**)(void))&__pyx_vtable_11structarray_Array.__pyx_base._setitem = (void(*)(void))__pyx_f_11structarray_5Array__setitem;
  __pyx_type_11structarray_Array.tp_base = __pyx_ptype_11structarray__BaseArray;
  if (PyType_Ready(&__pyx_type_11structarray_Array) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 444; goto __pyx_L1;}
  if (__Pyx_SetVtable(__pyx_type_11structarray_Array.tp_dict, __pyx_vtabptr_11structarray_Array) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 444; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "Array", (PyObject *)&__pyx_type_11structarray_Array) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 444; goto __pyx_L1;}
  __pyx_ptype_11structarray_Array = &__pyx_type_11structarray_Array;
  __pyx_type_11structarray__ArrayIter.tp_free = _PyObject_GC_Del;
  if (PyType_Ready(&__pyx_type_11structarray__ArrayIter) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 715; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "_ArrayIter", (PyObject *)&__pyx_type_11structarray__ArrayIter) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 715; goto __pyx_L1;}
  __pyx_ptype_11structarray__ArrayIter = &__pyx_type_11structarray__ArrayIter;
  __pyx_vtabptr_11structarray_OffsetArray = &__pyx_vtable_11structarray_OffsetArray;
  __pyx_vtable_11structarray_OffsetArray.__pyx_base = *__pyx_vtabptr_11structarray_Array;
  *(void(**)(void))&__pyx_vtable_11structarray_OffsetArray.__pyx_base.__pyx_base._sync_data_ptr = (void(*)(void))__pyx_f_11structarray_11OffsetArray__sync_data_ptr;
  __pyx_type_11structarray_OffsetArray.tp_base = __pyx_ptype_11structarray_Array;
  if (PyType_Ready(&__pyx_type_11structarray_OffsetArray) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 729; goto __pyx_L1;}
  if (__Pyx_SetVtable(__pyx_type_11structarray_OffsetArray.tp_dict, __pyx_vtabptr_11structarray_OffsetArray) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 729; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "OffsetArray", (PyObject *)&__pyx_type_11structarray_OffsetArray) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 729; goto __pyx_L1;}
  __pyx_ptype_11structarray_OffsetArray = &__pyx_type_11structarray_OffsetArray;
  __pyx_type_11structarray__ArrayOp2.tp_free = _PyObject_GC_Del;
  if (PyType_Ready(&__pyx_type_11structarray__ArrayOp2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 796; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "_ArrayOp2", (PyObject *)&__pyx_type_11structarray__ArrayOp2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 796; goto __pyx_L1;}
  __pyx_ptype_11structarray__ArrayOp2 = &__pyx_type_11structarray__ArrayOp2;
  __pyx_type_11structarray_ArrayOpAdd.tp_base = __pyx_ptype_11structarray__ArrayOp2;
  if (PyType_Ready(&__pyx_type_11structarray_ArrayOpAdd) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 877; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ArrayOpAdd", (PyObject *)&__pyx_type_11structarray_ArrayOpAdd) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 877; goto __pyx_L1;}
  __pyx_ptype_11structarray_ArrayOpAdd = &__pyx_type_11structarray_ArrayOpAdd;
  __pyx_type_11structarray_ArrayOpSub.tp_base = __pyx_ptype_11structarray__ArrayOp2;
  if (PyType_Ready(&__pyx_type_11structarray_ArrayOpSub) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 882; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ArrayOpSub", (PyObject *)&__pyx_type_11structarray_ArrayOpSub) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 882; goto __pyx_L1;}
  __pyx_ptype_11structarray_ArrayOpSub = &__pyx_type_11structarray_ArrayOpSub;
  __pyx_type_11structarray_ArrayOpMul.tp_base = __pyx_ptype_11structarray__ArrayOp2;
  if (PyType_Ready(&__pyx_type_11structarray_ArrayOpMul) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 887; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ArrayOpMul", (PyObject *)&__pyx_type_11structarray_ArrayOpMul) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 887; goto __pyx_L1;}
  __pyx_ptype_11structarray_ArrayOpMul = &__pyx_type_11structarray_ArrayOpMul;
  __pyx_type_11structarray_ArrayOpDiv.tp_base = __pyx_ptype_11structarray__ArrayOp2;
  if (PyType_Ready(&__pyx_type_11structarray_ArrayOpDiv) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 892; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ArrayOpDiv", (PyObject *)&__pyx_type_11structarray_ArrayOpDiv) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 892; goto __pyx_L1;}
  __pyx_ptype_11structarray_ArrayOpDiv = &__pyx_type_11structarray_ArrayOpDiv;
  __pyx_type_11structarray_ArrayOpMod.tp_base = __pyx_ptype_11structarray__ArrayOp2;
  if (PyType_Ready(&__pyx_type_11structarray_ArrayOpMod) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 897; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ArrayOpMod", (PyObject *)&__pyx_type_11structarray_ArrayOpMod) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 897; goto __pyx_L1;}
  __pyx_ptype_11structarray_ArrayOpMod = &__pyx_type_11structarray_ArrayOpMod;
  __pyx_type_11structarray_ArrayOpMin.tp_base = __pyx_ptype_11structarray__ArrayOp2;
  if (PyType_Ready(&__pyx_type_11structarray_ArrayOpMin) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 902; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ArrayOpMin", (PyObject *)&__pyx_type_11structarray_ArrayOpMin) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 902; goto __pyx_L1;}
  __pyx_ptype_11structarray_ArrayOpMin = &__pyx_type_11structarray_ArrayOpMin;
  __pyx_type_11structarray_ArrayOpMax.tp_base = __pyx_ptype_11structarray__ArrayOp2;
  if (PyType_Ready(&__pyx_type_11structarray_ArrayOpMax) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 907; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ArrayOpMax", (PyObject *)&__pyx_type_11structarray_ArrayOpMax) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 907; goto __pyx_L1;}
  __pyx_ptype_11structarray_ArrayOpMax = &__pyx_type_11structarray_ArrayOpMax;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":34 */
  if (PyObject_SetAttr(__pyx_m, __pyx_n___credits__, __pyx_k1p) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 33; goto __pyx_L1;}

  /* "/home/mmarshall/projects/structarray/structarray.pyx":58 */
  if (PyObject_SetAttr(__pyx_m, __pyx_n___author__, __pyx_k2p) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 58; goto __pyx_L1;}

  /* "/home/mmarshall/projects/structarray/structarray.pyx":60 */
  if (PyObject_SetAttr(__pyx_m, __pyx_n___version__, __pyx_k3p) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 60; goto __pyx_L1;}

  /* "/home/mmarshall/projects/structarray/structarray.pyx":355 */
  __pyx_1 = PyList_New(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 355; goto __pyx_L1;}
  __pyx_k4 = __pyx_1;
  __pyx_1 = 0;
  __pyx_2 = PyDict_New(); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 355; goto __pyx_L1;}
  __pyx_k5 = __pyx_2;
  __pyx_2 = 0;
  __pyx_3 = PyInt_FromLong(0); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 355; goto __pyx_L1;}
  __pyx_k6 = __pyx_3;
  __pyx_3 = 0;
  Py_INCREF(Py_None);
  __pyx_k7 = Py_None;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":492 */
  __pyx_4 = PyList_New(0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 492; goto __pyx_L1;}
  __pyx_k8 = __pyx_4;
  __pyx_4 = 0;
  __pyx_5 = PyInt_FromLong(0); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 492; goto __pyx_L1;}
  __pyx_k9 = __pyx_5;
  __pyx_5 = 0;
  Py_INCREF(Py_None);
  __pyx_k10 = Py_None;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":971 */
  __pyx_6 = PyList_New(4); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 971; goto __pyx_L1;}
  Py_INCREF(__pyx_n_Array);
  PyList_SET_ITEM(__pyx_6, 0, __pyx_n_Array);
  Py_INCREF(__pyx_n_StructArray);
  PyList_SET_ITEM(__pyx_6, 1, __pyx_n_StructArray);
  Py_INCREF(__pyx_n_array_max);
  PyList_SET_ITEM(__pyx_6, 2, __pyx_n_array_max);
  Py_INCREF(__pyx_n_array_min);
  PyList_SET_ITEM(__pyx_6, 3, __pyx_n_array_min);
  if (PyObject_SetAttr(__pyx_m, __pyx_n___all__, __pyx_6) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 971; goto __pyx_L1;}
  Py_DECREF(__pyx_6); __pyx_6 = 0;

  /* "/home/mmarshall/projects/structarray/structarray.pyx":972 */
  __pyx_6 = __Pyx_GetName(__pyx_m, __pyx_n___all__); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 972; goto __pyx_L1;}
  if (PyObject_SetAttr(__pyx_m, __pyx_n___docs_all__, __pyx_6) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 972; goto __pyx_L1;}
  Py_DECREF(__pyx_6); __pyx_6 = 0;
  return;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  Py_XDECREF(__pyx_5);
  Py_XDECREF(__pyx_6);
  __Pyx_AddTraceback("structarray");
}

static char *__pyx_filenames[] = {
  "structarray.pyx",
};

/* Runtime support code */

static void __pyx_init_filenames(void) {
  __pyx_f = __pyx_filenames;
}

static int __Pyx_ArgTypeTest(PyObject *obj, PyTypeObject *type, int none_allowed, char *name) {
    if (!type) {
        PyErr_Format(PyExc_SystemError, "Missing type object");
        return 0;
    }
    if ((none_allowed && obj == Py_None) || PyObject_TypeCheck(obj, type))
        return 1;
    PyErr_Format(PyExc_TypeError,
        "Argument '%s' has incorrect type (expected %s, got %s)",
        name, type->tp_name, obj->ob_type->tp_name);
    return 0;
}

static PyObject *__Pyx_GetName(PyObject *dict, PyObject *name) {
    PyObject *result;
    result = PyObject_GetAttr(dict, name);
    if (!result)
        PyErr_SetObject(PyExc_NameError, name);
    return result;
}

static void __Pyx_Raise(PyObject *type, PyObject *value, PyObject *tb) {
    Py_XINCREF(type);
    Py_XINCREF(value);
    Py_XINCREF(tb);
    /* First, check the traceback argument, replacing None with NULL. */
    if (tb == Py_None) {
        Py_DECREF(tb);
        tb = 0;
    }
    else if (tb != NULL && !PyTraceBack_Check(tb)) {
        PyErr_SetString(PyExc_TypeError,
            "raise: arg 3 must be a traceback or None");
        goto raise_error;
    }
    /* Next, replace a missing value with None */
    if (value == NULL) {
        value = Py_None;
        Py_INCREF(value);
    }
    #if PY_VERSION_HEX < 0x02050000
    if (!PyClass_Check(type))
    #else
    if (!PyType_Check(type))
    #endif
    {
        /* Raising an instance.  The value should be a dummy. */
        if (value != Py_None) {
            PyErr_SetString(PyExc_TypeError,
                "instance exception may not have a separate value");
            goto raise_error;
        }
        /* Normalize to raise <class>, <instance> */
        Py_DECREF(value);
        value = type;
        #if PY_VERSION_HEX < 0x02050000
            if (PyInstance_Check(type)) {
                type = (PyObject*) ((PyInstanceObject*)type)->in_class;
                Py_INCREF(type);
            }
            else {
                PyErr_SetString(PyExc_TypeError,
                    "raise: exception must be an old-style class or instance");
                goto raise_error;
            }
        #else
            type = (PyObject*) type->ob_type;
            Py_INCREF(type);
            if (!PyType_IsSubtype((PyTypeObject *)type, (PyTypeObject *)PyExc_BaseException)) {
                PyErr_SetString(PyExc_TypeError,
                    "raise: exception class must be a subclass of BaseException");
                goto raise_error;
            }
        #endif
    }
    PyErr_Restore(type, value, tb);
    return;
raise_error:
    Py_XDECREF(value);
    Py_XDECREF(type);
    Py_XDECREF(tb);
    return;
}

static void __Pyx_WriteUnraisable(char *name) {
    PyObject *old_exc, *old_val, *old_tb;
    PyObject *ctx;
    PyErr_Fetch(&old_exc, &old_val, &old_tb);
    ctx = PyString_FromString(name);
    PyErr_Restore(old_exc, old_val, old_tb);
    if (!ctx)
        ctx = Py_None;
    PyErr_WriteUnraisable(ctx);
}

static int __Pyx_GetException(PyObject **type, PyObject **value, PyObject **tb) {
    PyThreadState *tstate = PyThreadState_Get();
    PyErr_Fetch(type, value, tb);
    PyErr_NormalizeException(type, value, tb);
    if (PyErr_Occurred())
        goto bad;
    Py_INCREF(*type);
    Py_INCREF(*value);
    Py_INCREF(*tb);
    Py_XDECREF(tstate->exc_type);
    Py_XDECREF(tstate->exc_value);
    Py_XDECREF(tstate->exc_traceback);
    tstate->exc_type = *type;
    tstate->exc_value = *value;
    tstate->exc_traceback = *tb;
    return 0;
bad:
    Py_XDECREF(*type);
    Py_XDECREF(*value);
    Py_XDECREF(*tb);
    return -1;
}

static void __Pyx_UnpackError(void) {
    PyErr_SetString(PyExc_ValueError, "unpack sequence of wrong size");
}

static PyObject *__Pyx_UnpackItem(PyObject *iter) {
    PyObject *item;
    if (!(item = PyIter_Next(iter))) {
        if (!PyErr_Occurred())
            __Pyx_UnpackError();
    }
    return item;
}

static int __Pyx_EndUnpack(PyObject *iter) {
    PyObject *item;
    if ((item = PyIter_Next(iter))) {
        Py_DECREF(item);
        __Pyx_UnpackError();
        return -1;
    }
    else if (!PyErr_Occurred())
        return 0;
    else
        return -1;
}

static int __Pyx_TypeTest(PyObject *obj, PyTypeObject *type) {
    if (!type) {
        PyErr_Format(PyExc_SystemError, "Missing type object");
        return 0;
    }
    if (obj == Py_None || PyObject_TypeCheck(obj, type))
        return 1;
    PyErr_Format(PyExc_TypeError, "Cannot convert %s to %s",
        obj->ob_type->tp_name, type->tp_name);
    return 0;
}

static int __Pyx_InternStrings(__Pyx_InternTabEntry *t) {
    while (t->p) {
        *t->p = PyString_InternFromString(t->s);
        if (!*t->p)
            return -1;
        ++t;
    }
    return 0;
}

static int __Pyx_InitStrings(__Pyx_StringTabEntry *t) {
    while (t->p) {
        *t->p = PyString_FromStringAndSize(t->s, t->n - 1);
        if (!*t->p)
            return -1;
        ++t;
    }
    return 0;
}

static int __Pyx_SetVtable(PyObject *dict, void *vtable) {
    PyObject *pycobj = 0;
    int result;
    
    pycobj = PyCObject_FromVoidPtr(vtable, 0);
    if (!pycobj)
        goto bad;
    if (PyDict_SetItemString(dict, "__pyx_vtable__", pycobj) < 0)
        goto bad;
    result = 0;
    goto done;

bad:
    result = -1;
done:
    Py_XDECREF(pycobj);
    return result;
}

#include "compile.h"
#include "frameobject.h"
#include "traceback.h"

static void __Pyx_AddTraceback(char *funcname) {
    PyObject *py_srcfile = 0;
    PyObject *py_funcname = 0;
    PyObject *py_globals = 0;
    PyObject *empty_tuple = 0;
    PyObject *empty_string = 0;
    PyCodeObject *py_code = 0;
    PyFrameObject *py_frame = 0;
    
    py_srcfile = PyString_FromString(__pyx_filename);
    if (!py_srcfile) goto bad;
    py_funcname = PyString_FromString(funcname);
    if (!py_funcname) goto bad;
    py_globals = PyModule_GetDict(__pyx_m);
    if (!py_globals) goto bad;
    empty_tuple = PyTuple_New(0);
    if (!empty_tuple) goto bad;
    empty_string = PyString_FromString("");
    if (!empty_string) goto bad;
    py_code = PyCode_New(
        0,            /*int argcount,*/
        0,            /*int nlocals,*/
        0,            /*int stacksize,*/
        0,            /*int flags,*/
        empty_string, /*PyObject *code,*/
        empty_tuple,  /*PyObject *consts,*/
        empty_tuple,  /*PyObject *names,*/
        empty_tuple,  /*PyObject *varnames,*/
        empty_tuple,  /*PyObject *freevars,*/
        empty_tuple,  /*PyObject *cellvars,*/
        py_srcfile,   /*PyObject *filename,*/
        py_funcname,  /*PyObject *name,*/
        __pyx_lineno,   /*int firstlineno,*/
        empty_string  /*PyObject *lnotab*/
    );
    if (!py_code) goto bad;
    py_frame = PyFrame_New(
        PyThreadState_Get(), /*PyThreadState *tstate,*/
        py_code,             /*PyCodeObject *code,*/
        py_globals,          /*PyObject *globals,*/
        0                    /*PyObject *locals*/
    );
    if (!py_frame) goto bad;
    py_frame->f_lineno = __pyx_lineno;
    PyTraceBack_Here(py_frame);
bad:
    Py_XDECREF(py_srcfile);
    Py_XDECREF(py_funcname);
    Py_XDECREF(empty_tuple);
    Py_XDECREF(empty_string);
    Py_XDECREF(py_code);
    Py_XDECREF(py_frame);
}
