from setuptools import setup

setup(name='Struqtural',
      version='0.1',
      description='High level SQL structure manipulation library',
      author='Nathan Rice',
      author_email='nathan.alexander.rice@gmail.com',
      url='http://www.turnkey-analytics.com/struqtural/',
      packages=['struqtural',
                'struqtural/database',
                'struqtural/mixins',
                'struqtural/loaders',
                'struqtural/processes',
                'struqtural/structures',
                'tests',
                'tests/structures'],
      requires=['sqlalchemy', 'decorator'],
      data_files=[('tests/data',
                   ['tests/data/sales_order.xml', 'tests/data/menu.xml']),
                  ('struqtural/resources',
                   ['struqtural/resources/sql_server.cfg'])],
      classifiers=[
          'Development Status :: 4 - Beta',
          'Environment :: Console',
          'Environment :: Web Environment',
          'Intended Audience :: Information Technology',
          'Intended Audience :: Developers',
          'Intended Audience :: Science/Research',
          'Topic :: Database',
          'Topic :: Software Development :: Libraries',
          'License :: OSI Approved :: Python Software Foundation License',
          'Operating System :: MacOS :: MacOS X',
          'Operating System :: Microsoft :: Windows',
          'Operating System :: POSIX',
          'Programming Language :: Python']
      )
