

"""Module Description

Copyright (c) 2014, Ying Jin <yjin@cshl.edu >


This code is free software; you can redistribute it and/or modify it
under the terms of the Artistic License (see the file COPYING included
with the distribution).

@author:  Ying Jin
@contact: yjin@cshl.edu
"""
import sys, time
import logging
from math import ceil,floor


class Node :
    def __init__(self,start=-1,end=-1,name="",parent=None,left=None,right=None):
        self.__start = start
        self.__end = end
        self.__name = name
        self.left = left
        self.right = right
        self.balanceFactor = 0
        self.parent = parent
        self.isroot = False
        
    
    def isRoot(self):
        return self.isroot
    
    def isLeftChild(self):
        return self.parent and self.parent.left == self
    
    def isRightChild(self):
        return  self.parent and self.parent.right == self
    
    def getStart(self):
        return self.__start
    
    def getEnd(self):
        return self.__end
    
    def getName(self):
        return self.__name
    
    def overlaps(self,start,end):
        if start < self.__end and end >= self.__start :
         #   ovpstart = 0
         #   ovpend = 0
         #   if start > self.__start :
         #       ovpstart = start
         #   else :
         #       ovpstart = self.__start
         #   if end > self.__end :
         #       ovpend = self.__end
         #   else :
         #       ovpend = end
         #   if ovpend - ovpstart >= (end -start)/2 : #overlap >= half of the read
                return True
         #   else :
         #       return False
        else :
            return False

class BinaryTree :
    def __init__(self):
        
        self.root = None
        self.size = 0
        
                

    def print_tree(self,node):
        
        print(str(node.getStart()))
        if node.left :
            self.print_tree(node.left)
       

        
        if node.right :
            self.print_tree(node.right)
            
        return
            
        

    def children_count(self):
        """
        Return the number of children

        @returns number of children: 0, 1, 2
        """
        cnt = 0
        if self.left:
            cnt += 1
        if self.right:
            cnt += 1
        return cnt
        
    def insert(self,start,end,name):
        if self.root:
            self.__insert(self.root,start,end,name)
        else:
            self.root = Node(start,end,name)
            self.root.isroot  = True
        self.size = self.size + 1
    
    def __insert(self, node, start,end,name):
        """
        Insert new node with data

        @param data node data object to insert
        """
        root = node
        
        if start < root.getStart():
            if root.left is None:
                root.left = Node(start=start,end=end,name=name,parent=root)
                #root.left.isLeft = True
                self.updateBalance(root.left)
            else:
                self.__insert(root.left,start,end,name)
        else:
            if root.right is None:
                root.right = Node(start,end,name,parent=root)
                #self.right.isLeft = False
                self.updateBalance(root.right)
            else:
                self.__insert(root.right,start,end,name)
    
    
#    def __contains__(self,key):
#        if self._get(key,self.root):
#            return True
#        else:
#            return False

            
    def updateBalance(self,node):
     #   print("updateBalance")
     #   print("node.start" + str(node.getStart()))
        if node.balanceFactor > 1 or node.balanceFactor < -1 :
            self.rebalance(node)
            return
        
        if node.parent != None :
            if node.isLeftChild() :
                node.parent.balanceFactor += 1
            elif node.isRightChild() :
                node.parent.balanceFactor -= 1
            
            if node.parent.balanceFactor != 0 :
                self.updateBalance(node.parent)
            
    def rebalance(self,node):
    #    print("rebalance")
        if node.balanceFactor < 0 :
            if node.right.balanceFactor > 0 :
                self.rotateRight(node.right)
                self.rotateLeft(node)
            else :
                self.rotateLeft(node)
        elif node.balanceFactor > 0 :
            if node.left.balanceFactor < 0 :
                self.rotateLeft(node.left)
                self.rotateRight(node)
            else :
                self.rotateRight(node)

    def rotateRight(self,oldRoot):
        newRoot = oldRoot.left
        oldRoot.left = newRoot.right
        if newRoot.right != None :
            newRoot.right.parent = oldRoot
        newRoot.parent = oldRoot.parent
        
        if oldRoot.isRoot() :
            self.root = newRoot
            newRoot.isroot = True
        else :
            if oldRoot.isLeftChild() :
                oldRoot.parent.left = newRoot
            else :
                oldRoot.parent.right = newRoot
                
        
        newRoot.right = oldRoot
        oldRoot.parent = newRoot
        oldRoot.balanceFactor = oldRoot.balanceFactor - 1 - max(newRoot.balanceFactor,0)
        newRoot.balanceFactor = newRoot.balanceFactor - 1 + min(oldRoot.balanceFactor,0)
                                            
    def rotateLeft(self,oldRoot):
        newRoot = oldRoot.right
        oldRoot.right = newRoot.left
        if newRoot.left != None :
            newRoot.left.parent = oldRoot
        newRoot.parent = oldRoot.parent
        
        if oldRoot.isRoot() :
            self.root = newRoot
            newRoot.isroot = True
        else :
            if oldRoot.isLeftChild() :
                oldRoot.parent.left = newRoot
            else :
                oldRoot.parent.right = newRoot
                
        
        newRoot.left = oldRoot
        oldRoot.parent = newRoot
        oldRoot.balanceFactor = oldRoot.balanceFactor + 1 - min(newRoot.balanceFactor,0)
        newRoot.balanceFactor = newRoot.balanceFactor + 1 - max(oldRoot.balanceFactor,0)
                            

    def lookup(self, start,node,lastSmallest):
        """
        Lookup node containing data

        @param data node data object to look up
        @param parent node's parent
        @returns node and node's parent if found or None, None
        """
        if start < node.getStart():
            if node.left is None:
                    return lastSmallest
                
            return self.lookup(start, node.left,lastSmallest)
        
        elif start > node.getStart():
            lastSmallest = node
            if node.right is None:
               
                    return lastSmallest
                
            return self.lookup(start, node.right,lastSmallest)
        else:
            return node

'''   
 def delete(self, data):
        """
        Delete node containing data

        @param data node's content to delete
        """
        # get node containing data
        node, parent = self.lookup(data)
        if node is not None:
            children_count = node.children_count()
            if children_count == 0:
                # if node has no children, just remove it
                # check if it is not the root node
                if parent.left is node:
                    parent.left = None
                else:
                    parent.right = None
                del node
            elif children_count == 1:
                # if node has 1 child
                # replace node by its child
                if node.left:
                    n = node.left
                else:
                    n = node.right
                if parent.left is node:
                    parent.left = n
                else:
                    parent.right = n
                del node
            else:
                # if node has 2 children
                # find its successor
                parent = node
                successor = node.right
                while successor.left:
                    parent = successor
                    successor = successor.left
                # replace node data by its successor data
                node.data = successor.data
                # fix successor's parent node child
                if parent.left == successor:
                    parent.left = successor.right
                else:
                    parent.right = successor.right

    def compare_trees(self, node):
        """
        Compare 2 trees

        @param node tree to compare
        @returns True if the tree passed is identical to this tree
        """
        if node is None:
            return False
        if self.data != node.data:
            return False
        res = True
        if self.left is None:
            if node.left:
                return False
        else:
            res = self.left.compare_trees(node.left)
        if self.right is None:
            if node.right:
                return False
        else:
            res = self.right.compare_trees(node.right)
        return res
'''           

'''
    def tree_data(self):
        """
        Generator to get the tree nodes data
        """
        # we use a stack to traverse the tree in a non-recursive way
        stack = []
        node = self
        while stack or node: 
            if node:
                stack.append(node)
                node = node.left
            else: # we are returning so we pop the node and we yield it
                node = stack.pop()
                yield node.data
                node = node.right
'''

        
        
class TEfeatures:
    """index of TE annotations.
    """
    def __init__ (self, opt=None, filename=""):
        self.__srcfile = filename
        self.opt = opt

       # self.build()
        self.__binsize = 100
        
        self.indexlist = {}
    
    def getFamilyID(self,chr,start,end):
        binID = start/self.__binsize
        endbinID = end/self.__binsize + 1
       
        if self.indexlist.has_key(chr) :
            index = self.indexlist[chr]
            node = index.lookup(binID,index.root,None)
            if node is None :
                return "None"
            if node.overlaps(binID,endbinID) :
                return node.getName()
            else :
                return "None"
        else :

            return "None"
    
    def build (self,filename):
            self.__srcfile = filename
         #   print("build te index....")
            try:
                f = open(self.__srcfile,'r')
            except:
                logging.error("cannot open such file %s !\n" %(s))
                sys.exit(1)
            
            for line in f :
                line = line.strip()
                items = line.split('\t')
                chr = items[0]
                start = int(items[3])
                end = int(items[4])
                items[8] = items[8].replace("; ",";")
                desc = items[8].split(';')
                name = ""
                family_id = ""
                ele_id = ""
                class_id = ""
                
                
                for i in range(len(desc)) :
                    desc[i] = desc[i].replace("\"","")
                    pos = desc[i].find(" ")
                    id = desc[i][:pos]
                    val = desc[i][pos+1:len(desc[i])]
                    #print(id)
                    if id == "ele_id" :
                        ele_id = val
                    if id == "transcript_id" :
                        name = val
                    if id == "family_id" :
                        family_id = val
                    if id == "calss_id" :
                        calss_id = val
                        
                bin_startID = start/self.__binsize -1
                if bin_startID == -1 :
                    bin_startID = 0
                bin_endID = end/self.__binsize +1
               
               
                if self.indexlist.has_key(chr) :
                
                    index = self.indexlist[chr]
                    index.insert(bin_startID, bin_endID, family_id)
                    
                else :
                
                    index = BinaryTree()
                    index.insert(bin_startID, bin_endID, family_id)
                    self.indexlist[chr] = index
            #    print(self.indexlist["chr10"].size)
            
            f.close()
                    
 
def main():
     
     a = [1,3,4,6,7,8,10,11,13,14]
     
     bt = BinaryTree()
     
     for i in range(len(a)) :
        # j = len(a) - i -1
    #     print(str(a[j]))
        # bt.insert(a[j], a[j], str(a[j]))
         bt.insert(a[i], a[i], str(a[i]))
     #    print(bt.root.getStart())
       #  print(bt.root.balanceFactor)
         
     bt.print_tree(bt.root)
     node  = bt.lookup(12, bt.root,None)
     if node != None :
         print(node.getStart())     
 
if __name__ == '__main__':
    try:
       
        main()
       
    except KeyboardInterrupt:
        sys.stderr.write("User interrupt !\n")
        sys.exit(0)      
