from setuptools import setup

def readme():
    with open('README') as f:
        return f.read()

setup(name='TEToolkit',
      version='1.2.3',
      description='Tools for estimating differential enrichment of Transposable Elements or other highly repetetive regions',
      long_description=readme(),
      classifiers=[
      ],
      keywords='TE transposable element differential enrichment',
      url='http://hammelllab.labsites.cshl.edu/',
      author='Ying Jin, Eric Paniagua, Oliver Tam and Molly Hammell',
      author_email='yjin@cshl.edu',
      license='GPLv3',
      packages=[
          'TEToolkit',
          'TEToolkit.IO',
          'TEToolkit.ShortRead'
      ],
      install_requires=[
          'argparse',
      ],
      include_package_data=True,
      zip_safe=False,
      scripts=[
          'bin/TEtranscripts',
          'bin/TEpeaks'
      ]
)
