#!python

import sys
import os.path
import unittest

tempest_path = os.path.abspath(os.path.dirname(__file__)) + '/../src/'
sys.path.insert(1, tempest_path)
from Tempest import Tempest

class APITest(unittest.TestCase):
    
    def testConstructor(self):
        self.assertTrue( Tempest.__dict__.has_key('__init__') )
    
    def testRender(self):
        self.assertTrue( Tempest.__dict__.has_key('render') )
    
    def testVersions(self):
        self.assertTrue( Tempest.__dict__.has_key('version') )
        self.assertTrue( Tempest.__dict__.has_key('api_version') )
    
    def testGettersAndSetters(self):
        props = [
            'input_file',
            'output_file',
            'coordinates',
            'plot_file',
            'color_file',
            'overlay',
            'opacity',
            'image_lib',
        ]
        
        for propname in props:
            self.assertTrue( Tempest.__dict__.has_key('get_' + propname), propname + ' getter' )
            self.assertTrue( Tempest.__dict__.has_key('set_' + propname), propname + ' setter' )
    
    def testConstants(self):
        consts = {
            'LIB_PIL' : {'name':'Image'},
        }
        
        for constname, constval in consts.iteritems():
            self.assertTrue( Tempest.__dict__.has_key(constname), constname + ' constant' )
            self.assertEqual( constval, Tempest.__dict__[constname], constname + ' constant value' )

if __name__ == '__main__':
    unittest.main()
