#!python

import sys
import os.path
import re
import subprocess
import unittest

current_path = os.path.abspath(os.path.dirname(__file__))
tempest_path = current_path + '/../src/'
sys.path.insert(1, tempest_path)
from Tempest import Tempest

class LoadTest(unittest.TestCase):
    def setUp(self):
        if os.path.isfile(current_path + '/data/output_pil.png'):
            os.remove(current_path + '/data/output_pil.png')
    
    def testRender(self):
        instance = Tempest(
            input_file=current_path + '/data/screenshot.png',
            output_file=current_path + '/data/output_pil.png',
            coordinates=(
                (205,196),
                (208,205),
                (211,198),
                (218,205),
                (208,205),
                (208,205),
                (208,205),
                (388,201),
                (298,226),
                (369,231),
                (343,225),
                (345,14),
                (345,14),
            ),
            image_lib=Tempest.LIB_PIL,
            overlay=True
        )
        return_val = instance.render()
        self.assertTrue(return_val, 'Render method should return true')
        
        self.assertTrue( os.path.isfile(current_path + '/data/output_pil.png'), 'Output file should exist' )
        
        return_val = self._compare(10, current_path + '/data/output_pil.png')
        
        if None == return_val:
            print "Skipping image comparison"
            #@unittest.skipIf(None == return_val, 'ImageMagick compare utility not available')
        else:
            self.assertEqual( "0\n", return_val, 'Output image should resemble the image we expect' )
    
    def testOpacityFrequency(self):
        a_test = Tempest(
            input_file=current_path + '/data/screenshot.png',
            output_file=current_path + '/data/opacity_pil_a.png',
            coordinates=(
                (100,100),
                (200,200), (200,200),
                (300,300), (300,300), (300,300),
            ),
            image_lib=Tempest.LIB_PIL
        )
        a_test.render()
        
        self.assertTrue( os.path.isfile(current_path + '/data/opacity_pil_a.png'), 'Output file for "a" test should exist' )
        
        b_test = Tempest(
            input_file=current_path + '/data/screenshot.png',
            output_file=current_path + '/data/opacity_pil_b.png',
            coordinates=(
                (100,100), (100,100),
                (200,200), (200,200), (200,200),
                (300,300), (300,300), (300,300), (300,300),
            ),
            image_lib=Tempest.LIB_PIL
        )
        b_test.render()
        
        self.assertTrue( os.path.isfile(current_path + '/data/opacity_pil_b.png'), 'Output file for "b" test should exist' )
        
        return_val = self._compare(20, current_path + '/data/opacity_pil_a.png', current_path + '/data/opacity_pil_b.png')
        
        if None == return_val:
            print "Skipping image comparison"
            #@unittest.skipIf(None == return_val, 'ImageMagick compare utility not available')
        else:
            self.assertEqual( "0\n", return_val, 'Output images should be mostly identical' )
    
    def _compare(self, fuzz, compare_file, baseline_file=None):
        if None == baseline_file:
            baseline_file = current_path + '/data/compare.png'
        
        if not os.path.isfile(current_path + '/data/diff.png'):
            open(current_path + '/data/diff.png', 'w').close()
        
        try:
            cmp_proc = subprocess.Popen(args=['compare','-version'], stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
            output = cmp_proc.stdout.readline()
        except Exception:
            output = None
        
        if None == output or None == re.search('Version\:\s*ImageMagick', output):
            return None
        
        cmp_proc = subprocess.Popen(args=[
                'compare', '-metric', 'ae','-fuzz', '%s%%' % fuzz,
                os.path.abspath(compare_file),
                os.path.abspath(baseline_file),
                os.path.abspath(current_path + '/data/diff.png'),
            ], stderr=subprocess.PIPE)
        
        return cmp_proc.stderr.readline()
        

if __name__ == '__main__':
    unittest.main()
