#!python

import sys
import os.path
import unittest

current_path = os.path.abspath(os.path.dirname(__file__))
tempest_path = current_path + '/../src/'
sys.path.insert(1, tempest_path)
from Tempest import Tempest

class InstantiationTest(unittest.TestCase):
    
    def testInstantiate(self):
        instance = Tempest(
            input_file=current_path + '/data/screenshot.png',
            output_file=current_path + '/data/output_pil.png',
            coordinates=( (0,0), )
        )
        
        self.assertEqual( instance.__class__, Tempest )
        
        for method_name, method_args in {'version':[], 'api_version':[], 'has_image_lib':[Tempest.LIB_PIL]}.items():
            static_result = Tempest.__dict__[method_name](*method_args)
            member_result = getattr(instance, method_name)(*method_args)
            
            self.assertEqual(static_result, member_result)

if __name__ == '__main__':
    unittest.main()
