#!/usr/bin/env python

from distutils.core import setup
from sys import version

# patch distutils if it can't cope with the "classifiers"
if version < '2.2.3':
    from distutils.dist import DistributionMetadata
    DistributionMetadata.classifiers = None
    DistributionMetadata.download_url = None

setup(name='Tempest',
      version='2009.07.16a',
      description='Flexible temperature-map/heat-map generator',
      long_description='A consistent, reliable API for generating heat-map images based on coordinate data-sets.  Tempest is implemented natively in multiple programming languages, including Python 2',
      author='Evan Kaufman',
      author_email='evan@digitalflophouse.com',
      url='http://code.google.com/p/image-tempest/',
      classifiers=[
        'Development Status :: 3 - Alpha',
        'License :: OSI Approved :: MIT License',
        'Natural Language :: English',
        'Operating System :: OS Independent',
        'Programming Language :: Python :: 2',
        ],
      packages=['Tempest'],
      package_dir={'Tempest': 'src/Tempest'},
     )
