
###
### auto generated by ../doc/Kookbook.py
###

import sys, os, re
from glob import glob
from oktest import ok, run

class ExamplesTest(object):

    DIR = os.path.dirname(os.path.abspath(__file__)) + '/data/examples'
    CWD = os.getcwd()

    def before(self):
        sys.stdout.write('\n** test_%s: (' % self.__name__)
        os.chdir(self.DIR + '/' + self.__name__)
        for x in glob('views/*.cache'):
            os.unlink(x)

    def after(self):
        os.chdir(self.CWD)

    def _test(self):
        for fname in glob('*.result'):
            sys.stdout.write(' %s' % fname)
            result = open(fname).read()
            command, expected = re.split(r'\n', result, 1)
            command = re.sub('^\$ ', '', command)
            actual = os.popen(command).read()
            ok (actual) == expected
        sys.stdout.write(' )')

    def test_form(self):
        self._test()

    def test_preprocessing(self):
        self._test()

    def test_table(self):
        self._test()

if __name__ == '__main__':
    run(ExamplesTest)
