
###
### auto generated by ../doc/Kookbook.py
###

import sys, os, re
from glob import glob
from oktest import ok, run

class UsersGuideTest(object):

    DIR = os.path.dirname(os.path.abspath(__file__)) + '/data/users_guide'
    CWD = os.getcwd()

    def before(self):
        sys.stdout.write('\n** test_%s: (' % self.__name__)
        os.chdir(self.DIR + '/test_' + self.__name__)
        for x in glob('*.cache') + glob('views/*.cache'):
            os.unlink(x)
        if self.__name__ == 'flexibleindent':
            for parent_dir in ['..', '../..', '../../..']:
                fname = parent_dir + '/my_template.py'
                if os.path.isfile(fname):
                    import shutil
                    shutil.copy(fname, 'my_template.py')
                    break

    def after(self):
        os.chdir(self.CWD)

    def _test(self):
        for fname in glob('result*.output'):
            sys.stdout.write(' %s' % fname)
            result = open(fname).read()
            command, expected = re.split(r'\n', result, 1)
            command = re.sub('^\$ ', '', command)
            if self.__name__ == 'logging':
                sin, sout, serr = os.popen3(command)
                sin.close()
                actual = sout.read() + serr.read()
                sout.close()
                serr.close()
                actual = re.sub(r'file=.*?/test_logging/', "file='/home/user/", actual)
            else:
                actual = os.popen(command).read()
            ok (actual) == expected
        sys.stdout.write(' )')

    def test_010(self):
        self._test()

    def test_011(self):
        self._test()

    def test_020(self):
        self._test()

    def test_021(self):
        self._test()

    def test_030(self):
        self._test()

    def test_040(self):
        self._test()

    def test_050(self):
        self._test()

    def test_051(self):
        self._test()

    def test_060(self):
        self._test()

    def test_070(self):
        self._test()

    def test_capturing(self):
        self._test()

    def test_context(self):
        self._test()

    def test_convert(self):
        self._test()

    def test_escape(self):
        self._test()

    def test_execute(self):
        self._test()

    def test_flexibleindent(self):
        self._test()

    def test_fragmentcache(self):
        self._test()

    def test_logging(self):
        self._test()

    def test_m18n(self):
        self._test()

    def test_nested(self):
        self._test()

    def test_preprocessing(self):
        self._test()

    def test_retrieve(self):
        self._test()

    def test_syntax_check(self):
        self._test()

    def test_syntaxerr(self):
        self._test()

if __name__ == '__main__':
    run(UsersGuideTest)
