
###
### auto generated by ../doc/Kookbook.py
###

import sys, os, re
from glob import glob
from oktest import ok, run

python3 = sys.version_info[0] == 3
PYPY    = hasattr(sys, 'pypy_version_info')
JYTHON  = hasattr(sys, 'JYTHON_JAR')

try:    # Python 2.6 or later
    from subprocess import Popen, PIPE
    def _popen3(command):
        p = Popen(command, shell=True, close_fds=True,
                  stdin=PIPE, stdout=PIPE, stderr=PIPE)
        t = (p.stdin, p.stdout, p.stderr)
        return (p.stdin, p.stdout, p.stderr)
except ImportError:
    def _popen3(command):
        return os.popen3(command)


class UsersGuideTest(object):

    DIR = os.path.dirname(os.path.abspath(__file__)) + '/data/users_guide'
    CWD = os.getcwd()

    def before(self):
        #sys.stdout.write('\n** test_%s: (' % self.__name__)
        sys.stdout.write(' (')
        os.chdir(self.DIR + '/test_' + self.__name__)
        for x in glob('*.cache') + glob('views/*.cache'):
            os.unlink(x)
        if self.__name__ == 'flexibleindent':
            for parent_dir in ['..', '../..', '../../..']:
                fname = parent_dir + '/my_template.py'
                if os.path.isfile(fname):
                    import shutil
                    shutil.copy(fname, 'my_template.py')
                    break
        if PYPY:
            if self.__name__ == 'syntaxerr':
                s = (
                    "$ pytenjin -z syntaxerr.pyhtml\n"
                    "syntaxerr.pyhtml:5:8: invalid syntax\n"
                    "  5:         else\n"
                    "            ^\n"
                    )
                f = open('result.output', 'w'); f.write(s); f.close()
                del s

    def after(self):
        os.chdir(self.CWD)

    def _test(self):
        result_files = glob('result*.output')
        for fname in result_files:
            sys.stdout.write(' %s' % fname)
            result = open(fname).read()
            command, expected = re.split(r'\n', result, 1)
            command = re.sub('^\$ ', '', command)
            if self.__name__ == 'logging':
                sin, sout, serr = _popen3(command)
                sin.close()
                actual = sout.read() + serr.read()
                sout.close()
                serr.close()
                if python3:
                    actual = actual.decode('utf-8')
                actual = re.sub(r'file=.*?/test_logging/', "file='/home/user/", actual)
            else:
                actual = os.popen(command).read()
                if self.__name__ == 'm17n':
                    expected = re.sub(r'timestamp: \d+(\.\d+)?', 'timestamp: 0.0', expected)
                    actual   = re.sub(r'timestamp: \d+(\.\d+)?', 'timestamp: 0.0', actual)
            if self._testMethodName == 'test_nested':
                expected = re.sub(r'[ \t]*\#.*', '', expected)
            ok (actual) == expected
        if not result_files:
            fname = glob('*main*.py')[0]
            command = sys.executable + " " + fname
            actual = os.popen(command).read()
            fname = glob('*.expected')[0]
            f = open(fname); expected = f.read(); f.close()
            ok (actual) == expected
        sys.stdout.write(' )')

    def test_010(self):
        self._test()

    def test_011(self):
        self._test()

    def test_020(self):
        self._test()

    def test_021(self):
        self._test()

    def test_030(self):
        self._test()

    def test_040(self):
        self._test()

    def test_050(self):
        self._test()

    def test_051(self):
        self._test()

    def test_060(self):
        self._test()

    def test_070(self):
        self._test()

    def test_capturing(self):
        self._test()

    def test_context(self):
        self._test()

    def test_convert(self):
        self._test()

    def test_escape(self):
        self._test()

    def test_execute(self):
        self._test()

    def test_fragmentcache(self):
        self._test()

    def test_logging(self):
        self._test()

    def test_m17n(self):
        self._test()

    def test_nested(self):
        self._test()

    def test_pp(self):
        self._test()

    def test_pp_javascript(self):
        self._test()

    def test_pp_prefixed(self):
        self._test()

    def test_pp_trim(self):
        self._test()

    def test_preprocessing(self):
        self._test()

    def test_retrieve(self):
        self._test()

    def test_safe(self):
        self._test()

    def test_syntax_check(self):
        self._test()

    def test_syntaxerr(self):
        self._test()

    def test_trace(self):
        self._test()

if __name__ == '__main__':
    run()
