import sacontext
import elixir

context = None

class ElixirStrategy(sacontext.ContextualStrategy):

    def create_session(self, context):
        return elixir.objectstore.session

    def create_metadata(self, key, context):
        elixir.metadata.connect(context.get_engine(key))
        return elixir.metadata

    def get_connectable(self, key, context):
        return context.get_engine(key)

def connect():
    """
    Connects engine 
    """
    global context
    context = sacontext.PylonsSAContext(strategy=ElixirStrategy())
    elixir.setup_all()

def resync():
    """
    Renews SQLAlchemy session with current thread
    """
    context.session.clear()

def flush_all():
    """
    Flushes all changes to database
    """
    elixir.objectstore.flush()

def execute(query):
    """
    Executes an SQL query string
    """
    return context.engine.text(query).execute()

def create_all(*args, **kw):
    """
    Shortcut for metadata.create_all()
    """
    context.metadata.create_all(*args, **kw)

def drop_all(*args, **kw):
    """
    Shortcut for metadata.drop_all()
    """
    context.metadata.drop_all(*args, **kw)

def get_context():
    return context

# Uncomment these lines if you want to use the "autoload" option with your Elixir models
#if not metadata.is_bound():
#    elixir.delay_setup = True

