from authxpprojectname.lib.auth import get_user
from authxpprojectname import model
import pylons
import types

# Common permissions. Permission classes must have a 'check' method which returns True or False.

class SignedIn(object):

    def check(self):
        return (get_user() is not None)

class InGroup(object):

    def __init__(self, group_name):
        self.group_name = group_name 

    def check(self):
        group = model.Group.get_by(name = self.group_name, active = True)
        if group and get_user() in group.members:
            return True
        return False

class HasPermission(object):

    def __init__(self, permission, obj=None):
        "obj may be string or actual object. If string, object retrieved from Context"
        self.permission = permission
        self.obj = obj

    def check(self):
        user = get_user()
        if type(self.obj) is types.StringType:
            c = pylons.c._current_obj()
            obj = getattr(c, self.obj, None)
        else:
            obj = self.obj
        if user and user.has_permission(self.permission, obj):
            return True
        return False