import unittest
from threadqueue import ThreadQueue
from time import sleep
import logging

logging.getLogger().setLevel(logging.ERROR)


class QueueTests(unittest.TestCase):

    def method(self, d, seconds=0):
        """Method used to test the invocation of a long running thread."""
        sleep(seconds)
        self.total += d

    def testOneThread(self):
        """Run one single thread and check if it ran."""
        if True:
            return
        self.total = 0
        tq = ThreadQueue(1) # Limit to only 1 thread
        tq.enqueue(self.method, 5, 0.1)
        self.assertEqual(self.total, 0) # No functions are finished yet
        tq.join()
        self.assertEqual(self.total, 5) # The function must be finished now

    def testFourThreads(self):
        """
        Run four threads, only two at a time. Check the result after the first 2 finished and after they all finished.
        """
        self.total = 0
        tq = ThreadQueue(2) # Limit to only 2 threads
        tq.enqueue(self.method, 0x1)
        tq.enqueue(self.method, 0x2)
        tq.join()
        self.assertEqual(self.total, 0x3) # First two functions must be finished by now
        tq.enqueue(self.method, 0x4)
        tq.enqueue(self.method, 0x8)
        tq.join()
        self.assertEqual(self.total, 0xF) # All functions must be finished by now

    def testManyThreads(self):
        """Run 1000 invocations of self.method using a thread queue with 10 active threads. Tests if all invocations did
        run.
        """
        self.total = 0
        tq = ThreadQueue(10)
        to_sum = range(0, 1000)
        for i in to_sum:
            tq.enqueue(self.method, i)
        tq.join()
        self.assertEqual(self.total, sum(to_sum)) # All invocations must have finished running

    def testManyThreadsLimited(self):
        """Run 10000 invocations of self.method using a thread queue with 31 active threads. Tests if the limit remains
        31 workers.
        """
        self.total = 0
        tq = ThreadQueue(31)
        to_sum = range(0, 10000)
        for i in to_sum:
            tq.enqueue(self.method, i, 0.001)
            self.assertLessEqual(len(tq.threads), 31)
        tq.join()

    def testJoinNone(self):
        """Tests a join when no threads have been started"""
        tq = ThreadQueue(11)
        tq.join()
        self.assertEquals(len(tq.threads), 0)


def main():
    unittest.main()

if __name__ == '__main__':
    main()