quantity_qualifier = {
    "01": "Discrete Quantity",
    "02": "Cumulative Quantity",
    "03": "Discreet Quantity - Rejected Material",
    "04": "Discrete Quantity - Rejected Material: Disposition Replacement",
    "05": "Discrete Quantity - Rejected Material: Disposition Credit",
    "06": "Discrete Quantity - Rejected Material: Disposition Pending",
    "07": "Cumulative Quantity - Rejected Material",
    "08": "Cumulative Quantity - Rejected Material: Disposition Replacement",
    "09": "Cumulative Quantity - Rejected Material: Disposition Credit",
    "10": "Cumulative Quantity - Rejected Material: Disposition Pending",
    "11": "Split Quantity",
    "12": "Ship Notice Quantity",
    "13": "Collateral Requirements",
    "14": "Quantity in Float",
    "15": "Quantity in Hold Out",
    "16": "Line Thread Quantity",
    "17": "Quantity on Hand",
    "18": "Previous Week Quantity",
    "19": "Unverified Receipts",
    "1A": "Original Duration (in calendar units)",
    "1B": "Current Duration (in calendar units)",
    "1C": "Remaining Duration (in calendar units)",
    "1D": "Total Float (in calendar units)",
    "1E": "Free Float (in calendar units)",
    "1F": "Lag (as in Lag Time - in calendar units)",
    "1G": "Lead Time (in calendar units)",
    "1H": "Started",
    "1I": "Completed",
    "1J": "Due",
    "1K": "Time Units",
    "1L": "Shifts",
    "1M": "Time units per shift",
    "1N": "Scrap allowed",
    "1O": "Calendar Units",
    "1P": "Resource (Quantity) available",
    "1Q": "Total Resource (Quantity)",
    "1R": "Level Resource (Quantity)",
    "1S": "Late",
    "1T": "Number of Delinquent Installments",
    "1U": "Number of Loans",
    "1V": "Total Number of Mortgagees",
    "1W": "Total Number of Loan Detail Records",
    "1X": "Prescription Effective Period",
    "1Y": "Rate Per Day (RPD)",
    "1Z": "End Of Month Inventory Prior To Ship",
    "20": "Unusable Quantity",
    "21": "Cumulative Quantity Shipped Short - Disposition Pending",
    "22": "Cumulative Quantity Shipped Short - Disposition Challenged",
    "23": "Cumulative Quantity Shipped Long - Disposition Pending",
    "24": "Cumulative Quantity Shipped Long - Disposition Challenged",
    "25": "OEM Inventory",
    "26": "Total Inventory",
    "27": "Committed Quantity",
    "28": "Quantity Available for Return",
    "29": "Projected Available Inventory",
    "2A": "Commitment Period",
    "2B": "Number of Borrowers",
    "2C": "Number of Adjustment Periods",
    "2D": "Age Nearest",
    "2E": "Total Other Properties Owned and Financed",
    "2F": "Age Next",
    "2G": "Reconsideration Period",
    "2H": "Flat Extra Premium",
    "2I": "CO2 Injection Volume",
    "2J": "Accounts Placed for Collection",
    "2K": "Changes",
    "2L": "Companies in Same Activity for a Period",
    "2M": "Comparison Period",
    "2N": "Departments",
    "2O": "Employees Shared",
    "2P": "Estimated Accounts",
    "2Q": "Installed Capacity",
    "2R": "Levels Occupied",
    "2S": "Registered Brands Distributed",
    "2T": "Electronic Signatures",
    "2U": "Bytes",
    "2V": "Employed at this Location",
    "2W": "Segments",
    "2X": "Registered Brands Manufactured",
    "2Y": "Functional Groups",
    "2Z": "Transaction Sets",
    "30": "Quote Quantity on Inventory",
    "31": "Additional Demand Quantity",
    "32": "Quantity Sold",
    "33": "Quantity Available for Sale (stock quantity)",
    "34": "Noncommitted Inventory on Shelf",
    "35": "Inventory on Shelf + Work in Progress",
    "36": "Distributor Inventory",
    "37": "Work In Process",
    "38": "Original Quantity",
    "39": "Shipped Quantity",
    "3A": "Total Credits Accepted",
    "3B": "Total Credits Rejected",
    "3C": "Total Debits Accepted",
    "3D": "Total Debits Rejected",
    "3E": "Total Payments Rejected",
    "3F": "Total Pre-advices Accepted",
    "3G": "Total Pre-advices Rejected",
    "3H": "Total Prenotes Accepted",
    "3I": "Total Prenotes Rejected",
    "3J": "Total Post-advices Accepted",
    "3K": "Total Post-advices Rejected",
    "3L": "Total Unidentified Transactions Rejected",
    "3M": "Total Credits Received",
    "3N": "Total Debits Received",
    "3P": "Total Pre-advices Received",
    "3Q": "Total Prenotes Received",
    "3R": "Total Post-advices Received",
    "3S": "Total Debits",
    "3T": "Total Credits",
    "3U": "Total Transactions",
    "3V": "Minimum Transfer",
    "3W": "Maximum Transfer",
    "3X": "Speed Capacity",
    "3Y": "Subcontractors",
    "40": "Remaining Quantity",
    "41": "Number of Batches",
    "42": "Number of Checks",
    "43": "Talk Paths",
    "45": "Cumulative quantity on order",
    "46": "Total transactions",
    "47": "Primary Net Quantity",
    "48": "Secondary Net Quantity",
    "49": "Number of Signed Bills of Lading",
    "4A": "Accounts",
    "4B": "Agents",
    "4C": "Authorized Shares",
    "4D": "Clerks",
    "4E": "Design Employees",
    "4F": "Foreign Related Entities",
    "4G": "Group Employees",
    "4H": "Issued Shares",
    "4I": "Laborers",
    "4J": "Other Employee Type",
    "4K": "Part Time Employees",
    "4L": "Related Entities",
    "4M": "Relatives Employed",
    "4N": "Salespersons",
    "4O": "Space Occupied",
    "4P": "Special Partners",
    "4Q": "Suppliers' Credit",
    "4R": "Technicians",
    "4S": "Trainees",
    "4T": "Warehouse Employees",
    "4U": "Shareholders",
    "50": "Number of Copies of Bill of Lading",
    "51": "Number of Unsigned Bills of Lading",
    "52": "Number of Originals",
    "53": "Original payment item count.",
    "54": "Bank reject item count.",
    "55": "Net to pay item count.",
    "56": "Minimum Contract Quantity",
    "57": "Minimum Order Quantity",
    "58": "Payment Cancellation Item Count",
    "5A": "Aggregate Benefit Period",
    "5B": "Anticipated Length of Service",
    "5C": "Approval/Offer Duration",
    "5D": "Benefit Amount",
    "5E": "Benefit Period",
    "5F": "Brothers Deceased",
    "5G": "Brothers Living",
    "5H": "Children",
    "5I": "Citations",
    "5J": "Claim Period",
    "5K": "Coverage",
    "5L": "Elimination Period",
    "5M": "Elimination Period - Accident",
    "5N": "Elimination Period - Sickness",
    "5O": "Employees - Nonowner",
    "5P": "Employees - Owner",
    "5Q": "Employees - Part Time",
    "5R": "Employees - Same Duties",
    "5S": "Employees - Same Occupation",
    "5T": "Expense",
    "5U": "Frequency",
    "5V": "General Elimination Period",
    "5W": "Guarantee Period",
    "5X": "Height",
    "5Y": "Hours Flown - Aircraft Type/Life",
    "5Z": "Hours Flown - Aircraft Type/Period",
    "60": "Total Authorized Quantity",
    "61": "Remaining Authorized Quantity",
    "62": "Number of Days Covered by Inventory",
    "63": "On Order Quantity",
    "64": "Past Due Quantity",
    "65": "Previous Month's Usage",
    "66": "Minimum Fabrication Quantity",
    "67": "Minimum Ship Quantity",
    "68": "Maximum Number of Shipments Allowed",
    "69": "Incremental Order Quantity",
    "6A": "Hours Flown - Aircraft/Type Flying",
    "6B": "Hours Flown - Lifetime",
    "6C": "Hours Flown - Type Flying",
    "6D": "Impairment Duration",
    "6E": "Impairment Frequency",
    "6F": "Installment Frequency",
    "6G": "Installments",
    "6H": "Intended Change Time Period",
    "6I": "Interim Term Period",
    "6J": "Involvement Period",
    "6K": "Loan Rate",
    "6L": "Maximum Age",
    "6M": "Maximum Benefit Period - Accident",
    "6N": "Maximum Benefit Period - Sickness",
    "6O": "Maximum Benefit Period",
    "6P": "Medication Duration",
    "6Q": "Minimum Age",
    "6R": "Own Occupation Qualification Period",
    "6S": "Owner's Equity",
    "6T": "Ownership Change Age",
    "6U": "Ownership Duration",
    "6V": "Ownership Percentage",
    "6W": "Payment Frequency",
    "6X": "Payments Number",
    "6Z": "Placement Period Expiration",
    "70": "Maximum Order Quantity",
    "72": "Minimum Stock Level",
    "73": "Maximum Stock Level",
    "74": "Damaged Goods",
    "75": "Receipts",
    "76": "Returns",
    "77": "Stock Transfers In",
    "78": "Stock Transfers Out",
    "79": "Billing Unit(s) Per Pricing Unit",
    "7A": "Previous Benefits",
    "7B": "Qualification Period",
    "7C": "Range Average",
    "7D": "Range Maximum",
    "7E": "Range Minimum",
    "7F": "Relationship Duration",
    "7G": "Replaced Amount",
    "7H": "Residence Duration",
    "7I": "Sisters Deceased",
    "7J": "Sisters Living",
    "7K": "Time Frame",
    "7L": "Time in Country",
    "7M": "Time Since Hospitalization",
    "7N": "Time Since Last Application",
    "7O": "Time Since Last Civilian Flight",
    "7P": "Time Since Last Insurance Medical",
    "7Q": "Time Since Last Military Flight",
    "7R": "Time Since Medical Consult",
    "7S": "Time Since Medication End",
    "7T": "Time Since Medication Start",
    "7U": "Time Since Onset",
    "7V": "Time Since Surgery",
    "7W": "Time Since Trip",
    "7X": "Travel Frequency",
    "7Y": "Travel Period",
    "7Z": "Trip Duration",
    "80": "Pricing Unit(s) Per Billing Unit",
    "81": "Prepaid Quantity Shipped",
    "82": "Prepaid Quantity Not Shipped",
    "83": "Submitted Quantity Sold",
    "84": "Submitted Quantity Returned",
    "85": "Lot Size",
    "86": "Nonconformance Quantity",
    "87": "Quantity Received",
    "88": "Beds",
    "89": "Operating Beds",
    "8A": "Visitation Frequency",
    "8B": "Weight",
    "8C": "Weight Change Period",
    "8D": "Work Period",
    "90": "Acknowledged Quantity",
    "91": "Additional Usage Quantity",
    "92": "Allotted Usage Quantity",
    "93": "Attendant-Handled Quantity",
    "94": "Billable Quantity",
    "95": "Data Storage Quantity",
    "96": "Non-Billable Quantity",
    "97": "Non-Urgent Delivery Quantity",
    "98": "Overflow Quantity",
    "99": "Quantity Used",
    "9A": "Time Expended",
    "9C": "Primary Meter Reading Value",
    "9D": "Engineered Standard",
    "9E": "Active Maintenance Time",
    "9F": "Actual Duration",
    "9H": "Estimated Duration",
    "9J": "Gross Estimate",
    "9K": "Finish Offset",
    "9L": "Start Offset",
    "9M": "Picture Count",
    "9N": "Component Meter Reading Count",
    "A1": "Acceptable Unserviceable Quantity",
    "A2": "Optimistic Duration",
    "A3": "Most Likely Duration",
    "A4": "Pessimistic Duration",
    "A5": "Adjusted Quantity",
    "A6": "Accidents",
    "A7": "Years in School",
    "A8": "Number of Dependents",
    "A9": "Years on Job",
    "AA": "Unacknowledged Quantity",
    "AAA": "Quantity Earned",
    "AAB": "Quantity Carried Forward",
    "AB": "Urgent Delivery Quantity",
    "AC": "Voice Storage Quantity",
    "ACA": "Existence Limit Period",
    "ACB": "Shares",
    "ACC": "Directors",
    "ACD": "Minimum",
    "ACE": "Voting Shares Held",
    "ACF": "Outstanding Shares",
    "ACG": "Shares Held as Treasury Stock",
    "ACH": "Shares Subscribed but Not Issued",
    "ACI": "Total Shares of Stock",
    "ACJ": "Shares Owned by Out-of-State Residents",
    "ACK": "Shares Owned by In-State Residents",
    "ACL": "Land Holding",
    "ACM": "Shares Subscribed",
    "ACN": "Non-Domestic Stockholders",
    "ACO": "Partners",
    "AD": "Maintenance Units",
    "AE": "Minimum Average Time Requirement (MATR) Units",
    "AF": "Wide Area Telephone Service (WATS)/800 Service Units",
    "AG": "Number of End Users",
    "AH": "Number of Message Recipients",
    "AI": "Number of Operator Credits",
    "AJ": "Daily Adjustments",
    "AK": "Years in this Line of Work/Profession",
    "AL": "Area per Units",
    "AN": "Age at Death",
    "AO": "Verified Receipts",
    "AP": "Order Quantity Multiple",
    "AQ": "Contribution Total",
    "AR": "Loan Repayment Total",
    "AS": "Participant Total",
    "AT": "Actual",
    "AU": "Cumulative Actual",
    "AV": "Budget",
    "AW": "Cumulative Budget",
    "AX": "Number of Insured Lives",
    "AY": "Forecast",
    "AZ": "Forecast at Complete",
    "B1": "Number of Mortgagors",
    "B2": "Mortgage Pool Count",
    "B3": "Requested Amount",
    "B4": "Approved Amount",
    "B5": "Additional Amount",
    "B6": "Pre-op Days",
    "B7": "Post-op Days",
    "B8": "Average",
    "BA": "Due-In",
    "BB": "Contractor Cumulative to Date",
    "BC": "Budget At Complete",
    "BD": "Contractor at Complete",
    "BE": "Subcontractor Cumulative to Date",
    "BF": "Age Modifying Units",
    "BG": "Subcontractor at Complete",
    "BH": "Book Order Quantity",
    "BI": "Book Inventory",
    "BJ": "Bedroom Count",
    "BK": "Bathroom Count",
    "BQ": "Backorder Quantity",
    "BR": "Blood Record",
    "BW": "Birth Weight",
    "C0": "Creditors",
    "CA": "Covered - Actual",
    "CB": "Closing Statement Balance",
    "CC": "Current Days on Market",
    "CD": "Co-insured - Actual",
    "CE": "Covered - Estimated",
    "CF": "Co-insured - Estimated",
    "CG": "Cumulative Gas Volume",
    "CH": "Cumulative Effect of Prior Period Adjustment",
    "CI": "Cumulative Gas Injection Volume",
    "CL": "Cumulative Liquid Injection Volume",
    "CN": "Continuance Duration",
    "CO": "Cumulative Oil/Condensate Volume",
    "CP": "Current Period Imbalance",
    "CR": "Certified Registered Nurse Anesthetist (CRNA) Number of "
            "Concurrent Procedures",
    "CS": "Current Service Life",
    "CW": "Cumulative Water Volume",
    "CY": "Convictions Sent",
    "CZ": "Total Number of Convictions",
    "D1": "Billed",
    "D3": "Number of Co-insurance Days",
    "DA": "Dependent's Age",
    "DB": "Deductible Blood Units",
    "DC": "Dependent Count",
    "DD": "Distributed",
    "DE": "Debited",
    "DF": "Deleted",
    "DG": "Gas Used for Drilling",
    "DI": "Disposed",
    "DN": "Default Notification Response Period",
    "DO": "Days Operated",
    "DP": "Days Produced",
    "DR": "Direct Workers",
    "DS": "Dose",
    "DT": "Dependent Total",
    "DY": "Days",
    "E1": "Course Segments",
    "E2": "Degree Segments",
    "E3": "Employed on this job",
    "E4": "Employed in this Profession",
    "E5": "Employed by this Company",
    "EA": "Exclusive Uses",
    "EB": "Nonexclusive Uses",
    "EC": "Use of Extracorporeal Circulation",
    "ED": "Domestic Uses",
    "EE": "Small Business Uses",
    "EM": "Emergency Modifying Units",
    "EP": "Product Exchange Amount",
    "EQ": "Equity Security Holder",
    "ER": "Estimated Remaining Economic Life",
    "ES": "Ending Stock",
    "ET": "Employee Total",
    "EW": "Evaporated Water",
    "F1": "Off Lease Fuel",
    "FA": "Full Baths",
    "FB": "Furnished Blood Units",
    "FC": "Fuel Consumed or Burned Amount",
    "FD": "Vehicular Radios",
    "FE": "Portable Radios",
    "FF": "Flare or Flash",
    "FG": "Marine Radios",
    "FH": "Pagers",
    "FI": "Conventional Mobiles",
    "FJ": "Trunked Channels",
    "FK": "Mobile Loading Allocation",
    "FL": "Units",
    "FM": "Aircraft Radios",
    "FR": "Units For Sale",
    "FS": "Gas Used for Fuel System",
    "FT": "Forecast to Complete",
    "GA": "Gross Building Area",
    "GB": "Gross Annual Income Multiplier",
    "GC": "Gross Living Area",
    "GE": "Original Term In Years",
    "GF": "Years Remaining",
    "GI": "Gas Injection Volume",
    "GL": "Gas Lift Volume",
    "GP": "Gross Production",
    "GQ": "Government Reporting Quantity",
    "GR": "Gas Receipt Volume",
    "GS": "Gas Sold",
    "GT": "Grade Transfer Amount",
    "GU": "Employee Total First Month of Quarter",
    "GV": "Gas Volume",
    "GW": "Employee Total Second Month of Quarter",
    "GX": "Employee Total Third Month of Quarter",
    "GZ": "Active Listings",
    "HA": "Market Price Change",
    "HB": "Unpaid",
    "HC": "Branches",
    "HD": "Subsidiaries",
    "HE": "Age of Financial Information",
    "HF": "Invoices",
    "HG": "Financial Coverage Period",
    "HH": "Maximum Number of Employees at Location",
    "HI": "Previous Number of Accounts",
    "HJ": "Collection Period",
    "HK": "Disbursement Period",
    "HL": "Seats",
    "HM": "Use of Hypothermia",
    "HN": "Previous Number of Employees",
    "HO": "Use of Hypotension",
    "HP": "Use of Hyperbaric Pressurization",
    "HR": "Use of Hypertension",
    "HS": "Hours",
    "II": "Number of Irregular Interest Payments",
    "IN": "Indirect Workers",
    "IP": "Number of Interest Payments",
    "IQ": "In-Transit Quantity",
    "IS": "Information Provider Standardized Motor Vehicle Penalty Points",
    "IT": "Intertank Transfer Amount",
    "JA": "Activity Codes",
    "JB": "Associates",
    "JC": "Average Employees",
    "JD": "Cooperative Shares",
    "JE": "Estimated Employees at Location",
    "JF": "Estimated Total Employees",
    "JG": "Financial Institutions",
    "JH": "Judgments",
    "JI": "Land Size",
    "JJ": "Liens",
    "JK": "Minimum Employees at Location",
    "JL": "Office Size",
    "JM": "Owner",
    "JN": "Plant Size",
    "JO": "Previous Number of Branches",
    "JP": "Protested Bills",
    "JQ": "Suits",
    "JR": "Uniform Commercial Code (UCC) Filings",
    "JS": "Judicial Stay Duration",
    "JT": "Warehouse Size",
    "K6": "Drafts",
    "KA": "Estimated",
    "KB": "Net Quantity Increase",
    "KC": "Net Quantity Decrease",
    "KD": "Expenditure Quantity",
    "KE": "Originals",
    "KF": "Duplicates",
    "KG": "Completed Line Items",
    "KH": "Completed Contracts",
    "KI": "Active Contracts Delinquent-Buying Party Caused",
    "KJ": "Active Contracts Delinquent",
    "KK": "Active Contracts Delinquent-Contractor Caused",
    "KL": "Active Contracts Delinquent-Unknown Causes",
    "KM": "Active Line Items Delinquent",
    "KN": "Active Line Items Delinquent-Buying Party Caused",
    "KO": "Active Line Items Delinquent-Contractor Caused",
    "KP": "Active Line Items Delinquent-Unknown Causes",
    "KQ": "Contracts Completed Delinquent-Buying Party Caused",
    "KR": "Contract Completed Delinquent-Contractor Caused",
    "KS": "Contracts Completed Delinquent-Unknown Causes",
    "KU": "Reported Deficiencies",
    "KV": "Line Items Completed Delinquent-Buying Party Caused",
    "KW": "Line Items Completed Delinquent-Contractor Caused",
    "KX": "Line Items Completed Delinquent-Unknown Causes",
    "KY": "Corrective Action Requests-Verbal",
    "KZ": "Corrective Action Requests-Written",
    "L2": "Guarantee Fee Buyup Maximum",
    "L3": "Contract Buyup",
    "L4": "Contract Buydown",
    "L5": "Guarantee Fee Rate after Alternate Payment Method",
    "L6": "Guarantee Fee Rate after Buyup or Buydown",
    "L7": "Buyup or Buydown Rate per Basis Point",
    "LA": "Life-time Reserve - Actual",
    "LB": "Loss Allowance",
    "LC": "Late Payment Period",
    "LE": "Life-time Reserve - Estimated",
    "LG": "Loss or Gain",
    "LH": "Lost Gas",
    "LI": "Liquid Injection Volume",
    "LK": "Corrective Action Requests-Method C",
    "LL": "Corrective Action Requests-Method D",
    "LM": "Corrective Action Requests-Method E",
    "LN": "Aged Active Line Items Delinquent-Contractor Caused",
    "LO": "Lost Oil",
    "LP": "Lease Periods",
    "LQ": "Aged Line Items Delinquent",
    "LR": "Aged Line Items Completed-Contractor Caused",
    "LS": "Oil Condensate Sold",
    "LT": "Tariff Loss Allowance",
    "LV": "Oil/Condensate Volume",
    "LW": "Lost Work Time Actual",
    "LX": "Lost Work Time Estimated",
    "LY": "Length of Residency",
    "M1": "Matching Equipment",
    "M2": "Maximum",
    "MA": "Miscellaneous Allowance",
    "MD": "Million Dollar Roundtable Credits",
    "ME": "Minimum Number of Employees",
    "MF": "Manufactured",
    "MI": "Miles",
    "MM": "Maximum Maturity Extension",
    "MN": "Month",
    "MO": "Minimum Order Package Level",
    "MQ": "Maximum Ship Quantity",
    "MX": "Maximum Number of Employees",
    "N1": "Number of Attacks or Occurences",
    "N2": "Number of Dead",
    "N3": "Number of Living",
    "N4": "Number of Times",
    "N5": "Minimum Forecast Quantity",
    "N6": "Maximum Forecast Quantity",
    "NA": "Number of Non-covered Days",
    "NB": "Number of Units (Housing)",
    "NC": "Number of Claimants",
    "ND": "Number of Late Charges",
    "NE": "Non-Covered - Estimated",
    "NF": "Number of Full-Time Employees",
    "NG": "Number of Nonsufficient Fund Items",
    "NL": "Number of Levels",
    "NN": "Number of Hospitals",
    "NO": "Number of Physicians",
    "NP": "Number of Members",
    "NQ": "Number of Franchisees",
    "NR": "Not Replaced Blood Units",
    "NS": "Number of Stations",
    "NT": "Reports",
    "NU": "Last Travel",
    "NV": "Net",
    "NW": "Next Travel",
    "OC": "Order Count",
    "OD": "Other Miscellaneous Disposition",
    "OF": "Off Premise Sales Quantity",
    "OG": "Other Gas Disposition",
    "OH": "Other Injection Volume",
    "OI": "Opening Statement Balance",
    "OL": "Original Loan Term",
    "ON": "On Premise Sales Quantity",
    "OO": "Other Oil Condensate Disposition",
    "OR": "Original",
    "OT": "Number of Operating Periods at Failure",
    "OU": "Outlier Days",
    "OV": "Overage",
    "OW": "Other Water Disposition",
    "P1": "Project Phases",
    "P3": "Physical Status III",
    "P4": "Physical Status IV",
    "P5": "Physical Status V",
    "P6": "Number of Services or Procedures",
    "P7": "Prescription Dosage",
    "P8": "Prescription Frequency",
    "P9": "Number of People Living at Residence",
    "PA": "Pipeline Adjustment or Allowance",
    "PB": "Pressure Base",
    "PC": "Prior Cumulative Imbalance",
    "PD": "Payment Duration Weeks",
    "PE": "Period of Employment",
    "PF": "Gas Used for Plant Fuel",
    "PG": "Persistency",
    "PK": "Parking Spaces",
    "PL": "Partial Baths",
    "PO": "Percentage of Ordered Quantity",
    "PP": "Purchase of Product",
    "PQ": "Cumulative Quantity Required Prior to the First Scheduled Period",
    "PR": "Requirement Quantity that was Previously Released",
    "PS": "Prescription",
    "PT": "Patients",
    "PW": "Pitted Water",
    "PX": "Prior Units Accepted",
    "Q1": "Minimum quantity to which tax rate applies",
    "Q2": "Maximum quantity to which tax rate applies",
    "QA": "Quantity Approved",
    "QB": "Quantity Dispensed",
    "QC": "Quantity Disapproved",
    "QD": "Quantity Delivered",
    "QE": "Quantity Deferred",
    "QF": "High Fabrication Authorization Quantity",
    "QH": "Quantity on Hold",
    "QI": "Community Service Duration",
    "QJ": "Number of Times Deported",
    "QL": "Jail Sentence Duration",
    "QM": "Probation Duration",
    "QN": "Restriction Duration",
    "QO": "Operating Quantity",
    "QP": "Quantity by Position",
    "QQ": "Suspended Duration",
    "QR": "High Raw Material Authorization Quantity",
    "QS": "Quantity Per Skid",
    "QU": "Quantity Serviced",
    "QV": "Quantity Cancelled",
    "QW": "Quantity Withdrawn",
    "QX": "Qualifying Weeks",
    "R3": "Estimated Remaining Physical Life",
    "R5": "Axles",
    "R6": "Platform Count",
    "R9": "Fuel",
    "RA": "Refills Authorized",
    "RB": "Replaced Blood Units",
    "RC": "Number of Items Authorized at Store",
    "RD": "Number of Items Authorized at Warehouse",
    "RE": "Gas Returned to Earth",
    "RF": "Number of Items in Stock",
    "RG": "Gas Used for Repressuring or Pressure Maintenance",
    "RH": "Number of Shelf Tags",
    "RJ": "Quantity Available on Shelf",
    "RL": "Gas Returned to Property for fuel",
    "RM": "Room Count",
    "RN": "Units Rented",
    "RQ": "Royalty",
    "RS": "Number of Shelf Facings",
    "RT": "Retail Sales Quantity",
    "RW": "Water Re-injected on Property",
    "RY": "Requirement Quantity",
    "S1": "Planned Unit Development (PUD) Units",
    "S2": "Rooms, Finished Area Above Grade",
    "S3": "Dwelling Area",
    "S4": "Garage or Carport Area",
    "S5": "Units for Sale",
    "S6": "Gross Rent Multiplier",
    "S7": "Age, High Value",
    "S8": "Age, Low Value",
    "S9": "Bedrooms, Finished Area Above Grade",
    "SA": "Shipments",
    "SB": "Solicited",
    "SC": "Bathrooms, Finished Area Above Grade",
    "SD": "Criminal Sentence Duration",
    "SE": "Gross Living, Finished Area Above Grade",
    "SF": "Site",
    "SG": "Swan-Ganz",
    "SH": "Shortage",
    "SI": "Rooms",
    "SJ": "Area of Level",
    "SK": "Gas Shrinkage",
    "SL": "Predominate Age",
    "SM": "Minimum Criminal Sentence Duration",
    "SN": "Age",
    "SO": "Oil Sedimentation",
    "SP": "Days Supply",
    "SQ": "Product Sales Amount",
    "SR": "Effective Age",
    "SS": "Shares of Preferred Stock",
    "ST": "Standard",
    "SU": "Forecasted Scanned Quantity",
    "SV": "Shares of Common Stock",
    "SW": "Sample Amount",
    "SX": "Maximum Criminal Sentence Duration",
    "SY": "State or Province Motor Vehicle Penalty Points",
    "T1": "Time Units Known",
    "T2": "Time Units Spent on Duty",
    "T3": "Total Days on Market",
    "T4": "Total Rooms",
    "T5": "Total Number of Units",
    "T6": "Total Number of Units for Sale",
    "T7": "Tires",
    "TA": "Tank Allowance",
    "TB": "Oil Theft",
    "TC": "Total at Complete",
    "TD": "Total to Date",
    "TE": "Number of Theatres",
    "TG": "Total Gas Injection Volume",
    "TH": "Theoretical Quantity",
    "TI": "Total Oil and/or Condensate Injection Volume",
    "TJ": "Duration in Current Job",
    "TK": "Total Oil and/or Condensate Disposition",
    "TM": "Total Water Disposition",
    "TN": "Total Beginning Inventory",
    "TO": "Total",
    "TP": "Time in Position",
    "TR": "Trips",
    "TS": "Total Number of Parking Spaces",
    "TT": "Total Production Volume",
    "TU": "Total Adjustments Volume",
    "TV": "Total Gas Disposition",
    "TW": "Total Water Injection Volume",
    "TX": "Total Ending Inventory",
    "TY": "Total Sales Volume",
    "UA": "Units Completed",
    "UG": "Gas Used on Property",
    "UL": "Approximate Number of Units for Sale Projected",
    "UO": "Oil Condensate Used on Property",
    "US": "In-Use",
    "UU": "Used",
    "V1": "Retention Quantity",
    "V2": "Available Quantity",
    "V3": "Transfer Quantity",
    "V4": "Surveys in Average Rating",
    "V5": "Vacancies",
    "VA": "Volume Shrinkage Adjustment or Allowance",
    "VB": "Blank Votes",
    "VC": "Cumulative Earned Value",
    "VD": "Scattered Votes",
    "VE": "Earned Value",
    "VF": "Federal Votes",
    "VG": "Gas Vented",
    "VH": "Schedule Variance",
    "VI": "Cumulative Schedule Variance",
    "VJ": "Cumulative Variance",
    "VK": "Estimate at Complete",
    "VL": "At Complete Variance",
    "VM": "Variance Adjustment",
    "VN": "No Votes",
    "VP": "Presidential Votes",
    "VR": "Variance",
    "VS": "Visits",
    "VT": "Votes",
    "VV": "Void Votes",
    "VY": "Yes Votes",
    "WA": "Total number of Workers' Compensation First Reports",
    "WB": "Total number of Workers' Compensation Subsequent Reports",
    "WC": "Total number of Workers' Compensation Combined Reports",
    "WD": "Units Worked per Day",
    "WE": "Limited Quantity",
    "WG": "Weight Gain",
    "WL": "Weight Loss",
    "WO": "Operator's Working Interest",
    "WP": "Number of Producing Wells Remaining on Property or Facility",
    "WR": "Number of Producing Wells Remaining on Royalty Account",
    "WT": "Total Working Interest",
    "WV": "Water Volume",
    "WW": "Weeks Worked",
    "WX": "License Withdrawal Duration",
    "WY": "License Withdrawals Sent",
    "X1": "Producing Wells",
    "XA": "Total of Issuable Assets",
    "XB": "Total System Backorder Quantity, High Priority",
    "XC": "Total Service Backorder Quantity, High Priority",
    "XD": "Total System Backorder Quantity, Low Priority",
    "XE": "Total Service Backorder Quantity, Low Priority",
    "XG": "On Hand and Due-In",
    "XI": "Installment Payments",
    "XJ": "Other War Reserve Material Requirements Protectable (OWRMRP) "
            "Quantity",
    "XL": "Approximate Number of Units Projected",
    "XN": "Approximate Number of Holders",
    "XO": "Circulating Oil",
    "XT": "Protected Quantity",
    "XU": "Reserved",
    "XV": "Requisitioning Objective",
    "XX": "Authorized Retention Level",
    "XY": "Safety Level",
    "XZ": "Backorder Lines",
    "YA": "Total Demand Quantity",
    "YB": "Total Demand Orders",
    "YC": "First Quarter Recurring Demand",
    "YD": "First Quarter Recurrring Orders",
    "YE": "First Quarter Non-recurring Demand",
    "YF": "First Quarter Non-recurring Orders",
    "YG": "Second Quarter Recurring Demand",
    "YH": "Second Quarter Recurring Orders",
    "YJ": "Second Quarter Non-recurring Demand",
    "YK": "Second Quarter Non-recurring Orders",
    "YL": "Third Quarter Recurring Demand",
    "YM": "Third Quarter Recurring Orders",
    "YN": "Third Quarter Non-recurring Demand",
    "YP": "Third Quarter Non-recurring Orders",
    "YQ": "Fourth Quarter Recurring Demand",
    "YR": "Fourth Quarter Recurring Orders",
    "YS": "Fourth Quarter Non-recurring Demand",
    "YT": "Fourth Quarter Non-recurring Orders",
    "YW": "Reorder Point Quantity",
    "YX": "Contract Line Item Quantity",
    "YY": "Years",
    "Z1": "Units Worked Last Day",
    "Z2": "Units Worked per Week",
    "Z3": "Units Worked per Quarter",
    "Z4": "Number Weeks Paid",
    "Z6": "Unused Accumulated Sick Days",
    "ZA": "Federal Medicare or Medicaid Claim Mandate - Category 1",
    "ZB": "Federal Medicare or Medicaid Claim Mandate - Category 2",
    "ZC": "Federal Medicare or Medicaid Claim Mandate - Category 3",
    "ZD": "Federal Medicare or Medicaid Claim Mandate - Category 4",
    "ZE": "Federal Medicare or Medicaid Claim Mandate - Category 5",
    "ZF": "Federal Pension Mandate - Category 1",
    "ZG": "Federal Pension Mandate - Category 2",
    "ZH": "Federal Pension Mandate - Category 3",
    "ZI": "Holding Period",
    "ZJ": "Federal Pension Mandate - Category 5",
    "ZK": "Federal Medicare or Medicaid Payment Mandate - Category 1",
    "ZL": "Federal Medicare or Medicaid Payment Mandate - Category 2",
    "ZM": "Federal Medicare or Medicaid Payment Mandate - Category 3",
    "ZN": "Federal Medicare or Medicaid Payment Mandate - Category 4",
    "ZO": "Federal Medicare or Medicaid Payment Mandate - Category 5",
    "ZP": "Federal Pension Mandate - Category 4",
    "ZQ": "Shares Added",
    "ZR": "Extended Term",
    "ZS": "Amortization Term",
    "ZT": "Beginning Shares",
    "ZU": "Shares Deleted",
    "ZW": "Current Share Balance",
}

time_period_qualifier = {
    "1": "Chargeable Periods",
    "2": "Periods Held",
    "3": "Free Periods",
    "4": "Saturdays, Sundays and Holidays",
    "5": "Other Allowance Periods",
    "6": "Hour",
    "7": "Day",
    "8": "Not Applicable",
    "10": "Six Hours",
    "11": "12 Hours",
    "12": "18 Hours",
    "13": "24 Hours",
    "14": "Debit Days",
    "15": "Credit Days",
    "16": "Excess Days",
    "17": "Hazardous Days",
    "18": "Holidays",
    "19": "Saturdays and Sundays",
    "20": "Sundays and Holidays",
    "21": "Years",
    "22": "Service Year",
    "23": "Calendar Year",
    "24": "Year to Date",
    "25": "Contract",
    "26": "Episode",
    "27": "Visit",
    "28": "Outlier",
    "29": "Remaining",
    "30": "Exceeded",
    "31": "Not Exceeded",
    "32": "Lifetime",
    "33": "Lifetime Remaining",
    "34": "Month",
    "35": "Week",
    "36": "Admisson",
    "Z": "Mutually Defined",
}

delivery_or_calendar_pattern_code = {
    "1": "1st Week of the Month",
    "2": "2nd Week of the Month",
    "3": "3rd Week of the Month",
    "4": "4th Week of the Month",
    "5": "5th Week of the Month",
    "6": "1st & 3rd Weeks of the Month",
    "7": "2nd & 4th Weeks of the Month",
    "8": "1st Working Day of Period",
    "9": "Last Working Day of Period",
    "A": "Monday through Friday",
    "B": "Monday through Saturday",
    "C": "Monday through Sunday",
    "D": "Monday",
    "E": "Tuesday",
    "F": "Wednesday",
    "G": "Thursday",
    "H": "Friday",
    "J": "Saturday",
    "K": "Sunday",
    "L": "Monday through Thursday",
    "M": "Immediately",
    "N": "As Directed",
    "O": "Daily Mon. through Fri.",
    "P": "1/2 Mon. & 1/2 Thurs.",
    "Q": "1/2 Tues. & 1/2 Thurs.",
    "R": "1/2 Wed. & 1/2 Fri.",
    "S": "Once Anytime Mon. through Fri.",
    "SA": "Sunday, Monday, Thursday, Friday, Saturday",
    "SB": "Tuesday through Saturday",
    "SC": "Sunday, Wednesday, Thursday, Friday, Saturday",
    "SD": "Monday, Wednesday, Thursday, Friday, Saturday",
    "SG": "Tuesday through Friday",
    "SL": "Monday, Tuesday and Thursday",
    "SP": "Monday, Tuesday and Friday",
    "SX": "Wednesday and Thursday",
    "SY": "Monday, Wednesday and Thursday",
    "SZ": "Tuesday, Thursday and Friday",
    "T": "1/2 Tue. & 1/2 Fri.",
    "U": "1/2 Mon. & 1/2 Wed.",
    "V": "1/3 Mon., 1/3 Wed., 1/3 Fri.",
    "W": "Whenever Necessary",
    "X": "1/2 By Wed., Bal. By Fri.",
    "Y": "None (Also Used to Cancel or Override a Previous Pattern)",
    "Z": "Mutually Defined",
}

delivery_time_pattern_code = {
    "A": "1st Shift (Normal Working Hours)",
    "B": "2nd Shift",
    "C": "3rd Shift",
    "D": "A.M.",
    "E": "P.M.",
    "F": "As Directed",
    "G": "Any Shift",
    "Y": "None (Also Used to Cancel or Override a Previous Pattern)",
    "Z": "Mutually Defined",
}

reference_id_qualifier = {
    "01": "American Bankers Assoc. (ABA) Transit/Routing Number (Including "
            "Check Digit, 9 Digits)",
    "02": "Society for Worldwide Interbank Financial Telecommunication "
            "(S.W.I.F.T.) Identification (8 or 11 Characters)",
    "03": "Clearing House Interbank Payment System (CHIPS) Participant "
            "Number (3 or 4 Digits)",
    "04": "Canadian Financial Institution Branch and Institution Number",
    "05": "Clearing House Interbank Payment System (CHIPS) User "
            "Identification (6 digits)",
    "06": "System Number",
    "07": "Add-On System Number",
    "08": "Carrier Assigned Package Identification Number",
    "09": "Customs Bar Code Number",
    "0A": "Supervisory Appraiser Certification Number",
    "0B": "State License Number",
    "0D": "Subject Property Verification Source",
    "0E": "Subject Property Reference Number",
    "0F": "Subscriber Number",
    "0G": "Reviewer File Number",
    "0H": "Comparable Property Pending Sale Reference Number",
    "0I": "Comparable Property Sale Reference Number",
    "0J": "Subject Property Non-Sale Reference Number",
    "0K": "Policy Form Identifying Number",
    "0L": "Referenced By",
    "0M": "Mortgage Identification Number",
    "0N": "Attached To",
    "0P": "Real Estate Owned Property Identifier",
    "10": "Account Managers Code",
    "11": "Account Number",
    "12": "Billing Account",
    "13": "Horizontal Coordinate",
    "14": "Master Account Number",
    "15": "Vertical Coordinate",
    "16": "Military Interdepartmental Purchase Request (MIPR) Number",
    "17": "Client Reporting Category",
    "18": "Plan Number",
    "19": "Division Identifier",
    "1A": "Blue Cross Provider Number",
    "1B": "Blue Shield Provider Number",
    "1C": "Medicare Provider Number",
    "1D": "Medicaid Provider Number",
    "1E": "Dentist License Number",
    "1F": "Anesthesia License Number",
    "1G": "Provider UPIN Number",
    "1H": "CHAMPUS Identification Number",
    "1I": "Department of Defense Identification Code (DoDIC)",
    "1J": "Facility ID Number",
    "1K": "Payor's Claim Number",
    "1L": "Group or Policy Number",
    "1M": "Preferred Provider Organization Site Number",
    "1N": "Diagnosis Related Group (DRG) Number",
    "1O": "Consolidation Shipment Number",
    "1P": "Accessorial Status Code",
    "1Q": "Error Identification Code",
    "1R": "Storage Information Code",
    "1S": "Ambulatory Patient Group (APG) Number",
    "1T": "Resource Utilization Group (RUG) Number",
    "1U": "Pay Grade",
    "1V": "Related Vendor Order Number",
    "1W": "Member Identification Number",
    "1X": "Credit or Debit Adjustment Number",
    "1Y": "Repair Action Number",
    "1Z": "Financial Detail Code",
    "20": "Repair Part Number",
    "21": "American Gas Association Equation Number",
    "22": "Special Charge or Allowance Code",
    "23": "Client Number",
    "24": "Short-term Disability Policy Number",
    "25": "Reason Not Lowest Cost Code",
    "26": "Union Number",
    "27": "Insuror Pool Identification Number",
    "28": "Employee Identification Number",
    "29": "Foreclosure Account Number",
    "2A": "Import License Number",
    "2B": "Terminal Release Order Number",
    "2C": "Long-term Disability Policy Number",
    "2D": "Aeronautical Equipment Reference Number (AERNO)",
    "2E": "Foreign Military Sales Case Number",
    "2F": "Consolidated Invoice Number",
    "2G": "Amendment",
    "2H": "Assigned by transaction set sender",
    "2I": "Tracking Number",
    "2J": "Floor Number",
    "2K": "Food and Drug Administration (FDA) Product Type",
    "2L": "Association of American Railroads (AAR) Railway Accounting Rules",
    "2M": "Federal Communications Commission (FCC) Identifier",
    "2N": "Federal Communications Commission (FCC) Trade/Brand Identifier",
    "2O": "Occupational Safety and Health Administration (OSHA) Claim Number",
    "2P": "Subdivision Identifier",
    "2Q": "Food and Drug Administration (FDA) Accession Number",
    "2R": "Coupon Redemption Number",
    "2S": "Catalog",
    "2T": "Sub-subhouse Bill of Lading",
    "2U": "Payer Identification Number",
    "2V": "Special Government Accounting Classification Reference Number "
            "(ACRN)",
    "2W": "Change Order Authority",
    "2X": "Supplemental Agreement Authority",
    "2Y": "Wage Determination",
    "2Z": "U.S. Customs Service (USCS) Anti-dumping Duty Case Number",
    "30": "United States Government Visa Number",
    "31": "Docket Number",
    "32": "Credit Repository Code",
    "33": "Lender Case Number",
    "34": "Loan Request Number",
    "35": "Multifamily Project Number",
    "36": "Underwriter Identification Number",
    "37": "Condominium Identification Number",
    "38": "Master Policy Number",
    "39": "Proposal Number",
    "3A": "Section of the National Housing Act Code",
    "3B": "Supplemental Claim Number",
    "3C": "Payee Loan Number",
    "3D": "Servicer Loan Number",
    "3E": "Investor Loan Number",
    "3F": "Show Identification",
    "3G": "Catastrophe Number",
    "3H": "Case Number",
    "3I": "Precinct Number",
    "3J": "Office Number",
    "3K": "Petroleum Pool Code",
    "3L": "Branch Identifier",
    "3M": "Federal Communications Commission (FCC) Condition Code",
    "3N": "Gas Custodian Identification",
    "3O": "U.S. Customs Service (USCS) Pre-approval Ruling Number",
    "3P": "Third Party Originator Number",
    "3Q": "Food and Drug Administration (FDA) Product Code",
    "3R": "U.S. Customs Service (USCS) Binding Ruling Number",
    "3S": "Provincial (Canadian) Sales Tax Exemption Number",
    "3T": "U.S. Customs Service (USCS) Pre-classification Ruling Number",
    "3U": "Protraction Number",
    "3V": "Formation Identifier",
    "3W": "U.S. Customs Service (USCS) Commercial Description",
    "3X": "Subcontract Number",
    "3Y": "Receiver Assigned Drop Zone",
    "3Z": "Customs Broker Reference Number",
    "40": "Lease Schedule Number - Replacement",
    "41": "Lease Schedule Number - Prior",
    "42": "Phone Calls",
    "43": "Supporting Document Number",
    "44": "End Use Number",
    "45": "Old Account Number",
    "46": "Old Meter Number",
    "47": "Plate Number",
    "48": "Agency's Student Number. This is the number assigned by an agency "
            "other than the institution sending the record.",
    "49": "Family Unit Number",
    "4A": "Personal Identification Number (PIN)",
    "4B": "Shipment Origin Code",
    "4C": "Shipment Destination Code",
    "4D": "Shipping Zone",
    "4E": "Carrier-assigned Consignee Number",
    "4F": "Carrier-assigned Shipper Number",
    "4G": "Provincial Tax Identification",
    "4H": "Commercial Invoice Number",
    "4I": "Balance-due Reference Number",
    "4J": "Vehicle-related Services Reference Number",
    "4K": "Accessorial Rail Diversion Reference Number",
    "4L": "Location-specific Services Reference Number",
    "4M": "Special Move Reference Number",
    "4N": "Special Payment Reference Number",
    "4O": "Canadian Goods & Services or Quebec Sales Tax Reference Number",
    "4P": "Affiliation Number",
    "4Q": "Call Sign",
    "4R": "Rule Section",
    "4S": "Preferred Call Sign",
    "4T": "North American Datum Standard (NADS)",
    "4U": "Market Area",
    "4V": "Emission Designator",
    "4W": "Study",
    "4X": "Log",
    "4Y": "Subhouse Bill of Lading",
    "4Z": "U.S. Customs Service (USCS) Countervailing Duty Case Number",
    "50": "State Student Identification Number",
    "51": "Picture Number",
    "52": "SWIFT (MT 100)",
    "53": "SWIFT (MT 202)",
    "54": "FEDWIRE (Federal Wire Transfer)",
    "55": "Sequence Number",
    "56": "Corrected Social Security Number",
    "57": "Prior Incorrect Social Security Number",
    "58": "Corrected Batch Number",
    "59": "Prior Incorrect Batch Number",
    "5A": "Offense Tracking",
    "5B": "Supplemental Account Number",
    "5C": "Congressional District",
    "5D": "Line of Credit Category",
    "5E": "Consumer Identifier",
    "5F": "Warrant",
    "5G": "Complaint",
    "5H": "Incident",
    "5I": "Offender Tracking",
    "5J": "Driver's License",
    "5K": "Commercial Driver's License",
    "5L": "Jurisdictional Community Number",
    "5M": "Previous Sequence",
    "5N": "Citation of Statute",
    "5O": "Citation of Opinion",
    "5P": "National Criminal Information Center Originating Agency "
            "Identification",
    "5Q": "State Criminal History Repository Individual Identification",
    "5R": "Federal Bureau of Investigation Individual Identification",
    "5S": "Processing Area",
    "5T": "Payment Location",
    "5U": "Flood Data Identifier",
    "5V": "Coupon Distribution Method",
    "5W": "Original Uniform Commercial Code Filing Number",
    "5X": "Amended Uniform Commercial Code Filing Number",
    "5Y": "Continuation Uniform Commercial Code Filing Number",
    "5Z": "Uniform Commercial Code Filing Collateral Number",
    "60": "Account Suffix Code",
    "61": "Taxing Authority Identification Number",
    "63": "Prior Loan Number",
    "64": "Jurisdictional Community Name Identifier",
    "65": "Total Order Cycle Number",
    "66": "Previous Policy Number",
    "67": "Previous Claim History Identifier",
    "68": "Dental Insurance Account Number",
    "69": "Dental Insurance Policy Number",
    "6A": "Consignee Reference Number",
    "6B": "U.S. Customs Service (USCS) Entry Number",
    "6C": "U.S. Customs Service (USCS) Entry Type Code",
    "6D": "U.S. Customs Service (USCS) Statement Number",
    "6E": "Map Reference",
    "6F": "Appraiser License",
    "6G": "Map Number",
    "6H": "Comparable Property Verification Source",
    "6I": "Comparable Property",
    "6J": "Census Tract",
    "6K": "Zone",
    "6L": "Agent Contract Number",
    "6M": "Application Number",
    "6N": "Claimant Number",
    "6O": "Cross Reference Number",
    "6P": "Group Number",
    "6Q": "Insurance License Number",
    "6R": "Provider Control Number",
    "6S": "Provider Order Ticket Number",
    "6T": "Pilot License Number",
    "6U": "Question Number",
    "6V": "Reissue Cession Number",
    "6W": "Sequence Number",
    "6X": "Specimen Identifier",
    "6Y": "Equipment Initial",
    "6Z": "Secretaria de Comercia y Famenta Industrial (SECOFI) Number",
    "70": "Calendar Number",
    "71": "(Working) Shift Number",
    "72": "Schedule Reference Number",
    "73": "Statement of Work (SOW)",
    "74": "Work Breakdown Structure (WBS)",
    "75": "Organization Breakdown Structure",
    "76": "Milestone",
    "77": "Work Package",
    "78": "Planning Package",
    "79": "Cost Account",
    "7A": "Purchase Order Number Included in On-Order Position",
    "7B": "Purchase Order Number of Shipment Received since Last Reporting "
            "Date",
    "7C": "Purchase Order Number of Order Received since Last Reporting Date",
    "7D": "Tester Identification",
    "7E": "Collector Identification",
    "7F": "Repeat Location",
    "7G": "Data Quality Reject Reason",
    "7H": "Environmental Protection Agency (EPA) Test Type Purpose Code",
    "7I": "Subscriber Authorization Number",
    "7J": "Toll Billing Telephone Reference Number",
    "7K": "List of Materials",
    "7L": "Qualified Materials List",
    "7M": "Frame",
    "7N": "Piggyback",
    "7O": "Tripleback",
    "7P": "Sheet",
    "7Q": "Engineering Change Order",
    "7R": "Representative Identification Number",
    "7S": "Drawing Type",
    "7T": "Master Contract",
    "7U": "Related Transaction Reference Number",
    "7W": "Interchange Train Identification",
    "7X": "Home Mortgage Disclosure Act (HMDA) State Code",
    "7Y": "Home Mortgage Disclosure Act (HMDA) County Code",
    "7Z": "Home Mortgage Disclosure Act (HMDA) Metropolitan Statistical Area "
            "(MSA)",
    "80": "Charge Number",
    "81": "Symbol Number (for Milestone or LOB reports)",
    "82": "Data Item Description (DID) Reference",
    "83": "Extended (or Exhibit) Line Item Number (ELIN)",
    "84": "Contractor Data Requirements List (CDRL)",
    "85": "Subcontractor Data Requirements (SDRL)",
    "86": "Operation Number",
    "87": "Functional Category",
    "88": "Work Center",
    "89": "Assembly Number",
    "8A": "Health Maintenance Organization (HMO) Authorization Number",
    "8B": "Preferred Provider Organization (PPO) Authorization Number",
    "8C": "Third-party Organization (TPO) Authorization Number",
    "8D": "Chemical Abstract Service Registry Number",
    "8E": "Guarantor Loan Number",
    "8F": "School Loan Number",
    "8G": "Automated Clearinghouse (ACH) Trace Number",
    "8H": "Check List Number",
    "8I": "FEDWIRE Confirmation Number",
    "8J": "Society for Worldwide Interbank Financial Telecommunications "
            "(SWIFT) Confirmation Number",
    "8K": "Dominion of Canada Code",
    "8L": "International Standard Industry Classification Code (ISIC)",
    "8M": "Originating Company Identifier",
    "8N": "Receiving Company Identifier",
    "8O": "Automated Clearing House (ACH) Entry Description",
    "8P": "Originating Depository Financial Institution Identifier",
    "8Q": "Receiving Depository Financial Institution Identifier",
    "8R": "Security Type",
    "8S": "Broker Identification",
    "8T": "Committee for Uniform Security Identification Procedure (CUSIP)",
    "8U": "Bank Assigned Security Identifier",
    "8V": "Credit Reference",
    "8W": "Bank to Bank Information",
    "8X": "Transaction Category or Type",
    "8Y": "Safekeeping Account Number",
    "8Z": "Alternate Clause Number",
    "90": "Subassembly Number",
    "91": "Cost Element",
    "92": "Change Document Number",
    "93": "Funds Authorization",
    "94": "File Identification Number",
    "95": "Committee on Uniform Securities Identification Procedures (CUSIP) "
            "Number",
    "96": "Stock Certificate Number",
    "97": "Package Number",
    "98": "Container/Packaging Specification Number",
    "99": "Rate Conference ID Code",
    "9A": "Repriced Claim Reference Number",
    "9B": "Repriced Line Item Reference Number",
    "9C": "Adjusted Repriced Claim Reference Number",
    "9D": "Adjusted Repriced Line Item Reference Number",
    "9E": "Replacement Claim Number",
    "9F": "Referral Number",
    "9G": "Department of Defense Form 250 Requirement Code",
    "9H": "Packaging Group Number",
    "9I": "Automated Clearing House (ACH) Standard Entry Class",
    "9J": "Pension Contract",
    "9K": "Servicer",
    "9L": "Service Bureau",
    "9M": "Clearing House Interbank Payments System (CHIPS) Sequence Number",
    "9N": "Investor",
    "9P": "Loan Type",
    "9Q": "Pool Suffix",
    "9R": "Job Order Number",
    "9S": "Delivery Region",
    "9T": "Tenor",
    "9U": "Loan Feature Code",
    "9V": "Payment Category",
    "9W": "Payer Category",
    "9X": "Account Category",
    "9Y": "Bank Assigned Bankers Reference Number",
    "9Z": "Chamber of Commerce Number",
    "A0": "Advertiser Number",
    "A1": "Analysis number/Test number",
    "A2": "Disability Insurance Account Number",
    "A3": "Assigment Number",
    "A4": "Disability Insurance Policy Number",
    "A5": "Educational Institution Identification Number",
    "A6": "Employee Identification Number",
    "A7": "Flexible Spending Account (FSA) Insurance Account Number",
    "A8": "Flexible Spending Account (FSA) Insurance Policy Number",
    "A9": "Health Insurance Account Number",
    "AA": "Accounts Receivable Statement Number",
    "AAA": "Distributor's Split Agent Number",
    "AAB": "Fund Manager's Reference Number",
    "AAC": "Agency Hierarchical Level",
    "AAD": "Officer License Number",
    "AAE": "Previous Distributor Number",
    "AAF": "Interviewer ID",
    "AAG": "Military ID",
    "AAH": "Option Policy Number",
    "AAI": "Payroll Account Number",
    "AAJ": "Prior Contract Number",
    "AAK": "Worksite Number",
    "AAL": "Agent Number",
    "AAM": "Treaty Identifier",
    "AAN": "Associated Case Control Number",
    "AAO": "Carrier Assigned Code",
    "AAP": "Dealer Number",
    "AAQ": "Directory Number",
    "AAR": "Distributor Assigned Transaction Number",
    "AAS": "Distributor Assigned Order Number",
    "AAT": "Distributor's Account Number",
    "AAU": "General Agency Number",
    "AAV": "Laboratory Number",
    "AAW": "Agency Assigned Number",
    "AAX": "List Bill Number",
    "AAY": "Accounting Period Reference",
    "AAZ": "Paramedical ID Number",
    "AB": "Acceptable Source Purchaser ID",
    "ABA": "Payroll Number",
    "ABB": "Personal ID Number",
    "ABC": "Policy Link Number",
    "ABD": "Secondary Policy Number",
    "ABE": "Special Quote Number",
    "ABF": "National Property Registry System Level 1",
    "ABG": "National Property Registry System Level 2",
    "ABH": "Investor Assigned Identification Number",
    "ABJ": "Ginnie Mae (Government National Mortgage Association) Pool "
            "Package Number",
    "ABK": "Mortgage Electronic Registration System Organization Identifier",
    "ABL": "Seller Loan Number",
    "ABM": "Sub-Servicer Loan Number",
    "ABN": "National Property Registry System Level 3",
    "ABO": "State Hazardous Waste Entity Identifier",
    "ABP": "Bankruptcy Procedure Number",
    "ABQ": "National Business Identification Number",
    "ABR": "Prior Data Universal Number System (D-U-N-S) Number, "
            "Dun & Bradstreet",
    "ABS": "Vessel Name",
    "ABT": "Security Instrument Number",
    "ABU": "Assignment Recording Number",
    "ABV": "Book Number",
    "ABY": "Health Care Financing Administration National Payer "
            "Identification Number",
    "AC": "Air Cargo Transfer Manifest",
    "ACA": "Growth Factor Reference",
    "ACB": "Region",
    "ACC": "Status",
    "ACD": "Class Code",
    "ACE": "Service Request Number",
    "ACF": "Supplement Number",
    "ACG": "Previous Ticket Number",
    "ACH": "One Call Agency Ticket Number",
    "ACI": "Ticket Number",
    "ACJ": "Bill of Material Revision Number",
    "ACK": "Drawing Revision Number",
    "ACL": "Application Transaction Reference Number",
    "ACM": "Related Object Identification Number",
    "ACN": "Common Access Reference Number",
    "ACO": "First Transfer Number",
    "ACP": "Continuous Transfer Number",
    "ACQ": "Last Transfer Number",
    "ACR": "Automated Clearinghouse (ACH) Return/Notification of Change "
            "(NOC) Code",
    "ACS": "Society of Property Information Compilers and Analysts",
    "ACT": "Accounting Code",
    "AD": "Acceptable Source DUNS Number",
    "ADA": "Agency for International Development Acquisition Regulation "
            "(AIDAR)",
    "ADB": "Master Property Number",
    "ADC": "Project Property Number",
    "ADD": "Unit Property Number",
    "ADE": "Associated Property Number",
    "ADF": "Associated Number For Limited Common Element Parking",
    "ADG": "Associated Number For Unit Parking",
    "ADH": "Associated Number For Joined Unit not re-subdivided",
    "ADI": "Processor Identification Number",
    "ADM": "Air Dimension Code",
    "AE": "Authorization for Expense (AFE) Number",
    "AEA": "Numero de Cedula de Identidad (CIN) Number",
    "AEB": "Company's Registry Office (CRO) Number",
    "AEC": "Government Registration Number",
    "AED": "Judicial Number",
    "AEE": "Numero de Identificacion Tributaria (NIT)",
    "AEF": "Passport Number",
    "AEG": "Patron Number",
    "AEH": "Registro Informacion Fiscal (RIF)",
    "AEI": "Registro Unico de Contribuyente (RUC)",
    "AEJ": "Superintendencia de Inversiones Extranjeras (SIEX) Number",
    "AEK": "Tokyo Shoko Research Business Identifier",
    "AEL": "Registro Nacional de Contribuyente (RNC)",
    "AEM": "Distribution Center Number",
    "AF": "Airlines Flight Identification Number",
    "AG": "Agent's Shipment Number",
    "AH": "Agreement Number",
    "AHC": "Air Handling Code",
    "AI": "Associated Invoices",
    "AJ": "Accounts Receivable Customer Account",
    "AK": "Sending Company Audit Number (Automated Clearinghouse Transfers)",
    "AL": "Accounting (Equipment) Location Number",
    "ALC": "Agency Location Code",
    "ALG": "Title Company Code Book Reference",
    "ALH": "Title Document Schedule",
    "ALI": "Recording Number",
    "ALJ": "Title Policy Number",
    "ALT": "Alteration Number",
    "AM": "Adjustment Memo (Charge Back)",
    "AN": "Associated Purchase Orders",
    "AO": "Appointment Number",
    "AP": "Accounts Receivable Number",
    "API": "American Petroleum Institute (API) Deduction Code",
    "AQ": "Access Code",
    "AR": "Arrival Code",
    "AS": "Acceptable Source Supplier ID",
    "ASL": "Atomic Safety and Licensing Board Panel (ASLBP) Number",
    "ASP": "Animal Species",
    "AST": "Animal Strain",
    "AT": "Appropriation Number",
    "ATC": "Maintenance Availability Type",
    "AU": "Authorization to Meet Competition Number",
    "AV": "Health Insurance Rating Account Number",
    "AW": "Air Waybill Number",
    "AX": "Government Accounting Class Reference Number (ACRN)",
    "AY": "Floor Plan Approval Number",
    "AZ": "Health Insurance Policy Number",
    "B1": "Lessee Bill Code Number",
    "B2": "Axle Ratio",
    "B3": "Preferred Provider Organization Number",
    "B4": "Bilateral Car Service Agreements",
    "B5": "Health Insurance Rating Suffix Code",
    "B6": "Life Insurance Billing Account Number",
    "B7": "Life Insurance Policy Number",
    "B8": "Life Insurance Billing Suffix Code",
    "B9": "Retirement Plan Account Number",
    "BA": "Retirement Plan Policy Number",
    "BAA": "Franchise Tax Account Number",
    "BAB": "Certificate of Incorporation Number",
    "BAC": "Beam Assembly Code",
    "BAD": "State Tax Identification Number",
    "BAE": "Charter Number",
    "BAF": "Receipt Number",
    "BAG": "Withdrawal Account Number",
    "BAH": "Deposit Account Number",
    "BAI": "Business Identification Number",
    "BB": "Authorization Number",
    "BC": "Buyer's Contract Number",
    "BCI": "Basic Contract Line Item Number",
    "BD": "Bid Number",
    "BE": "Business Activity",
    "BF": "Billing Center Identification",
    "BG": "Beginning Serial Number",
    "BH": "Lease Schedule Number - Blanket",
    "BI": "Bonded Carrier Internal Revenue Service Identification Number",
    "BJ": "Carrier's Customs Bond Number",
    "BK": "Broker's Order Number",
    "BKT": "Bank Telegraphic Number",
    "BL": "Government Bill of Lading",
    "BLT": "Billing Type",
    "BM": "Bill of Lading Number",
    "BMM": "Begin Mile Marker",
    "BN": "Booking Number",
    "BO": "Bin Location Number",
    "BOI": "Binary Object Identifier",
    "BP": "Adjustment Control Number",
    "BQ": "Health Maintenance Organization Code Number",
    "BR": "Broker or Sales Office Number",
    "BS": "Split Booking Number",
    "BT": "Batch Number",
    "BU": "Buyer's Approval Mark",
    "BV": "Purchase Order Line Item Identifier (Buyer)",
    "BW": "Blended With Batch Number",
    "BX": "Buyer's Shipment Mark Number",
    "BY": "Repair Category Number",
    "BZ": "Complaint Code",
    "C0": "Canadian Social Insurance Number",
    "C1": "Customer material specification number",
    "C2": "Customer process specification number",
    "C3": "Customer specification number",
    "C4": "Change Number",
    "C5": "Customer Tracking Number For Loaned Materials",
    "C6": "Carnet Number",
    "C7": "Contract Line Item Number",
    "C8": "Corrected Contract Number",
    "C9": "Previous Credit/Debit Adjustment Number",
    "CA": "Cost Allocation Reference",
    "CB": "Combined Shipment",
    "CBG": "Census Block Group",
    "CC": "Contract Co-op Number",
    "CD": "Credit Note Number",
    "CDN": "Citizenship Document Number",
    "CE": "Class of Contract Code",
    "CF": "Fleet Reference Number",
    "CG": "Consignee's Order Number",
    "CH": "Customer catalog number",
    "CI": "Unique Consignment Identifier",
    "CIR": "Circuit Number",
    "CIT": "Citation",
    "CJ": "Clause Number",
    "CK": "Check Number",
    "CL": "Seller's Credit Memo",
    "CM": "Buyer's Credit Memo",
    "CMN": "Continuous Move Number",
    "CMP": "Customer Maintenance Period Sequence Number",
    "CMT": "Component",
    "CN": "Carrier's Reference Number (PRO/Invoice)",
    "CNO": "Commitment Number",
    "CO": "Customer Order Number",
    "COL": "Collocation Indicator",
    "COT": "Certificate of Transportation",
    "CP": "Condition of Purchase Document Number",
    "CPA": "Canadian Province Operating Authority Number",
    "CPT": "Current Procedural Terminology Code",
    "CQ": "Customshouse Broker License Number",
    "CR": "Customer Reference Number",
    "CRN": "Casualty Report Number",
    "CRS": "Casualty Report Serial Number",
    "CS": "Condition of Sale Document Number",
    "CSC": "CS54 Key Train Indicator Code",
    "CSG": "CS54 Key Train Indicator Group Name",
    "CST": "Census State Code",
    "CT": "Contract Number",
    "CTS": "Census Tract Suffix",
    "CU": "Clear Text Clause",
    "CV": "Coil Number",
    "CW": "Canadian Wheat Board Permit Number",
    "CX": "Consignment Classification ID",
    "CY": "Commercial Registration Number",
    "CYC": "Periodicity Code",
    "CZ": "Contract Rider Number (Used in conjunction with contract number)",
    "D0": "Data Reliability Code",
    "D1": "Drug Enforcement Administration Order Blank Number",
    "D2": "Supplier Document Identification Number",
    "D3": "National Association of Boards of Pharmacy Number",
    "D4": "Cut Number",
    "D5": "Dye Lot Number",
    "D6": "Duplicate Bill Number",
    "D7": "Coverage Code",
    "D8": "Loss Report Number",
    "D9": "Claim Number",
    "DA": "Domicile Branch Number",
    "DB": "Buyer's Debit Memo",
    "DC": "Dealer purchase order number",
    "DD": "Document Identification Code",
    "DE": "Depositor Number",
    "DF": "Defense Federal Acquisition Regulations (DFAR)",
    "DG": "Drawing Number",
    "DH": "Drug Enforcement Administration Number",
    "DHH": "Department of Health and Human Services Acquisition Regulation "
            "(HHSAR)",
    "DI": "Distributor Invoice Number",
    "DIS": "District Number",
    "DJ": "Delivery Ticket Number",
    "DK": "Dock Number",
    "DL": "Seller's Debit Memo",
    "DM": "Associated Product Number",
    "DN": "Draft Number",
    "DNR": "Deposit Number",
    "DNS": "D-U-N-S+4, D-U-N-S Number with Four Character Suffix",
    "DO": "Delivery Order Number",
    "DOA": "Department of Agriculture Acquisition Regulation (AGAR)",
    "DOC": "Department of Commerce Acquisition Regulation (CAR)",
    "DOE": "Department of Energy Acquisition Regulation (DEAR)",
    "DOI": "Department of Interior Acquisition Regulation (DIAR)",
    "DOJ": "Department of Justice Acquisition Regulation (JAR)",
    "DOL": "Department of Labor Acquisition Regulation (DOLAR)",
    "DON": "Density Order Number",
    "DOS": "Department of State Acquisition Regulation (DOSAR)",
    "DOT": "Department of Transportation Acquisition Regulation (TAR)",
    "DP": "Department Number",
    "DQ": "Delivery Quote Number",
    "DR": "Dock Receipt Number",
    "DRN": "Drainhole Number",
    "DS": "Defense Priorities Allocation System (DPAS) Priority Rating",
    "DSC": "Departure from Specification Class Code",
    "DSI": "Departure from Specification Number",
    "DST": "Departure from Specification Type Code",
    "DT": "Downstream Shipper Contract Number",
    "DTS": "Department of the Treasury Acquisition/Procurement Regulation "
            "(TAPR)",
    "DU": "Dependents Information",
    "DUN": "D-U-N-S Number Dun & Bradstreet",
    "DV": "Diversion Authority Number",
    "DW": "Deposit Sequence Number",
    "DX": "Department/Agency Number",
    "DY": "Department of Defense Transportation Service Code Number "
            "(Household Goods)",
    "DZ": "Certified Registered Nurse Anesthetist (CRNA) Provider "
            "Identification Number",
    "E1": "Emergency Order Number",
    "E2": "Part Causing Repair Number",
    "E3": "Expansion on Effect of Change Number",
    "E4": "Charge Card Number",
    "E5": "Claimant's Claim Number",
    "E6": "Backout Procedure Code",
    "E7": "Service Bulletin Number",
    "E8": "Service Contract (Coverage) Number",
    "E9": "Attachment Code",
    "EA": "Medical Record Identification Number",
    "EB": "Embargo Permit Number",
    "EC": "Circular",
    "ED": "Export Declaration",
    "EDA": "Department of Education Acquisition Regulation (EDAR)",
    "EE": "Election District",
    "EF": "Electronic Funds Transfer ID Number",
    "EG": "Ending Serial Number",
    "EH": "Financial Classification Code",
    "EI": "Employer's Identification Number",
    "EJ": "Patient Account Number",
    "EK": "Healthcare Manpower Shortage Area (HMSA) Facility Identification "
            "Number",
    "EL": "Electronic device pin number",
    "EM": "Electronic Payment Reference Number",
    "EMM": "End Mile Marker",
    "EN": "Embargo Number",
    "END": "Endorsement Number",
    "EO": "Submitter Identification Number",
    "EP": "Export Permit Number",
    "EPA": "Environmental Protection Agency Acquisition Regulation (EPAAR)",
    "EPB": "Environmental Protection Agency Transporter Identification Number",
    "EQ": "Equipment Number",
    "ER": "Container or Equipment Receipt Number",
    "ES": "Employer's Social Security Number",
    "ESN": "Estimate Sequence Number",
    "ET": "Excess Transportation",
    "EU": "End User's Purchase Order Number",
    "EV": "Receiver Identification Number",
    "EW": "Mammography Certification Number",
    "EX": "Estimate Number",
    "EY": "Receiver Sub-identification Number",
    "EZ": "Electronic Data Interchange Agreement Number",
    "F1": "Version Code - National",
    "F2": "Version Code - Local",
    "F3": "Submission Number",
    "F4": "Facility Certification Number",
    "F5": "Medicare Version Code",
    "F6": "Health Insurance Claim (HIC) Number",
    "F7": "New Health Insurance Claim (HIC) Number",
    "F8": "Original Reference Number",
    "F9": "Freight Payor Reference Number",
    "FA": "Federal Acquisition Regulations (FAR)",
    "FB": "File Transfer Form Number",
    "FC": "Filer Code Issued by Customs",
    "FCN": "Assigned Contract Number",
    "FD": "Filer Code Issued by Bureau of Census",
    "FE": "Failure mechanism number",
    "FF": "Film Number",
    "FG": "Fund Identification Number",
    "FH": "Clinic Number",
    "FI": "File Identifier",
    "FJ": "Line Item Control Number",
    "FK": "Finish Lot Number",
    "FL": "Fine Line Classification",
    "FLZ": "Flood Zone",
    "FM": "Federal Maritime Commisssion (FMC) Forwarders Number",
    "FMP": "Facility Measurement Point Number",
    "FN": "Forwarder's/Agent's Reference Number",
    "FND": "Finder Number",
    "FO": "Drug Formulary Number",
    "FP": "Forestry Permit Number",
    "FQ": "Form Number",
    "FR": "Freight Bill Number",
    "FS": "Final Sequence Number",
    "FSN": "Assigned Sequence Number",
    "FT": "Foreign Trade Zone",
    "FTN": "Premarket Notification Number",
    "FU": "Fund Code",
    "FV": "Health Maintenance Organization (HMO) Reference Number",
    "FW": "State License Identification Number",
    "FWC": "Final Work Candidate Number",
    "FX": "Failure Analysis Report Number",
    "FY": "Claim Office Number",
    "FZ": "Processor's Invoice Number",
    "G1": "Prior Authorization Number",
    "G2": "Provider Commercial Number",
    "G3": "Predetermination of Benefits Identification Number",
    "G4": "Peer Review Organization (PRO) Approval Number",
    "G5": "Provider Site Number",
    "G6": "Payer Assigned Resubmission Reference Number",
    "G7": "Resubmission Reason Code",
    "G8": "Resubmission Number",
    "G9": "Secondary Employee Identification Number",
    "GA": "Government Advance Progress",
    "GB": "Grain Block Number",
    "GC": "Government Contract Number",
    "GD": "Return Goods Bill of Lading Number",
    "GE": "Geographic Number",
    "GF": "Specialty License Number",
    "GG": "Gauge Ticket Number",
    "GH": "Identification Card Serial Number",
    "GI": "Secondary Provider Number",
    "GJ": "Cornbore Certification Number",
    "GK": "Third Party Reference Number",
    "GL": "Geographic Destination Zone Number",
    "GM": "Loan Acquisition Number",
    "GN": "Folder Number",
    "GO": "Exhibit Identifier",
    "GP": "Government Priority Number",
    "GQ": "Internal Purchase Order Release Number",
    "GR": "Grain Order Reference Number",
    "GS": "General Services Administration Regulations (GSAR)",
    "GT": "Goods and Service Tax Registration Number",
    "GU": "Internal Purchase Order Item Number",
    "GV": "Third Party Purchase Order Number",
    "GW": "Third Party Purchase Order Release Number",
    "GWS": "Group Work Candidate Sequence Number",
    "GX": "Third Party Purchase Order Item Number",
    "GY": "Empty Repositioning Number",
    "GZ": "General Ledger Account",
    "H1": "High Fabrication Authorization Number",
    "H2": "High Raw Material Authorization Number",
    "H3": "Gravity Source Meter Number",
    "H4": "Federal Information Resources Management Regulation",
    "H5": "Special Clause",
    "H6": "Quality Clause",
    "H7": "Standard Clause",
    "H8": "Home Mortgage Disclosure Act (HMDA) Census Tract",
    "H9": "Payment History Reference Number",
    "HA": "Competent Authority",
    "HB": "Bill & Hold Invoice Number",
    "HC": "Heat Code",
    "HD": "Department of Transportation Hazardous Number",
    "HE": "Hazardous Exemption Number",
    "HF": "Engineering Data List",
    "HG": "Civil Action Number",
    "HH": "Fiscal Code",
    "HHT": "Type of Household Goods Code",
    "HI": "Health Industry Number (HIN)",
    "HJ": "Identity Card Number",
    "HK": "Judgment Number",
    "HL": "SIREN Number",
    "HM": "SIRET Number",
    "HMB": "Home Mortgage Disclosure Act Block Number Area",
    "HN": "Hazardous Certification Number",
    "HO": "Shipper's Hazardous Number",
    "HP": "Pack & Hold Invoice Number",
    "HPI": "Health Care Financing Administration National Provider Identifier",
    "HQ": "Reinsurance Reference",
    "HR": "Horsepower",
    "HS": "Harmonized Code System (Canada)",
    "HT": "Code of Federal Regulations",
    "HU": "Type of Escrow Number",
    "HUD": "Department of Housing and Urban Development Acquisition "
            "Regulation (HUDAR)",
    "HV": "Escrow File Number",
    "HW": "High/Wide File Number",
    "HX": "Auto Loss Item Number",
    "HY": "Property Loss Item Number",
    "HZ": "Tax Agency Number (MERS [Mortgage Electronic Registration System] "
            "Federal Information Processing Standards [FIPS] Based Number)",
    "I1": "Owning Bureau Identification Number",
    "I2": "Interstate Commerce Commission (ICC) Account Number",
    "I3": "Non-American Identification Number",
    "I4": "Credit Counseling Identification Number",
    "I5": "Invoice Identification",
    "I7": "Credit Report Number",
    "I8": "Social Insurance Number",
    "I9": "Pollutant",
    "IA": "Internal Vendor Number",
    "IB": "In Bond Number",
    "IC": "Inbound-to Party",
    "ICD": "ICD-9-CM (International Classification of Diseases)",
    "ID": "Insurance Certificate Number",
    "IE": "Interchange Agreement Number",
    "IF": "Issue Number",
    "IFT": "International Fuel Tax Agreement Account Number",
    "IG": "Insurance Policy Number",
    "IH": "Initial Dealer Claim Number",
    "II": "Initial Sample Inspection Report Number",
    "IID": "Image Identifier",
    "IJ": "Standard Industry Classification (SIC) Code",
    "IK": "Invoice Number",
    "IL": "Internal Order Number",
    "IM": "Intergovernmental Maritime Organization (IMO) Number",
    "IMP": "Integrated Master Plan (IMP)",
    "IMS": "Integrated Master Schedule (IMS)",
    "IN": "Consignee's Invoice Number",
    "IND": "Investigatorial New Drug Number",
    "IO": "Inbound-to or Outbound-from Party",
    "IP": "Inspection Report Number",
    "IQ": "End Item",
    "IR": "Intra Plant Routing",
    "IRN": "Importer's Reference Number to Letter of Credit",
    "IRP": "International Registration Plan Account Number",
    "IS": "Invoice Number Suffix",
    "ISC": "International Standard Industrial Classification (ISIC) "
            "Dominion of Canada Code (DCC)",
    "ISN": "International Registration Plan Sticker Number",
    "ISS": "Inspection and Survey Sequence Number",
    "IT": "Internal Customer Number",
    "IU": "Barge Permit Number",
    "IV": "Seller's Invoice Number",
    "IW": "Part Interchangeability",
    "IX": "Item Number",
    "IZ": "Insured Parcel Post Number",
    "J0": "Proceeding",
    "J1": "Creditor",
    "J2": "Attorney",
    "J3": "Judge",
    "J4": "Trustee",
    "J5": "Originating Case",
    "J6": "Adversary Case",
    "J7": "Lead Case",
    "J8": "Jointly Administered Case",
    "J9": "Substantively Consolidated Case",
    "JA": "Beginning Job Sequence Number",
    "JB": "Job (Project) Number",
    "JC": "Review",
    "JD": "User Identification",
    "JE": "Ending Job Sequence Number",
    "JF": "Automated Underwriting Reference Number",
    "JH": "Tag",
    "JI": "Multiple Listing Service Area",
    "JK": "Multiple Listing Service Sub-area",
    "JL": "Packet",
    "JM": "Multiple Listing Service Map X Coordinate",
    "JN": "Multiple Listing Service Map Y Coordinate",
    "JO": "Multiple Listing Number",
    "JP": "Multiple Listing Service Book Type",
    "JQ": "Elevation",
    "JR": "Property Component Location",
    "JS": "Job Sequence Number",
    "JT": "Prior Tax Identification Number (TIN)",
    "JU": "Prior Phone Number",
    "JV": "Prior Health Industry Number",
    "JW": "Prior Universal Provider Identification Number (UPIN)",
    "JX": "Prior Postal Zip Code",
    "JY": "Origin of Shipment Harmonized-Based Code",
    "JZ": "Governing Class Code",
    "K0": "Approval Code",
    "K1": "Foreign Military Sales Notice Number",
    "K2": "Certified Mail Number",
    "K3": "Registered Mail Number",
    "K4": "Criticality Designator",
    "K5": "Task Order",
    "K6": "Purchase Description",
    "K7": "Paragraph Number",
    "K8": "Project Paragraph Number",
    "K9": "Inquiry Request Number",
    "KA": "Distribution List",
    "KB": "Beginning Kanban Serial Number",
    "KC": "Exhibit Distribution List",
    "KD": "Special Instructions Number",
    "KE": "Ending Kanban Serial Number",
    "KF": "Pre-award Survey",
    "KG": "Foreclosing Status",
    "KH": "Type of Law Suit",
    "KI": "Type of Outstanding Judgment",
    "KJ": "Tax Lien Jurisdiction",
    "KK": "Delivery Reference",
    "KL": "Contract Reference",
    "KM": "Rental Account Number",
    "KN": "Census Automated Files ID",
    "KO": "Customs Drawback Entry Number",
    "KP": "Health Certificate Number",
    "KQ": "Procuring Agency",
    "KR": "Response to a Request for Quotation Reference",
    "KS": "Solicitation",
    "KT": "Request for Quotation Reference",
    "KU": "Office Symbol",
    "KV": "Distribution Statement Code",
    "KW": "Certification",
    "KX": "Representation",
    "KY": "Site Specific Procedures, Terms, and Conditions",
    "KZ": "Master Solicitation Procedures, Terms, and Conditions",
    "L1": "Letters or Notes",
    "L2": "Location on Product Code",
    "L3": "Labor Operation Number",
    "L4": "Proposal Paragraph Number",
    "L5": "Subexhibit Line Item Number",
    "L6": "Subcontract Line Item Number",
    "L7": "Customer's Release Number",
    "L8": "Consignee's Release Number",
    "L9": "Customer's Part Number",
    "LA": "Shipping Label Serial Number",
    "LB": "Lockbox",
    "LC": "Lease Number",
    "LD": "Loan Number",
    "LE": "Lender Entity Number",
    "LEN": "Location Exception Order Number",
    "LF": "Assembly Line Feed Location",
    "LG": "Lease Schedule Number",
    "LH": "Longitude Expressed in Seconds",
    "LI": "Line Item Identifier (Seller's)",
    "LIC": "Health Industry Business Communications Council (HIBCC) Labeler "
            "Identification Code (LIC)",
    "LJ": "Local Jurisdiction",
    "LK": "Longitude expressed in Degrees, Minutes and Seconds",
    "LL": "Latitude Expressed in Seconds",
    "LM": "Product Period for which Labor Costs are Firm",
    "LN": "Non pickup Limited Tariff Number",
    "LO": "Load Planning Number",
    "LOI": "Logical Observation Identifier Names and Codes (LOINC)",
    "LP": "For Pickup Limited Freight Tariff Number",
    "LQ": "Latitude Expressed in Degrees, Minutes and Seconds",
    "LR": "Local Student Identification Number",
    "LS": "Bar-Coded Serial Number",
    "LSD": "Logistics Support Documentation Type Code",
    "LT": "Lot Number",
    "LU": "Location Number",
    "LV": "License Plate Number",
    "LVO": "Levying Officer Identification",
    "LW": "Location Within Equipment",
    "LX": "Qualified Products List",
    "LY": "Destination of Shipment Harmonized-Based Code",
    "LZ": "Lender Account Number",
    "M1": "Material Storage Location",
    "M2": "Major Force Program",
    "M3": "Crop Year",
    "M5": "Lease Agreement Amendment Number - Master",
    "M6": "Military Ordnance Security Risk Number",
    "M7": "Medical Assistance Category",
    "M8": "Limited Partnership Identification Number",
    "M9": "Tax Shelter Number",
    "MA": "Ship Notice/Manifest Number",
    "MB": "Master Bill of Lading",
    "MBX": "Mailbox",
    "MC": "Microfilm Number",
    "MCI": "Motor Carrier Identification Number",
    "MD": "Magazine Code",
    "MDN": "Hazardous Waste Manifest Document Number",
    "ME": "Message Address or ID",
    "MF": "Manufacturers Part Number",
    "MG": "Meter Number",
    "MH": "Manufacturing Order Number",
    "MI": "Mill Order Number",
    "MJ": "Model Number",
    "MK": "Manifest Key Number",
    "ML": "Military Rank/Civilian Pay Grade Number",
    "MM": "Master Lease Agreement Number",
    "MN": "MICR Number",
    "MO": "Manufacturing Operation Number",
    "MP": "Multiple P.O.s of an Invoice",
    "MQ": "Meter Proving Report Number",
    "MR": "Merchandise Type Code",
    "MS": "Manufacturer's Material Safety Data Sheet Number",
    "MSL": "Mail Slot",
    "MT": "Meter Ticket Number",
    "MU": "Military Specification (MILSPEC) Number",
    "MV": "Migrant Number, This number is assigned by the national Migrant "
            "Records Transfer System",
    "MW": "Military Call Number",
    "MX": "Material Change Notice Number",
    "MY": "Model year number",
    "MZ": "Maintenance Request Number",
    "MZO": "Multiple Zone Order Number",
    "N0": "Nomination Number",
    "N1": "Local School Course Number",
    "N2": "Local School District Course Number",
    "N3": "Statewide Course Number",
    "N4": "United States Department of Education, National Center for "
            "Education Statistics (NCES) Course Number",
    "N5": "Provider Plan Network Identification Number",
    "N6": "Plan Network Identification Number",
    "N7": "Facility Network Identification Number",
    "N8": "Secondary Health Insurance Identification Number",
    "N9": "Data Authentication Number",
    "NA": "North American Hazardous Classification Number",
    "NAS": "National Aeronautics and Space Administration FAR Supplement "
            "(NFS)",
    "NB": "Letter of Credit Number",
    "NC": "Secondary Coverage Company Number",
    "ND": "Letter of Credit Draft Number",
    "NDA": "Abbreviated New Drug Application Number",
    "NDB": "New Drug Application Number",
    "NE": "Lease Rider Number",
    "NF": "National Association of Insurance Commissioners (NAIC) Code",
    "NFC": "National Flood Insurance Program Community Name",
    "NFD": "National Flood Insurance Program County",
    "NFM": "National Flood Insurance Program Map Number",
    "NFN": "National Flood Insurance Program Community Number",
    "NFS": "National Flood Insurance Program State",
    "NG": "Natural Gas Policy Act Category Code",
    "NH": "Rate Card Number",
    "NI": "Military Standard (MIL-STD) Number",
    "NJ": "Technical Document Number",
    "NK": "Prior Case",
    "NL": "Technical Order Number",
    "NM": "Discounter Registration Number",
    "NN": "Nonconformance Report Number",
    "NO": "No OT5 Authority-zero Mileage Rate",
    "NP": "Partial Payment Number",
    "NQ": "Medicaid Recipient Identification Number",
    "NR": "Progress Payment Number",
    "NS": "National Stock Number",
    "NT": "Administrator's Reference Number",
    "NU": "Pending Case",
    "NW": "Associated Policy Number",
    "NX": "Related Nonconformance Number",
    "NY": "Agent Claim Number",
    "NZ": "Critical Application",
    "O1": "Outer Continental Shelf Area Code",
    "O2": "Outer Continental Shelf Block Number",
    "O5": "OT5 Authority-Condition or Restriction on Car Hire Rate",
    "O7": "On-line Procurement and Accounting Control (OPAC) Transaction",
    "O8": "Original Filing",
    "O9": "Continuation Filing",
    "OA": "Outlet Number",
    "OB": "Ocean Bill of Lading",
    "OC": "Ocean Container Number",
    "OD": "Original Return Request Reference Number",
    "OE": "Open and Prepaid Station List Number",
    "OF": "Operator Identification Number",
    "OG": "Termination Filing",
    "OH": "Origin House",
    "OI": "Original Invoice Number",
    "OIC": "Object Identifier",
    "OJ": "Amendment Filing",
    "OK": "Offer Group",
    "OL": "Original Shipper's Bill of Lading Number",
    "OM": "Ocean Manifest",
    "ON": "Dealer Order Number",
    "OP": "Original Purchase Order",
    "OQ": "Order Number",
    "OR": "Order/Paragraph Number",
    "OS": "Outbound-from Party",
    "OT": "Sales Allowance Number",
    "OU": "Tariff Supplement Number",
    "OV": "Tariff Suffix Number",
    "OW": "Service Order Number",
    "OX": "Statement Number",
    "OZ": "Product Number",
    "P1": "Previous Contract Number",
    "P2": "Previous Drug Enforcement Administration Number",
    "P3": "Previous customer reference number",
    "P4": "Project Code",
    "P5": "Position Code",
    "P6": "Pipeline Number",
    "P7": "Product Line Number",
    "P8": "Pickup Reference Number",
    "P9": "Page Number",
    "PA": "Price Area Number",
    "PAC": "Patent Cooperation Treaty Application Number",
    "PAN": "Nonprovisional Patent Application Number",
    "PAP": "Provisional Patent Application Number",
    "PB": "Payer's Financial Institution Account Number for Check, Draft, or "
            "Wire Payments; Originating Company Account Number for ACH "
            "Transfers",
    "PC": "Production Code",
    "PCC": "Pool Contract Code",
    "PCN": "Protocol Number",
    "PD": "Promotion/Deal Number",
    "PDL": "Previous Driver's License",
    "PE": "Plant Number",
    "PF": "Prime Contractor Contract Number",
    "PG": "Product Group",
    "PGC": "Packing Group Code",
    "PGN": "Plug Number",
    "PGS": "Proposed Group Work Candidate Sequence Number",
    "PH": "Priority Rating",
    "PHC": "Process Handling Code",
    "PI": "Price List Change or Issue Number",
    "PID": "Program Identification Number",
    "PIN": "Platform Indentification Number",
    "PJ": "Packer Number",
    "PK": "Packing List Number",
    "PL": "Price List Number",
    "PLA": "Product Licensing Agreement Number",
    "PLN": "Proposed Contract Number",
    "PM": "Part Number",
    "PMN": "Premarket Application Number",
    "PN": "Permit Number",
    "PNN": "Patent Number",
    "PO": "Purchase Order Number",
    "POL": "Policy Number",
    "PP": "Purchase Order Revision Number",
    "PQ": "Payee Identification",
    "PR": "Price Quote Number",
    "PRS": "Previously Reported Social Security Number",
    "PRT": "Product Type",
    "PS": "Purchase Order Number Suffix",
    "PSI": "Previous Shipment Identification Number - Continuous Move",
    "PSL": "Next Shipment Identification Number - Continuous Move",
    "PSM": "Credit Card",
    "PSN": "Proposed Sequence Number",
    "PT": "Purchase Option Agreement",
    "PTC": "Patent Type",
    "PU": "Previous Bill of Lading Number",
    "PV": "Product change information number",
    "PW": "Prior purchase order number",
    "PWC": "Preliminary Work Candidate Number",
    "PWS": "Proposed Work Candidate Sequence Number",
    "PX": "Previous Invoice Number",
    "PY": "Payee's Financial Institution Account Number for Check, Draft or "
            "Wire Payments; Receiving Company Account Number for ACH Transfer",
    "PZ": "Product Change Notice Number",
    "Q1": "Quote Number",
    "Q2": "Starting Package Number",
    "Q3": "Ending Package Number",
    "Q4": "Prior Identifier Number",
    "Q5": "Property Control Number",
    "Q6": "Recall Number",
    "Q7": "Receiver Claim Number",
    "Q8": "Registration Number",
    "Q9": "Repair Order Number",
    "QA": "Press Identifier",
    "QB": "Press Form Identifier",
    "QC": "Product Specification Document Number",
    "QD": "Replacement Drug Enforcement Administration Number",
    "QE": "Replacement Customer Reference Number",
    "QF": "Quality Disposition Area Identifier",
    "QG": "Replacement Assembly Model Number",
    "QH": "Replacement Assembly Serial Number",
    "QI": "Quality Inspection Area Identifier",
    "QJ": "Return Material Authorization Number",
    "QK": "Sales Program Number",
    "QL": "Service Authorization Number",
    "QM": "Quality Review Material Crib Identifier",
    "QN": "Stop Sequence Number",
    "QO": "Service Estimate Number",
    "QP": "Substitute Part Number",
    "QQ": "Unit Number",
    "QR": "Quality Report Number",
    "QS": "Warranty Coverage Code",
    "QT": "Warranty Registration Number",
    "QU": "Change Verification Procedure Code",
    "QV": "Major System Affected Code",
    "QW": "New Part Number",
    "QX": "Old Part Number",
    "QY": "Service Performed Code",
    "QZ": "Reference Drawing Number",
    "R0": "Regiristo Federal de Contribuyentes (Mexican Federal Tax ID "
            "Number)",
    "R1": "Current Revision Number",
    "R2": "Canceled Revision Number",
    "R3": "Correction Number",
    "R4": "Tariff Section Number",
    "R5": "Tariff Page Number",
    "R6": "Tariff Rule Number",
    "R7": "Accounts Receivable Open Item",
    "R8": "Rental Agreement Number",
    "R9": "Rejection Number",
    "RA": "Repetitive Cargo Shipment Number",
    "RAA": "Restricted Availability Authorization",
    "RAN": "Restricted Availability Number",
    "RB": "Rate code number",
    "RC": "Rail Routing Code",
    "RD": "Reel Number",
    "RE": "Release Number",
    "REC": "Related Case",
    "RF": "Export Reference Number",
    "RG": "Route Order Number-Domestic",
    "RGI": "Regulatory Guideline Identifier",
    "RH": "Route Order Number-Export",
    "RI": "Release invoice number for prior bill and hold",
    "RIG": "Rig Number",
    "RJ": "Route Order Number-Emergency",
    "RK": "Rack Type Number",
    "RL": "Reserve Assembly Line Feed Location",
    "RM": "Raw material supplier Dun & Bradstreet number",
    "RN": "Run Number",
    "RO": "Repetitive Booking Number",
    "RP": "Repetitive Pattern Code",
    "RPP": "Relative Priority",
    "RPT": "Report Number",
    "RQ": "Purchase Requisition Number",
    "RR": "Payer's Financial Institution Transit Routing Number for Check, "
            "Draft or Wire Payments. Originating Depository Financial "
            "Institution Routing Number for ACH Transfers",
    "RRS": "Reconciliation Report Section Identification Code",
    "RS": "Returnable Container Serial Number",
    "RSN": "Reservation Number",
    "RT": "Payee's Financial Institution Transit Routing Number for Check, "
            "Draft or Wire Payments. Receiving Depository Financial "
            "Institution Transit Routing Number for ACH Transfers",
    "RU": "Route Number",
    "RV": "Receiving Number",
    "RW": "Repetitive Waybill Code (Origin Carrier, Standard Point Location "
            "Code, Repetitive Waybill Code Number)",
    "RX": "Resubmit number",
    "RY": "Rebate Number",
    "RZ": "Returned Goods Authorization Number",
    "S0": "Special Approval",
    "S1": "Engineering Specification Number",
    "S2": "Data Source",
    "S3": "Specification Number",
    "S4": "Shippers Bond Number",
    "S5": "Routing Instruction Number",
    "S6": "Stock Number",
    "S7": "Stack Train Identification",
    "S8": "Seal Off Number",
    "S9": "Seal On Number",
    "SA": "Salesperson",
    "SB": "Sales Region Number",
    "SBN": "Surety Bond Number",
    "SC": "Shipper Car Order Number",
    "SCA": "Standard Carrier Alpha Code (SCAC)",
    "SD": "Subday Number",
    "SE": "Serial Number",
    "SEK": "Search Key",
    "SES": "Session",
    "SF": "Ship From",
    "SG": "Savings",
    "SH": "Sender Defined Clause",
    "SHL": "Shelf Life Indicator",
    "SI": "Shipper's Identifying Number for Shipment (SID)",
    "SJ": "Set Number",
    "SK": "Service Change Number",
    "SL": "Sales/Territory Code",
    "SM": "Sales Office Number",
    "SN": "Seal Number",
    "SNH": "Systematized Nomenclature of Human and Veterinary Medicine "
            "(SNOMED)",
    "SNV": "State Non-Resident Violator Compact",
    "SO": "Shipper's Order (Invoice Number)",
    "SP": "Scan Line",
    "SPL": "Standard Point Location Code (SPLC)",
    "SPN": "Theater Screen Number",
    "SQ": "Container Sequence Number",
    "SR": "Sales Responsibility",
    "SS": "Split Shipment Number",
    "ST": "Store Number",
    "STB": "Standard Transportation Commodity Code (STCC) Bridge Number",
    "STR": "Standard Transportation Commodity Code (STCC) Replacement Code",
    "SU": "Special Processing Code",
    "SUB": "Title Reference",
    "SUO": "Spacing Unit Order Number",
    "SV": "Service Charge Number",
    "SW": "Seller's Sale Number",
    "SX": "Service Interrupt Tracking Number",
    "SY": "Social Security Number",
    "SZ": "Specification Revision",
    "T0": "Dealer Type Identification",
    "T1": "Tax Exchange Code",
    "T2": "Tax Form Code",
    "T3": "Tax Schedule Code",
    "T4": "Signal Code",
    "T5": "Trailer Use Agreements",
    "T6": "Tax Filing",
    "T7": "Affected Subsystem Code",
    "T8": "Description of Change Code",
    "T9": "Documentation Affected Number",
    "TA": "Telecommunication Circuit Supplemental ID",
    "TB": "Trucker's Bill of Lading",
    "TC": "Vendor Terms",
    "TD": "Reason for Change",
    "TDT": "Technical Documentation Type",
    "TE": "Federal Maritime Commission (FMC) Tariff Number",
    "TF": "Transfer Number",
    "TG": "Transportation Control Number (TCN)",
    "TH": "Transportation Account Code (TAC)",
    "TI": "TIR Number",
    "TIP": "Technical Information Package",
    "TJ": "Federal Taxpayer's Identification Number",
    "TK": "Tank Number",
    "TL": "Tax License Exemption",
    "TM": "Travel Manifest (ACI or OTR)",
    "TN": "Transaction Reference Number",
    "TO": "Terminal Operator Number",
    "TOC": "Type of Comment",
    "TP": "Test Specification Number",
    "TPN": "Transponder Number",
    "TQ": "Tracer Action Request Number",
    "TR": "Government Transportation Request",
    "TS": "Tariff Number",
    "TSN": "Template Sequence Number",
    "TT": "Terminal Code",
    "TU": "Trial Location Code",
    "TV": "Line of Business",
    "TW": "Tax Worksheet",
    "TX": "Tax Exempt Number",
    "TY": "Policy Type",
    "TZ": "Total Cycle Number",
    "U0": "Consolidator's Receipt Number",
    "U1": "Regional Account Number",
    "U2": "Term",
    "U3": "Unique Supplier Identification Number (USIN)",
    "U4": "Unpaid Installment Reference Number",
    "U5": "Successor Account",
    "U6": "Predecessor Account",
    "U8": "Mortgage Backed Security (MBS) Loan Number",
    "U9": "Mortgage Backed Security (MBS) Pool Number",
    "UA": "Mortgage Number",
    "UB": "Unacceptable Source Purchaser ID",
    "UC": "Mortgage Insurance Indicator Number",
    "UD": "Unacceptable Source DUNS Number",
    "UE": "Secondary Coverage Certificate Number",
    "UF": "Mortgage Insurance Company Number",
    "UG": "U.S. Government Transportation Control Number",
    "UH": "Removal Number",
    "UI": "Previous Course Number",
    "UJ": "Current or Latest Course Number",
    "UK": "Equivalent Course Number at Requesting Institution",
    "UL": "Cross-listed Course Number",
    "UM": "Quarter Quarter Section Number",
    "UN": "United Nations Hazardous Classification Number",
    "UO": "Quarter Quarter Spot Number",
    "UP": "Upstream Shipper Contract Number",
    "UQ": "Section Number",
    "UR": "Unit Relief Number",
    "URL": "Uniform Resource Locator",
    "US": "Unacceptable Source Supplier ID",
    "UT": "Unit Train",
    "UU": "Township Number",
    "UV": "Range Number",
    "UW": "State Senate District",
    "UX": "State Assembly District",
    "UY": "Federal National Mortgage Association (Fannie Mae) Loan Number",
    "UZ": "State Legislative District",
    "V0": "Version",
    "V1": "Volume Purchase Agreement Number",
    "V2": "Visa Type",
    "V3": "Voyage Number",
    "V4": "State Department I-20 Form Number",
    "V5": "State Department IAP-66 Form Number",
    "V6": "North American Free Trade Agreement (NAFTA) Compliance Number",
    "V7": "Judicial District",
    "V8": "Institution Number",
    "V9": "Subservicer",
    "VA": "Vessel Agent Number",
    "VB": "Department of Veterans Affairs Acquisition Regulations (VAAR)",
    "VC": "Vendor Contract Number",
    "VD": "Volume Number",
    "VE": "Vendor Abbreviation Code",
    "VF": "Vendor Change Identification Code",
    "VG": "Vendor Change Procedure Code",
    "VH": "County Legislative District",
    "VI": "Pool Number",
    "VJ": "Investor Note Holder Identification",
    "VK": "Institution Note Holder Identification",
    "VL": "Third Party Note Holder Identification",
    "VM": "Ward",
    "VN": "Vendor Order Number",
    "VO": "Institution Loan Number",
    "VP": "Vendor Product Number",
    "VQ": "Related Contract Line Item Number",
    "VR": "Vendor ID Number",
    "VS": "Vendor Order Number Suffix",
    "VT": "Motor Vehicle ID Number",
    "VU": "Preparer's Verification Number",
    "VV": "Voucher",
    "VW": "Standard",
    "VX": "Value-Added Tax Registration Number (Europe)",
    "VY": "Link Sequence Number",
    "VZ": "Sponsor's Reference Number",
    "W1": "Disposal Turn-In Document Number",
    "W2": "Weapon System Number",
    "W3": "Manufacturing Directive Number",
    "W4": "Procurement Request Number",
    "W5": "Inspector Identification Number",
    "W6": "Federal Supply Schedule Number",
    "W7": "Commercial and Government Entity (CAGE) Code",
    "W8": "Suffix",
    "W9": "Special Packaging Instruction Number",
    "WA": "Labor or Affiliation Identification",
    "WB": "American Petroleum Institute (API) Well",
    "WC": "Contract Option Number",
    "WCS": "Work Candidate Sequence Number",
    "WD": "Review Period Number",
    "WDR": "Withdrawal Record",
    "WE": "Well Classification Code",
    "WF": "Locally Assigned Control Number",
    "WG": "Vendor's Previous Job Number",
    "WH": "Master Reference (Link) Number",
    "WI": "Waiver",
    "WJ": "Pre-Award Survey",
    "WK": "Type of Science Code",
    "WL": "Federal Supply Classification Code",
    "WM": "Weight Agreement Number",
    "WN": "Well Number",
    "WO": "Work Order Number",
    "WP": "Warehouse Pick Ticket Number",
    "WQ": "Interim Funding Organization Loan Number",
    "WR": "Warehouse Receipt Number",
    "WS": "Warehouse storage location number",
    "WT": "Broker's Reference Number",
    "WU": "Vessel",
    "WV": "Dealer Identification",
    "WW": "Depository Trust Company Identification",
    "WX": "Distributor's Account Identification",
    "WY": "Waybill Number",
    "WZ": "Distributor's Representative Identification",
    "X0": "Debtor's Account",
    "X1": "Provider Claim Number",
    "X2": "Specification Class Number",
    "X3": "Defect Code Number",
    "X4": "Clinical Laboratory Improvement Amendment Number",
    "X5": "State Industrial Accident Provider Number",
    "X6": "Original Voucher Number",
    "X7": "Batch Sequence Number",
    "X8": "Secondary Suffix Code Indicator",
    "X9": "Internal Control Number",
    "XA": "Substitute National Stock Number",
    "XB": "Substitute Manufacturer's Part Number",
    "XC": "Cargo Control Number",
    "XD": "Subsistence Identification Number",
    "XE": "Transportation Priority Number",
    "XF": "Government Bill of Lading Office Code",
    "XG": "Airline Ticket Number",
    "XH": "Contract Auditor ID Number",
    "XI": "Federal Home Loan Mortgage Corporation Loan Number",
    "XJ": "Federal Home Loan Mortgage Corporation Default/Foreclosure "
            "Specialist Number",
    "XK": "Mortgagee Loan Number",
    "XL": "Insured's Loan Number",
    "XM": "Issuer Number",
    "XN": "Title XIX Identifier Number",
    "XO": "Sample Number",
    "XP": "Previous Cargo Control Number",
    "XQ": "Pier Number",
    "XR": "Railroad Commission Record Number",
    "XS": "Gas Analysis Source Meter Number",
    "XT": "Toxicology ID",
    "XU": "Universal Transverse Mercator - North",
    "XV": "Universal Transverse Mercator - East",
    "XW": "Universal Transverse Mercator - Zone",
    "XX": "Rating Period",
    "XY": "Other Unlisted Type of Reference Number",
    "XZ": "Pharmacy Prescription Number",
    "Y0": "Debtor",
    "Y1": "Claim Administrator Claim Number",
    "Y2": "Third-Party Administrator Claim Number",
    "Y3": "Contract Holder Claim Number",
    "Y4": "Agency Claim Number",
    "Y5": "Delivery Trailer Manifest",
    "Y6": "Sort and Segregate",
    "Y7": "Processing Area",
    "Y8": "User ID",
    "Y9": "Current Certificate Number",
    "YA": "Prior Certificate Number",
    "YB": "Revision Number",
    "YC": "Tract",
    "YD": "Buyer Identification",
    "YE": "Railroad Commission Oil Number",
    "YF": "Lessee Identification",
    "YG": "Operator Identification",
    "YH": "Operator Assigned Unit Number",
    "YI": "Refiner Identification",
    "YJ": "Revenue Source",
    "YK": "Rent Payor Identification",
    "YL": "Allowance Recipient Identification",
    "YM": "Resource Screening Reference",
    "YN": "Receiver ID Qualifier",
    "YO": "Formation",
    "YP": "Selling Arrangement",
    "YQ": "Minimum Royalty Payor Identification",
    "YR": "Operator Lease Number",
    "YS": "Yard Position",
    "YT": "Reporter Identification",
    "YU": "Payor Identification",
    "YV": "Participating Area",
    "YW": "Engineering Change Proposal",
    "YX": "Geographic Score",
    "YY": "Geographic Key",
    "YZ": "Geographic Index",
    "Z1": "Safety of Ship Certificate",
    "Z2": "Safety of Radio Certificate",
    "Z3": "Safety Equipment Certificate",
    "Z4": "Civil Liabilities of Oil Certificate",
    "Z5": "Load Line Certificate",
    "Z6": "Derat Certificate",
    "Z7": "Maritime Declaration of Health",
    "Z8": "Federal Housing Administration Case Number",
    "Z9": "Veterans Affairs Case Number",
    "ZA": "Supplier",
    "ZB": "Ultimate Consignee",
    "ZC": "Connecting Carrier",
    "ZD": "Family Member Identification",
    "ZE": "Coal Authority Number",
    "ZF": "Contractor Establishment Code (CEC)",
    "ZG": "Sales Representative Order Number",
    "ZH": "Carrier Assigned Reference Number",
    "ZI": "Reference Version Number",
    "ZJ": "Universal Railroad Revenue Waybill Identified Number (URRWIN)",
    "ZK": "Duplicate Waybill in Route",
    "ZL": "Duplicate Waybill Not in Route",
    "ZM": "Manufacturer Number",
    "ZN": "Agency Case Number",
    "ZO": "Makegood Commercial Line Number",
    "ZP": "Spouse Tie",
    "ZQ": "Non-Spouse Tie",
    "ZR": "Supplier (Replacement)",
    "ZS": "Software Application Number",
    "ZT": "Milling in Transit",
    "ZU": "Field",
    "ZV": "Block",
    "ZW": "Area",
    "ZX": "County Code",
    "ZY": "Referenced Pattern Identification",
    "ZZ": "Mutually Defined",
}

id_code_qualifier = {
    "1": "D-U-N-S Number, Dun & Bradstreet",
    "2": "Standard Carrier Alpha Code (SCAC)",
    "3": "Federal Maritime Commission (Ocean) (FMC)",
    "4": "International Air Transport Association (IATA)",
    "5": "SIRET",
    "6": "Plant Code",
    "7": "Loading Dock",
    "8": "UCC/EAN Global Product Identification Prefix",
    "9": "D-U-N-S+4, D-U-N-S Number with Four Character Suffix",
    "10": "Department of Defense Activity Address Code (DODAAC)",
    "11": "Drug Enforcement Administration (DEA)",
    "12": "Telephone Number (Phone)",
    "13": "Federal Reserve Routing Code (FRRC)",
    "14": "UCC/EAN Location Code Prefix",
    "15": "Standard Address Number (SAN)",
    "16": "ZIP Code",
    "17": "Automated Broker Interface (ABI) Routing Code",
    "18": "Automotive Industry Action Group (AIAG)",
    "19": "FIPS-55 (Named Populated Places)",
    "20": "Standard Point Location Code (SPLC)",
    "21": "Health Industry Number (HIN)",
    "22": "Council of Petroleum Accounting Societies code (COPAS)",
    "23": "Journal of Commerce (JOC)",
    "24": "Employer's Identification Number",
    "25": "Carrier's Customer Code",
    "26": "Petroleum Accountants Society of Canada Company Code",
    "27": "Government Bill Of Lading Office Code (GBLOC)",
    "28": "American Paper Institute",
    "29": "Grid Location and Facility Code",
    "30": "American Petroleum Institute Location Code",
    "31": "Bank Identification Code",
    "32": "Assigned by Property Operator",
    "33": "Commercial and Government Entity (CAGE)",
    "34": "Social Security Number",
    "35": "Electronic Mail Internal System Address Code",
    "36": "Customs House Broker License Number",
    "37": "United Nations Vendor Code",
    "38": "Country Code",
    "39": "Local Union Number",
    "40": "Electronic Mail User Code",
    "41": "Telecommunications Carrier Identification Code",
    "42": "Telecommunications Pseudo Carrier Identification Code",
    "43": "Alternate Social Security Number",
    "44": "Return Sequence Number",
    "45": "Declaration Control Number",
    "46": "Electronic Transmitter Identification Number (ETIN)",
    "47": "Tax Authority Identification",
    "48": "Electronic Filer Identification Number (EFIN)",
    "49": "State Identification Number",
    "50": "Business License Number",
    "53": "Building",
    "54": "Warehouse",
    "55": "Post Office Box",
    "56": "Division",
    "57": "Department",
    "58": "Originating Company Number",
    "59": "Receiving Company Number",
    "61": "Holding Mortgagee Number",
    "62": "Servicing Mortgagee Number",
    "63": "Servicer-holder Mortgagee Number",
    "64": "One Call Agency",
    "71": "Integrated Postsecondary Education Data System (IPEDS) set of "
            "codes maintained by the U.S. Department of Education's National "
            "Center of Education Statistics, Washington, D.C.",
    "72": "The College Board's Admission Testing Program (ATP), administered "
            "by the Educational Testing Service (ETS), 4-digit list of "
            "postsecondary educational institutions.",
    "73": "Federal Interagency Commission on Education (FICE) number. "
            "Available from the United States Department of Education, "
            "National Center for Education Statistics.",
    "74": "American College Testing (ACT) list of postsecondary educational "
            "institutions.",
    "75": "State or Province Assigned Number",
    "76": "Local School District or Jurisdiction Number",
    "77": "National Center for Education Statistics (NCES) Common Core of "
            "Data (CCD) number for PreK - 12 institutions",
    "78": "The College Board and ACT 6 digit code list of secondary "
            "educational institutions",
    "81": "Classification of Instructional Programs (CIP) coding structure "
            "maintained by the U.S. Department of Education's National Center "
            "for Education Statistics",
    "82": "Higher Education General Information Survey (HEGIS) maintained by "
            "the U.S. Department of Education's National Center for Education "
            "Statistics",
    "90": "California Ethnic Subgroups Code Table",
    "91": "Assigned by Seller or Seller's Agent",
    "92": "Assigned by Buyer or Buyer's Agent",
    "93": "Code assigned by the organization originating the transaction set",
    "94": "Code assigned by the organization that is the ultimate destination "
            "of the transaction set",
    "95": "Assigned By Transporter",
    "96": "Assigned By Pipeline Operator",
    "97": "Receiver's Code",
    "98": "Purchasing Office",
    "99": "Office of Workers Compensation Programs (OWCP) Agency Code",
    "A": "U.S. Customs Carrier Identification",
    "A1": "Approver ID",
    "A2": "Military Assistance Program Address Code (MAPAC)",
    "A3": "Assigned by Third Party",
    "A4": "Assigned by Clearinghouse",
    "A5": "Committee for Uniform Security Identification Procedures (CUSIP) "
            "Number",
    "A6": "Financial Identification Numbering System (FINS) Number",
    "AA": "Postal Service Code",
    "AB": "US Environmental Protection Agency (EPA) Identification Number",
    "AC": "Attachment Control Number",
    "AD": "Blue Cross Blue Shield Association Plan Code",
    "AE": "Alberta Energy Resources Conservation Board",
    "AL": "Anesthesia License Number",
    "AP": "Alberta Petroleum Marketing Commission",
    "BC": "British Columbia Ministry of Energy Mines and Petroleum Resources",
    "BD": "Blue Cross Provider Number",
    "BE": "Common Language Location Identification (CLLI)",
    "BG": "Badge Number",
    "BP": "Benefit Plan",
    "BS": "Blue Shield Provider Number",
    "C": "Insured's Changed Unique Identification Number",
    "C1": "Insured or Subscriber",
    "C2": "Health Maintenance Organization (HMO) Provider Number",
    "C5": "Customer Identification File",
    "CA": "Statistics Canada Canadian College Student Information System "
            "Course Codes",
    "CB": "Statistics Canada Canadian College Student Information System "
            "Institution Codes",
    "CC": "Statistics Canada University Student Information System "
            "Curriculum Codes",
    "CD": "Contract Division",
    "CE": "Bureau of the Census Filer Identification Code",
    "CF": "Canadian Financial Institution Routing Number",
    "CI": "CHAMPUS (Civilian Health and Medical Program of the Uniformed "
            "Services) Identification Number",
    "CL": "Corrected Loan Number",
    "CM": "U.S. Customs Service (USCS) Manufacturer Identifier (MID)",
    "CP": "Canadian Petroleum Association",
    "CR": "Credit Repository",
    "CS": "Statistics Canada University Student Information System University "
            "Codes",
    "CT": "Court Identification Code",
    "D": "Census Schedule D",
    "DG": "United States Department of Education Guarantor Identification "
            "Code",
    "DL": "United States Department of Education Lender Identification Code",
    "DN": "Dentist License Number",
    "DP": "Data Processing Point",
    "DS": "United States Department of Education School Identification Code",
    "E": "Hazard Insurance Policy Number",
    "EC": "ARI Electronic Commerce Location ID Code",
    "EH": "Theatre Number",
    "EI": "Employee Identification Number",
    "EP": "U.S. Environmental Protection Agency (EPA)",
    "EQ": "Insurance Company Assigned Identification Number",
    "ER": "Mortgagee Assigned Identification Number",
    "ES": "Automated Export System (AES) Filer Identification Code",
    "F": "Document Custodian Identification Number",
    "FA": "Facility Identification",
    "FB": "Field Code",
    "FC": "Federal Court Jurisdiction Identifier",
    "FD": "Federal Court Divisional Office Number",
    "FI": "Federal Taxpayer's Identification Number",
    "FJ": "Federal Jurisdiction",
    "FN": "U.S. Environmental Protection Agency (EPA) Laboratory "
            "Certification Identification",
    "G": "Payee Identification Number",
    "GA": "Primary Agent Identification",
    "GC": "GAS*CODE",
    "HC": "Health Care Financing Administration",
    "HN": "Health Insurance Claim (HIC) Number",
    "I": "Secondary Marketing Investor Assigned Number",
    "J": "Mortgage Electronic Registration System Organization Identifier",
    "K": "Census Schedule K",
    "L": "Investor Assigned Identification Number",
    "LC": "Agency Location Code (U.S. Government)",
    "LD": "NISO Z39.53 Language Codes",
    "LE": "ISO 639 Language Codes",
    "LI": "Labeler Identification Code (LIC)",
    "LN": "Loan Number",
    "M3": "Disbursing Station",
    "M4": "Department of Defense Routing Identifier Code (RIC)",
    "M5": "Jurisdiction Code",
    "M6": "Division Office Code",
    "MA": "Mail Stop",
    "MB": "Medical Information Bureau",
    "MC": "Medicaid Provider Number",
    "MD": "Manitoba Department of Mines and Resources",
    "MI": "Member Identification Number",
    "MK": "Market",
    "ML": "Multiple Listing Service Vendor - Multiple Listing Service "
            "Identification",
    "MN": "Mortgage Identification Number",
    "MP": "Medicare Provider Number",
    "MR": "Medicaid Recipient Identification Number",
    "N": "Insured's Unique Identification Number",
    "NA": "National Association of Realtors - Multiple Listing Service "
            "Identification",
    "ND": "Mode Designator",
    "NI": "National Association of Insurance Commissioners (NAIC) "
            "Identification",
    "NO": "National Criminal Information Center Originating Agency",
    "OC": "Occupation Code",
    "OP": "On-line Payment and Collection",
    "PA": "Secondary Agent Identification",
    "PB": "Public Identification",
    "PC": "Provider Commercial Number",
    "PI": "Payor Identification",
    "PP": "Pharmacy Processor Number",
    "PR": "Pier",
    "RA": "Regulatory Agency Number",
    "RB": "Real Estate Agent",
    "RC": "Real Estate Company",
    "RD": "Real Estate Broker Identification",
    "RE": "Real Estate License Number",
    "RT": "Railroad Track",
    "S": "Title Insurance Policy Number",
    "SA": "Tertiary Agent Identification",
    "SB": "Social Insurance Number",
    "SD": "Saskatchewan Department of Energy Mines and Resources",
    "SF": "Suffix Code",
    "SI": "Standard Industry Code (SIC)",
    "SJ": "State Jurisdiction",
    "SL": "State License Number",
    "SP": "Specialty License Number",
    "ST": "State/Province License Tag",
    "SV": "Service Provider Number",
    "SW": "Society for Worldwide Interbank Financial Telecommunications "
            "(SWIFT) Address",
    "TA": "Taxpayer ID Number",
    "TC": "Internal Revenue Service Terminal Code",
    "TZ": "Department Code",
    "UC": "Consumer Credit Identification Number",
    "UL": "UCC/EAN Location Code",
    "UM": "UCC/EAN Location Code Suffix",
    "UP": "Unique Physician Identification Number (UPIN)",
    "UR": "Uniform Resource Locator (URL)",
    "US": "Unique Supplier Identification Number (USIN)",
    "WR": "Wine Region Code",
    "XV": "Health Care Financing Administration National PlanIDRequired if "
            "the National PlanID is mandated for use. Otherwise, one of the "
            "other listed codes may be used.",
    "XX": "Health Care Financing Administration National Provider Identifier",
    "ZC": "Contractor Establishment Code",
    "ZN": "Zone",
    "ZY": "Temporary Identification Number",
    "A": "temporary ID to be used until a permanent ID is processed",
    "ZZ": "Mutually Defined",
}

date_or_time_qualifier = {
    "001": "Cancel After",
    "002": "Delivery Requested",
    "003": "Invoice",
    "004": "Purchase Order",
    "005": "Sailing",
    "006": "Sold",
    "007": "Effective",
    "008": "Purchase Order Received",
    "009": "Process",
    "010": "Requested Ship",
    "011": "Shipped",
    "012": "Terms Discount Due",
    "013": "Terms Net Due",
    "014": "Deferred Payment",
    "015": "Promotion Start",
    "016": "Promotion End",
    "017": "Estimated Delivery",
    "018": "Available",
    "019": "Unloaded",
    "020": "Check",
    "021": "Charge Back",
    "022": "Freight Bill",
    "023": "Promotion Order - Start",
    "024": "Promotion Order - End",
    "025": "Promotion Ship - Start",
    "026": "Promotion Ship - End",
    "027": "Promotion Requested Delivery - Start",
    "028": "Promotion Requested Delivery - End",
    "029": "Promotion Performance - Start",
    "030": "Promotion Performance - End",
    "031": "Promotion Invoice Performance - Start",
    "032": "Promotion Invoice Performance - End",
    "033": "Promotion Floor Stock Protect - Start",
    "034": "Promotion Floor Stock Protect - End",
    "035": "Delivered",
    "036": "Expiration",
    "037": "Ship Not Before",
    "038": "Ship No Later",
    "039": "Ship Week of",
    "040": "Status (After and Including)",
    "041": "Status (Prior and Including)",
    "042": "Superseded",
    "043": "Publication",
    "044": "Settlement Date as Specified by the Originator",
    "045": "Endorsement Date",
    "046": "Field Failure",
    "047": "Functional Test",
    "048": "System Test",
    "049": "Prototype Test",
    "050": "Received",
    "051": "Cumulative Quantity Start",
    "052": "Cumulative Quantity End",
    "053": "Buyers Local",
    "054": "Sellers Local",
    "055": "Confirmed",
    "056": "Estimated Port of Entry",
    "057": "Actual Port of Entry",
    "058": "Customs Clearance",
    "059": "Inland Ship",
    "060": "Engineering Change Level",
    "061": "Cancel if Not Delivered by",
    "062": "Blueprint",
    "063": "Do Not Deliver After",
    "064": "Do Not Deliver Before",
    "065": "1st Schedule Delivery",
    "066": "1st Schedule Ship",
    "067": "Current Schedule Delivery",
    "068": "Current Schedule Ship",
    "069": "Promised for Delivery",
    "070": "Scheduled for Delivery (After and Including)",
    "071": "Requested for Delivery (After and Including)",
    "072": "Promised for Delivery (After and Including)",
    "073": "Scheduled for Delivery (Prior to and Including)",
    "074": "Requested for Delivery (Prior to and Including)",
    "075": "Promised for Delivery (Prior to and Including)",
    "076": "Scheduled for Delivery (Week of)",
    "077": "Requested for Delivery (Week of)",
    "078": "Promised for Delivery (Week of)",
    "079": "Promised for Shipment",
    "080": "Scheduled for Shipment (After and Including)",
    "081": "Requested for Shipment (After and Including)",
    "082": "Promised for Shipment (After and Including)",
    "083": "Scheduled for Shipment (Prior to and Including)",
    "084": "Requested for Shipment (Prior to and Including)",
    "085": "Promised for Shipment (Prior to and Including)",
    "086": "Scheduled for Shipment (Week of)",
    "087": "Requested for Shipment (Week of)",
    "088": "Promised for Shipment (Week of)",
    "089": "Inquiry",
    "090": "Report Start",
    "091": "Report End",
    "092": "Contract Effective",
    "093": "Contract Expiration",
    "094": "Manufacture",
    "095": "Bill of Lading",
    "096": "Discharge",
    "097": "Transaction Creation",
    "098": "Bid (Effective)",
    "099": "Bid Open (Date Bids Will Be Opened)",
    "100": "No Shipping Schedule Established as of",
    "101": "No Production Schedule Established as of",
    "102": "Issue",
    "103": "Award",
    "104": "System Survey",
    "105": "Quality Rating",
    "106": "Required By",
    "107": "Deposit",
    "108": "Postmark",
    "109": "Received at Lockbox",
    "110": "Originally Scheduled Ship",
    "111": "Manifest/Ship Notice",
    "112": "Buyers Dock",
    "113": "Sample Required",
    "114": "Tooling Required",
    "115": "Sample Available",
    "116": "Scheduled Interchange Delivery",
    "118": "Requested Pick-up",
    "119": "Test Performed",
    "120": "Control Plan",
    "121": "Feasibility Sign Off",
    "122": "Failure Mode Effective",
    "124": "Group Contract Effective",
    "125": "Group Contract Expiration",
    "126": "Wholesale Contract Effective",
    "127": "Wholesale Contract Expiration",
    "128": "Replacement Effective",
    "129": "Customer Contract Effective",
    "130": "Customer Contract Expiration",
    "131": "Item Contract Effective",
    "132": "Item Contract Expiration",
    "133": "Accounts Receivable - Statement Date",
    "134": "Ready for Inspection",
    "135": "Booking",
    "136": "Technical Rating",
    "137": "Delivery Rating",
    "138": "Commerical Rating",
    "139": "Estimated",
    "140": "Actual",
    "141": "Assigned",
    "142": "Loss",
    "143": "Due Date of First Payment to Principal and Interest",
    "144": "Estimated Acceptance",
    "145": "Opening Date",
    "146": "Closing Date",
    "147": "Due Date Last Complete Installment Paid",
    "148": "Date of Local Office Approval of Conveyance of Damaged Real "
            "Estate Property",
    "149": "Date Deed Filed for Record",
    "150": "Service Period Start",
    "151": "Service Period End",
    "152": "Effective Date of Change",
    "153": "Service Interruption",
    "154": "Adjustment Period Start",
    "155": "Adjustment Period End",
    "156": "Allotment Period Start",
    "157": "Test Period Start",
    "158": "Test Period Ending",
    "159": "Bid Price Exception",
    "160": "Samples to be Returned By",
    "161": "Loaded on Vessel",
    "162": "Pending Archive",
    "163": "Actual Archive",
    "164": "First Issue",
    "165": "Final Issue",
    "166": "Message",
    "167": "Most Recent Revision (or Initial Version)",
    "168": "Release",
    "169": "Product Availability Date",
    "170": "Supplemental Issue",
    "171": "Revision",
    "172": "Correction",
    "173": "Week Ending",
    "174": "Month Ending",
    "175": "Cancel if not shipped by",
    "176": "Expedited on",
    "177": "Cancellation",
    "178": "Hold (as of)",
    "179": "Hold as Stock (as of)",
    "180": "No Promise (as of)",
    "181": "Stop Work (as of)",
    "182": "Will Advise (as of)",
    "183": "Connection",
    "184": "Inventory",
    "185": "Vessel Registry",
    "186": "Invoice Period Start",
    "187": "Invoice Period End",
    "188": "Credit Advice",
    "189": "Debit Advice",
    "190": "Released to Vessel",
    "191": "Material Specification",
    "192": "Delivery Ticket",
    "193": "Period Start",
    "194": "Period End",
    "195": "Contract Re-Open",
    "196": "Start",
    "197": "End",
    "198": "Completion",
    "199": "Seal",
    "200": "Assembly Start",
    "201": "Acceptance",
    "202": "Master Lease Agreement",
    "203": "First Produced",
    "204": "Official Rail Car Interchange (Either Actual or Agreed Upon)",
    "205": "Transmitted",
    "206": "Status (Outside Processor)",
    "207": "Status (Commercial)",
    "208": "Lot Number Expiration",
    "209": "Contract Performance Start",
    "210": "Contract Performance Delivery",
    "211": "Service Requested",
    "212": "Returned to Customer",
    "213": "Adjustment to Bill Dated",
    "214": "Date of Repair/Service",
    "215": "Interruption Start",
    "216": "Interruption End",
    "217": "Spud",
    "218": "Initial Completion",
    "219": "Plugged and Abandoned",
    "220": "Penalty",
    "221": "Penalty Begin",
    "222": "Birth",
    "223": "Birth Certificate",
    "224": "Adoption",
    "225": "Christening",
    "226": "Lease Commencement",
    "227": "Lease Term Start",
    "228": "Lease Term End",
    "229": "Rent Start",
    "230": "Installation",
    "231": "Progress Payment",
    "232": "Claim Statement Period Start",
    "233": "Claim Statement Period End",
    "234": "Settlement Date",
    "235": "Delayed Billing (Not Delayed Payment)",
    "236": "Lender Credit Check",
    "237": "Student Signed",
    "238": "Schedule Release",
    "239": "Baseline",
    "240": "Baseline Start",
    "241": "Baseline Complete",
    "242": "Actual Start",
    "243": "Actual Complete",
    "244": "Estimated Start",
    "245": "Estimated Completion",
    "246": "Start no earlier than",
    "247": "Start no later than",
    "248": "Finish no later than",
    "249": "Finish no earlier than",
    "250": "Mandatory (or Target) Start",
    "251": "Mandatory (or Target) Finish",
    "252": "Early Start",
    "253": "Early Finish",
    "254": "Late Start",
    "255": "Late Finish",
    "256": "Scheduled Start",
    "257": "Scheduled Finish",
    "258": "Original Early Start",
    "259": "Original Early Finish",
    "260": "Rest Day",
    "261": "Rest Start",
    "262": "Rest Finish",
    "263": "Holiday",
    "264": "Holiday Start",
    "265": "Holiday Finish",
    "266": "Base",
    "267": "Timenow",
    "268": "End Date of Support",
    "269": "Date Account Matures",
    "270": "Date Filed",
    "271": "Penalty End",
    "272": "Exit Plant Date",
    "273": "Latest On Board Carrier Date",
    "274": "Requested Departure Date",
    "275": "Approved",
    "276": "Contract Start",
    "277": "Contract Definition",
    "278": "Last Item Delivery",
    "279": "Contract Completion",
    "280": "Date Course of Orthodontics Treatment Began or is Expected to "
            "Begin",
    "281": "Over Target Baseline Month",
    "282": "Previous Report",
    "283": "Funds Appropriation - Start",
    "284": "Funds Appropriation - End",
    "285": "Employment or Hire",
    "286": "Retirement",
    "287": "Medicare",
    "288": "Consolidated Omnibus Budget Reconciliation Act (COBRA)",
    "289": "Premium Paid to Date",
    "290": "Coordination of Benefits",
    "291": "Plan",
    "292": "Benefit",
    "293": "Education",
    "294": "Earnings Effective Date",
    "295": "Primary Care Provider",
    "296": "Return to Work",
    "297": "Date Last Worked",
    "298": "Latest Absence",
    "299": "Illness",
    "300": "Enrollment Signature Date",
    "301": "Consolidated Omnibus Budget Reconciliation Act (COBRA) Qualifying "
            "Event",
    "302": "Maintenance",
    "303": "Maintenance Effective",
    "304": "Latest Visit or Consultation",
    "305": "Net Credit Service Date",
    "306": "Adjustment Effective Date",
    "307": "Eligibility",
    "308": "Pre-Award Survey",
    "309": "Plan Termination",
    "310": "Date of Closing",
    "311": "Latest Receiving Date/Cutoff Date",
    "312": "Salary Deferral",
    "313": "Cycle",
    "314": "Disability",
    "315": "Offset",
    "316": "Prior Incorrect Date of Birth",
    "317": "Corrected Date of Birth",
    "318": "Added",
    "319": "Failed",
    "320": "Date Foreclosure Proceedings Instituted",
    "321": "Purchased",
    "322": "Put into Service",
    "323": "Replaced",
    "324": "Returned",
    "325": "Disbursement Date",
    "326": "Guarantee Date",
    "327": "Quarter Ending",
    "328": "Changed",
    "329": "Terminated",
    "330": "Referral Date",
    "331": "Evaluation Date",
    "332": "Placement Date",
    "333": "Individual Education Plan (IEP)",
    "334": "Re-evaluation Date",
    "335": "Dismissal Date",
    "336": "Employment Begin",
    "337": "Employment End",
    "338": "Medicare Begin",
    "339": "Medicare End",
    "340": "Consolidated Omnibus Budget Reconciliation Act (COBRA) Begin",
    "341": "Consolidated Omnibus Budget Reconciliation Act (COBRA) End",
    "342": "Premium Paid to Date Begin",
    "343": "Premium Paid to Date End",
    "344": "Coordination of Benefits Begin",
    "345": "Coordination of Benefits End",
    "346": "Plan Begin",
    "347": "Plan End",
    "348": "Benefit Begin",
    "349": "Benefit End",
    "350": "Education Begin",
    "351": "Education End",
    "352": "Primary Care Provider Begin",
    "353": "Primary Care Provider End",
    "354": "Illness Begin",
    "355": "Illness End",
    "356": "Eligibility Begin",
    "357": "Eligibility End",
    "358": "Cycle Begin",
    "359": "Cycle End",
    "360": "Disability Begin",
    "361": "Disability End",
    "362": "Offset Begin",
    "363": "Offset End",
    "364": "Plan Period Election Begin",
    "365": "Plan Period Election End",
    "366": "Plan Period Election",
    "367": "Due to Customer",
    "368": "Submittal",
    "369": "Estimated Departure Date",
    "370": "Actual Departure Date",
    "371": "Estimated Arrival Date",
    "372": "Actual Arrival Date",
    "373": "Order Start",
    "374": "Order End",
    "375": "Delivery Start",
    "376": "Delivery End",
    "377": "Contract Costs Through",
    "378": "Financial Information Submission",
    "379": "Business Termination",
    "380": "Applicant Signed",
    "381": "Cosigner Signed",
    "382": "Enrollment",
    "383": "Adjusted Hire",
    "384": "Credited Service",
    "385": "Credited Service Begin",
    "386": "Credited Service End",
    "387": "Deferred Distribution",
    "388": "Payment Commencement",
    "389": "Payroll Period",
    "390": "Payroll Period Begin",
    "391": "Payroll Period End",
    "392": "Plan Entry",
    "393": "Plan Participation Suspension",
    "394": "Rehire",
    "395": "Retermination",
    "396": "Termination",
    "397": "Valuation",
    "398": "Vesting Service",
    "399": "Vesting Service Begin",
    "400": "Vesting Service End",
    "401": "Duplicate Bill",
    "402": "Adjustment Promised",
    "403": "Adjustment Processed",
    "404": "Year Ending",
    "405": "Production",
    "406": "Material Classification",
    "408": "Weighed",
    "409": "Date of Deed in Lieu",
    "410": "Date of Firm Commitment",
    "411": "Expiration Date of Extension to Foreclose",
    "412": "Date of Notice to Convey",
    "413": "Date of Release of Bankruptcy",
    "414": "Optimistic Early Start",
    "415": "Optimistic Early Finish",
    "416": "Optimistic Late Start",
    "417": "Optimistic Late Finish",
    "418": "Most Likely Early Start",
    "419": "Most Likely Early Finish",
    "420": "Most Likely Late Start",
    "421": "Most Likely Late Finish",
    "422": "Pessimistic Early Start",
    "423": "Pessimistic Early Finish",
    "424": "Pessimistic Late Start",
    "425": "Pessimistic Late Finish",
    "426": "First Payment Due",
    "427": "First Interest Payment Due",
    "428": "Subsequent Interest Payment Due",
    "429": "Irregular Interest Payment Due",
    "430": "Guarantor Received",
    "431": "Onset of Current Symptoms or Illness",
    "432": "Submission",
    "433": "Removed",
    "434": "Statement",
    "435": "Admission",
    "436": "Insurance Card",
    "437": "Spouse Retirement",
    "438": "Onset of Similar Symptoms or Illness",
    "439": "Accident",
    "440": "Release of Information",
    "441": "Prior Placement",
    "442": "Date of Death",
    "443": "Peer Review Organization (PRO) Approved Stay",
    "444": "First Visit or Consultation",
    "445": "Initial Placement",
    "446": "Replacement",
    "447": "Occurrence",
    "448": "Occurrence Span",
    "449": "Occurrence Span From",
    "450": "Occurrence Span To",
    "451": "Initial Fee Due",
    "452": "Appliance Placement",
    "453": "Acute Manifestation of a Chronic Condition",
    "454": "Initial Treatment",
    "455": "Last X-Ray",
    "456": "Surgery",
    "457": "Continuous Passive Motion (CPM)",
    "458": "Certification",
    "459": "Nursing Home From",
    "460": "Nursing Home To",
    "461": "Last Certification",
    "462": "Date of Local Office Approval of Conveyance of Occupied Real "
            "Estate Property",
    "463": "Begin Therapy",
    "464": "Oxygen Therapy From",
    "465": "Oxygen Therapy To",
    "466": "Oxygen Therapy",
    "467": "Signature",
    "468": "Prescription Fill",
    "469": "Provider Signature",
    "470": "Date of Local Office Certification of Conveyance of Damaged Real "
            "Estate Property",
    "471": "Prescription",
    "472": "Service",
    "473": "Medicaid Begin",
    "474": "Medicaid End",
    "475": "Medicaid",
    "476": "Peer Review Organization (PRO) Approved Stay From",
    "477": "Peer Review Organization (PRO) Approved Stay To",
    "478": "Prescription From",
    "479": "Prescription To",
    "480": "Arterial Blood Gas Test",
    "481": "Oxygen Saturation Test",
    "482": "Pregnancy Begin",
    "483": "Pregnancy End",
    "484": "Last Menstrual Period",
    "485": "Injury Begin",
    "486": "Injury End",
    "487": "Nursing Home",
    "488": "Collateral Dependent",
    "489": "Collateral Dependent Begin",
    "490": "Collateral Dependent End",
    "491": "Sponsored Dependent",
    "492": "Sponsored Dependent Begin",
    "493": "Sponsored Dependent End",
    "494": "Deductible",
    "495": "Out-of-Pocket",
    "496": "Contract Audit Date",
    "497": "Latest Delivery Date at Pier",
    "498": "Mortgagee Reported Curtailment Date",
    "499": "Mortgagee Official Signature Date",
    "500": "Resubmission",
    "501": "Expected Reply",
    "502": "Dropped to Less than Half Time",
    "503": "Repayment Begin",
    "504": "Loan Servicing Transfer",
    "505": "Loan Purchase",
    "506": "Last Notification",
    "507": "Extract",
    "508": "Extended",
    "509": "Servicer Signature Date",
    "510": "Date Packed",
    "511": "Shelf Life Expiration",
    "512": "Warranty Expiration",
    "513": "Overhauled",
    "514": "Transferred",
    "515": "Notified",
    "516": "Discovered",
    "517": "Inspected",
    "518": "Voucher (Date of)",
    "519": "Date Bankruptcy Filed",
    "520": "Date of Damage",
    "521": "Date Hazard Insurance Policy Cancelled",
    "522": "Expiration Date to Submit Title Evidence",
    "523": "Date of Claim",
    "524": "Date of Notice of Referral for Assignment",
    "525": "Date of Notice of Probable Ineligibility for Assignment",
    "526": "Date of Foreclosure Notice",
    "527": "Expiration of Foreclosure Timeframe",
    "528": "Date Possessory Action Initiated",
    "529": "Date of Possession",
    "530": "Date of Last Installment Received",
    "531": "Date of Acquisition of Title",
    "532": "Expiration of Extension to Convey",
    "533": "Date of Assignment Approval",
    "534": "Date of Assignment Rejection",
    "535": "Curtailment Date from Advice of Payment",
    "536": "Expiration of Extension to Submit Fiscal Data",
    "537": "Date Documentation, or Paperwork, or Both Was Sent",
    "538": "Makegood Commercial Date",
    "539": "Policy Effective",
    "540": "Policy Expiration",
    "541": "Employee Effective Date of Coverage",
    "542": "Date of Representation",
    "543": "Last Premium Paid Date",
    "544": "Date Reported to Employer",
    "545": "Date Reported to Claim Administrator",
    "546": "Date of Maximum Medical Improvement",
    "547": "Date of Loan",
    "548": "Date of Advance",
    "549": "Beginning Lay Date",
    "550": "Certificate Effective",
    "551": "Benefit Application Date",
    "552": "Actual Return to Work",
    "553": "Released Return to Work",
    "554": "Ending Lay Date",
    "555": "Employee Wages Ceased",
    "556": "Last Salary Increase",
    "557": "Employee Laid Off",
    "558": "Injury or Illness",
    "559": "Oldest Unpaid Installment",
    "560": "Preforeclosure Acceptance Date",
    "561": "Preforeclosure Sale Closing Date",
    "562": "Date of First Uncured Default",
    "563": "Date Default Was Cured",
    "564": "Date of First Mortgage Payment",
    "565": "Date of Property Inspection",
    "566": "Date Total Amount of Delinquency Reported",
    "567": "Date Outstanding Loan Balance Reported",
    "568": "Date Foreclosure Sale Scheduled",
    "569": "Date Foreclosure Held",
    "570": "Date Redemption Period Ends",
    "571": "Date Voluntary Conveyance Accepted",
    "572": "Date Property Sold",
    "573": "Date Claim Paid",
    "574": "Action Begin Date",
    "575": "Projected Action End Date",
    "576": "Action End Date",
    "577": "Original Maturity Date",
    "578": "Date Referred to Attorney for Foreclosure",
    "579": "Planned Release",
    "580": "Actual Release",
    "581": "Contract Period",
    "582": "Report Period",
    "583": "Suspension",
    "584": "Reinstatement",
    "585": "Report",
    "586": "First Contact",
    "587": "Projected Foreclosure Sale Date",
    "589": "Date Assignment Filed for Record",
    "590": "Date of Appraisal",
    "591": "Expiration Date of Extension to Assign",
    "592": "Date of Extension to Convey",
    "593": "Date Hazard Insurance Policy Refused",
    "594": "High Fabrication Release Authorization",
    "595": "High Raw Material Authorization",
    "596": "Material Change Notice",
    "597": "Latest Delivery Date at Rail Ramp",
    "598": "Rejected",
    "599": "Repayment Schedule Sent",
    "600": "As Of",
    "601": "First Submission",
    "602": "Subsequent Submission",
    "603": "Renewal",
    "604": "Withdrawn",
    "606": "Certification Period Start",
    "607": "Certification Revision",
    "608": "Continuous Coverage Date(s)",
    "609": "Prearranged Deal Match",
    "610": "Contingency End",
    "611": "Oxygen Therapy Evaluation",
    "612": "Shut In",
    "613": "Allowable Effective",
    "614": "First Sales",
    "615": "Date Acquired",
    "616": "Interviewer Signed",
    "617": "Application Logged Date",
    "618": "Review Date",
    "619": "Decision Date",
    "620": "Previously Resided",
    "621": "Reported",
    "622": "Checked",
    "623": "Settled",
    "624": "Presently Residing",
    "625": "Employed in this Position",
    "626": "Verified",
    "627": "Second Admission Date",
    "628": "Inquiry",
    "629": "Account Opened",
    "630": "Account Closed",
    "631": "Property Acquired",
    "632": "Property Built",
    "633": "Employed in this Profession",
    "634": "Next Review Date",
    "635": "Initial Contact Date",
    "636": "Date of Last Update",
    "637": "Second Discharge Date",
    "638": "Date of Last Draw",
    "640": "Complaint",
    "641": "Option",
    "642": "Solicitation",
    "643": "Clause",
    "644": "Meeting",
    "646": "Rental Period",
    "647": "Next Pay Increase",
    "648": "Period Covered by Source Documents",
    "649": "Document Due",
    "650": "Court Notice",
    "651": "Expected Funding Date",
    "652": "Assignment Recorded",
    "653": "Case Reopened",
    "655": "Previous Court Event",
    "656": "Last Date to Object",
    "657": "Court Event",
    "658": "Last Date to File a Claim",
    "659": "Case Converted",
    "660": "Debt Incurred",
    "661": "Judgment",
    "662": "Wages Start",
    "663": "Wages End",
    "664": "Date Through Which Property Taxes Have Been Paid",
    "665": "Paid Through Date",
    "666": "Date Paid",
    "667": "Anesthesia Administration",
    "668": "Price Protection",
    "669": "Claim Incurred",
    "670": "Book Entry Delivery",
    "671": "Rate Adjustment",
    "672": "Next Installment Due Date",
    "673": "Daylight Overdraft Time",
    "674": "Presentment Date",
    "675": "Negotiated Extension Date",
    "681": "Remittance",
    "682": "Security Rate Adjustment",
    "683": "Filing Period",
    "684": "Review Period End",
    "685": "Requested Settlement",
    "686": "Last Screening",
    "687": "Confinement",
    "688": "Arrested",
    "689": "Convicted",
    "690": "Interviewed",
    "691": "Last Visit",
    "692": "Recovery",
    "693": "Time in U.S.",
    "694": "Future Period",
    "695": "Previous Period",
    "696": "Interest Paid To",
    "697": "Date of Seizure",
    "699": "Setoff",
    "700": "Override Date for Settlement",
    "701": "Settlement Date (From Interline Settlement System (ISS) only)",
    "702": "Sending Road Time Stamp",
    "703": "Retransmission Time Stamp",
    "704": "Delivery Appointment Date and Time",
    "705": "Interest Paid Through",
    "706": "Date Material Usage Suspended",
    "707": "Last Payment Made",
    "708": "Past Due",
    "709": "Analysis Month Ending",
    "710": "Date of Specification",
    "711": "Date of Standard",
    "712": "Return to Work Part Time",
    "713": "Paid-through Date for Salary Continuation",
    "714": "Paid-through Date for Vacation Pay",
    "715": "Paid-through Date for Accrued Sick Pay",
    "716": "Appraisal Ordered",
    "717": "Date of Operation",
    "718": "Best Time to Call",
    "719": "Verbal Report Needed",
    "720": "Estimated Escrow Closing",
    "721": "Permit Year",
    "722": "Remodeling Completed",
    "723": "Current Month Ending",
    "724": "Previous Month Ending",
    "725": "Cycle to Date",
    "726": "Year to Date",
    "727": "On Hold",
    "728": "Off Hold",
    "729": "Facsimile Due By",
    "730": "Reporting Cycle Date",
    "731": "Last Paid Installment Date",
    "732": "Claims Made",
    "733": "Date of Last Payment Received",
    "734": "Curtailment Date",
    "736": "Pool Settlement",
    "737": "Next Interest Change Date",
    "738": "Most Recent Hemoglobin or Hematocrit or Both",
    "739": "Most Recent Serum Creatine",
    "740": "Closed",
    "741": "Therapy",
    "742": "Implantation",
    "743": "Explantation",
    "744": "Date Became Aware",
    "745": "First Marketed",
    "746": "Last Marketed",
    "750": "Expected Problem Resolution",
    "751": "Alternate Problem Resolution",
    "752": "Fee Capitalization",
    "753": "Interest Capitalization",
    "754": "Next Payment Due",
    "755": "Conversion to Repayment",
    "756": "End of Grace",
    "757": "School Refund",
    "758": "Simple Interest Due",
    "760": "Printed",
    "770": "Back on Market",
    "771": "Status",
    "773": "Off-Market",
    "774": "Tour",
    "776": "Listing Received",
    "778": "Anticipated Closing",
    "779": "Last Publication",
    "780": "Sold Book Publication",
    "781": "Occupancy",
    "782": "Contingency",
    "783": "Percolation Test",
    "784": "Septic Approval",
    "785": "Title Transfer",
    "786": "Open House",
    "789": "Homestead",
    "800": "Midpoint of Performance",
    "801": "Acquisition Date",
    "802": "Date of Action",
    "803": "Paid in Full",
    "804": "Refinance",
    "805": "Voluntary Termination",
    "806": "Customer Order",
    "807": "Stored",
    "808": "Selected",
    "809": "Posted",
    "810": "Document Received",
    "811": "Rebuilt",
    "812": "Marriage",
    "813": "Customs Entry Date",
    "814": "Payment Due Date",
    "815": "Maturity Date",
    "816": "Trade Date",
    "817": "Gallons Per Minute (GPM) Test Performed",
    "818": "British Thermal Unit (BTU) Test Perfomed",
    "820": "Real Estate Tax Year",
    "821": "Final Reconciliation Value Estimate as of",
    "822": "Map",
    "823": "Opinion",
    "824": "Version",
    "825": "Original Due Date",
    "826": "Incumbency Period",
    "827": "Audience Deficiency Period",
    "828": "Aired Date",
    "830": "Schedule",
    "831": "Paid Through Date for Minimum Payment",
    "832": "Paid Through Date for Total Payment",
    "840": "Election",
    "841": "Engineering Data List",
    "842": "Last Production",
    "843": "Not Before",
    "844": "Not After",
    "845": "Initial Claim",
    "846": "Benefits Paid",
    "847": "Wages Earned",
    "848": "Adjusted Start",
    "849": "Adjusted End",
    "850": "Revised Adjusted Start",
    "851": "Revised Adjusted End",
    "853": "Field Test",
    "854": "Mortgage Note Date",
    "855": "Alternative Due Date",
    "856": "First Payment Change",
    "857": "First Rate Adjustment",
    "858": "Alternate Base Period",
    "859": "Prior Notice",
    "860": "Appointment Effective",
    "861": "Appointment Expiration",
    "862": "Company Termination",
    "863": "Continuing Education Requirement",
    "864": "Distributor Effective",
    "865": "Distributor Termination",
    "866": "Examination",
    "867": "Incorporation Dissolution",
    "868": "Last Follow-up",
    "869": "License Effective",
    "870": "License Expiration",
    "871": "License Renewal",
    "872": "License Requested",
    "873": "Mailed",
    "874": "Paperwork Mailed",
    "875": "Previous Employment",
    "876": "Previous Employment End",
    "877": "Previous Employment Start",
    "878": "Previous Residence",
    "879": "Previous Residence End",
    "880": "Previous Residence Start",
    "881": "Request",
    "882": "Resident License Effective",
    "883": "Resident License Expiration",
    "884": "State Termination",
    "885": "Texas Line Termination",
    "900": "Acceleration",
    "901": "Adjusted Contestability",
    "902": "Application",
    "903": "Application Entry",
    "904": "Approval/Offer",
    "905": "Automatic Premium Loan",
    "906": "Collection",
    "907": "Confinement End",
    "908": "Confinement Start",
    "909": "Contestability",
    "910": "Flat Extra End",
    "911": "Last Activity",
    "912": "Last Change",
    "913": "Last Episode",
    "914": "Last Meal",
    "915": "Loan",
    "916": "Application Status",
    "917": "Maturity",
    "918": "Medical Information Signature",
    "919": "Medical Information System",
    "920": "Note",
    "921": "Offer Expiration",
    "922": "Original Receipt",
    "923": "Placement",
    "924": "Placement Period Expiration",
    "925": "Processing",
    "926": "Recapture",
    "927": "Re-entry",
    "928": "Reissue",
    "929": "Reinstatement",
    "930": "Requalification",
    "931": "Reinsurance Effective",
    "932": "Reservation of Facility",
    "933": "Settlement Status",
    "934": "Table Rating End",
    "935": "Termination of Facility",
    "936": "Treatment",
    "937": "Department of Labor Wage Determination Date",
    "938": "Order",
    "939": "Resolved",
    "940": "Execution Date",
    "941": "Capitation Period Start",
    "942": "Capitation Period End",
    "943": "Last Date for a Government Agency to File a Claim",
    "944": "Adjustment Period",
    "945": "Activity",
    "946": "Mail By",
    "947": "Preparation",
    "948": "Payment Initiated",
    "949": "Payment Effective",
    "950": "Application",
    "951": "Reclassification",
    "952": "Reclassification (Exit Date)",
    "953": "Post-Reclassification",
    "954": "Post-Reclassification (First Report Card)",
    "955": "Post-Reclassification (First Semi-annual)",
    "956": "Post-Reclassification (Second Semi-annual)",
    "957": "Post-Reclassification (End of Second Year)",
    "960": "Adjusted Death Benefit",
    "961": "Anniversary",
    "962": "Annuitization",
    "963": "Annuity Commencement Date",
    "964": "Bill",
    "965": "Calendar Anniversary",
    "966": "Contract Mailed",
    "967": "Early Withdrawal",
    "968": "Fiscal Anniversary",
    "969": "Income",
    "970": "Initial Premium",
    "971": "Initial Premium Effective",
    "972": "Last Premium Effective",
    "973": "Minimum Required Distribution",
    "974": "Next Anniversary",
    "975": "Notice",
    "976": "Notification of Death",
    "977": "Partial Annuitization",
    "978": "Plan Anniversary",
    "979": "Policy Surrender",
    "980": "Prior Contract Anniversary",
    "981": "Prior Contract Issue",
    "982": "Signature Received",
    "983": "Tax",
    "984": "Benefit Period",
    "985": "Month to Date",
    "986": "Semiannual Ending",
    "987": "Surrender",
    "988": "Plan of Treatment Period",
    "989": "Prior Hospitalization Date(s) Related to Current Service(s)",
    "992": "Date Requested",
    "993": "Request for Quotation",
    "994": "Quote",
    "995": "Recorded Date",
    "996": "Required Delivery",
    "997": "Quote to be Received By",
    "998": "Continuation of Pay Start Date",
    "999": "Document Date",
    "AA1": "Estimated Point of Arrival",
    "AA2": "Estimated Point of Discharge",
    "AA3": "Cancel After, Ex Country",
    "AA4": "Cancel After, Ex Factory",
    "AA5": "Do Not Ship Before, Ex Country",
    "AA6": "Do Not Ship Before, Ex Factory",
    "AA7": "Final Scheduled Payment",
    "AA8": "Actual Discharge",
    "AA9": "Address Period",
    "AAA": "Arrival in Country",
    "AAB": "Citation",
    "AAD": "Crime",
    "AAE": "Discharge - Planned",
    "AAF": "Draft",
    "AAG": "Due Date",
    "AAH": "Event",
    "AAI": "First Involvement",
    "AAJ": "Guarantee Period",
    "AAK": "Income Increase Period",
    "AAL": "Installment Date",
    "AAM": "Last Civilian Flight",
    "AAN": "Last Flight",
    "AAO": "Last Insurance Medical",
    "AAP": "Last Military Flight",
    "AAQ": "Last Physical",
    "AAR": "License",
    "AAS": "Medical Certificate",
    "AAT": "Medication",
    "AAU": "Net Worth Date",
    "AAV": "Next Activity",
    "AAW": "Ownewship Change",
    "AAX": "Ownership Period",
    "AAY": "Rate Date",
    "AAZ": "Requested Contract",
    "AB1": "Requested Offer",
    "AB2": "Sales Period",
    "AB3": "Tax Year",
    "AB4": "Time Period",
    "AB5": "Travel",
    "AB6": "Treatment End",
    "AB7": "Treatment Start",
    "AB8": "Trust",
    "AB9": "Worst Time to Call",
    "ABA": "Registration",
    "ABB": "Revoked",
    "ABC": "Estimated Date of Birth",
    "ABD": "Last Annual Report",
    "ABE": "Legal Action Started",
    "ABG": "Payment Period",
    "ABH": "Profit Period",
    "ABI": "Registered",
    "ABK": "Consolidated",
    "ABL": "Board of Directors Not Authorized As Of",
    "ABM": "Board of Directors Incomplete As Of",
    "ABN": "Manager Not Registered As Of",
    "ABO": "Citizenship Change",
    "ABP": "Participation",
    "ABQ": "Capitalization",
    "ABR": "Registration of Board of Directors",
    "ABS": "Ceased Operations",
    "ABT": "Satisfied",
    "ABU": "Terms Met",
    "ABV": "Asset Documentation Expiration",
    "ABW": "Credit Documentation Expiration",
    "ABX": "Income Documentation Expiration",
    "ABY": "Product Held Until",
    "ACA": "Immigration Date",
    "ACB": "Estimated Immigration Date",
    "ACK": "Acknowledgment",
    "ADB": "Business Control Change",
    "ADC": "Court Registration",
    "ADD": "Annual Report Due",
    "ADL": "Asset and Liability Schedule",
    "ADM": "Annual Report Mailed",
    "ADR": "Annual Report Filed",
    "ARD": "Annual Report Delinquency",
    "CAD": "Changed Accounting Date",
    "CCR": "Customs Cargo Release",
    "CDT": "Maintenance Comment",
    "CEA": "Formation",
    "CEB": "Continuance",
    "CEC": "Merger",
    "CED": "Year Due",
    "CEE": "Next Annual Meeting",
    "CEF": "End of Last Fiscal Year",
    "CEH": "Year Beginning",
    "CEJ": "Started Doing Business",
    "CEK": "Sworn and Subscribed",
    "CEL": "Calendar Year",
    "CEM": "Asset",
    "CEN": "Inactivity",
    "CEO": "High Capital Year",
    "CLO": "Closing Date of First Balance Sheet",
    "CLU": "Closed Until",
    "COM": "Compliance",
    "CON": "Converted into Holding Company",
    "CUR": "Current List",
    "DDO": "Declaration",
    "DEE": "Deed Not Available",
    "DET": "Detrimental Information Received",
    "DFF": "Deferral",
    "DFS": "Departure From Specification",
    "DIS": "Disposition",
    "DLC": "Date of Last Contact",
    "DOA": "Date of Abandonment",
    "DOI": "Delivery Order Issued",
    "DSP": "Disposal",
    "ECD": "Estimated Construction Date",
    "ECF": "Estimated Completion - First Prior Month",
    "ECS": "Estimated Completion - Second Prior Month",
    "ECT": "Estimated Completion - Third Prior Month",
    "EPP": "Estimate Preparation",
    "ESC": "Estimate Comment",
    "ESF": "Estimated Start - First Prior Month",
    "ESS": "Estimated Start - Second Prior Month",
    "EST": "Estimated Start - Third Prior Month",
    "ETP": "Earliest Filing Period",
    "EXO": "Exposure",
    "EXP": "Export",
    "FFI": "Financial Information",
    "GRD": "Graduated",
    "ICF": "Converted to Electronic Date",
    "IDG": "Insolvency Discharge Granted",
    "III": "Incorporation",
    "IMP": "Import",
    "INC": "Incident",
    "INT": "Inactive Until",
    "KEV": "Key Event Fiscal Year",
    "KEW": "Key Event Calendar Year",
    "LAS": "Last Check for Balance Sheet Update",
    "LCC": "Last Capital Change",
    "LEA": "Letter of Agreement",
    "LEL": "Letter of Liability",
    "LIQ": "Liquidation",
    "LLP": "Low Period",
    "LOG": "Equipment Log Entry",
    "LPC": "List Price Change",
    "LSC": "Legal Structure Change",
    "LTP": "Latest Filing Period",
    "MRR": "Meter Reading",
    "MSD": "Latest Material Safety Data Sheet Date",
    "NAM": "Present Name",
    "NFD": "Negotiated Finish",
    "NRG": "Not Registered",
    "NSD": "Negotiated Start",
    "ORG": "Original List",
    "PBC": "Present Control",
    "PDV": "Privilege Details Verification",
    "PLS": "Present Legal Structure",
    "PPP": "Peak Period",
    "PRD": "Previously Reported Date of Birth",
    "PRR": "Presented to Receivers",
    "PTD": "Paid To Date",
    "RAP": "Receiver Appointed",
    "RES": "Resigned",
    "RFD": "Requested Finish",
    "RFF": "Recovery Finish",
    "RFO": "Referred From",
    "RNT": "Rent Survey",
    "RRM": "Received in the Mail",
    "RRT": "Revocation",
    "RSD": "Requested Start",
    "RSS": "Recovery Start",
    "RTO": "Referred To",
    "SCV": "Social Security Claims Verification",
    "SDD": "Sole Directorship Date",
    "STN": "Transition",
    "TSR": "Trade Style Registered",
    "TSS": "Trial Started",
    "TST": "Trial Set",
    "VAT": "Value Added Tax (VAT) Claims Verification",
    "VLU": "Valid Until",
    "W01": "Sample Collected",
    "W02": "Status Change",
    "W03": "Construction Start",
    "W05": "Recompletion",
    "W06": "Last Logged",
    "W07": "Well Log Run",
    "W08": "Surface Casing Authority Approval",
    "W09": "Reached Total Depth",
    "W10": "Spacing Order Unit Assigned",
    "W11": "Rig Arrival",
    "W12": "Location Exception Order Number Assigned",
    "W13": "Sidetracked Wellbore",
    "WAY": "Waybill",
    "YXX": "Programmed Fiscal Year",
    "YXY": "Programmed Calendar Year",
    "ZZZ": "Mutually Defined",
}
