service_type_codes = {
    "1": "Medical Care",
    "2": "Surgical",
    "3": "Consultation",
    "4": "Diagnostic X-Ray",
    "5": "Diagnostic Lab",
    "6": "Radiation Therapy",
    "7": "Anesthesia",
    "8": "Surgical Assistance",
    "9": "Other Medical",
    "10": "Blood",
    "11": "Durable Medical Equipment Used",
    "12": "Durable Medical Equipment Purchased",
    "13": "Ambulatory Service Center Facility",
    "14": "Renal Supplies",
    "15": "Alternate Method Dialysis",
    "16": "Chronic Renal Disease (CRD) Equipment",
    "17": "Pre-Admission Testing",
    "18": "Durable Medical Equipment Rental",
    "19": "Pneumonia Vaccine",
    "20": "Second Surgical Opinion",
    "21": "Third Surgical Opinion",
    "22": "Social Work",
    "23": "Diagnostic Dental",
    "24": "Periodontics",
    "25": "Restorative",
    "26": "Endodontics",
    "27": "Maxillofacial Prosthetics",
    "28": "Adjunctive Dental Services",
    "30": "Health Benefit Plan Coverage",
    "32": "Plan Waiting Period",
    "33": "Chiropractic",
    "34": "Chiropractic Modality",
    "35": "Dental Care",
    "36": "Dental Crowns",
    "37": "Dental Accident",
    "38": "Orthodontics",
    "39": "Prosthodontics",
    "40": "Oral Surgery",
    "41": "Preventive Dental",
    "42": "Home Health Care",
    "43": "Home Health Prescriptions",
    "44": "Home Health Visits",
    "45": "Hospice",
    "46": "Respite Care",
    "47": "Hospitalization",
    "48": "Hospital - Inpatient",
    "49": "Hospital - Room and Board",
    "50": "Hospital - Outpatient",
    "51": "Hospital - Emergency Accident",
    "52": "Hospital - Emergency Medical",
    "53": "Hospital - Ambulatory Surgical",
    "54": "Long Term Care",
    "55": "Major Medical",
    "56": "Medically Related Transportation",
    "57": "Air Transportation",
    "58": "Cabulance",
    "59": "Licensed Ambulance",
    "60": "General Benefits",
    "61": "In-vitro Fertilization",
    "62": "MRI Scan",
    "63": "Donor Procedures",
    "64": "Acupuncture",
    "65": "Newborn Care",
    "66": "Pathology",
    "67": "Smoking Cessation",
    "68": "Well Baby Care",
    "69": "Maternity",
    "70": "Transplants",
    "71": "Audiology",
    "72": "Inhalation Therapy",
    "73": "Diagnostic Medical",
    "74": "Private Duty Nursing",
    "75": "Prosthetic Device",
    "76": "Dialysis",
    "77": "Otology",
    "78": "Chemotherapy",
    "79": "Allergy Testing",
    "80": "Immunizations",
    "81": "Routine Physical",
    "82": "Family Planning",
    "83": "Infertility",
    "84": "Abortion",
    "85": "HIV - AIDS Treatment",
    "86": "Emergency Services",
    "87": "Cancer Treatment",
    "88": "Pharmacy",
    "89": "Free Standing Prescription Drug",
    "90": "Mail Order Prescription Drug",
    "91": "Brand Name Prescription Drug",
    "92": "Generic Prescription Drug",
    "93": "Podiatry",
    "94": "Podiatry - Office Visits",
    "95": "Podiatry - Nursing Home Visits",
    "96": "Professional (Physician)",
    "97": "Anesthesiologist",
    "98": "Professional (Physician) Visit - Office",
    "99": "Professional (Physician) Visit - Inpatient",
    "A0": "Professional (Physician) Visit - Outpatient",
    "A1": "Professional (Physician) Visit - Nursing Home",
    "A2": "Professional (Physician) Visit - Skilled Nursing Facility",
    "A3": "Professional (Physician) Visit - Home",
    "A4": "Psychiatric",
    "A5": "Psychiatric - Room and Board",
    "A6": "Psychotherapy",
    "A7": "Psychiatric - Inpatient",
    "A8": "Psychiatric - Outpatient",
    "A9": "Rehabilitation",
    "AA": "Rehabilitation - Room and Board",
    "AB": "Rehabilitation - Inpatient",
    "AC": "Rehabilitation - Outpatient",
    "AD": "Occupational Therapy",
    "AE": "Physical Medicine",
    "AF": "Speech Therapy",
    "AG": "Skilled Nursing Care",
    "AH": "Skilled Nursing Care - Room and Board",
    "AI": "Substance Abuse",
    "AJ": "Alcoholism Treatment",
    "AK": "Drug Addiction",
    "AL": "Optometry",
    "AM": "Frames",
    "AO": "Lenses",
    "AP": "Routine Eye Exam",
    "AQ": "Nonmedically Necessary Physical (These physicals are required by "
            "other entities e.g., insurance application, pilot license, "
            "employment or school)",
    "AR": "Experimental Drug Therapy",
    "B1": "Burn Care",
    "B2": "Brand Name Prescription Drug - Formulary",
    "B3": "Brand Name Prescription Drug - Non-Formulary",
    "BA": "Independent Medical Evaluation",
    "BB": "Psychiatric Treatment Partial Hospitalization",
    "BC": "Day Care (Psychiatric)",
    "BD": "Cognitive Therapy",
    "BE": "Massage Therapy",
    "BF": "Pulmonary Rehabilitation",
    "BG": "Cardiac Rehabilitation",
    "BH": "Pediatric",
    "BI": "Nursery Room and Board",
    "BJ": "Skin",
    "BK": "Orthopedic",
    "BL": "Cardiac",
    "BM": "Lymphatic",
    "BN": "Gastrointestinal",
    "BP": "Endocrine",
    "BQ": "Neurology",
    "BR": "Eye",
    "BS": "Invasive Procedures",
    "BT": "Gynecological",
    "BU": "Obstetrical",
    "BV": "Obstetrical/Gynecological",
    "BW": "Mail Order Prescription Drug: Brand Name",
    "BX": "Mail Order Prescription Drug: Generic",
    "BY": "Physician Visit - Sick",
    "BZ": "Physician Visit - Well",
    "C1": "Coronary Care",
    "CK": "Screening X-ray",
    "CL": "Screening laboratory",
    "CM": "Mammogram, High Risk Patient",
    "CN": "Mammogram, Low Risk Patient",
    "CO": "Flu Vaccination",
    "CP": "Eyewear Accessories",
    "CQ": "Case Management",
    "DG": "Dermatology",
    "DM": "Durable Medical Equipment",
    "DS": "Diabetic Supplies",
    "E0": "Allied Behavioral Analysis Therapy",
    "E1": "Non-Medical Equipment (non DME)",
    "E2": "Psychiatric Emergency",
    "E3": "Step Down Unit",
    "E4": "Skilled Nursing Facility Head Level of Care",
    "E5": "Skilled Nursing Facility Ventilator Level of Care",
    "E6": "Level of Care 1",
    "E7": "Level of Care 2",
    "E8": "Level of Care 3",
    "E9": "Level of Care 4",
    "E10": "Radiographs",
    "E11": "Diagnostic Imaging",
    "E12": "Basic Restorative - Dental",
    "E13": "Major Restorative - Dental",
    "E14": "Fixed Prosthodontics",
    "E15": "Removable Prosthodontics",
    "E16": "Intraoral Images - Complete Series",
    "E17": "Oral Evaluation",
    "E18": "Dental Prophylaxis",
    "E19": "Panoramic Images",
    "E20": "Sealants",
    "E21": "Flouride Treatments",
    "E22": "Dental Implants",
    "E23": "Temporomandibular Joint Dysfunction",
    "E24": "Retail Pharmacy Prescription Drug",
    "E25": "Long Term Care Pharmacy",
    "E26": "Comprehensive Medication Therapy Management Review",
    "E27": "Targeted Medication Therapy Management Review",
    "E28": "Dietary/Nutritional Services",
    "EA": "Preventive Services",
    "EB": "Specialty Pharmacy",
    "EC": "Durable Medical Equipment New",
    "ED": "CAT Scan",
    "EE": "Ophthalmology",
    "EF": "Contact Lenses",
    "GF": "Generic Prescription Drug - Formulary",
    "GN": "Generic Prescription Drug - Non-Formulary",
    "GY": "Allergy",
    "IC": "Intensive Care",
    "MH": "Mental Health",
    "NI": "Neonatal Intensive Care",
    "ON": "Oncology",
    "PE": "Positron Emission Tomography (PET) Scan",
    "PT": "Physical Therapy",
    "PU": "Pulmonary",
    "RN": "Renal",
    "RT": "Residential Psychiatric Treatment",
    "SMH": "Serious Mental Health",
    "TC": "Transitional Care",
    "TN": "Transitional Nursery Care",
    "UC": "Urgent Care",
}

coverage_level = {
    "CHD": "Children Only",
    "DEP": "Dependents Only",
    "ECH": "Employee and Children",
    "EMP": "Employee Only",
    "ESP": "Employee and Spouse",
    "FAM": "Family",
    "IND": "Individual",
    "SPC": "Spouse and Children",
    "SPO": "Spouse Only"
}

insurance_type = {
    "12": "Medicare Secondary Working Aged Beneficiary or Spouse with "
            "Employer Group Health Plan",
    "13": "Medicare Secondary End-Stage Renal Disease Beneficiary in the 12 "
            "month coordination period with an employer's group health plan",
    "14": "Medicare Secondary, No-fault Insurance including Auto is Primary",
    "15": "Medicare Secondary Worker's Compensation",
    "16": "Medicare Secondary Public Health Service (PHS)or Other Federal "
            "Agency",
    "41": "Medicare Secondary Black Lung",
    "42": "Medicare Secondary Veteran's Administration",
    "43": "Medicare Secondary Disabled Beneficiary Under Age 65 with Large "
            "Group Health Plan (LGHP)",
    "47": "Medicare Secondary, Other Liability Insurance is Primary",
    "AP": "Auto Insurance Policy",
    "C1": "Commercial",
    "CO": "Consolidated Omnibus Budget Reconciliation Act (COBRA)",
    "CP": "Medicare Conditionally Primary",
    "D": "Disability",
    "DB": "Disability Benefits",
    "EP": "Exclusive Provider Organization",
    "FF": "Family or Friends",
    "GP": "Group Policy",
    "HM": "Health Maintenance Organization (HMO)",
    "HN": "Health Maintenance Organization (HMO) - Medicare Risk",
    "HS": "Special Low Income Medicare Beneficiary",
    "IN": "Indemnity",
    "IP": "Individual Policy",
    "LC": "Long Term Care",
    "LD": "Long Term Policy",
    "LI": "Life Insurance",
    "LT": "Litigation",
    "MA": "Medicare Part A",
    "MB": "Medicare Part B",
    "MC": "Medicaid",
    "MH": "Medigap Part A",
    "MI": "Medigap Part B",
    "MP": "Medicare Primary",
    "OT": "Other",
    "PE": "Property Insurance - Personal",
    "PL": "Personal",
    "PP": "Personal Payment (Cash - No Insurance)",
    "PR": "Preferred Provider Organization (PPO)",
    "PS": "Point of Service (POS)",
    "QM": "Qualified Medicare Beneficiary",
    "RP": "Property Insurance - Real",
    "SP": "Supplemental Policy",
    "TF": "Tax Equity Fiscal Responsibility Act (TEFRA)",
    "WC": "Workers Compensation",
    "WU": "Wrap Up Policy",
}

reject_reason_code = {
    "01": "Price Authorization Invalid",
    "02": "Price Authorization Expired",
    "03": "Product not on the price authorization",
    "04": "Authorized Quantity Exceeded",
    "05": "Zero Balance",
    "06": "Special Cost Incorrect",
    "07": "Catalog Cost Incorrect",
    "08": "Invalid Ship Location",
    "09": "No Credit Allowed",
    "10": "Administrative Cancellation",
    "11": "Invalid Debit Number",
    "12": "Duplicate Sequence Number",
    "13": "Not Valid for Price Protection",
    "14": "Invalid part number",
    "15": "Required application data missing",
    "16": "Unit resale higher than authorized",
    "17": "Negotiated price was not less than book price",
    "18": "Ship date must not be after current date",
    "19": "Ship date cannot be prior to price authorization issue date",
    "20": "Ship date should not be before price authorization date (for "
            "rebills)",
    "21": "Price authorization is a rebill type",
    "23": "Price authorization has been deleted",
    "24": "Price authorization used on a sales order",
    "25": "Disposition pending vendor review.",
    "26": "Invalid Customer Number",
    "27": "Invalid Ship Date",
    "28": "Duplicate Invoice Number",
    "29": "Claim Submitted Past Exercise Period",
    "30": "Invalid Meet Competition Cost",
    "31": "Invalid Book Cost",
    "32": "Input Incomplete",
    "33": "Input Errors",
    "34": "No Coverage",
    "35": "Out of Network",
    "36": "Testing not Included",
    "37": "Request Forwarded To and Decision Response Forthcoming From an "
            "External Review Organization",
    "41": "Authorization/Access Restrictions",
    "42": "Unable to Respond at Current Time",
    "43": "Invalid/Missing Provider Identification",
    "44": "Invalid/Missing Provider Name",
    "45": "Invalid/Missing Provider Specialty",
    "46": "Invalid/Missing Provider Phone Number",
    "47": "Invalid/Missing Provider State",
    "48": "Invalid/Missing Referring Provider Identification Number",
    "49": "Provider is Not Primary Care Physician",
    "50": "Provider Ineligible for Inquiries",
    "51": "Provider Not on File",
    "52": "Service Dates Not Within Provider Plan Enrollment",
    "53": "Inquired Benefit Inconsistent with Provider Type",
    "54": "Inappropriate Product/Service ID Qualifier",
    "55": "Inappropriate Product/Service ID",
    "56": "Inappropriate Date",
    "57": "Invalid/Missing Date(s) of Service",
    "58": "Invalid/Missing Date-of-Birth",
    "59": "Invalid/Missing Date-of-Death",
    "60": "Date of Birth Follows Date(s) of Service",
    "61": "Date of Death Precedes Date(s) of Service",
    "62": "Date of Service Not Within Allowable Inquiry Period",
    "63": "Date of Service in Future",
    "64": "Invalid/Missing Patient ID",
    "65": "Invalid/Missing Patient Name",
    "66": "Invalid/Missing Patient Gender Code",
    "67": "Patient Not Found",
    "68": "Duplicate Patient ID Number",
    "69": "Inconsistent with Patient's Age",
    "70": "Inconsistent with Patient's Gender",
    "71": "Patient Birth Date Does Not Match That for the Patient on the "
            "Database",
    "72": "Invalid/Missing Subscriber/Insured ID",
    "73": "Invalid/Missing Subscriber/Insured Name",
    "74": "Invalid/Missing Subscriber/Insured Gender Code",
    "75": "Subscriber/Insured Not Found",
    "76": "Duplicate Subscriber/Insured ID Number",
    "77": "Subscriber Found, Patient Not Found",
    "78": "Subscriber/Insured Not in Group/Plan Identified",
    "79": "Invalid Participant Identification",
    "80": "No Response received - Transaction Terminated",
    "81": "Invalid or Missing Case Number",
    "82": "Not Medically Necessary",
    "83": "Level of Care Not Appropriate",
    "84": "Certification Not Required for this Service",
    "85": "Certification Responsibility of External Review Organization",
    "86": "Primary Care Service",
    "87": "Exceeds Plan Maximums",
    "88": "Non-covered Service",
    "89": "No Prior Approval",
    "90": "Requested Information Not Received",
    "91": "Duplicate Request",
    "92": "Service Inconsistent with Diagnosis",
    "95": "Patient Not Eligible",
    "96": "Pre-existing Condition",
    "97": "Invalid or Missing Provider Address",
    "98": "Experimental Service or Procedure",
    "AB": "Air Brakes - Inoperative, etc.",
    "AD": "Accident Damage - Derail/Sideswiped",
    "AR": "Arrivals",
    "BA": "Reject Due to Air Bags",
    "BC": "Reject Due to No Chains",
    "BD": "Reject Due to Damps",
    "BG": "Reject Due to Bearings",
    "BL": "Reject Due to Load Divider Bad Order",
    "BP": "Reject Due to Bridge Plate",
    "BR": "Reject Due to Brake Rigging Beam, Lever",
    "BS": "Reject Due to Bad Order Slides",
    "BV": "Reject Due to Bad Order Valves/Piping",
    "BW": "Reject Due to Bad Order Walls",
    "CA": "Reject Due to Crank Arm Application",
    "CB": "Reject Due to Center Bowls, Plates and Pins",
    "CL": "Complete Loading",
    "CM": "Released as Railroad Company Material",
    "CP": "Put on Constructive Placement",
    "CS": "Release Load Through Bill Connecting Road",
    "CT": "Release as a Cross-town Load",
    "CU": "Equipment Not Used",
    "DD": "Reject Due to Doors",
    "DG": "Reject Due to Draft Gear - Yoke",
    "DM": "Dismantle",
    "DP": "Departed",
    "DR": "Reject Due to Dirty",
    "DV": "Reject Due to Load Dividers, Side Filters, Special Equipment",
    "E1": "Requested Record Will Not Be Sent; Cannot Identify the Record",
    "E2": "Requested Record Will Not Be Sent; Need Student or Parent "
            "Permission",
    "E3": "Requested Record Will Not Be Sent",
    "E4": "Requested Record Will Not Be Sent; Never Enrolled",
    "E5": "Requested Record Will Not Be Sent; No Degree Awarded",
    "E6": "Requested Record Will Not Be Sent; No Grades Posted",
    "E7": "Requested Record Cannot Be Sent Electronically; Record Resides in "
            "Paper Format only which Will Be Sent by Mail",
    "E8": "Requires Medical Review",
    "EA": "Empty Equipment Available for Loading",
    "ER": "Reject Due to Spotted in Error",
    "ET": "Empty Trailer Flat Release",
    "FR": "Reject Due to Bad Floor",
    "GS": "Release From Demurrage and Start Storage until Waybilled",
    "HB": "Reject Due to Handbrake",
    "HH": "Reject Due to Hand Hold, Ladder, Step, Running Boards, Platforms, "
            "etc.",
    "HX": "Reject Due to Hot Journal Box",
    "ID": "Releases an Idler",
    "II": "Industrial Interchange",
    "IN": "Inter-plant Switch",
    "KR": "Reject Due to Couplers",
    "LK": "Reject Due to Leaking Contents",
    "LS": "Reject Due to Load Shifted",
    "LW": "Light Weigh and Restencil",
    "MO": "Move from Current Spot to Next",
    "OG": "Reject Due to Outlet Gate/Valve Lo and Open Hopper",
    "OI": "Released from Industry to be Inspected",
    "OR": "Ordered for Replacement",
    "OV": "Reject Due to Overloaded",
    "PF": "Released Repaired by Private Facility",
    "PM": "Preventitive Maintenance",
    "PN": "Released not Repaired by Private Facility",
    "RB": "Released from Industry to Custody of Broker",
    "RD": "To be Reloaded",
    "RF": "Reject Due to Refrigeration Unit",
    "RH": "Reject Due to Roof Hatches",
    "RK": "Reject Due to Racks (Bi or Tri Levels)",
    "RL": "Released",
    "RN": "Bad Order Reinitialing and Numbering",
    "RP": "Released Partially Unloaded",
    "RS": "Released Loaded for Line Haul Shipment",
    "RT": "Run Through Equipment not Spotted",
    "SC": "Released from Demurrage after being Scrapped",
    "ST": "Released from Shop Track",
    "SU": "Reject Due to Superstructure - End, Roof and Sides",
    "SW": "Local Waybill",
    "T1": "Cannot Identify Provider as TPO (Third Party Organization) "
            "Participant",
    "T2": "Cannot Identify Payer as TPO (Third Party Organization) "
            "Participant",
    "T3": "Cannot Identify Insured as TPO (Third Party Organization) "
            "Participant",
    "T4": "Payer Name or Identifier Missing",
    "T5": "Certification Information Missing",
    "T6": "Claim does not contain enough information for re-pricing",
    "TC": "Bad Order to Transfer Lading",
    "TD": "Reject Due to Tie Down Devices",
    "TH": "Reject Due to Trailer Hitch",
    "TL": "Reject Due to Train Line, Air Hose, Anglecock",
    "TR": "Reject Due to Truck, S-Frame, Bolster",
    "UC": "Reject Due to Uncoupling Rod",
    "UF": "Reject Due to Underframe - Including Sills",
    "UG": "Bad Order for Upgrading of Car",
    "WA": "Reject Due to Wheel/Axle",
    "WK": "Bad Order Due to Wreck",
    "ZZ": "Mutually Defined",
}

eligibility_or_benefit_code = {
    "1": "Active Coverage",
    "2": "Active - Full Risk Capitation",
    "3": "Active - Services Capitated",
    "4": "Active - Services Capitated to Primary Care Physician",
    "5": "Active - Pending Investigation",
    "6": "Inactive",
    "7": "Inactive - Pending Eligibility Update",
    "8": "Inactive - Pending Investigation",
    "A": "Co-Insurance",
    "B": "Co-Payment",
    "C": "Deductible",
    "CB": "Coverage Basis",
    "D": "Benefit Description",
    "E": "Exclusions",
    "F": "Limitations",
    "G": "Out of Pocket (Stop Loss)",
    "H": "Unlimited",
    "I": "Non-Covered",
    "J": "Cost Containment",
    "K": "Reserve",
    "L": "Primary Care Provider",
    "M": "Pre-existing Condition",
    "MC": "Managed Care Coordinator",
    "N": "Services Restricted to Following Provider",
    "O": "Not Deemed a Medical Necessity",
    "P": "Benefit Disclaimer",
    "Q": "Second Surgical Opinion Required",
    "R": "Other or Additional Payor",
    "S": "Prior Year(s) History",
    "T": "Card(s) Reported Lost/Stolen",
    "U": "Contact Following Entity for Eligibility or Benefit Information",
    "V": "Cannot Process",
    "W": "Other Source of Data",
    "X": "Health Care Facility",
    "Y": "Spend Down"
}
