from distutils.core import setup

setup(
    name="TinyFastSS",
    version="1.0",
    py_modules=["tinyfss"],
    author="Seiji Fujimoto",
    author_email="fujimoto.report@gmail.com",
    url="http://writingarchives.sakura.ne.jp/tinyfss/index.html",
    description="Efficient Data Structure for Fuzzy String Search",
    long_description="""\
Abstract
========

FastSS is an extremely efficient data structure for approximate string search, invented by researchers at Zurich University. Given a set of words, it allows exhaustive retrieval of entries whose edit distance to query string is equal to or less than *k*. The amount of time it requires to lookup is quite smaller than any other approaches. For more details about FastSS, visit the official website at <http://fastss.csg.uzh.ch/>.

TinyFastSS is a simple Python implementation of FastSSwC (variant of FastSS) with fixed bound k=2 , written in less than 80 lines.

Documentation
=============

http://writingarchives.sakura.ne.jp/tinyfss/index.html

Bug report
==========

Please email to <fujimoto.report at gmail.com>
""",
    classifiers=[
        "Programming Language :: Python",
        "Development Status :: 4 - Beta",
        "Intended Audience :: Science/Research",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 2",
        "Programming Language :: Python :: 3",
        "Topic :: Scientific/Engineering",
        "Topic :: Text Processing"
    ]
)
