class FastSS:
    def __init__(self):
        self.words = set()
        self.index = {}
        
    def add(self, item):
        self.words.add(item)
        return

    def remove(self, item):
        self.words.discard(item)
        return

    def indexkeys(self, w):
        L = len(w)
        res = set([w])
        for i in range(L):
            for j in range(i,L):
                tmp = w[:i]+w[i+1:j]+w[j+1:]
                res.add(tmp)
        return res
 
    def makeindex(self):
        self.index.clear()
        for w in self.words:
            for key in self.indexkeys(w):
                if key in self.index:
                    self.index[key].add(w)
                else:
                    self.index[key] = set([w])

    def search(self, query):
        result = {0:[], 1:[], 2:[]}
        candidate = set()

        for key in self.indexkeys(query):
            if key in self.index:
                candidate.update(self.index[key])

        for word in candidate:
            dist = editdist(word, query)
            if dist < 3:
                result[dist].append(word)

        return result

def editdist(s,t):
    matrix = {}
    for i in range(len(s)+1):
        matrix[(i, 0)] = i
    for j in range(len(t)+1):
        matrix[(0, j)] = j

    for j in range(1,len(t)+1):
        for i in range(1,len(s)+1):
            if s[i-1] == t[j-1]:
                matrix[(i, j)] = matrix[(i-1, j-1)]
            else:
                matrix[(i, j)] = min([matrix[(i-1, j)] +1, matrix[(i, j-1)]+1, matrix[(i-1, j-1)] +1])

    return matrix[(i,j)]

def test():
    d = FastSS()
    d.add("tall")
    d.add("talker")
    d.add("maker")
    d.makeindex()

    print(d.search("maker"))
    print(d.search("talk"))
    print(d.search("darker"))

if __name__ == "__main__":
    test()
