VERSION = '0.1.0'
ENTRY_POINTS = {
    'console_scripts': [
        'tinyurl = tinyurl:main',
    ],
}

options(
    setup=Bunch(name='TinyUrl',
        version=VERSION,
        description="super tiny library and command-line interface " \
                    "to tinyurl.com",
        classifiers=[
            "Development Status :: 4 - Beta",
            "Environment :: Console",
            "Intended Audience :: Developers",
            "Intended Audience :: End Users/Desktop",
            "Intended Audience :: Information Technology",
            "Intended Audience :: Other Audience",
            "Intended Audience :: Science/Research",
            "Intended Audience :: System Administrators",
            "Intended Audience :: Telecommunications Industry",
            "License :: OSI Approved :: MIT License",
            "Natural Language :: English",
            "Operating System :: OS Independent",
            "Programming Language :: Python",
            "Topic :: Internet :: WWW/HTTP",
            "Topic :: Software Development :: Libraries :: Python Modules",
            "Topic :: Utilities",
        ],
        keywords='tinyurl,tiny,url',
        author='Dan Buch',
        author_email='daniel.buch@gmail.com',
        url='http://meatballhat.com/projects/TinyUrl',
        license='MIT',
        platforms=['any'],
        py_modules=['tinyurl'],
        include_package_data=True,
        zip_safe=True,
        entry_points=ENTRY_POINTS,
    )
)

    
@task
def publish():
    """push dist files to meatballhat.com"""
    sh('scp -P 2328 dist/* ' \
        'dbuch@codechunk.net:/home/dbuch/code/TinyUrl/dist/')
