import abc
import requests
import json
import logging
import sys

logger = logging.getLogger("parsers")


def get_parser(args):
	parser_type = args.get("type", "")
	del args["type"]

	module = __name__

	if '.' in parser_type:
		tmp = parser_type.split(".")
		module = tmp[0]
		parser_type = tmp[1]
		__import__(module)

	className = parser_type + "Parser"
	return getattr(sys.modules[module], className)(**args)


class Parser(object):
	__metaclass__ = abc.ABCMeta

	def __init__(self, **kwargs):
		pass

	@abc.abstractmethod
	def get_torrents(self, keywords, **kwargs):
		return


class FenopyParser(Parser):

	def get_torrents(self, keywords, **kwargs):
		fenopyApi_site = "http://fenopy.eu/module/search/api.php"

		additional_args = ""
		for key, value in kwargs.iteritems():
			additional_args += ("&%s=%s") % (key, value)

		seq = (fenopyApi_site, "?format=json&keyword=", keywords, additional_args)
		delimiter = ""
		search_link = delimiter.join(seq)

		logger.info("Search link: %s", search_link)
		data = json.loads(requests.get(search_link).text)

		magnet_links = []
		for item in data:
			magnet_links.append(item['magnet'])

		return magnet_links
