/**
 * Copyright (c) 2013-2014 Tomas Dzetkulic
 * Copyright (c) 2013-2014 Pavol Rusnak
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

#include "secp256k1.h"

const bignum256 prime256k1 = {
/*.val =*/{0x3ffffc2f, 0x3ffffffb, 0x3fffffff, 0x3fffffff, 0x3fffffff, 0x3fffffff, 0x3fffffff, 0x3fffffff, 0xffff}};

const curve_point G256k1 = {
/*.x =*/{/*.val =*/{0x16f81798, 0x27ca056c, 0x1ce28d95, 0x26ff36cb, 0x70b0702, 0x18a573a, 0xbbac55a, 0x199fbe77, 0x79be}},
/*.y =*/{/*.val =*/{0x3b10d4b8, 0x311f423f, 0x28554199, 0x5ed1229, 0x1108a8fd, 0x13eff038, 0x3c4655da, 0x369dc9a8, 0x483a}}};

const bignum256 order256k1 = {
/*.val =*/{0x10364141, 0x3f497a33, 0x348a03bb, 0x2bb739ab, 0x3ffffeba, 0x3fffffff, 0x3fffffff, 0x3fffffff, 0xffff}};

const bignum256 order256k1_half = {
/*.val =*/{0x281b20a0, 0x3fa4bd19, 0x3a4501dd, 0x15db9cd5, 0x3fffff5d, 0x3fffffff, 0x3fffffff, 0x3fffffff, 0x7fff}};

const bignum256 three_over_two256k1 = {
/*.val =*/{0x3ffffe19, 0x3ffffffd, 0x3fffffff, 0x3fffffff, 0x3fffffff, 0x3fffffff, 0x3fffffff, 0x3fffffff, 0x7fff}};

#if USE_PRECOMPUTED_IV
const bignum256 secp256k1_iv[256] = {
{/*.val =*/{0x868192a, 0x20e02474, 0x24a059d, 0x2c88ffb7, 0x32b761bc, 0x1b0b0a57, 0x383999c4, 0x6414554, 0xc9bd}},
{/*.val =*/{0x4340c95, 0x3070123a, 0x212502ce, 0x16447fdb, 0x395bb0de, 0xd85852b, 0x1c1ccce2, 0x2320a2aa, 0x64de}},
{/*.val =*/{0x21a0462, 0x1838091b, 0x30928167, 0xb223fed, 0x3cadd86f, 0x6c2c295, 0xe0e6671, 0x11905155, 0xb26f}},
{/*.val =*/{0x210d0231, 0x2c1c048d, 0x384940b3, 0x25911ff6, 0x3e56ec37, 0x2361614a, 0x27073338, 0x28c828aa, 0x5937}},
{/*.val =*/{0x30867f30, 0x360e0244, 0x1c24a059, 0x32c88ffb, 0x1f2b761b, 0x11b0b0a5, 0x1383999c, 0x34641455, 0xac9b}},
{/*.val =*/{0x18433f98, 0x3b070122, 0x2e12502c, 0x396447fd, 0x2f95bb0d, 0x8d85852, 0x29c1ccce, 0x3a320a2a, 0x564d}},
{/*.val =*/{0xc219fcc, 0x1d838091, 0x37092816, 0x3cb223fe, 0x17cadd86, 0x46c2c29, 0x14e0e667, 0x3d190515, 0x2b26}},
{/*.val =*/{0x2610cfe6, 0xec1c048, 0x1b84940b, 0x1e5911ff, 0x2be56ec3, 0x22361614, 0x2a707333, 0x1e8c828a, 0x1593}},
{/*.val =*/{0x130867f3, 0x2760e024, 0x2dc24a05, 0x2f2c88ff, 0x15f2b761, 0x311b0b0a, 0x15383999, 0x2f464145, 0xac9}},
{/*.val =*/{0x9843211, 0x33b07010, 0x36e12502, 0x3796447f, 0xaf95bb0, 0x388d8585, 0x2a9c1ccc, 0x37a320a2, 0x8564}},
{/*.val =*/{0x4c21720, 0x19d83806, 0x3b709281, 0x1bcb223f, 0x257cadd8, 0x1c46c2c2, 0x154e0e66, 0x1bd19051, 0xc2b2}},
{/*.val =*/{0x2610b90, 0x2cec1c03, 0x3db84940, 0xde5911f, 0x12be56ec, 0xe236161, 0x2aa70733, 0xde8c828, 0x6159}},
{/*.val =*/{0x213085c8, 0x16760e01, 0x3edc24a0, 0x6f2c88f, 0x295f2b76, 0x2711b0b0, 0x15538399, 0x26f46414, 0x30ac}},
{/*.val =*/{0x309842e4, 0xb3b0700, 0x3f6e1250, 0x3796447, 0x14af95bb, 0x3388d858, 0xaa9c1cc, 0x137a320a, 0x1856}},
{/*.val =*/{0x184c2172, 0x59d8380, 0x3fb70928, 0x21bcb223, 0xa57cadd, 0x19c46c2c, 0x554e0e6, 0x9bd1905, 0xc2b}},
{/*.val =*/{0xc2610b9, 0x2cec1c0, 0x3fdb8494, 0x30de5911, 0x52be56e, 0xce23616, 0x22aa7073, 0x24de8c82, 0x615}},
{/*.val =*/{0x6130674, 0x16760de, 0x3fedc24a, 0x186f2c88, 0x295f2b7, 0x26711b0b, 0x11553839, 0x326f4641, 0x830a}},
{/*.val =*/{0x309833a, 0xb3b06f, 0x1ff6e125, 0x2c379644, 0x214af95b, 0x33388d85, 0x28aa9c1c, 0x1937a320, 0x4185}},
{/*.val =*/{0x2184c19d, 0x2059d837, 0xffb7092, 0x361bcb22, 0x30a57cad, 0x199c46c2, 0x14554e0e, 0x2c9bd190, 0x20c2}},
{/*.val =*/{0x30c25ee6, 0x102cec19, 0x7fdb849, 0x3b0de591, 0x1852be56, 0xcce2361, 0xa2aa707, 0x164de8c8, 0x9061}},
{/*.val =*/{0x38612f73, 0x2816760c, 0x23fedc24, 0x1d86f2c8, 0x2c295f2b, 0x266711b0, 0x5155383, 0x2b26f464, 0x4830}},
{/*.val =*/{0x1c3095d1, 0x140b3b04, 0x11ff6e12, 0x2ec37964, 0x1614af95, 0x333388d8, 0x28aa9c1, 0x15937a32, 0xa418}},
{/*.val =*/{0xe184900, 0xa059d80, 0x8ffb709, 0x3761bcb2, 0xb0a57ca, 0x3999c46c, 0x14554e0, 0xac9bd19, 0xd20c}},
{/*.val =*/{0x70c2480, 0x2502cec0, 0x47fdb84, 0x1bb0de59, 0x5852be5, 0x1ccce236, 0x20a2aa70, 0x564de8c, 0x6906}},
{/*.val =*/{0x3861240, 0x12816760, 0x223fedc2, 0x2dd86f2c, 0x2c295f2, 0xe66711b, 0x10515538, 0x2b26f46, 0x3483}},
{/*.val =*/{0x1c30920, 0x940b3b0, 0x111ff6e1, 0x16ec3796, 0x21614af9, 0x733388d, 0x828aa9c, 0x215937a3, 0x1a41}},
{/*.val =*/{0xe18490, 0x24a059d8, 0x88ffb70, 0x2b761bcb, 0x30b0a57c, 0x3999c46, 0x2414554e, 0x30ac9bd1, 0xd20}},
{/*.val =*/{0x70c248, 0x12502cec, 0x2447fdb8, 0x15bb0de5, 0x185852be, 0x1ccce23, 0x320a2aa7, 0x18564de8, 0x690}},
{/*.val =*/{0x386124, 0x9281676, 0x3223fedc, 0xadd86f2, 0x2c2c295f, 0x20e66711, 0x19051553, 0xc2b26f4, 0x348}},
{/*.val =*/{0x1c3092, 0x4940b3b, 0x1911ff6e, 0x256ec379, 0x361614af, 0x30733388, 0xc828aa9, 0x615937a, 0x1a4}},
{/*.val =*/{0x200e1849, 0x24a059d, 0x2c88ffb7, 0x32b761bc, 0x1b0b0a57, 0x383999c4, 0x6414554, 0x30ac9bd, 0xd2}},
{/*.val =*/{0x30070a3c, 0x212502cc, 0x16447fdb, 0x395bb0de, 0xd85852b, 0x1c1ccce2, 0x2320a2aa, 0x18564de, 0x8069}},
{/*.val =*/{0x1803851e, 0x30928166, 0xb223fed, 0x3cadd86f, 0x6c2c295, 0xe0e6671, 0x11905155, 0x20c2b26f, 0x4034}},
{/*.val =*/{0xc01c28f, 0x384940b3, 0x25911ff6, 0x3e56ec37, 0x2361614a, 0x27073338, 0x28c828aa, 0x10615937, 0x201a}},
{/*.val =*/{0x2600df5f, 0x1c24a057, 0x32c88ffb, 0x1f2b761b, 0x11b0b0a5, 0x1383999c, 0x34641455, 0x830ac9b, 0x900d}},
{/*.val =*/{0x33006dc7, 0x2e125029, 0x396447fd, 0x2f95bb0d, 0x8d85852, 0x29c1ccce, 0x3a320a2a, 0x2418564d, 0xc806}},
{/*.val =*/{0x398034fb, 0x37092812, 0x3cb223fe, 0x17cadd86, 0x46c2c29, 0x14e0e667, 0x3d190515, 0x120c2b26, 0xe403}},
{/*.val =*/{0x1cc01895, 0x1b849407, 0x1e5911ff, 0x2be56ec3, 0x22361614, 0x2a707333, 0x1e8c828a, 0x29061593, 0xf201}},
{/*.val =*/{0x2e600a62, 0x2dc24a01, 0x2f2c88ff, 0x15f2b761, 0x311b0b0a, 0x15383999, 0x2f464145, 0x34830ac9, 0xf900}},
{/*.val =*/{0x37300531, 0x36e12500, 0x3796447f, 0xaf95bb0, 0x388d8585, 0x2a9c1ccc, 0x37a320a2, 0x1a418564, 0x7c80}},
{/*.val =*/{0x1b9800b0, 0x3b70927e, 0x1bcb223f, 0x257cadd8, 0x1c46c2c2, 0x154e0e66, 0x1bd19051, 0xd20c2b2, 0xbe40}},
{/*.val =*/{0xdcc0058, 0x3db8493f, 0xde5911f, 0x12be56ec, 0xe236161, 0x2aa70733, 0xde8c828, 0x6906159, 0x5f20}},
{/*.val =*/{0x26e6002c, 0x3edc249f, 0x6f2c88f, 0x295f2b76, 0x2711b0b0, 0x15538399, 0x26f46414, 0x34830ac, 0x2f90}},
{/*.val =*/{0x33730016, 0x3f6e124f, 0x3796447, 0x14af95bb, 0x3388d858, 0xaa9c1cc, 0x137a320a, 0x1a41856, 0x17c8}},
{/*.val =*/{0x39b9800b, 0x3fb70927, 0x21bcb223, 0xa57cadd, 0x19c46c2c, 0x554e0e6, 0x9bd1905, 0xd20c2b, 0xbe4}},
{/*.val =*/{0x3cdcbe1d, 0x3fdb8491, 0x30de5911, 0x52be56e, 0xce23616, 0x22aa7073, 0x24de8c82, 0x690615, 0x85f2}},
{/*.val =*/{0x3e6e5d26, 0x3fedc246, 0x186f2c88, 0x295f2b7, 0x26711b0b, 0x11553839, 0x326f4641, 0x34830a, 0xc2f9}},
{/*.val =*/{0x1f372e93, 0x1ff6e123, 0x2c379644, 0x214af95b, 0x33388d85, 0x28aa9c1c, 0x1937a320, 0x201a4185, 0x617c}},
{/*.val =*/{0x2f9b9561, 0xffb708f, 0x361bcb22, 0x30a57cad, 0x199c46c2, 0x14554e0e, 0x2c9bd190, 0x100d20c2, 0xb0be}},
{/*.val =*/{0x37cdc8c8, 0x7fdb845, 0x3b0de591, 0x1852be56, 0xcce2361, 0xa2aa707, 0x164de8c8, 0x8069061, 0xd85f}},
{/*.val =*/{0x3be6e464, 0x23fedc22, 0x1d86f2c8, 0x2c295f2b, 0x266711b0, 0x5155383, 0x2b26f464, 0x24034830, 0x6c2f}},
{/*.val =*/{0x1df37232, 0x11ff6e11, 0x2ec37964, 0x1614af95, 0x333388d8, 0x28aa9c1, 0x15937a32, 0x3201a418, 0x3617}},
{/*.val =*/{0x2ef9b919, 0x8ffb708, 0x3761bcb2, 0xb0a57ca, 0x3999c46c, 0x14554e0, 0xac9bd19, 0x3900d20c, 0x1b0b}},
{/*.val =*/{0x177cdaa4, 0x47fdb82, 0x1bb0de59, 0x5852be5, 0x1ccce236, 0x20a2aa70, 0x564de8c, 0x3c806906, 0x8d85}},
{/*.val =*/{0xbbe6d52, 0x223fedc1, 0x2dd86f2c, 0x2c295f2, 0xe66711b, 0x10515538, 0x2b26f46, 0x3e403483, 0x46c2}},
{/*.val =*/{0x25df36a9, 0x111ff6e0, 0x16ec3796, 0x21614af9, 0x733388d, 0x828aa9c, 0x215937a3, 0x1f201a41, 0x2361}},
{/*.val =*/{0x12ef996c, 0x88ffb6e, 0x2b761bcb, 0x30b0a57c, 0x3999c46, 0x2414554e, 0x30ac9bd1, 0x2f900d20, 0x91b0}},
{/*.val =*/{0x977ccb6, 0x2447fdb7, 0x15bb0de5, 0x185852be, 0x1ccce23, 0x320a2aa7, 0x18564de8, 0x17c80690, 0x48d8}},
{/*.val =*/{0x24bbe65b, 0x3223fedb, 0xadd86f2, 0x2c2c295f, 0x20e66711, 0x19051553, 0xc2b26f4, 0xbe40348, 0x246c}},
{/*.val =*/{0x325df145, 0x1911ff6b, 0x256ec379, 0x361614af, 0x30733388, 0xc828aa9, 0x615937a, 0x5f201a4, 0x9236}},
{/*.val =*/{0x392ef6ba, 0x2c88ffb3, 0x32b761bc, 0x1b0b0a57, 0x383999c4, 0x6414554, 0x30ac9bd, 0x2f900d2, 0xc91b}},
{/*.val =*/{0x3c977b5d, 0x16447fd9, 0x395bb0de, 0xd85852b, 0x1c1ccce2, 0x2320a2aa, 0x18564de, 0x217c8069, 0x648d}},
{/*.val =*/{0x3e4bbbc6, 0xb223fea, 0x3cadd86f, 0x6c2c295, 0xe0e6671, 0x11905155, 0x20c2b26f, 0x30be4034, 0xb246}},
{/*.val =*/{0x1f25dde3, 0x25911ff5, 0x3e56ec37, 0x2361614a, 0x27073338, 0x28c828aa, 0x10615937, 0x185f201a, 0x5923}},
{/*.val =*/{0x2f92ed09, 0x32c88ff8, 0x1f2b761b, 0x11b0b0a5, 0x1383999c, 0x34641455, 0x830ac9b, 0x2c2f900d, 0xac91}},
{/*.val =*/{0x17c9749c, 0x396447fa, 0x2f95bb0d, 0x8d85852, 0x29c1ccce, 0x3a320a2a, 0x2418564d, 0x3617c806, 0xd648}},
{/*.val =*/{0xbe4ba4e, 0x3cb223fd, 0x17cadd86, 0x46c2c29, 0x14e0e667, 0x3d190515, 0x120c2b26, 0x1b0be403, 0x6b24}},
{/*.val =*/{0x25f25d27, 0x1e5911fe, 0x2be56ec3, 0x22361614, 0x2a707333, 0x1e8c828a, 0x29061593, 0xd85f201, 0x3592}},
{/*.val =*/{0x12f92cab, 0x2f2c88fd, 0x15f2b761, 0x311b0b0a, 0x15383999, 0x2f464145, 0x34830ac9, 0x6c2f900, 0x9ac9}},
{/*.val =*/{0x297c946d, 0x3796447c, 0xaf95bb0, 0x388d8585, 0x2a9c1ccc, 0x37a320a2, 0x1a418564, 0x23617c80, 0xcd64}},
{/*.val =*/{0x14be484e, 0x1bcb223c, 0x257cadd8, 0x1c46c2c2, 0x154e0e66, 0x1bd19051, 0xd20c2b2, 0x11b0be40, 0xe6b2}},
{/*.val =*/{0xa5f2427, 0xde5911e, 0x12be56ec, 0xe236161, 0x2aa70733, 0xde8c828, 0x6906159, 0x8d85f20, 0x7359}},
{/*.val =*/{0x52f902b, 0x6f2c88d, 0x295f2b76, 0x2711b0b0, 0x15538399, 0x26f46414, 0x34830ac, 0x246c2f90, 0xb9ac}},
{/*.val =*/{0x2297c62d, 0x3796444, 0x14af95bb, 0x3388d858, 0xaa9c1cc, 0x137a320a, 0x1a41856, 0x123617c8, 0xdcd6}},
{/*.val =*/{0x114be12e, 0x21bcb220, 0xa57cadd, 0x19c46c2c, 0x554e0e6, 0x9bd1905, 0xd20c2b, 0x91b0be4, 0xee6b}},
{/*.val =*/{0x8a5f097, 0x30de5910, 0x52be56e, 0xce23616, 0x22aa7073, 0x24de8c82, 0x690615, 0x248d85f2, 0x7735}},
{/*.val =*/{0x452f663, 0x186f2c86, 0x295f2b7, 0x26711b0b, 0x11553839, 0x326f4641, 0x34830a, 0x3246c2f9, 0xbb9a}},
{/*.val =*/{0x2297949, 0x2c379641, 0x214af95b, 0x33388d85, 0x28aa9c1c, 0x1937a320, 0x201a4185, 0x1923617c, 0xddcd}},
{/*.val =*/{0x2114babc, 0x361bcb1e, 0x30a57cad, 0x199c46c2, 0x14554e0e, 0x2c9bd190, 0x100d20c2, 0x2c91b0be, 0xeee6}},
{/*.val =*/{0x108a5d5e, 0x3b0de58f, 0x1852be56, 0xcce2361, 0xa2aa707, 0x164de8c8, 0x8069061, 0x1648d85f, 0x7773}},
{/*.val =*/{0x28452eaf, 0x1d86f2c7, 0x2c295f2b, 0x266711b0, 0x5155383, 0x2b26f464, 0x24034830, 0x2b246c2f, 0x3bb9}},
{/*.val =*/{0x3422956f, 0x2ec37961, 0x1614af95, 0x333388d8, 0x28aa9c1, 0x15937a32, 0x3201a418, 0x35923617, 0x9ddc}},
{/*.val =*/{0x3a1148cf, 0x3761bcae, 0xb0a57ca, 0x3999c46c, 0x14554e0, 0xac9bd19, 0x3900d20c, 0x1ac91b0b, 0xceee}},
{/*.val =*/{0x1d08a27f, 0x1bb0de55, 0x5852be5, 0x1ccce236, 0x20a2aa70, 0x564de8c, 0x3c806906, 0xd648d85, 0xe777}},
{/*.val =*/{0x2e844f57, 0x2dd86f28, 0x2c295f2, 0xe66711b, 0x10515538, 0x2b26f46, 0x3e403483, 0x26b246c2, 0xf3bb}},
{/*.val =*/{0x174225c3, 0x16ec3792, 0x21614af9, 0x733388d, 0x828aa9c, 0x215937a3, 0x1f201a41, 0x33592361, 0xf9dd}},
{/*.val =*/{0xba110f9, 0x2b761bc7, 0x30b0a57c, 0x3999c46, 0x2414554e, 0x30ac9bd1, 0x2f900d20, 0x39ac91b0, 0xfcee}},
{/*.val =*/{0x25d08694, 0x15bb0de1, 0x185852be, 0x1ccce23, 0x320a2aa7, 0x18564de8, 0x17c80690, 0x1cd648d8, 0xfe77}},
{/*.val =*/{0x32e8434a, 0xadd86f0, 0x2c2c295f, 0x20e66711, 0x19051553, 0xc2b26f4, 0xbe40348, 0x2e6b246c, 0x7f3b}},
{/*.val =*/{0x197421a5, 0x256ec378, 0x361614af, 0x30733388, 0xc828aa9, 0x615937a, 0x5f201a4, 0x37359236, 0x3f9d}},
{/*.val =*/{0xcba0eea, 0x32b761ba, 0x1b0b0a57, 0x383999c4, 0x6414554, 0x30ac9bd, 0x2f900d2, 0x3b9ac91b, 0x9fce}},
{/*.val =*/{0x65d0775, 0x395bb0dd, 0xd85852b, 0x1c1ccce2, 0x2320a2aa, 0x18564de, 0x217c8069, 0x1dcd648d, 0x4fe7}},
{/*.val =*/{0x232e81d2, 0x3cadd86c, 0x6c2c295, 0xe0e6671, 0x11905155, 0x20c2b26f, 0x30be4034, 0x2ee6b246, 0xa7f3}},
{/*.val =*/{0x119740e9, 0x3e56ec36, 0x2361614a, 0x27073338, 0x28c828aa, 0x10615937, 0x185f201a, 0x37735923, 0x53f9}},
{/*.val =*/{0x8cb9e8c, 0x1f2b7619, 0x11b0b0a5, 0x1383999c, 0x34641455, 0x830ac9b, 0x2c2f900d, 0x3bb9ac91, 0xa9fc}},
{/*.val =*/{0x2465cf46, 0x2f95bb0c, 0x8d85852, 0x29c1ccce, 0x3a320a2a, 0x2418564d, 0x3617c806, 0x1ddcd648, 0x54fe}},
{/*.val =*/{0x1232e7a3, 0x17cadd86, 0x46c2c29, 0x14e0e667, 0x3d190515, 0x120c2b26, 0x1b0be403, 0xeee6b24, 0x2a7f}},
{/*.val =*/{0x91971e9, 0x2be56ec1, 0x22361614, 0x2a707333, 0x1e8c828a, 0x29061593, 0xd85f201, 0x27773592, 0x953f}},
{/*.val =*/{0x248cb70c, 0x15f2b75e, 0x311b0b0a, 0x15383999, 0x2f464145, 0x34830ac9, 0x6c2f900, 0x33bb9ac9, 0xca9f}},
{/*.val =*/{0x12465b86, 0xaf95baf, 0x388d8585, 0x2a9c1ccc, 0x37a320a2, 0x1a418564, 0x23617c80, 0x39ddcd64, 0x654f}},
{/*.val =*/{0x29232dc3, 0x257cadd7, 0x1c46c2c2, 0x154e0e66, 0x1bd19051, 0xd20c2b2, 0x11b0be40, 0x3ceee6b2, 0x32a7}},
{/*.val =*/{0x349194f9, 0x12be56e9, 0xe236161, 0x2aa70733, 0xde8c828, 0x6906159, 0x8d85f20, 0x3e777359, 0x9953}},
{/*.val =*/{0x3a48c894, 0x295f2b72, 0x2711b0b0, 0x15538399, 0x26f46414, 0x34830ac, 0x246c2f90, 0x3f3bb9ac, 0xcca9}},
{/*.val =*/{0x1d24644a, 0x14af95b9, 0x3388d858, 0xaa9c1cc, 0x137a320a, 0x1a41856, 0x123617c8, 0x3f9ddcd6, 0x6654}},
{/*.val =*/{0x2e923225, 0xa57cadc, 0x19c46c2c, 0x554e0e6, 0x9bd1905, 0xd20c2b, 0x91b0be4, 0x1fceee6b, 0x332a}},
{/*.val =*/{0x1749172a, 0x52be56c, 0xce23616, 0x22aa7073, 0x24de8c82, 0x690615, 0x248d85f2, 0xfe77735, 0x9995}},
{/*.val =*/{0xba48b95, 0x295f2b6, 0x26711b0b, 0x11553839, 0x326f4641, 0x34830a, 0x3246c2f9, 0x27f3bb9a, 0x4cca}},
{/*.val =*/{0x5d243e2, 0x214af959, 0x33388d85, 0x28aa9c1c, 0x1937a320, 0x201a4185, 0x1923617c, 0x13f9ddcd, 0xa665}},
{/*.val =*/{0x22e921f1, 0x30a57cac, 0x199c46c2, 0x14554e0e, 0x2c9bd190, 0x100d20c2, 0x2c91b0be, 0x29fceee6, 0x5332}},
{/*.val =*/{0x11748f10, 0x1852be54, 0xcce2361, 0xa2aa707, 0x164de8c8, 0x8069061, 0x1648d85f, 0x14fe7773, 0xa999}},
{/*.val =*/{0x8ba4788, 0x2c295f2a, 0x266711b0, 0x5155383, 0x2b26f464, 0x24034830, 0x2b246c2f, 0x2a7f3bb9, 0x54cc}},
{/*.val =*/{0x45d23c4, 0x1614af95, 0x333388d8, 0x28aa9c1, 0x15937a32, 0x3201a418, 0x35923617, 0x153f9ddc, 0x2a66}},
{/*.val =*/{0x222e91e2, 0xb0a57ca, 0x3999c46c, 0x14554e0, 0xac9bd19, 0x3900d20c, 0x1ac91b0b, 0xa9fceee, 0x1533}},
{/*.val =*/{0x111748f1, 0x5852be5, 0x1ccce236, 0x20a2aa70, 0x564de8c, 0x3c806906, 0xd648d85, 0x254fe777, 0xa99}},
{/*.val =*/{0x288ba290, 0x2c295f0, 0xe66711b, 0x10515538, 0x2b26f46, 0x3e403483, 0x26b246c2, 0x32a7f3bb, 0x854c}},
{/*.val =*/{0x1445d148, 0x21614af8, 0x733388d, 0x828aa9c, 0x215937a3, 0x1f201a41, 0x33592361, 0x1953f9dd, 0x42a6}},
{/*.val =*/{0xa22e8a4, 0x30b0a57c, 0x3999c46, 0x2414554e, 0x30ac9bd1, 0x2f900d20, 0x39ac91b0, 0xca9fcee, 0x2153}},
{/*.val =*/{0x5117452, 0x185852be, 0x1ccce23, 0x320a2aa7, 0x18564de8, 0x17c80690, 0x1cd648d8, 0x2654fe77, 0x10a9}},
{/*.val =*/{0x288ba29, 0x2c2c295f, 0x20e66711, 0x19051553, 0xc2b26f4, 0xbe40348, 0x2e6b246c, 0x332a7f3b, 0x854}},
{/*.val =*/{0x21445b2c, 0x361614ad, 0x30733388, 0xc828aa9, 0x615937a, 0x5f201a4, 0x37359236, 0x19953f9d, 0x842a}},
{/*.val =*/{0x30a22d96, 0x1b0b0a56, 0x383999c4, 0x6414554, 0x30ac9bd, 0x2f900d2, 0x3b9ac91b, 0xcca9fce, 0x4215}},
{/*.val =*/{0x185116cb, 0xd85852b, 0x1c1ccce2, 0x2320a2aa, 0x18564de, 0x217c8069, 0x1dcd648d, 0x26654fe7, 0x210a}},
{/*.val =*/{0x2c28897d, 0x6c2c293, 0xe0e6671, 0x11905155, 0x20c2b26f, 0x30be4034, 0x2ee6b246, 0x1332a7f3, 0x9085}},
{/*.val =*/{0x361442d6, 0x23616147, 0x27073338, 0x28c828aa, 0x10615937, 0x185f201a, 0x37735923, 0x299953f9, 0xc842}},
{/*.val =*/{0x3b0a216b, 0x11b0b0a3, 0x1383999c, 0x34641455, 0x830ac9b, 0x2c2f900d, 0x3bb9ac91, 0x14cca9fc, 0x6421}},
{/*.val =*/{0x3d850ecd, 0x8d8584f, 0x29c1ccce, 0x3a320a2a, 0x2418564d, 0x3617c806, 0x1ddcd648, 0x2a6654fe, 0xb210}},
{/*.val =*/{0x3ec2857e, 0x46c2c25, 0x14e0e667, 0x3d190515, 0x120c2b26, 0x1b0be403, 0xeee6b24, 0x15332a7f, 0xd908}},
{/*.val =*/{0x3f6142bf, 0x22361612, 0x2a707333, 0x1e8c828a, 0x29061593, 0xd85f201, 0x27773592, 0xa99953f, 0x6c84}},
{/*.val =*/{0x1fb09f77, 0x311b0b07, 0x15383999, 0x2f464145, 0x34830ac9, 0x6c2f900, 0x33bb9ac9, 0x54cca9f, 0xb642}},
{/*.val =*/{0x2fd84dd3, 0x388d8581, 0x2a9c1ccc, 0x37a320a2, 0x1a418564, 0x23617c80, 0x39ddcd64, 0x2a6654f, 0xdb21}},
{/*.val =*/{0x37ec2501, 0x1c46c2be, 0x154e0e66, 0x1bd19051, 0xd20c2b2, 0x11b0be40, 0x3ceee6b2, 0x215332a7, 0xed90}},
{/*.val =*/{0x1bf61098, 0xe23615d, 0x2aa70733, 0xde8c828, 0x6906159, 0x8d85f20, 0x3e777359, 0x10a99953, 0xf6c8}},
{/*.val =*/{0x2dfb084c, 0x2711b0ae, 0x15538399, 0x26f46414, 0x34830ac, 0x246c2f90, 0x3f3bb9ac, 0x854cca9, 0x7b64}},
{/*.val =*/{0x16fd8426, 0x3388d857, 0xaa9c1cc, 0x137a320a, 0x1a41856, 0x123617c8, 0x3f9ddcd6, 0x42a6654, 0x3db2}},
{/*.val =*/{0x2b7ec213, 0x19c46c2b, 0x554e0e6, 0x9bd1905, 0xd20c2b, 0x91b0be4, 0x1fceee6b, 0x215332a, 0x1ed9}},
{/*.val =*/{0x35bf5f21, 0xce23613, 0x22aa7073, 0x24de8c82, 0x690615, 0x248d85f2, 0xfe77735, 0x210a9995, 0x8f6c}},
{/*.val =*/{0x3adfada8, 0x26711b07, 0x11553839, 0x326f4641, 0x34830a, 0x3246c2f9, 0x27f3bb9a, 0x10854cca, 0xc7b6}},
{/*.val =*/{0x3d6fd6d4, 0x33388d83, 0x28aa9c1c, 0x1937a320, 0x201a4185, 0x1923617c, 0x13f9ddcd, 0x842a665, 0x63db}},
{/*.val =*/{0x3eb7eb6a, 0x199c46c1, 0x14554e0e, 0x2c9bd190, 0x100d20c2, 0x2c91b0be, 0x29fceee6, 0x24215332, 0x31ed}},
{/*.val =*/{0x3f5bf5b5, 0xcce2360, 0xa2aa707, 0x164de8c8, 0x8069061, 0x1648d85f, 0x14fe7773, 0x3210a999, 0x18f6}},
{/*.val =*/{0x1fadf8f2, 0x266711ae, 0x5155383, 0x2b26f464, 0x24034830, 0x2b246c2f, 0x2a7f3bb9, 0x190854cc, 0x8c7b}},
{/*.val =*/{0xfd6fc79, 0x333388d7, 0x28aa9c1, 0x15937a32, 0x3201a418, 0x35923617, 0x153f9ddc, 0x2c842a66, 0x463d}},
{/*.val =*/{0x27eb7c54, 0x3999c469, 0x14554e0, 0xac9bd19, 0x3900d20c, 0x1ac91b0b, 0xa9fceee, 0x36421533, 0xa31e}},
{/*.val =*/{0x33f5be2a, 0x1ccce234, 0x20a2aa70, 0x564de8c, 0x3c806906, 0xd648d85, 0x254fe777, 0x1b210a99, 0x518f}},
{/*.val =*/{0x19fadf15, 0xe66711a, 0x10515538, 0x2b26f46, 0x3e403483, 0x26b246c2, 0x32a7f3bb, 0x2d90854c, 0x28c7}},
{/*.val =*/{0xcfd6da2, 0x733388b, 0x828aa9c, 0x215937a3, 0x1f201a41, 0x33592361, 0x1953f9dd, 0x36c842a6, 0x9463}},
{/*.val =*/{0x267eb6d1, 0x3999c45, 0x2414554e, 0x30ac9bd1, 0x2f900d20, 0x39ac91b0, 0xca9fcee, 0x3b642153, 0x4a31}},
{/*.val =*/{0x333f5980, 0x1ccce20, 0x320a2aa7, 0x18564de8, 0x17c80690, 0x1cd648d8, 0x2654fe77, 0x3db210a9, 0xa518}},
{/*.val =*/{0x199facc0, 0x20e66710, 0x19051553, 0xc2b26f4, 0xbe40348, 0x2e6b246c, 0x332a7f3b, 0x1ed90854, 0x528c}},
{/*.val =*/{0xccfd660, 0x30733388, 0xc828aa9, 0x615937a, 0x5f201a4, 0x37359236, 0x19953f9d, 0xf6c842a, 0x2946}},
{/*.val =*/{0x667eb30, 0x383999c4, 0x6414554, 0x30ac9bd, 0x2f900d2, 0x3b9ac91b, 0xcca9fce, 0x7b64215, 0x14a3}},
{/*.val =*/{0x333f598, 0x1c1ccce2, 0x2320a2aa, 0x18564de, 0x217c8069, 0x1dcd648d, 0x26654fe7, 0x23db210a, 0xa51}},
{/*.val =*/{0x199facc, 0xe0e6671, 0x11905155, 0x20c2b26f, 0x30be4034, 0x2ee6b246, 0x1332a7f3, 0x31ed9085, 0x528}},
{/*.val =*/{0x20ccfd66, 0x27073338, 0x28c828aa, 0x10615937, 0x185f201a, 0x37735923, 0x299953f9, 0x18f6c842, 0x294}},
{/*.val =*/{0x10667eb3, 0x1383999c, 0x34641455, 0x830ac9b, 0x2c2f900d, 0x3bb9ac91, 0x14cca9fc, 0xc7b6421, 0x14a}},
{/*.val =*/{0x8333d71, 0x29c1cccc, 0x3a320a2a, 0x2418564d, 0x3617c806, 0x1ddcd648, 0x2a6654fe, 0x63db210, 0x80a5}},
{/*.val =*/{0x4199cd0, 0x14e0e664, 0x3d190515, 0x120c2b26, 0x1b0be403, 0xeee6b24, 0x15332a7f, 0x231ed908, 0xc052}},
{/*.val =*/{0x20cce68, 0x2a707332, 0x1e8c828a, 0x29061593, 0xd85f201, 0x27773592, 0xa99953f, 0x118f6c84, 0x6029}},
{/*.val =*/{0x1066734, 0x15383999, 0x2f464145, 0x34830ac9, 0x6c2f900, 0x33bb9ac9, 0x54cca9f, 0x28c7b642, 0x3014}},
{/*.val =*/{0x2083339a, 0x2a9c1ccc, 0x37a320a2, 0x1a418564, 0x23617c80, 0x39ddcd64, 0x2a6654f, 0x1463db21, 0x180a}},
{/*.val =*/{0x104199cd, 0x154e0e66, 0x1bd19051, 0xd20c2b2, 0x11b0be40, 0x3ceee6b2, 0x215332a7, 0xa31ed90, 0xc05}},
{/*.val =*/{0x820cafe, 0x2aa70731, 0xde8c828, 0x6906159, 0x8d85f20, 0x3e777359, 0x10a99953, 0x2518f6c8, 0x8602}},
{/*.val =*/{0x2410657f, 0x15538398, 0x26f46414, 0x34830ac, 0x246c2f90, 0x3f3bb9ac, 0x854cca9, 0x128c7b64, 0x4301}},
{/*.val =*/{0x120830d7, 0xaa9c1ca, 0x137a320a, 0x1a41856, 0x123617c8, 0x3f9ddcd6, 0x42a6654, 0x29463db2, 0xa180}},
{/*.val =*/{0x9041683, 0x554e0e3, 0x9bd1905, 0xd20c2b, 0x91b0be4, 0x1fceee6b, 0x215332a, 0x14a31ed9, 0xd0c0}},
{/*.val =*/{0x24820959, 0x22aa706f, 0x24de8c82, 0x690615, 0x248d85f2, 0xfe77735, 0x210a9995, 0xa518f6c, 0xe860}},
{/*.val =*/{0x324102c4, 0x11553835, 0x326f4641, 0x34830a, 0x3246c2f9, 0x27f3bb9a, 0x10854cca, 0x528c7b6, 0xf430}},
{/*.val =*/{0x39208162, 0x28aa9c1a, 0x1937a320, 0x201a4185, 0x1923617c, 0x13f9ddcd, 0x842a665, 0x29463db, 0x7a18}},
{/*.val =*/{0x1c9040b1, 0x14554e0d, 0x2c9bd190, 0x100d20c2, 0x2c91b0be, 0x29fceee6, 0x24215332, 0x14a31ed, 0x3d0c}},
{/*.val =*/{0x2e481e70, 0xa2aa704, 0x164de8c8, 0x8069061, 0x1648d85f, 0x14fe7773, 0x3210a999, 0xa518f6, 0x9e86}},
{/*.val =*/{0x17240f38, 0x5155382, 0x2b26f464, 0x24034830, 0x2b246c2f, 0x2a7f3bb9, 0x190854cc, 0x528c7b, 0x4f43}},
{/*.val =*/{0xb92079c, 0x28aa9c1, 0x15937a32, 0x3201a418, 0x35923617, 0x153f9ddc, 0x2c842a66, 0x2029463d, 0x27a1}},
{/*.val =*/{0x25c903ce, 0x14554e0, 0xac9bd19, 0x3900d20c, 0x1ac91b0b, 0xa9fceee, 0x36421533, 0x3014a31e, 0x13d0}},
{/*.val =*/{0x12e481e7, 0x20a2aa70, 0x564de8c, 0x3c806906, 0xd648d85, 0x254fe777, 0x1b210a99, 0x180a518f, 0x9e8}},
{/*.val =*/{0x9723f0b, 0x10515536, 0x2b26f46, 0x3e403483, 0x26b246c2, 0x32a7f3bb, 0x2d90854c, 0xc0528c7, 0x84f4}},
{/*.val =*/{0x4b91d9d, 0x828aa99, 0x215937a3, 0x1f201a41, 0x33592361, 0x1953f9dd, 0x36c842a6, 0x6029463, 0xc27a}},
{/*.val =*/{0x225c8ce6, 0x2414554a, 0x30ac9bd1, 0x2f900d20, 0x39ac91b0, 0xca9fcee, 0x3b642153, 0x3014a31, 0xe13d}},
{/*.val =*/{0x112e4673, 0x320a2aa5, 0x18564de8, 0x17c80690, 0x1cd648d8, 0x2654fe77, 0x3db210a9, 0x2180a518, 0x709e}},
{/*.val =*/{0x28972151, 0x19051550, 0xc2b26f4, 0xbe40348, 0x2e6b246c, 0x332a7f3b, 0x1ed90854, 0x10c0528c, 0xb84f}},
{/*.val =*/{0x144b8ec0, 0xc828aa6, 0x615937a, 0x5f201a4, 0x37359236, 0x19953f9d, 0xf6c842a, 0x28602946, 0xdc27}},
{/*.val =*/{0xa25c760, 0x6414553, 0x30ac9bd, 0x2f900d2, 0x3b9ac91b, 0xcca9fce, 0x7b64215, 0x343014a3, 0x6e13}},
{/*.val =*/{0x2512e3b0, 0x2320a2a9, 0x18564de, 0x217c8069, 0x1dcd648d, 0x26654fe7, 0x23db210a, 0x3a180a51, 0x3709}},
{/*.val =*/{0x328971d8, 0x11905154, 0x20c2b26f, 0x30be4034, 0x2ee6b246, 0x1332a7f3, 0x31ed9085, 0x3d0c0528, 0x1b84}},
{/*.val =*/{0x1944b8ec, 0x28c828aa, 0x10615937, 0x185f201a, 0x37735923, 0x299953f9, 0x18f6c842, 0x1e860294, 0xdc2}},
{/*.val =*/{0xca25c76, 0x34641455, 0x830ac9b, 0x2c2f900d, 0x3bb9ac91, 0x14cca9fc, 0xc7b6421, 0xf43014a, 0x6e1}},
{/*.val =*/{0x26512e3b, 0x3a320a2a, 0x2418564d, 0x3617c806, 0x1ddcd648, 0x2a6654fe, 0x63db210, 0x27a180a5, 0x370}},
{/*.val =*/{0x13289535, 0x3d190513, 0x120c2b26, 0x1b0be403, 0xeee6b24, 0x15332a7f, 0x231ed908, 0x13d0c052, 0x81b8}},
{/*.val =*/{0x299448b2, 0x1e8c8287, 0x29061593, 0xd85f201, 0x27773592, 0xa99953f, 0x118f6c84, 0x9e86029, 0xc0dc}},
{/*.val =*/{0x34ca2459, 0x2f464143, 0x34830ac9, 0x6c2f900, 0x33bb9ac9, 0x54cca9f, 0x28c7b642, 0x4f43014, 0x606e}},
{/*.val =*/{0x3a651044, 0x37a3209f, 0x1a418564, 0x23617c80, 0x39ddcd64, 0x2a6654f, 0x1463db21, 0x27a180a, 0xb037}},
{/*.val =*/{0x3d328822, 0x1bd1904f, 0xd20c2b2, 0x11b0be40, 0x3ceee6b2, 0x215332a7, 0xa31ed90, 0x213d0c05, 0x581b}},
{/*.val =*/{0x3e994411, 0xde8c827, 0x6906159, 0x8d85f20, 0x3e777359, 0x10a99953, 0x2518f6c8, 0x309e8602, 0x2c0d}},
{/*.val =*/{0x3f4ca020, 0x26f46411, 0x34830ac, 0x246c2f90, 0x3f3bb9ac, 0x854cca9, 0x128c7b64, 0x384f4301, 0x9606}},
{/*.val =*/{0x3fa65010, 0x137a3208, 0x1a41856, 0x123617c8, 0x3f9ddcd6, 0x42a6654, 0x29463db2, 0x1c27a180, 0x4b03}},
{/*.val =*/{0x1fd32808, 0x9bd1904, 0xd20c2b, 0x91b0be4, 0x1fceee6b, 0x215332a, 0x14a31ed9, 0x2e13d0c0, 0x2581}},
{/*.val =*/{0xfe99404, 0x24de8c82, 0x690615, 0x248d85f2, 0xfe77735, 0x210a9995, 0xa518f6c, 0x3709e860, 0x12c0}},
{/*.val =*/{0x7f4ca02, 0x326f4641, 0x34830a, 0x3246c2f9, 0x27f3bb9a, 0x10854cca, 0x528c7b6, 0x1b84f430, 0x960}},
{/*.val =*/{0x23fa6501, 0x1937a320, 0x201a4185, 0x1923617c, 0x13f9ddcd, 0x842a665, 0x29463db, 0xdc27a18, 0x4b0}},
{/*.val =*/{0x11fd3098, 0x2c9bd18e, 0x100d20c2, 0x2c91b0be, 0x29fceee6, 0x24215332, 0x14a31ed, 0x6e13d0c, 0x8258}},
{/*.val =*/{0x8fe984c, 0x164de8c7, 0x8069061, 0x1648d85f, 0x14fe7773, 0x3210a999, 0xa518f6, 0x3709e86, 0x412c}},
{/*.val =*/{0x247f4c26, 0x2b26f463, 0x24034830, 0x2b246c2f, 0x2a7f3bb9, 0x190854cc, 0x528c7b, 0x1b84f43, 0x2096}},
{/*.val =*/{0x323fa613, 0x15937a31, 0x3201a418, 0x35923617, 0x153f9ddc, 0x2c842a66, 0x2029463d, 0xdc27a1, 0x104b}},
{/*.val =*/{0x391fd121, 0xac9bd16, 0x3900d20c, 0x1ac91b0b, 0xa9fceee, 0x36421533, 0x3014a31e, 0x206e13d0, 0x8825}},
{/*.val =*/{0x1c8fe6a8, 0x564de89, 0x3c806906, 0xd648d85, 0x254fe777, 0x1b210a99, 0x180a518f, 0x303709e8, 0xc412}},
{/*.val =*/{0x2e47f354, 0x2b26f44, 0x3e403483, 0x26b246c2, 0x32a7f3bb, 0x2d90854c, 0xc0528c7, 0x181b84f4, 0x6209}},
{/*.val =*/{0x1723f9aa, 0x215937a2, 0x1f201a41, 0x33592361, 0x1953f9dd, 0x36c842a6, 0x6029463, 0x2c0dc27a, 0x3104}},
{/*.val =*/{0xb91fcd5, 0x30ac9bd1, 0x2f900d20, 0x39ac91b0, 0xca9fcee, 0x3b642153, 0x3014a31, 0x1606e13d, 0x1882}},
{/*.val =*/{0x25c8fc82, 0x18564de6, 0x17c80690, 0x1cd648d8, 0x2654fe77, 0x3db210a9, 0x2180a518, 0xb03709e, 0x8c41}},
{/*.val =*/{0x12e47e41, 0xc2b26f3, 0xbe40348, 0x2e6b246c, 0x332a7f3b, 0x1ed90854, 0x10c0528c, 0x2581b84f, 0x4620}},
{/*.val =*/{0x29723d38, 0x6159377, 0x5f201a4, 0x37359236, 0x19953f9d, 0xf6c842a, 0x28602946, 0x12c0dc27, 0xa310}},
{/*.val =*/{0x34b91e9c, 0x30ac9bb, 0x2f900d2, 0x3b9ac91b, 0xcca9fce, 0x7b64215, 0x343014a3, 0x9606e13, 0x5188}},
{/*.val =*/{0x3a5c8f4e, 0x18564dd, 0x217c8069, 0x1dcd648d, 0x26654fe7, 0x23db210a, 0x3a180a51, 0x4b03709, 0x28c4}},
{/*.val =*/{0x3d2e47a7, 0x20c2b26e, 0x30be4034, 0x2ee6b246, 0x1332a7f3, 0x31ed9085, 0x3d0c0528, 0x2581b84, 0x1462}},
{/*.val =*/{0x1e9721eb, 0x10615935, 0x185f201a, 0x37735923, 0x299953f9, 0x18f6c842, 0x1e860294, 0x12c0dc2, 0x8a31}},
{/*.val =*/{0x2f4b8f0d, 0x830ac98, 0x2c2f900d, 0x3bb9ac91, 0x14cca9fc, 0xc7b6421, 0xf43014a, 0x209606e1, 0xc518}},
{/*.val =*/{0x17a5c59e, 0x2418564a, 0x3617c806, 0x1ddcd648, 0x2a6654fe, 0x63db210, 0x27a180a5, 0x104b0370, 0xe28c}},
{/*.val =*/{0xbd2e2cf, 0x120c2b25, 0x1b0be403, 0xeee6b24, 0x15332a7f, 0x231ed908, 0x13d0c052, 0x82581b8, 0x7146}},
{/*.val =*/{0x25e96f7f, 0x29061590, 0xd85f201, 0x27773592, 0xa99953f, 0x118f6c84, 0x9e86029, 0x412c0dc, 0xb8a3}},
{/*.val =*/{0x12f4b5d7, 0x34830ac6, 0x6c2f900, 0x33bb9ac9, 0x54cca9f, 0x28c7b642, 0x4f43014, 0x2209606e, 0xdc51}},
{/*.val =*/{0x97a5903, 0x1a418561, 0x23617c80, 0x39ddcd64, 0x2a6654f, 0x1463db21, 0x27a180a, 0x3104b037, 0xee28}},
{/*.val =*/{0x24bd2a99, 0xd20c2ae, 0x11b0be40, 0x3ceee6b2, 0x215332a7, 0xa31ed90, 0x213d0c05, 0x1882581b, 0xf714}},
{/*.val =*/{0x125e9364, 0x6906155, 0x8d85f20, 0x3e777359, 0x10a99953, 0x2518f6c8, 0x309e8602, 0xc412c0d, 0xfb8a}},
{/*.val =*/{0x292f49b2, 0x34830aa, 0x246c2f90, 0x3f3bb9ac, 0x854cca9, 0x128c7b64, 0x384f4301, 0x6209606, 0x7dc5}},
{/*.val =*/{0x1497a4d9, 0x1a41855, 0x123617c8, 0x3f9ddcd6, 0x42a6654, 0x29463db2, 0x1c27a180, 0x23104b03, 0x3ee2}},
{/*.val =*/{0x2a4bd084, 0xd20c28, 0x91b0be4, 0x1fceee6b, 0x215332a, 0x14a31ed9, 0x2e13d0c0, 0x11882581, 0x9f71}},
{/*.val =*/{0x1525e842, 0x690614, 0x248d85f2, 0xfe77735, 0x210a9995, 0xa518f6c, 0x3709e860, 0x28c412c0, 0x4fb8}},
{/*.val =*/{0xa92f421, 0x34830a, 0x3246c2f9, 0x27f3bb9a, 0x10854cca, 0x528c7b6, 0x1b84f430, 0x14620960, 0x27dc}},
{/*.val =*/{0x5497828, 0x201a4183, 0x1923617c, 0x13f9ddcd, 0x842a665, 0x29463db, 0xdc27a18, 0xa3104b0, 0x93ee}},
{/*.val =*/{0x22a4bc14, 0x100d20c1, 0x2c91b0be, 0x29fceee6, 0x24215332, 0x14a31ed, 0x6e13d0c, 0x5188258, 0x49f7}},
{/*.val =*/{0x31525e0a, 0x8069060, 0x1648d85f, 0x14fe7773, 0x3210a999, 0xa518f6, 0x3709e86, 0x228c412c, 0x24fb}},
{/*.val =*/{0x18a92f05, 0x24034830, 0x2b246c2f, 0x2a7f3bb9, 0x190854cc, 0x528c7b, 0x1b84f43, 0x31462096, 0x127d}},
{/*.val =*/{0xc54959a, 0x3201a416, 0x35923617, 0x153f9ddc, 0x2c842a66, 0x2029463d, 0xdc27a1, 0x38a3104b, 0x893e}},
{/*.val =*/{0x62a4acd, 0x3900d20b, 0x1ac91b0b, 0xa9fceee, 0x36421533, 0x3014a31e, 0x206e13d0, 0x1c518825, 0x449f}},
{/*.val =*/{0x2315237e, 0x3c806903, 0xd648d85, 0x254fe777, 0x1b210a99, 0x180a518f, 0x303709e8, 0x2e28c412, 0xa24f}},
{/*.val =*/{0x318a91bf, 0x3e403481, 0x26b246c2, 0x32a7f3bb, 0x2d90854c, 0xc0528c7, 0x181b84f4, 0x37146209, 0x5127}},
{/*.val =*/{0x38c546f7, 0x1f201a3e, 0x33592361, 0x1953f9dd, 0x36c842a6, 0x6029463, 0x2c0dc27a, 0x3b8a3104, 0xa893}},
{/*.val =*/{0x1c62a193, 0x2f900d1d, 0x39ac91b0, 0xca9fcee, 0x3b642153, 0x3014a31, 0x1606e13d, 0x3dc51882, 0xd449}},
{/*.val =*/{0x2e314ee1, 0x17c8068c, 0x1cd648d8, 0x2654fe77, 0x3db210a9, 0x2180a518, 0xb03709e, 0x3ee28c41, 0xea24}},
{/*.val =*/{0x1718a588, 0xbe40344, 0x2e6b246c, 0x332a7f3b, 0x1ed90854, 0x10c0528c, 0x2581b84f, 0x1f714620, 0xf512}},
{/*.val =*/{0xb8c52c4, 0x5f201a2, 0x37359236, 0x19953f9d, 0xf6c842a, 0x28602946, 0x12c0dc27, 0xfb8a310, 0x7a89}},
{/*.val =*/{0x5c62962, 0x2f900d1, 0x3b9ac91b, 0xcca9fce, 0x7b64215, 0x343014a3, 0x9606e13, 0x27dc5188, 0x3d44}},
{/*.val =*/{0x22e314b1, 0x217c8068, 0x1dcd648d, 0x26654fe7, 0x23db210a, 0x3a180a51, 0x4b03709, 0x13ee28c4, 0x1ea2}},
{/*.val =*/{0x11718870, 0x30be4032, 0x2ee6b246, 0x1332a7f3, 0x31ed9085, 0x3d0c0528, 0x2581b84, 0x9f71462, 0x8f51}},
{/*.val =*/{0x8b8c438, 0x185f2019, 0x37735923, 0x299953f9, 0x18f6c842, 0x1e860294, 0x12c0dc2, 0x24fb8a31, 0x47a8}},
{/*.val =*/{0x245c621c, 0x2c2f900c, 0x3bb9ac91, 0x14cca9fc, 0xc7b6421, 0xf43014a, 0x209606e1, 0x127dc518, 0x23d4}},
{/*.val =*/{0x122e310e, 0x3617c806, 0x1ddcd648, 0x2a6654fe, 0x63db210, 0x27a180a5, 0x104b0370, 0x93ee28c, 0x11ea}},
{/*.val =*/{0x9171887, 0x1b0be403, 0xeee6b24, 0x15332a7f, 0x231ed908, 0x13d0c052, 0x82581b8, 0x49f7146, 0x8f5}},
{/*.val =*/{0x248b8a5b, 0xd85f1ff, 0x27773592, 0xa99953f, 0x118f6c84, 0x9e86029, 0x412c0dc, 0x224fb8a3, 0x847a}},
{/*.val =*/{0x3245c345, 0x6c2f8fd, 0x33bb9ac9, 0x54cca9f, 0x28c7b642, 0x4f43014, 0x2209606e, 0x1127dc51, 0xc23d}},
{/*.val =*/{0x3922dfba, 0x23617c7c, 0x39ddcd64, 0x2a6654f, 0x1463db21, 0x27a180a, 0x3104b037, 0x2893ee28, 0xe11e}},
{/*.val =*/{0x1c916fdd, 0x11b0be3e, 0x3ceee6b2, 0x215332a7, 0xa31ed90, 0x213d0c05, 0x1882581b, 0x1449f714, 0x708f}},
{/*.val =*/{0xe48b606, 0x8d85f1d, 0x3e777359, 0x10a99953, 0x2518f6c8, 0x309e8602, 0xc412c0d, 0x2a24fb8a, 0xb847}},
{/*.val =*/{0x27245b03, 0x246c2f8e, 0x3f3bb9ac, 0x854cca9, 0x128c7b64, 0x384f4301, 0x6209606, 0x35127dc5, 0x5c23}},
{/*.val =*/{0x13922b99, 0x123617c5, 0x3f9ddcd6, 0x42a6654, 0x29463db2, 0x1c27a180, 0x23104b03, 0x3a893ee2, 0xae11}},
{/*.val =*/{0x29c913e4, 0x91b0be0, 0x1fceee6b, 0x215332a, 0x14a31ed9, 0x2e13d0c0, 0x11882581, 0x3d449f71, 0xd708}},
{/*.val =*/{0x14e489f2, 0x248d85f0, 0xfe77735, 0x210a9995, 0xa518f6c, 0x3709e860, 0x28c412c0, 0x1ea24fb8, 0x6b84}},
};
#endif

#if USE_PRECOMPUTED_CP
const curve_point secp256k1_cp[256] = {
{/*.x =*/{/*.val =*/{0x16f81798, 0x27ca056c, 0x1ce28d95, 0x26ff36cb, 0x70b0702, 0x18a573a, 0xbbac55a, 0x199fbe77, 0x79be}},
 /*.y =*/{/*.val =*/{0x3b10d4b8, 0x311f423f, 0x28554199, 0x5ed1229, 0x1108a8fd, 0x13eff038, 0x3c4655da, 0x369dc9a8, 0x483a}}},
{/*.x =*/{/*.val =*/{0x1c709ee5, 0x2eb026e5, 0xef3ca7a, 0x1de392e3, 0x7cd85c, 0x1501ba57, 0x17d6d304, 0x1fe5107b, 0xc604}},
 /*.y =*/{/*.val =*/{0x10cfe52a, 0xd90c6a5, 0x266d0e12, 0x3d8c994c, 0x2ceaeef7, 0x16106519, 0x1c339a3c, 0x1a3fa98f, 0x1ae1}}},
{/*.x =*/{/*.val =*/{0x28c4cd13, 0x13ea52af, 0x2e075847, 0x1b04e403, 0xb1404cc, 0x3924124c, 0x180f3581, 0x36fc7043, 0xe493}},
 /*.y =*/{/*.val =*/{0x7739922, 0x3fa5ef71, 0x3bdfe40c, 0x19eb8cef, 0x251448d9, 0xb88263a, 0x55b7564, 0x264fa835, 0x51ed}}},
{/*.x =*/{/*.val =*/{0x210a2a01, 0x1de13bcf, 0x1af888a6, 0x6f74179, 0xf3c2f0a, 0xe10fedc, 0x2351daff, 0x39785732, 0x2f01}},
 /*.y =*/{/*.val =*/{0x2cbde904, 0x1768b2dd, 0x25b7617b, 0x3884f5ae, 0x2d13b4c2, 0x3420a84c, 0x39949293, 0x2a29d054, 0x5c4d}}},
{/*.x =*/{/*.val =*/{0x2a6dec0a, 0x113ba278, 0x7a5ae9c, 0x28c4da6e, 0x23e97b2, 0x6aaf087, 0x29ec5301, 0x33a4ed67, 0xe60f}},
 /*.y =*/{/*.val =*/{0x29616821, 0x7ccb339, 0xd23f0be, 0x25a24791, 0x39371012, 0x267cd3d5, 0x195929db, 0x141ce679, 0xf7e3}}},
{/*.x =*/{/*.val =*/{0x7143e65, 0x17436f50, 0x104a61d7, 0x33ff2e26, 0x3378ceda, 0x1b81538b, 0x1a22d47b, 0x2675d3ed, 0xd301}},
 /*.y =*/{/*.val =*/{0x24106ab9, 0x16cffc7c, 0xed81960, 0x1d8330d9, 0x380651f, 0x1b7b27a6, 0x3d5c3b3d, 0x236742b8, 0x9503}}},
{/*.x =*/{/*.val =*/{0x3874ef8b, 0xde4639b, 0x1bafd81e, 0x131bc773, 0x32823cfc, 0x147abe0, 0x2eab70b1, 0x30550b45, 0xbf23}},
 /*.y =*/{/*.val =*/{0x26831d9f, 0x370dfbf9, 0x11e2f784, 0x8bf1520, 0x1392e4c5, 0x24a282e9, 0x3737ad, 0x219bf0cc, 0x5cb3}}},
{/*.x =*/{/*.val =*/{0x2769a24e, 0x11c1dd15, 0x5356556, 0x3d5735c0, 0x11671cbc, 0x30f427df, 0x37a06696, 0xef900cf, 0x34ff}},
 /*.y =*/{/*.val =*/{0x33cc2f1a, 0x124419e9, 0xf8b6818, 0x37c5b0fa, 0x32098c55, 0x18676260, 0x36c553f6, 0x4588e88, 0x5d9d}}},
{/*.x =*/{/*.val =*/{0x15f51508, 0x191b88ff, 0x1ac1ca10, 0x30e72af5, 0x2de238d8, 0x29b8f85c, 0x209d9ea2, 0x98c84b1, 0x8282}},
 /*.y =*/{/*.val =*/{0x36e26caf, 0xc6dbabf, 0x37b17bed, 0x3584eb0b, 0x360ace62, 0x95ba0c2, 0x3dfe45e8, 0x2a026155, 0x11f8}}},
{/*.x =*/{/*.val =*/{0x2f34a24d, 0x9b8b003, 0x1e159d09, 0x36f25a36, 0x3918d50a, 0x2a15ea73, 0x39ff3905, 0x1c2ca1e9, 0x4653}},
 /*.y =*/{/*.val =*/{0x333887f4, 0xbe3ec82, 0x1d37a10a, 0x23826c85, 0x2ec2c158, 0x3e2f6bf7, 0xc082a4a, 0xc6ce0da, 0x35e5}}},
{/*.x =*/{/*.val =*/{0x2285131f, 0x16e406cb, 0x13b088d, 0x3b1bb372, 0x2d6240aa, 0x12863d9a, 0xbd77d66, 0x3aee388f, 0x241f}},
 /*.y =*/{/*.val =*/{0x2750026d, 0x2ecf99bc, 0x10cb5afa, 0x143f43ef, 0x181df8cd, 0x1082f44e, 0xf8d3d6c, 0x1e367fe5, 0x5133}}},
{/*.x =*/{/*.val =*/{0x1b920471, 0x372d8c1a, 0x23de0de, 0xc62e17d, 0x18f8d9fc, 0x1330a60f, 0x2fa79fce, 0x36d3a85c, 0x5d1b}},
 /*.y =*/{/*.val =*/{0x37b83103, 0xcc199b, 0x2c56e7b7, 0x3ac7a665, 0x22265679, 0x2ee650e2, 0x39e2e794, 0x2099de4d, 0x2843}}},
{/*.x =*/{/*.val =*/{0x11e5b739, 0xff396d5, 0x12222ed7, 0x2e4e0cff, 0x3c846de0, 0x26731b1b, 0x3865a72f, 0x567dca2, 0x175e}},
 /*.y =*/{/*.val =*/{0x29fed695, 0x3be9bffb, 0x124345c6, 0x2d6556b7, 0x371f5eac, 0x3e5e947f, 0x79eba4e, 0x1b83678f, 0xd350}}},
{/*.x =*/{/*.val =*/{0x6bc47d6, 0x39e01279, 0x2da121bc, 0x3f7fad71, 0x39c62130, 0x3ef32384, 0x332d7a5f, 0x4fc0ff, 0x423a}},
 /*.y =*/{/*.val =*/{0xb548a34, 0x48db9b6, 0x24f009ed, 0x363b0d4, 0x36b3c772, 0x1e7deeeb, 0x1d970a11, 0x3803f878, 0xb91a}}},
{/*.x =*/{/*.val =*/{0x416824a, 0xb7dbde, 0x33e27413, 0x37d98bce, 0x16877649, 0x1e9eaf3, 0x3b905089, 0x1a916b07, 0x111d}},
 /*.y =*/{/*.val =*/{0x2108e9d0, 0x26844750, 0x2daca4ca, 0x1c002265, 0x65952f0, 0x35236ffc, 0x2affbb90, 0x244711e3, 0x696}}},
{/*.x =*/{/*.val =*/{0x1bced775, 0x2d7b7780, 0x2f74e56a, 0x242da297, 0x39dcff72, 0x2576faf2, 0x3c8b8ad7, 0x1b725eb1, 0x4a4a}},
 /*.y =*/{/*.val =*/{0x278dd66d, 0xafe3da2, 0x24742acb, 0x3a4336d0, 0xf4571d, 0x3be7dce7, 0x31e72943, 0x46c0598, 0x5299}}},
{/*.x =*/{/*.val =*/{0x3ff4640, 0x9aeb63e, 0x1552ffe5, 0x11071f95, 0x262ee053, 0x3ab016d8, 0xc9c99c, 0x243511ec, 0x363d}},
 /*.y =*/{/*.val =*/{0x3bee9de9, 0x800f1fc, 0x199ecb6, 0x2e6a2402, 0x33363145, 0x2d114e5f, 0x32221953, 0x1ceb7f1c, 0x4e2}}},
{/*.x =*/{/*.val =*/{0x2f92c541, 0x9c4a972, 0x2dfb59dd, 0x18bec04b, 0x3b02bf0b, 0x25cf1b24, 0x27e9b553, 0x2619bb66, 0x4c1b}},
 /*.y =*/{/*.val =*/{0x68fe020, 0xb13cff7, 0x3eb1ad7, 0x14bab5f9, 0x16e69cc6, 0x32dd4f39, 0x28a0f7fb, 0x24b4c82f, 0xc1f7}}},
{/*.x =*/{/*.val =*/{0x3eaaf3d1, 0x323ca32, 0x228f135e, 0xcfb6f06, 0xb54e32, 0x28bcf01e, 0x3b12b529, 0xe1deea0, 0xa408}},
 /*.y =*/{/*.val =*/{0x30b254b9, 0x4ad4d37, 0x2d1ef90b, 0x79d5db, 0x21b3e220, 0x3e0f5a4d, 0x3bc79b8b, 0x3d84bfbb, 0x40e9}}},
{/*.x =*/{/*.val =*/{0x3940d33a, 0x334f6d69, 0x14203b98, 0x3620291, 0x16c86f6e, 0x38f868bd, 0xc0b53a4, 0x319074a3, 0xa804}},
 /*.y =*/{/*.val =*/{0x2d46967a, 0xf3a57e9, 0xf736a94, 0x3c632a27, 0x2047e81a, 0x30a10b05, 0x3a6d03de, 0x20c94acb, 0x95be}}},
{/*.x =*/{/*.val =*/{0x1ffdf80c, 0x27de6957, 0x15bcd1b6, 0x3929e068, 0x5638843, 0x912d6dd, 0x3c2be8c6, 0x17c5977c, 0x8b4b}},
 /*.y =*/{/*.val =*/{0x1fd4fd36, 0xfbfc319, 0x162ee56b, 0x38cd9518, 0x30da04f9, 0x2f5e04ea, 0x308b4b3f, 0x29bda34, 0x4aad}}},
{/*.x =*/{/*.val =*/{0x755e4be, 0x2cfc99c5, 0x17c997ab, 0x2bd93b90, 0x3c611071, 0x5f1fb20, 0x291718ce, 0x1739384c, 0xed0c}},
 /*.y =*/{/*.val =*/{0x207bf42f, 0xfe7e9ba, 0x23ddab16, 0x364e495d, 0x3ea68049, 0x36b5fd69, 0x345bdbf3, 0x27f1ef08, 0x221a}}},
{/*.x =*/{/*.val =*/{0x7cec8ab, 0x12db9b20, 0x20552ced, 0xc95159b, 0x31fae8e5, 0x570fe0f, 0xe694b3b, 0x2c04f113, 0xfaec}},
 /*.y =*/{/*.val =*/{0x2b155070, 0x26077f66, 0x5e2e2e8, 0xcaca1ae, 0x2fb13d9c, 0x380b1bb0, 0x2cb57fc2, 0x2d7a43a7, 0xcc09}}},
{/*.x =*/{/*.val =*/{0x1ad1b1f7, 0x1fd93aba, 0x323cd3e0, 0x2cb76093, 0xbcafdb3, 0xc682cdf, 0x2d2f2c87, 0x2284cb72, 0x9bb}},
 /*.y =*/{/*.val =*/{0x3811c80, 0x104c189f, 0x752d536, 0x152a103d, 0x63e850f, 0x2774a13e, 0x2e3b9b6f, 0x2cacabfb, 0x945b}}},
{/*.x =*/{/*.val =*/{0x1232fcda, 0x2d845649, 0x2c0e77bc, 0x36ffe9, 0x1548c7b7, 0x1dc7002f, 0x3996d6bf, 0x2ea9b976, 0x723c}},
 /*.y =*/{/*.val =*/{0x1eb39f5f, 0x7701a76, 0x37949480, 0x1828194d, 0x24d6e26, 0x44dd222, 0xc498a92, 0x19ed5657, 0x96e8}}},
{/*.x =*/{/*.val =*/{0xca030d5, 0x3f4e0f58, 0x39849071, 0x90290c1, 0x33a3c62d, 0x35f7115d, 0x3744d343, 0x29e190de, 0x57ef}},
 /*.y =*/{/*.val =*/{0x34b02f9e, 0x1ead109, 0x1e9974ab, 0x26db4ab9, 0x1e03ec68, 0x189f24a3, 0x8518893, 0x36c2f46d, 0xd712}}},
{/*.x =*/{/*.val =*/{0xc584dd5, 0x3ebf1ddc, 0x27b012a7, 0x2015df8c, 0x226cb910, 0x3dfa7354, 0xbc42a2d, 0x2f50da8a, 0x264b}},
 /*.y =*/{/*.val =*/{0x3704ab11, 0x18489e4d, 0x17b8d8de, 0x46090dc, 0x33be226a, 0x1d738930, 0x93b4d4f, 0x1bea53b8, 0xd87c}}},
{/*.x =*/{/*.val =*/{0xb2438e8, 0x2fc9af61, 0x1bdec9d2, 0x22f187f5, 0x36a79da7, 0x21701588, 0xd2bbdac, 0x19492f50, 0xa94c}},
 /*.y =*/{/*.val =*/{0x318661f4, 0xb8b236f, 0xe39b2bc, 0x174f1828, 0x19e3a7e, 0x24865414, 0x16280fd7, 0x7f664be, 0xb520}}},
{/*.x =*/{/*.val =*/{0xe7dd7fa, 0x294cfb28, 0x3a919839, 0x11e5848d, 0x2d3b509, 0x3fbb204b, 0x2bf98ba5, 0x293524ef, 0xeebf}},
 /*.y =*/{/*.val =*/{0x21de8999, 0x37f53f6b, 0x311f712d, 0x393370e9, 0x38089d9a, 0x39fb6bc5, 0x2f0f269e, 0x2328e5c3, 0x5d9a}}},
{/*.x =*/{/*.val =*/{0x7d297fd, 0x1afba421, 0x36766d67, 0x3a92f023, 0x18495fc4, 0x3180c704, 0x17bfda61, 0x12b5e9ea, 0x381c}},
 /*.y =*/{/*.val =*/{0x3d493fc5, 0xeb38c61, 0x3939c009, 0x11440cb6, 0x115eccf0, 0x397e9c26, 0x2eee48f3, 0x3d4ec8e3, 0x936a}}},
{/*.x =*/{/*.val =*/{0x2ede454c, 0x1235c108, 0x3dd08b24, 0x3c7417fb, 0x138c479c, 0x420c765, 0x1c63bcce, 0x2e73416b, 0xe1ef}},
 /*.y =*/{/*.val =*/{0x28913797, 0x367f48ce, 0x3a2d4c6a, 0x138c9129, 0x7712346, 0x15307ff9, 0x39be7b01, 0x114c362b, 0xecb}}},
{/*.x =*/{/*.val =*/{0x29eb99a4, 0xcffbacc, 0x3d47b18d, 0x395067cc, 0x3475a8c7, 0x308d7a6b, 0x17010c5a, 0x3e6c689a, 0x5318}},
 /*.y =*/{/*.val =*/{0x3e91f92d, 0x31c9bbbb, 0x1e3ec652, 0x7cad034, 0x3405e8a4, 0xb64ebae, 0x1a419577, 0x33fad2fb, 0xf44c}}},
{/*.x =*/{/*.val =*/{0x39a48db0, 0x3f5e0d6c, 0x33c03bfe, 0x48568a6, 0x3bde459f, 0x742826d, 0x27167279, 0x11369a5b, 0x100f}},
 /*.y =*/{/*.val =*/{0x2bc65a09, 0x3ef57358, 0x35195ac0, 0x3fd2863f, 0x90666b7, 0x23ccc030, 0xb772ec, 0x384c64a8, 0xcdd9}}},
{/*.x =*/{/*.val =*/{0x1e4df706, 0x2c14a13c, 0x37d08084, 0x36723e48, 0xc4199d8, 0x577fcad, 0x1c771a84, 0x227cb3ad, 0x8c09}},
 /*.y =*/{/*.val =*/{0x1d72fa98, 0xdab168d, 0x16511aa7, 0x379afd45, 0x1c966c60, 0x85cb2e7, 0x32034ffd, 0x2f4113d0, 0xfb4d}}},
{/*.x =*/{/*.val =*/{0x1c47bffd, 0x798f0cf, 0x95bc1bb, 0x14a14e6f, 0x22c0259c, 0x1205d0c9, 0x26704c4a, 0x54f1789, 0xfb8f}},
 /*.y =*/{/*.val =*/{0x1949b095, 0x24291777, 0x5426130, 0x3784e26b, 0x3ccd531d, 0x284766d2, 0x621816f, 0x1ea77178, 0x6ca2}}},
{/*.x =*/{/*.val =*/{0xbb2629a, 0x23e86e2d, 0x337a7b8b, 0x280b161d, 0x28708465, 0x3327c29c, 0x151755a0, 0xccff5d7, 0xe747}},
 /*.y =*/{/*.val =*/{0x2946f6d6, 0x3e365869, 0x21a969a9, 0x20ddaa9b, 0xc2581c8, 0x10d80e01, 0x30c114cc, 0x3f805141, 0xf2af}}},
{/*.x =*/{/*.val =*/{0x2534fd2d, 0x322b379b, 0xf3b3852, 0x1fe35119, 0x4c017a7, 0x2489e928, 0x3ed1b1dc, 0x6f898b1, 0xe103}},
 /*.y =*/{/*.val =*/{0x1456a00d, 0x113c63ca, 0x21ced79a, 0x24b75067, 0x17535af2, 0x1a905d96, 0x405e6bb, 0x1864a250, 0x9d70}}},
{/*.x =*/{/*.val =*/{0x295c8356, 0x1389f8da, 0x294d8578, 0x229ab177, 0x29b2c902, 0x2577343c, 0x89eab9f, 0xfc89320, 0xf4b9}},
 /*.y =*/{/*.val =*/{0x3e001fd3, 0x356186e6, 0x115609ab, 0x1fbc4d12, 0xeee90c3, 0x17da9e90, 0x162dfb0e, 0x24bb018a, 0xa67a}}},
{/*.x =*/{/*.val =*/{0x3b160e8a, 0x358bf85, 0x17e696c2, 0x7a144be, 0x1b08b0d5, 0x188ba809, 0x15236b19, 0x2b287f39, 0x9d1}},
 /*.y =*/{/*.val =*/{0x3ca04c44, 0x13814315, 0x212b5e53, 0x3a783ba4, 0x18c27e6f, 0x19a4b383, 0x1f0c63e5, 0x623d440, 0x1153}}},
{/*.x =*/{/*.val =*/{0x35ba7fc2, 0x25f5f411, 0x3c39562e, 0x22cea4ef, 0x21cde751, 0xab5e4e0, 0x2b9e18a, 0x16731153, 0xc66c}},
 /*.y =*/{/*.val =*/{0x375f5956, 0x3b0f1a73, 0x15955977, 0x298376c, 0x10cb2f0, 0x13cf3aab, 0x30fcfbea, 0xbf8afec, 0xd959}}},
{/*.x =*/{/*.val =*/{0x1094696d, 0x3579a236, 0x1d6af52, 0x3e2c99a9, 0x3bd7ec5c, 0xa0e7c50, 0x15b530ac, 0x1b2b91b5, 0xfeea}},
 /*.y =*/{/*.val =*/{0x18090088, 0x5577afc, 0x41442d3, 0x72255f3, 0x3ecd5c98, 0x39384afc, 0xe1bab06, 0x1adb25f7, 0xe57c}}},
{/*.x =*/{/*.val =*/{0x2e752b08, 0x2a90102b, 0x331a1870, 0x7b2b82c, 0x32e17914, 0x986be76, 0x387e1c53, 0x2d886b6, 0x4d00}},
 /*.y =*/{/*.val =*/{0x8302cea, 0x39ca147d, 0x1c7293a3, 0x1f7d7c46, 0x1972cccb, 0x3609560b, 0xd255cb6, 0x16e3c638, 0x6a0d}}},
{/*.x =*/{/*.val =*/{0x75c58ef, 0x22658bf5, 0x21f1b77f, 0x15e8100f, 0x317128d6, 0x28988451, 0x1a05dd6a, 0x1c32880f, 0x71f5}},
 /*.y =*/{/*.val =*/{0x135d420e, 0x219269cb, 0x3363e7df, 0x11174030, 0x95b8df2, 0x155cd16f, 0x880dd25, 0x1056e577, 0xeb42}}},
{/*.x =*/{/*.val =*/{0x3ff8359, 0x122c181, 0x25e76516, 0x2d208771, 0x1da01446, 0xa0ad708, 0x3d253b7d, 0x2cd8a7de, 0xa2b7}},
 /*.y =*/{/*.val =*/{0x3e86fec2, 0x8e5ffb3, 0x6f3835a, 0x34420d41, 0x1e29c910, 0x24de8fdc, 0x1122d57a, 0xe2505a5, 0x6930}}},
{/*.x =*/{/*.val =*/{0x1ec6cb1, 0xfea5e2f, 0x8583de3, 0x3b595f60, 0x3fca3cfe, 0x1ef92f9b, 0x9cdcb36, 0x2a476441, 0xda67}},
 /*.y =*/{/*.val =*/{0x3a68be1d, 0x3a7aa389, 0xf740a17, 0x31eb7142, 0x1780e5de, 0x118fdfb2, 0x242bc41f, 0x2a8d5205, 0x9bac}}},
{/*.x =*/{/*.val =*/{0x1fe741c9, 0x3b8f3208, 0xea5a835, 0x2f67cd73, 0xd8718b, 0x3033eabc, 0x1ef587c0, 0x334d97e8, 0x4dba}},
 /*.y =*/{/*.val =*/{0x338eb623, 0x2f843e0, 0x3c0535f6, 0x30e12827, 0x38299d0c, 0x33f567a0, 0x1892e7fd, 0x1503a294, 0x16c3}}},
{/*.x =*/{/*.val =*/{0x34e218da, 0x1fb6a2ea, 0x26860508, 0x13217c54, 0x1c2590f, 0x3c5f63fd, 0x9beee68, 0x3ff12054, 0x13d1}},
 /*.y =*/{/*.val =*/{0x1b191c19, 0x36d0677, 0x15bd127e, 0x2b40481b, 0x3758bda4, 0x2e4cdec6, 0x1961dcec, 0xe47ea64, 0x6008}}},
{/*.x =*/{/*.val =*/{0x22e96db8, 0xced032a, 0x229dbff1, 0x327645b3, 0x30533b3c, 0x271e7116, 0x6000765, 0x13e73bdb, 0x219b}},
 /*.y =*/{/*.val =*/{0xd3b6bc7, 0x1f7c069e, 0x29057652, 0x13e2b14f, 0x372a6e39, 0x11060300, 0x1efeaf5a, 0x31817656, 0x24d9}}},
{/*.x =*/{/*.val =*/{0x1a37b7c0, 0x1d517330, 0x311069f5, 0x2343dee, 0x322151ec, 0x24d7b, 0x34cdda6e, 0x13ea82cc, 0x5390}},
 /*.y =*/{/*.val =*/{0x22771c8, 0x372c25ac, 0x14434699, 0x26666078, 0xd3c1c13, 0x27b32b08, 0x106d88c, 0x21f42f20, 0x5bc0}}},
{/*.x =*/{/*.val =*/{0x38a47ca9, 0x1f343c7c, 0x10f85ad5, 0x1bb9eaab, 0x16995d2a, 0x2644658c, 0x146753cf, 0x1d6be750, 0x1a5}},
 /*.y =*/{/*.val =*/{0x37ebcdb7, 0x1f177cb9, 0x34d7ea66, 0x2e4f1767, 0x3b8698bd, 0x17f14b86, 0x20dc3cc5, 0x3c72e2ac, 0x3038}}},
{/*.x =*/{/*.val =*/{0x2315565b, 0xc275d57, 0x3c20c6ee, 0x2986a0f4, 0x2155d6d3, 0x7d706dd, 0x1d439ca7, 0x3810dd88, 0xf5f0}},
 /*.y =*/{/*.val =*/{0x1d2ecc82, 0x1e10c2bf, 0x2d7e40a6, 0x2fd86fcf, 0x37101aa5, 0x6245837, 0x2052bf62, 0x1398af96, 0x6b9f}}},
{/*.x =*/{/*.val =*/{0x35362d33, 0x2f9e0767, 0x2227642c, 0x32f24851, 0xca4e347, 0x1fcdb65c, 0x36e9a57a, 0x1bc2db02, 0x8f50}},
 /*.y =*/{/*.val =*/{0x7fa243f, 0x121f432, 0x3bb8eaf3, 0x33e49750, 0x1c336848, 0x315093c, 0x26171953, 0x25574abe, 0x469f}}},
{/*.x =*/{/*.val =*/{0x3ad86047, 0x3fe567d0, 0x29b8bcae, 0x2d4e810e, 0xa906779, 0x3329dd93, 0x183a7719, 0x3342f4d6, 0x8e7b}},
 /*.y =*/{/*.val =*/{0x460372a, 0x284011fa, 0x3fd68b3e, 0x3a238b91, 0x29514579, 0xc410832, 0x1a4b3940, 0x1dc2ca8f, 0x10b7}}},
{/*.x =*/{/*.val =*/{0x313f0351, 0x1f4a022f, 0x10389e77, 0x3056e34f, 0x2950df3b, 0x3cc6665, 0x2729dc35, 0x16ea8657, 0x33b3}},
 /*.y =*/{/*.val =*/{0xb8d7418, 0x2f140f33, 0x889b702, 0x19583bef, 0xd52bcaa, 0x1900d892, 0x2bf87f94, 0x615902, 0xa58a}}},
{/*.x =*/{/*.val =*/{0x414bb36, 0x1c771ec9, 0x2d7bca6d, 0x3db84272, 0x1f7e2256, 0x20eb481c, 0x13f955cb, 0x3bab88b2, 0x374d}},
 /*.y =*/{/*.val =*/{0xdaf734a, 0x21d6faa6, 0xe543217, 0xa3598c0, 0x6f72938, 0xcb01be0, 0x14f99160, 0x196d93f3, 0x1711}}},
{/*.x =*/{/*.val =*/{0x2ae7d616, 0x3a2992b5, 0x22a9f0c5, 0x136ebcad, 0x2eb0dc94, 0x1b81ce56, 0x2eae57c4, 0x30271fce, 0x2380}},
 /*.y =*/{/*.val =*/{0x161bbc1a, 0x266f920, 0x38467560, 0x2be48523, 0x9b09a93, 0x262bbf54, 0x956af15, 0x21864d19, 0x6f8e}}},
{/*.x =*/{/*.val =*/{0x19c43862, 0x2a107856, 0x397e6690, 0x29fd3c60, 0x381bde71, 0x2061a26, 0x1ff21e6d, 0x3b4d3073, 0x385e}},
 /*.y =*/{/*.val =*/{0x142e5453, 0x1163f95, 0x86dc8cc, 0xc13bb08, 0x2bf4576b, 0x77867a7, 0x223f5670, 0x3af0fa3a, 0x283b}}},
{/*.x =*/{/*.val =*/{0x38f2827c, 0x320e89c1, 0x2fc1ce2d, 0x320990af, 0x1f67d147, 0x1af84d35, 0x35480045, 0x8820f6b, 0xf6f6}},
 /*.y =*/{/*.val =*/{0x20aaa102, 0x56c82d4, 0x321bf6d, 0x15f29d12, 0x27cee7e6, 0x315c56cd, 0x33a0faf2, 0x13a05f79, 0x1bcd}}},
{/*.x =*/{/*.val =*/{0x315adcb6, 0x3624c825, 0x18c6f369, 0x2470f39f, 0x1fc255cd, 0x32cf0f4, 0x13de2bd7, 0x394623e5, 0xfb26}},
 /*.y =*/{/*.val =*/{0x18ba68f3, 0x276f28ed, 0xb7ab544, 0x34b2cc6e, 0x10176916, 0x211a9c67, 0x2a34d58e, 0xa204404, 0xf3e1}}},
{/*.x =*/{/*.val =*/{0x20788c1e, 0x35136dd5, 0x28bd1d7e, 0x230dc183, 0x3ceab7d1, 0x171af1d8, 0x1132d28f, 0x896446e, 0x8991}},
 /*.y =*/{/*.val =*/{0xe8f0ef1, 0xd71088a, 0x1ef9e116, 0x25a7213f, 0x3136fa36, 0x21d8d566, 0x1ac9b27b, 0x13661f32, 0xda8b}}},
{/*.x =*/{/*.val =*/{0x3fac3a7, 0x181bb61b, 0x147fbc9c, 0x377e1296, 0x3dfa180f, 0x31ce9104, 0xf191637, 0x366e00fb, 0x6f9}},
 /*.y =*/{/*.val =*/{0x3a842160, 0x21a24180, 0x281002d, 0x29374bd7, 0x5c4d47e, 0x238a8c39, 0x59ba69b, 0x31a3980c, 0x7c80}}},
{/*.x =*/{/*.val =*/{0xb7fd72d, 0x327489d1, 0x3e4da175, 0x5d17969, 0x82939da, 0x30db0a11, 0x3411c1cd, 0x3bba894a, 0xae86}},
 /*.y =*/{/*.val =*/{0xeee38bc, 0xcd32de9, 0x72f7282, 0x24845545, 0x1ff0e98d, 0x2c2b3962, 0x302f962a, 0x24f25c1c, 0x19e9}}},
{/*.x =*/{/*.val =*/{0x3c169290, 0x2851d099, 0x336f2ee7, 0x62f9d73, 0x1c2c4887, 0x34be315b, 0x3ff55e61, 0x327e42ef, 0x2248}},
 /*.y =*/{/*.val =*/{0x83ea257, 0x1a76284a, 0x1da2be23, 0x18dd408d, 0x35ba18e1, 0x1aed56d0, 0x1eed7a50, 0x251a4b48, 0xfa05}}},
{/*.x =*/{/*.val =*/{0x350964e3, 0x3436b12e, 0x11c6f76f, 0x27c21df7, 0x85d0a9, 0x46d2365, 0x44074ac, 0x1b85b817, 0xe11a}},
 /*.y =*/{/*.val =*/{0x682bfc8, 0x19fefe2c, 0x318c6f7, 0x2b71b84e, 0x30af2417, 0x3578965b, 0x2d430e1a, 0x196e1e8, 0x87d6}}},
{/*.x =*/{/*.val =*/{0x2d0e6bd, 0xedf839d, 0x30f5e531, 0x1d3458f6, 0xd6ecbf7, 0x851f041, 0x4e2582a, 0x3500490f, 0x3322}},
 /*.y =*/{/*.val =*/{0x2c28b2a0, 0x13ce8ba5, 0x2873af62, 0x17d8fa8, 0x1af9b728, 0x66f137, 0x24ef5bfb, 0x1e5fa59, 0x56e7}}},
{/*.x =*/{/*.val =*/{0xade462, 0x31a5b4cb, 0x2dbcf29f, 0x1337723a, 0x80cd50d, 0x3bcc6c13, 0x2bdae120, 0x8009433, 0x8d26}},
 /*.y =*/{/*.val =*/{0xf26470c, 0x2382a2e4, 0x2678b3ad, 0x12bed39c, 0x2e36ba1d, 0x3dbcb70f, 0x3f437d31, 0xeed1c56, 0xebed}}},
{/*.x =*/{/*.val =*/{0x1516e633, 0x59190f8, 0x32d9c8b9, 0x3524c341, 0x14d03b8e, 0x1a287d6, 0x2bea9ce4, 0x301d9bab, 0x1238}},
 /*.y =*/{/*.val =*/{0x77b7805, 0x1736dca3, 0x7402280, 0x11894b73, 0x3dc1709, 0x25e78b47, 0x31359d6c, 0x2c0b6ec9, 0x8a9d}}},
{/*.x =*/{/*.val =*/{0x388e7a66, 0x26c05549, 0x30ec2161, 0x3735ca0a, 0x2a11b9cd, 0xba9d629, 0x39c15e7b, 0x16c1dc32, 0x271d}},
 /*.y =*/{/*.val =*/{0x203c9727, 0x2a35c963, 0x8a824e7, 0x281978d4, 0x2c877fe2, 0x1f426526, 0x3f491e45, 0x29160d39, 0x5d3a}}},
{/*.x =*/{/*.val =*/{0x134ab83, 0x875d34a, 0x36433977, 0x6cfe6bd, 0x26586874, 0x5dc3625, 0xb7da2bd, 0xb1f4b78, 0x8567}},
 /*.y =*/{/*.val =*/{0x390313a6, 0x238c253d, 0x1298f44c, 0x1fc5ff31, 0x22c2e5e7, 0x10126fe9, 0x3b2eb637, 0x6e6d6d0, 0x7c48}}},
{/*.x =*/{/*.val =*/{0x1f17fc25, 0x262e42f0, 0x32e6d969, 0x227a91b7, 0x8a61f3b, 0x6184857, 0x39ec036c, 0x33dadd03, 0x534c}},
 /*.y =*/{/*.val =*/{0xfe86e76, 0x1c71fdbb, 0x3dd28ddd, 0x38f49def, 0x1543550a, 0x2b8f74cb, 0x32ddb462, 0x172c2722, 0xd571}}},
{/*.x =*/{/*.val =*/{0x28bee8b6, 0x1c5c248f, 0xfbc8d2c, 0x8351fb, 0x38aaed79, 0x38508063, 0x3b7f3081, 0x7d73ba1, 0xa91d}},
 /*.y =*/{/*.val =*/{0x10644c1, 0xf45aa9, 0x28cb2250, 0x15a7d8, 0x1ad3b2f8, 0x6272377, 0x38ee15a7, 0xc93b8b7, 0x748a}}},
{/*.x =*/{/*.val =*/{0x1984cf74, 0x28687095, 0x2f61f10a, 0xd6b916f, 0x14383c07, 0x853778b, 0x8e35c1a, 0x2308f643, 0xc15c}},
 /*.y =*/{/*.val =*/{0x39ccb000, 0x12923360, 0xb015a2c, 0x2fddcb54, 0x1fd7ba47, 0x31bd1789, 0x22235c8d, 0x15360a14, 0x2ba9}}},
{/*.x =*/{/*.val =*/{0x20c82a0a, 0x3f6566bd, 0x3668832f, 0x2489b183, 0x1413b10f, 0x1b27c646, 0x188a46b0, 0x2fe026c6, 0x948}},
 /*.y =*/{/*.val =*/{0x18c8e589, 0x132dfe23, 0x17cd2bed, 0x137fc232, 0x3418c6d, 0x2dd31747, 0x36646dc6, 0x18a15b72, 0x53a5}}},
{/*.x =*/{/*.val =*/{0x3e8b000a, 0x25bac115, 0x2825e513, 0x5b04cc7, 0x11f0b6ef, 0x3393198a, 0x259360d5, 0xb1fcdcb, 0x2695}},
 /*.y =*/{/*.val =*/{0x5ef705a, 0x30f5007c, 0x13d67318, 0x2f8e63d9, 0x288422de, 0x3224f4b5, 0xa68862b, 0x3a931600, 0xf513}}},
{/*.x =*/{/*.val =*/{0x36134f96, 0x4096225, 0x2d6b0e9f, 0x846595c, 0x1ff243f5, 0xafa2c4c, 0x3c5bdbef, 0x1639bf08, 0xc62e}},
 /*.y =*/{/*.val =*/{0x114cf97e, 0x89dfb53, 0x3731c3e8, 0x3ee14d58, 0x141fc5bc, 0x359d9d4c, 0x1a1678c3, 0x209f516c, 0x4397}}},
{/*.x =*/{/*.val =*/{0xb188cbb, 0x1a1be200, 0x7de973, 0x700c802, 0x2622b0b8, 0xcca69c5, 0x5c74168, 0x181483bb, 0x1074}},
 /*.y =*/{/*.val =*/{0x1f272124, 0x75ed8d8, 0x1ce3da60, 0xb835d23, 0x354a1124, 0x9ae6e73, 0x1598c353, 0x35302688, 0xabe5}}},
{/*.x =*/{/*.val =*/{0x338fd8e8, 0x33b36067, 0x69752ac, 0x2c39137f, 0x2873a8f1, 0x19f383c0, 0x1c34f0, 0x339fd186, 0x6260}},
 /*.y =*/{/*.val =*/{0x32b4ae17, 0x6a13a56, 0x51c198c, 0x34a488e0, 0x2a1ef7ec, 0x24125dd, 0x1b571a7f, 0x2a0adbe9, 0xbc2d}}},
{/*.x =*/{/*.val =*/{0x3d477c2d, 0x1d99d1bc, 0x2aad27e0, 0x39971465, 0xf1a1316, 0x21026fa1, 0x11a73dec, 0x3691d22b, 0x85d8}},
 /*.y =*/{/*.val =*/{0x7d1dd70, 0x1e605bf, 0x3c4d5a62, 0x2c28080c, 0x2fc7bc94, 0x2d4d94c7, 0x6690586, 0x22d4d997, 0x5894}}},
{/*.x =*/{/*.val =*/{0x2c0b80d9, 0x2140c4b5, 0x3dc47f04, 0x79f8403, 0x3ee3ee4d, 0x224ba730, 0x4b968c0, 0x1c59b9fb, 0x8e2a}},
 /*.y =*/{/*.val =*/{0x16b29f50, 0x27187cab, 0x306349a4, 0x25eda235, 0x2a9d4852, 0x374a6dc5, 0xbe592ce, 0x2ea6b8b, 0xeadb}}},
{/*.x =*/{/*.val =*/{0x2c4561be, 0x2487e8f4, 0x359d90f9, 0x12acba04, 0xf8950ee, 0xd9bb35e, 0x3f58edc8, 0x31d610af, 0x769b}},
 /*.y =*/{/*.val =*/{0x30d9685f, 0x16482ffe, 0x37873add, 0x285ddd9e, 0x3f5d4741, 0x33933bdc, 0x383bac8d, 0x5cd8bf9, 0x4bf8}}},
{/*.x =*/{/*.val =*/{0x2037fa2d, 0x254f3234, 0x1bfdc432, 0xfb23d5d, 0x3f410304, 0xd21052e, 0x1d8d43d8, 0x1f782bf0, 0xe503}},
 /*.y =*/{/*.val =*/{0x1d755bda, 0x3977210, 0x481f10e, 0x17d6c0fb, 0x190bddbd, 0x263427ee, 0xd3b5f9f, 0x14d2eaa5, 0x4571}}},
{/*.x =*/{/*.val =*/{0x1e3d34ef, 0x318f231e, 0x12a2ddb8, 0x2ac85f1e, 0x161b3ec3, 0x2db3df4b, 0x15494f40, 0x36919ff, 0xa5e0}},
 /*.y =*/{/*.val =*/{0x2f7adb4c, 0x21571738, 0x10900acb, 0x18373f9e, 0x3f43d25b, 0x1c9bfa66, 0x8555421, 0x397d7958, 0x98f}}},
{/*.x =*/{/*.val =*/{0x17b91252, 0x19cdc583, 0x77572ae, 0x12bf4b91, 0x1bfbc46d, 0x27d2ec72, 0x22b40351, 0x57d7bce, 0xa994}},
 /*.y =*/{/*.val =*/{0xbedc264, 0xe8ddeb1, 0x10f4ddd7, 0x2685ab56, 0x36f6b689, 0xbc43c93, 0x1f84bb9e, 0x39932ba0, 0x82d0}}},
{/*.x =*/{/*.val =*/{0x2a540f17, 0x231196d9, 0x30c132bd, 0x1d435c17, 0x3935f84c, 0x3b778263, 0x3d1fc7d8, 0x13a7e793, 0xb56f}},
 /*.y =*/{/*.val =*/{0x200102d, 0x1a8bf2b8, 0x3cca8544, 0x350a58f2, 0x182d1d21, 0x3046b7c1, 0xa856d3d, 0x394d0a73, 0x32e8}}},
{/*.x =*/{/*.val =*/{0x24fce725, 0x1619a82b, 0x2a6c5b72, 0x3a36f471, 0x1771b4e7, 0x2a417a3c, 0x207adf5e, 0x1cac3d28, 0xe063}},
 /*.y =*/{/*.val =*/{0xeee31dd, 0x9c0d3e5, 0x3104870b, 0x12129de1, 0x1a488cd7, 0x9eecab5, 0x18cfe12a, 0x225d2f38, 0x7a90}}},
{/*.x =*/{/*.val =*/{0x3ed2ff3e, 0x3826bb90, 0x2c6ed3cf, 0x17aff6d3, 0x2d3f3c04, 0x36f4c13e, 0x6b8f9c8, 0x4d32881, 0xeac}},
 /*.y =*/{/*.val =*/{0x3d210988, 0x5c81881, 0x3f21376e, 0x67da5ad, 0x311799ac, 0x3c40efca, 0x19b4245b, 0x36f9e4d, 0x4963}}},
{/*.x =*/{/*.val =*/{0x1fbfa4dc, 0x1d9c1b93, 0xc85b174, 0x25229e01, 0x1bb41ff5, 0x84675eb, 0x3ea19839, 0x21641cc7, 0xd678}},
 /*.y =*/{/*.val =*/{0x3d3b5406, 0x29ef35ae, 0x1c9a07cc, 0x1bc7137, 0x1c13aa62, 0x3bd71b48, 0x63c4940, 0x2a322754, 0x28ea}}},
{/*.x =*/{/*.val =*/{0x248ff9b3, 0x9d7ed03, 0x199b01a7, 0x2c698815, 0x371d4bc7, 0x3c843c4a, 0x40974ab, 0x3f32f668, 0x6930}},
 /*.y =*/{/*.val =*/{0xee96a4e, 0x3f76ad7e, 0xacc51ac, 0x3e6c4f9, 0x1f6d7809, 0x3f36e1d, 0x301eada3, 0x2ba52e51, 0x7f02}}},
{/*.x =*/{/*.val =*/{0x10559754, 0x2b5a423, 0x2a3f5854, 0x2c42f778, 0xce02204, 0x2efe770, 0x1d45358d, 0x1e9c5735, 0x213c}},
 /*.y =*/{/*.val =*/{0x34b458f2, 0x3fcb09d4, 0x36a7eedd, 0x12143d7c, 0x1ba190bb, 0xeb41891, 0x6250701, 0x2b42d6b9, 0x4b6d}}},
{/*.x =*/{/*.val =*/{0xec87fac, 0x264e2578, 0x22e7cf08, 0x6ae5d18, 0x23480e0d, 0x3a7fb60c, 0x9a7f66a, 0x15204cad, 0x1c5e}},
 /*.y =*/{/*.val =*/{0x1fc2d4ef, 0x1575ecf5, 0x2fe324c5, 0x37ab3ac9, 0xc2ad3a3, 0x2567e875, 0x3468f2bb, 0x3d83e0df, 0x4ffc}}},
{/*.x =*/{/*.val =*/{0x14531dbc, 0x83f2e87, 0x2d5c970e, 0x2407067f, 0x3bc7ce1f, 0x1ba50842, 0x1668ddef, 0x1b4180b1, 0x4627}},
 /*.y =*/{/*.val =*/{0x1686b8e2, 0x3e1cc026, 0x3e1bc99a, 0x22eb7eff, 0xded9949, 0x248a1d5c, 0x75b84a2, 0x1fc93513, 0xe0f}}},
{/*.x =*/{/*.val =*/{0x122f001d, 0x453bc4d, 0x78d8996, 0x14382b37, 0x31916368, 0x17ac8470, 0x2c24f4e6, 0x1a3b29e9, 0xefea}},
 /*.y =*/{/*.val =*/{0x33bc4415, 0x4a1067d, 0x3848771c, 0x4e567ec, 0x319a17e4, 0x140c1e8d, 0x3c14da1, 0x11e1a756, 0xaab8}}},
{/*.x =*/{/*.val =*/{0x8fbd53c, 0x330e8ec, 0x1c62cddf, 0x20e31c2b, 0x19a87e2, 0x2e4d4a95, 0xb34e8db, 0x9ca9ebd, 0x4e7c}},
 /*.y =*/{/*.val =*/{0x17dcaae6, 0x2ce5060, 0x3f7dd33e, 0x2e5852f, 0x2f681b53, 0x3f427db7, 0x10b18e16, 0x271d9b27, 0x1774}}},
{/*.x =*/{/*.val =*/{0x3c6e1b4d, 0xa0879b9, 0x3ef8790e, 0x47c9686, 0x385d9c9b, 0x289a7d38, 0x2888f268, 0x5ec09a5, 0x8990}},
 /*.y =*/{/*.val =*/{0x1814ab2b, 0x26baf6b, 0x132b2120, 0x3946f03e, 0x358bfae4, 0x15e60cd8, 0x334f0bb4, 0xb36ad6c, 0x43ae}}},
{/*.x =*/{/*.val =*/{0x3e5f712f, 0x3c98d685, 0x1b583a8a, 0xc7d6fe4, 0x227f0e28, 0x11ca398c, 0x5fd4a8f, 0x113ddba4, 0x67f6}},
 /*.y =*/{/*.val =*/{0x307160e5, 0x1a2b2d79, 0x3d36198d, 0x385223d, 0x6cf785e, 0x2b7aded6, 0x5d04f05, 0x35a3d991, 0xb833}}},
{/*.x =*/{/*.val =*/{0x3b89a762, 0x4098fb4, 0x2ee6b8dc, 0x3724c04, 0xb471293, 0x281525a, 0x12555fa8, 0x21db24d9, 0x327f}},
 /*.y =*/{/*.val =*/{0x39203301, 0x327f6566, 0x2bd7dfe9, 0x14d41c3f, 0x1997b975, 0x25a49578, 0x24026b09, 0x13aacd4, 0xb2d4}}},
{/*.x =*/{/*.val =*/{0xfb27b6, 0x909f8a1, 0x24305763, 0x1b8f6caf, 0x286aa5c7, 0x8e2b585, 0x38b1b10f, 0x138f6f9d, 0xfea7}},
 /*.y =*/{/*.val =*/{0x323cb96f, 0x74f6df, 0x33f7b777, 0x1ad65ae5, 0x36af9312, 0x19d37b32, 0x313297cf, 0x1a36e6c2, 0x6e05}}},
{/*.x =*/{/*.val =*/{0x1f9756e4, 0x3f65f258, 0x23730488, 0x15c3b977, 0x28cd0ebb, 0x380f6143, 0x280ff180, 0x10720c10, 0xed94}},
 /*.y =*/{/*.val =*/{0x3f3abfae, 0x3c3827e4, 0x24de98bf, 0x3c8ddd3f, 0x13911e09, 0x5d84a2c, 0x3fa19afa, 0x27a7bfa2, 0x3dbe}}},
{/*.x =*/{/*.val =*/{0x151cf119, 0x16eb40cf, 0x3ab4d301, 0x42f7613, 0x3487515b, 0x3b4fd892, 0x27c3fc9f, 0x1a63b99e, 0x29d9}},
 /*.y =*/{/*.val =*/{0x35056339, 0x3221d015, 0x3a7c2963, 0x272503a4, 0x31c96fb8, 0x28495013, 0x2b45277, 0xb145f72, 0x7fd0}}},
{/*.x =*/{/*.val =*/{0x3f422491, 0x19f1114d, 0x2060cff4, 0x114f92a1, 0x180a31fd, 0x3edef4cd, 0x3936d6f3, 0x15f41404, 0x126b}},
 /*.y =*/{/*.val =*/{0x1da3ef84, 0x3e8c7c66, 0x3f39347a, 0x122eb0c2, 0x3f3fb0e1, 0x128fae8a, 0x262c2e3c, 0x3704c185, 0xc1a7}}},
{/*.x =*/{/*.val =*/{0x17bdde39, 0xb00a910, 0x36043295, 0x11385e6d, 0x1968d315, 0x95c3566, 0x3cf0e10a, 0x1044fd9d, 0x76e6}},
 /*.y =*/{/*.val =*/{0x1901ac01, 0x12c5d4b4, 0x16d2032b, 0xa8cf4ad, 0x1f0d35e, 0x19b5c1a, 0x295cf577, 0x37e37b93, 0xc90d}}},
{/*.x =*/{/*.val =*/{0x3a1187a5, 0x33e666a0, 0x29ae691, 0x1755d88b, 0x21c81000, 0x1f276205, 0x2c73bee8, 0x14c3a794, 0x708a}},
 /*.y =*/{/*.val =*/{0x73db9c0, 0x2293c66d, 0x1353e8a5, 0x3369cf1b, 0x2d38283e, 0x195b72ed, 0x1a897fa9, 0x1204787e, 0x9b88}}},
{/*.x =*/{/*.val =*/{0xde4f5be, 0x386c5b1b, 0x2b2b59e2, 0xdd2db61, 0x2462cf9f, 0x35920e57, 0x33be219b, 0xd3f122, 0x19cf}},
 /*.y =*/{/*.val =*/{0x2f321af2, 0x2a454cad, 0x30f1c0c0, 0x2474724f, 0x181947ef, 0x12f9a2ac, 0x2b466c3b, 0xac1a856, 0x28e3}}},
{/*.x =*/{/*.val =*/{0x117cf3e8, 0xeaf0827, 0x3ea2219e, 0x24ef40d2, 0x17f576ee, 0x670be0e, 0x35f0d7c7, 0x11281e32, 0xaf6c}},
 /*.y =*/{/*.val =*/{0x1751baea, 0x22b74180, 0xa0d435b, 0xd8aba9f, 0x3246dfec, 0x39cc54f2, 0x14b30af9, 0x25bfa17, 0x784}}},
{/*.x =*/{/*.val =*/{0x2bcbb891, 0x2ac54090, 0x326cbee3, 0x1f3190f7, 0x3f8f9a8f, 0x206ea9d0, 0x2abe1e82, 0x315ac0ec, 0xc738}},
 /*.y =*/{/*.val =*/{0x299a84c3, 0x1f9cd765, 0x80cfe91, 0xc53bbde, 0x3fbbbb82, 0x63cbab2, 0x2d2537f7, 0x2d5e2546, 0x893f}}},
{/*.x =*/{/*.val =*/{0x662ab1b, 0x36aac1e1, 0x1b8c9e4d, 0x1c65fa92, 0x27aa9464, 0xca9a64b, 0x37435b, 0x2117b35f, 0x5578}},
 /*.y =*/{/*.val =*/{0x56f3511, 0x5b463cc, 0x25d64de3, 0x14e9dd1a, 0x2a4053f6, 0x1b429474, 0x1e2c3cea, 0x1e5e2db, 0xe61d}}},
{/*.x =*/{/*.val =*/{0x148b6c29, 0x13e1a6e2, 0xe399609, 0x3c48d53f, 0xceccd22, 0x3e8ef074, 0x364cc4ab, 0xe0e2228, 0x47f3}},
 /*.y =*/{/*.val =*/{0xe537ef9, 0x3b7b8448, 0xf994a81, 0x2ed26562, 0x16c7118, 0x39219d6d, 0x32937190, 0x26a343c0, 0x48ca}}},
{/*.x =*/{/*.val =*/{0x5ff4adb, 0x2069b23c, 0xbef768a, 0x3d5c35bf, 0x25d5f614, 0x1ad3271a, 0x1b8cfe46, 0x7cd2b90, 0xc0c0}},
 /*.y =*/{/*.val =*/{0x2c351065, 0x313bfdce, 0xd15b85f, 0x2f10f45c, 0x35b8cecd, 0xde82d01, 0x17f5c7c9, 0x3d6fb90d, 0xb84}}},
{/*.x =*/{/*.val =*/{0x8f6c14b, 0x1cba7d96, 0x29250143, 0x35cb97ce, 0x172877d1, 0x131d8df2, 0x25b81e26, 0x1899522d, 0xd895}},
 /*.y =*/{/*.val =*/{0x1d7d991f, 0x24d8fb5d, 0x3b067e17, 0x10a358ca, 0x340eb03, 0x3b182063, 0x7eae728, 0x2a8e3caf, 0xfebf}}},
{/*.x =*/{/*.val =*/{0x37078424, 0x296d652d, 0x2c40c3fb, 0x3b2bde83, 0x3a26703, 0x290d8880, 0x1044e8a3, 0x1bbbe25c, 0xfd13}},
 /*.y =*/{/*.val =*/{0x671ddf1, 0x3587bbbf, 0x22adfa8c, 0x3cac7de2, 0x5efa57c, 0x74646d7, 0x252cc67a, 0x2a0d3cf1, 0x218d}}},
{/*.x =*/{/*.val =*/{0xdb1cb3c, 0x3c7613b2, 0x3f024a5, 0x1c00e835, 0x119f861b, 0x33294d9d, 0x38d140e9, 0x23a77658, 0xd99e}},
 /*.y =*/{/*.val =*/{0x2b8637a7, 0x2228a78d, 0x3c8765cd, 0x21bfbe3f, 0xeba6e62, 0x16ecc86f, 0xa3a7a94, 0x66b4730, 0x36dc}}},
{/*.x =*/{/*.val =*/{0x3c385172, 0x351bda34, 0x40e636f, 0xcd4781, 0x309191d2, 0x36295396, 0x18317a1b, 0x3c586686, 0x3fd}},
 /*.y =*/{/*.val =*/{0x3ccb9794, 0x26b19fc3, 0xe7232b7, 0x26e4a7a4, 0x573755b, 0x1c31f4f2, 0x12c3fe4, 0xb01b97, 0x408d}}},
{/*.x =*/{/*.val =*/{0xf676e03, 0x24542959, 0x3e84edd4, 0x3ff1cda4, 0x1e8761ce, 0x3d90cd5c, 0x17518eb0, 0x2500caa5, 0xb8da}},
 /*.y =*/{/*.val =*/{0xefdf6e7, 0x1223939d, 0x1ff3b511, 0x33161365, 0x2808b092, 0x267325d8, 0x1a1e4d7c, 0x37e91201, 0x2804}}},
{/*.x =*/{/*.val =*/{0x5af726a, 0x104fd053, 0x25bf6e6d, 0x268f972c, 0x3620f946, 0xb2da62a, 0xc5ce53f, 0x34417b63, 0x6d36}},
 /*.y =*/{/*.val =*/{0x13f9fc7d, 0x15c12468, 0x108a35c, 0x31664dad, 0x50029dc, 0x2319b257, 0x3669e72d, 0x170d38dd, 0xe4ba}}},
{/*.x =*/{/*.val =*/{0x2540db99, 0x1b8a8c32, 0x34b81228, 0x4c27014, 0x30b0e3eb, 0x220fe99b, 0x3ac0cd06, 0x2f784334, 0x3ab6}},
 /*.y =*/{/*.val =*/{0x1bda78a3, 0x1a1cff8c, 0x369c043e, 0x344dec38, 0x13e99c38, 0x45ea5a8, 0x71d7fc3, 0x1881e6fa, 0xbaca}}},
{/*.x =*/{/*.val =*/{0x1f1048da, 0x1ddefc9e, 0x3ddd3ba7, 0xbf53cdc, 0x7bce2ba, 0x281a7674, 0x156f0fdb, 0xd38fc6b, 0x7966}},
 /*.y =*/{/*.val =*/{0x2106cf01, 0x23e6f892, 0x3d74862e, 0x95db633, 0x3927f253, 0x39d1cd69, 0x20b8956d, 0x38adb3ec, 0x4d8e}}},
{/*.x =*/{/*.val =*/{0x23c0df5d, 0x6845de3, 0x156a792f, 0x67bfed4, 0x1d7fab20, 0x2b6ae51d, 0x3b33a7d8, 0x3a851107, 0xe80f}},
 /*.y =*/{/*.val =*/{0x2ac9ec78, 0x32d0a46d, 0x3322ea9f, 0x557a02b, 0xa94472d, 0x25da328f, 0x200771e8, 0x379fd8e3, 0xeed1}}},
{/*.x =*/{/*.val =*/{0xf83cd58, 0x36c39e2c, 0x3d2f9162, 0xb730e1d, 0x3e7a3712, 0x2b13b47b, 0x1265981, 0x287c23a9, 0x440c}},
 /*.y =*/{/*.val =*/{0x388a3f4b, 0x1ef01a6, 0x1c0a260b, 0x793509a, 0xe2f02a2, 0x25537275, 0x2e122af8, 0x2c34b357, 0xa6c8}}},
{/*.x =*/{/*.val =*/{0x12998b10, 0x206f689c, 0x1b229d9e, 0x31c3af30, 0x2907819b, 0x1fe0a74e, 0x26c1cc5f, 0x32ebcae5, 0xf694}},
 /*.y =*/{/*.val =*/{0xf05e51, 0x19e22c5c, 0x3c2a47f, 0x1b1930c6, 0x6d82aeb, 0x317feb31, 0x2f03d633, 0xfae986f, 0x40a6}}},
{/*.x =*/{/*.val =*/{0xdd553fd, 0x25684cd6, 0x8b6414f, 0x2afda570, 0x22595047, 0x1b53d0e6, 0x2684850b, 0x218a8d55, 0x8b6e}},
 /*.y =*/{/*.val =*/{0x3e9be5ed, 0x200f6b4c, 0x3383d0d, 0x2b0f1686, 0x2b9fa124, 0x2f0b7d3, 0x11cb40d1, 0x22443b4, 0xea5e}}},
{/*.x =*/{/*.val =*/{0x4e16070, 0x3701eef3, 0x2fd6915d, 0x286080c7, 0x167543f2, 0x29239475, 0x1704313b, 0x1a5ef7f3, 0xa301}},
 /*.y =*/{/*.val =*/{0x1e177ea1, 0x30346810, 0xa11a130, 0xd76fdf0, 0x140f9b17, 0x2027e897, 0x3e4f5081, 0x3e473ed9, 0x7370}}},
{/*.x =*/{/*.val =*/{0x324ba5ae, 0x5080c5b, 0x34b5d81, 0xe594013, 0xbff74b4, 0x23490678, 0x1f049f3e, 0x39673fde, 0x27e1}},
 /*.y =*/{/*.val =*/{0x83a45b3, 0x1296ffba, 0x2fa63f78, 0x122869a6, 0x39df05df, 0x2d78f3f1, 0xe209ee1, 0x9a9b201, 0x310b}}},
{/*.x =*/{/*.val =*/{0x1caed7ae, 0x25a45d72, 0xfbfb4f9, 0xe6b77a1, 0x2d7e4f5a, 0x223b0e24, 0x24aee165, 0x39e97da1, 0xc712}},
 /*.y =*/{/*.val =*/{0x6156294, 0x134522a9, 0x30ce6378, 0x3639512, 0x1dd9e538, 0x352e08c4, 0x363b365e, 0x1041d458, 0x4964}}},
{/*.x =*/{/*.val =*/{0x4a6db03, 0x2d0f87f9, 0x275d791, 0x32175bd6, 0x675fcb2, 0x303509ae, 0x3235d065, 0x141292c, 0xbfc}},
 /*.y =*/{/*.val =*/{0x64b8542, 0x22b23469, 0x5d4f055, 0x109c65cd, 0x26c99237, 0x23b1fe52, 0xf3453fb, 0x119e9b0d, 0x1955}}},
{/*.x =*/{/*.val =*/{0x3fb04ed4, 0x2deb18f8, 0x1307fffa, 0x330cc2c4, 0x278de208, 0x3e741449, 0x2b936463, 0x216ce275, 0x90ad}},
 /*.y =*/{/*.val =*/{0xb6ef150, 0x24753523, 0x182894d9, 0x2bbeaf85, 0x3222b839, 0x372f6509, 0x38261aff, 0x1e8d8828, 0xe50}}},
{/*.x =*/{/*.val =*/{0x27dc0151, 0x2062c3b6, 0x2707bad2, 0x496f991, 0x25e3d7e, 0x2c745521, 0x14077f44, 0x3503be32, 0x7e2c}},
 /*.y =*/{/*.val =*/{0x20721ec7, 0x28ef14e4, 0x2ee082c9, 0x26fb902b, 0x1ef95d88, 0x186a2cc8, 0xfab382a, 0x1d420ab7, 0x905b}}},
{/*.x =*/{/*.val =*/{0x1345e597, 0x3840eb90, 0x3853cf90, 0x18dafe76, 0x2f52a79c, 0x25d6ef47, 0x2dace21c, 0x3d48656f, 0xa146}},
 /*.y =*/{/*.val =*/{0x345a770a, 0x19d59dab, 0x1f094b07, 0x19e96c88, 0x331b40ea, 0x25774b6e, 0x3feb09ae, 0x26c2ac14, 0xa5a9}}},
{/*.x =*/{/*.val =*/{0xce45444, 0x32ed4ff1, 0x2ccc4e20, 0x379087bf, 0x1a8114db, 0x2fe76ac9, 0x193b9bcf, 0x1d6873c6, 0xd24c}},
 /*.y =*/{/*.val =*/{0x7dd4a57, 0x2e4c91a6, 0x1f1e524c, 0x1d64fd26, 0x25a78abf, 0x2df46043, 0x1c1d1cfc, 0x74b7a13, 0x58fe}}},
{/*.x =*/{/*.val =*/{0x1ec4c0da, 0x2ded1132, 0x23ea3351, 0x23159e1c, 0x1f162ee8, 0x2706b660, 0x35f33923, 0x2e74bd8e, 0x8f68}},
 /*.y =*/{/*.val =*/{0x101fff82, 0x8f2fde5, 0x1510bfdf, 0x3a8b3fa5, 0x3e215dbb, 0x36430ada, 0x23986de1, 0x27cb6e81, 0x662a}}},
{/*.x =*/{/*.val =*/{0xcf27076, 0x1a11f7e1, 0x3627eaee, 0x26162b79, 0x19af59d8, 0x3faf9dff, 0x28158fca, 0x2bbf5e13, 0x4d49}},
 /*.y =*/{/*.val =*/{0x3aa781e, 0x2e42d988, 0x1f4d8466, 0x3cb469f, 0x1ca6f06e, 0xfc840d6, 0x1d135e72, 0x3f166843, 0xcd32}}},
{/*.x =*/{/*.val =*/{0x29b62026, 0x236f2d5c, 0x9d1d4ee, 0xa8f7822, 0x1c5aa78d, 0x1986787d, 0x16f8537d, 0x14e7a175, 0x7564}},
 /*.y =*/{/*.val =*/{0x1ace0cf3, 0x5cb23eb, 0xb79f334, 0x12ab3655, 0x32292568, 0x77d4929, 0x1b3c6523, 0x21504dd2, 0xc1d6}}},
{/*.x =*/{/*.val =*/{0x17b4a278, 0xd936b35, 0x3f4082b5, 0x3d8697c7, 0x19ccc878, 0x1bfcc06b, 0x32779674, 0x245eb677, 0x210a}},
 /*.y =*/{/*.val =*/{0xc7b2231, 0x3c9c4ff4, 0x3f20bfc7, 0x227986ab, 0x16737d37, 0x26fa07e3, 0x1e57b7a3, 0x6d5142d, 0x670e}}},
{/*.x =*/{/*.val =*/{0x13231e11, 0x1a1bf541, 0x3681e3e6, 0x123a1940, 0xc36091f, 0x267fe466, 0x385d65ff, 0x3ec05dab, 0xe4f3}},
 /*.y =*/{/*.val =*/{0x2feb73bc, 0x8b0e15d, 0x151d1c98, 0x31f9d3b2, 0x2b7286c, 0x69b43a8, 0x34f1c166, 0x18ceb43b, 0x1e63}}},
{/*.x =*/{/*.val =*/{0x3bcdaf2f, 0x2ffb888c, 0x3a172953, 0x14c6a096, 0x1b362f88, 0x190442af, 0x373e01ec, 0x32edda19, 0x4b30}},
 /*.y =*/{/*.val =*/{0x3d26b5b7, 0x200cf518, 0x3485756, 0x37cf2079, 0x3c4a91f, 0x38b15ddf, 0x3629b6f9, 0xd40996e, 0x74c6}}},
{/*.x =*/{/*.val =*/{0x2673059f, 0x3ffa70a6, 0xe0fa192, 0x45c5414, 0x64817ec, 0x16c82c5d, 0x1700dcd1, 0xd2a9eb8, 0xcbb4}},
 /*.y =*/{/*.val =*/{0x227c070c, 0x1f6a5908, 0x2d5f845b, 0x351793c2, 0x35dfad41, 0x35248ce2, 0x2bd17562, 0x802ad36, 0x4a1a}}},
{/*.x =*/{/*.val =*/{0x6de12c0, 0x351e1b84, 0x34610e94, 0x2736b161, 0x17244c6d, 0x35ec79d5, 0x2c1cd06, 0x15b6704, 0xf478}},
 /*.y =*/{/*.val =*/{0xa5361fe, 0x269db39b, 0x1ab92d76, 0x305fbd82, 0x28694c26, 0x2578041, 0x23946e68, 0x39843ccf, 0x7f09}}},
{/*.x =*/{/*.val =*/{0x20eae29e, 0x1bedbab8, 0x14e1d071, 0xd3cbc3, 0x1a4266c7, 0x1854de91, 0x3f331eb9, 0x3ea6c63a, 0x8c00}},
 /*.y =*/{/*.val =*/{0x2702414b, 0x1f4a9319, 0x1e36c54e, 0x3eb6bea0, 0x36c974c2, 0x30d0e8dc, 0x121a1a9d, 0x1c99ffa9, 0xefa4}}},
{/*.x =*/{/*.val =*/{0x18ada5f, 0x21326ac3, 0x1122fb3e, 0x1f8a5fca, 0x2be1effd, 0x2d6fe58d, 0x2b46fa8b, 0x3005db68, 0x24cf}},
 /*.y =*/{/*.val =*/{0x178a586b, 0x23e984e6, 0xf814f26, 0x25672869, 0x2da927ed, 0x21c53577, 0x61a6986, 0x23eec1e7, 0xebff}}},
{/*.x =*/{/*.val =*/{0x14679da2, 0x40c6256, 0x3f057edf, 0x37759ff1, 0x292ec616, 0x37b5ca84, 0x1bc82ea2, 0x1f56352e, 0x4a}},
 /*.y =*/{/*.val =*/{0x379ffe26, 0x21dfd211, 0x23fa28a4, 0x30ed2525, 0x71b3b71, 0x76051fb, 0x2cb75e6b, 0x316dd9c0, 0xb98a}}},
{/*.x =*/{/*.val =*/{0x87c4b65, 0x33cd3ab7, 0x207b2a9c, 0x3e202287, 0x26ce4996, 0x1b178b01, 0x1c7fc7, 0x1a7132f4, 0xee7d}},
 /*.y =*/{/*.val =*/{0x1136a95a, 0xfa3d13b, 0x2e942e52, 0xfa2666e, 0xf2ee2c3, 0x24aafc0c, 0x13821a1, 0x189bb069, 0xecc8}}},
{/*.x =*/{/*.val =*/{0x20cb3e41, 0x25ff77f1, 0x8b92c09, 0xf4213cc, 0x298ed314, 0x33b02a7, 0x829f3e1, 0x1b39a775, 0xe7a2}},
 /*.y =*/{/*.val =*/{0xf2cfd51, 0x3a2a5087, 0x20e83e20, 0x29acb010, 0x2fbb18d0, 0x2c01a86a, 0x3984b471, 0x238c03e9, 0x2a75}}},
{/*.x =*/{/*.val =*/{0x3b4ae861, 0x25f96e45, 0x2e32fa9d, 0xf0d7935, 0x2089f520, 0x22fed9dc, 0x3f8d00d3, 0x3eae80da, 0xf5ca}},
 /*.y =*/{/*.val =*/{0xd82239c, 0x32708e70, 0x12f05f3c, 0xecaa715, 0x839159b, 0x3e641190, 0x26d817bf, 0xee2808a, 0x19e8}}},
{/*.x =*/{/*.val =*/{0x3d2a9651, 0x13f5335e, 0x14c98208, 0x27942712, 0x2805428f, 0x3d455b5f, 0x23f1f12d, 0x240933ad, 0xe938}},
 /*.y =*/{/*.val =*/{0x1e786824, 0x3bf78add, 0x2770bfef, 0x1c4433b1, 0x31aaf18d, 0x21eaebd9, 0x26595f92, 0x1a21c8dc, 0x8648}}},
{/*.x =*/{/*.val =*/{0x3cddab8b, 0x3cb506b9, 0x3c68e6fc, 0x3934494, 0x2d0c379f, 0x5a40360, 0x1256bed1, 0x16761e0a, 0x2645}},
 /*.y =*/{/*.val =*/{0x1de473, 0x27d92d14, 0x1caf1e6c, 0x218c6bce, 0x72d77a, 0x2f18dc0d, 0x3512cef7, 0x2f4649b4, 0x79e5}}},
{/*.x =*/{/*.val =*/{0x1e6b80ef, 0x33ca7acf, 0x179424f3, 0x32f2e59f, 0x3cbdc571, 0x1503088e, 0x22ec8d23, 0x2783b8d9, 0xb645}},
 /*.y =*/{/*.val =*/{0x1a71ba45, 0xc2fc2d8, 0xe35b2ff, 0x2ceb9b52, 0x261db3c4, 0x2b7c5b95, 0x3e06de1d, 0x21db41bc, 0x67c}}},
{/*.x =*/{/*.val =*/{0x33eb51f, 0x14fbcdd4, 0x279c2112, 0x22415daf, 0x341593b6, 0xdbdcc07, 0x23c88e4d, 0x3a3c3660, 0xe5d8}},
 /*.y =*/{/*.val =*/{0x1a62a2d9, 0x2756f659, 0x1f0f5497, 0x27711b6, 0x3eeef0e5, 0x5a95f63, 0x23e04abb, 0x3a6de187, 0x4dc1}}},
{/*.x =*/{/*.val =*/{0xf155e64, 0x1e99d920, 0xa301173, 0x19af93ea, 0x3ae0ddab, 0x2c3dcc86, 0x8c3dc56, 0x9fddf6f, 0xa9ca}},
 /*.y =*/{/*.val =*/{0x161b3297, 0x3cfcccf1, 0x3caf0ae1, 0x17506086, 0x2d00487, 0x1f4891b0, 0x314d4d19, 0xcd59e3e, 0xf4bb}}},
{/*.x =*/{/*.val =*/{0x16ee247c, 0x352f18a7, 0x351cee06, 0x11e3a11f, 0xfe7591f, 0x28415847, 0x2d7f25eb, 0x1c6001a1, 0x68fb}},
 /*.y =*/{/*.val =*/{0x1a01865d, 0x387e08b4, 0xc73c9da, 0x235602c1, 0x1b0c079a, 0xd509d40, 0x19636737, 0x348d18b7, 0xcd12}}},
{/*.x =*/{/*.val =*/{0x96943e8, 0x3b683d6d, 0x273c5a5d, 0x1bc7f19f, 0xf06231d, 0x8d2a846, 0x3b840793, 0x20320a02, 0xd68a}},
 /*.y =*/{/*.val =*/{0x2b133120, 0x25321099, 0x45295a2, 0x39ee3de, 0x30e28b5b, 0x2c7e45de, 0x186d00c4, 0x2a7ffd2d, 0xdb8b}}},
{/*.x =*/{/*.val =*/{0x2412b6fd, 0x2f6888b2, 0x3702b828, 0x3b414f1b, 0x12373cac, 0x3e3becdd, 0x240be402, 0x102719de, 0xf16a}},
 /*.y =*/{/*.val =*/{0x2ca052da, 0x1a36b9df, 0x9ebca42, 0x15019649, 0x230e4e16, 0x1a9d69d3, 0x32799d7a, 0xc45c514, 0x2a41}}},
{/*.x =*/{/*.val =*/{0x326dd4e4, 0x30682db8, 0x3ed98325, 0x27d3cbda, 0x36f84db8, 0xdfda665, 0x26f42fbe, 0x2d41aadd, 0x4154}},
 /*.y =*/{/*.val =*/{0x75ded1c, 0x32164a54, 0x1e22dd46, 0x13aa7674, 0x25ff641, 0x1b913584, 0x1988894c, 0x1d410f1, 0x23ad}}},
{/*.x =*/{/*.val =*/{0x3f7f0246, 0x31469e98, 0x727ddf4, 0x3a1b927f, 0x1956ea93, 0x2a35342d, 0x95c1080, 0x1949da73, 0xb73c}},
 /*.y =*/{/*.val =*/{0x2a2a407b, 0x25f94593, 0x2e554e55, 0x35cb931, 0x36c1ea1a, 0xd624f16, 0xca9d4b5, 0x36c41c5d, 0x9a67}}},
{/*.x =*/{/*.val =*/{0x28d3d5d, 0x256603f, 0x3449cea4, 0x4abae5c, 0x3a30b096, 0x3009c241, 0x804252d, 0x3b5f7d97, 0x324a}},
 /*.y =*/{/*.val =*/{0x16ab7c84, 0x19c892be, 0x23328439, 0x84ec31f, 0x2c1f4f19, 0x3030d6b, 0x21f2ff13, 0xd95dd2d, 0x648a}}},
{/*.x =*/{/*.val =*/{0x32919749, 0x23ce0e06, 0x1e0db1fa, 0xacf92a3, 0xd7203f7, 0xc9a0620, 0x3490228d, 0xcc7a89b, 0x32c9}},
 /*.y =*/{/*.val =*/{0x3290b5e3, 0xc7a5ec3, 0x239ab096, 0x2292af6b, 0x33dbb826, 0x28bc0adb, 0x9cb5695, 0x9cacd08, 0xd7cd}}},
{/*.x =*/{/*.val =*/{0x3b9795e4, 0x38708949, 0x1846b8e1, 0x30586db8, 0x2c6b1c69, 0xbda9c3f, 0x37854a0, 0xbcecee6, 0xeb29}},
 /*.y =*/{/*.val =*/{0x2e53a0fe, 0x2dfa74be, 0x1111c6f5, 0x4c75d42, 0x5835b57, 0x198d2bc5, 0x2be80169, 0x3096a5bb, 0x8c43}}},
{/*.x =*/{/*.val =*/{0x9303fdd, 0x3a8e755e, 0x1d1ed35a, 0x1c515fc6, 0x9fbe14d, 0x350c401, 0x35ef2e62, 0xe8077ce, 0xa65a}},
 /*.y =*/{/*.val =*/{0x2e68703, 0x2b512a34, 0x3aed3cad, 0x21874093, 0x2d2c7686, 0x10f63643, 0x35c6fb8f, 0x2825033f, 0x798e}}},
{/*.x =*/{/*.val =*/{0x3d054c96, 0x3a2f4dcf, 0xd1ca888, 0x31050eea, 0x3ee5dcee, 0x77f6f97, 0x1e61f6d5, 0x30524673, 0x4df9}},
 /*.y =*/{/*.val =*/{0xad10d5d, 0xbaeb01b, 0x28849019, 0x3541b370, 0x1d85d4b5, 0x25d308e8, 0x18728050, 0x3b14424b, 0x35}}},
{/*.x =*/{/*.val =*/{0x1da49e04, 0x31ac3f0, 0x17a8d70c, 0x37915539, 0x387088e9, 0xc5f5392, 0x998cd25, 0x32b634b3, 0xed32}},
 /*.y =*/{/*.val =*/{0x3c1db9e0, 0x18c48345, 0x9fab7db, 0x36a7eb2d, 0x19d20b52, 0x728dd61, 0x30204a54, 0x3bd7c740, 0x129f}}},
{/*.x =*/{/*.val =*/{0x2883f855, 0x2dd06353, 0x3c34016c, 0x30db72d8, 0x30366e28, 0x27904471, 0x360f1804, 0x2adc9358, 0xe821}},
 /*.y =*/{/*.val =*/{0x19852ddf, 0x353831a9, 0xec23efe, 0xec67185, 0x16cf598b, 0x3504550, 0x13ce367d, 0x32fe18fd, 0xadef}}},
{/*.x =*/{/*.val =*/{0x3441742e, 0x2ffd67ba, 0x33806e9f, 0x52951eb, 0x1693a72f, 0x1514bef2, 0x2d212f45, 0x22653946, 0x3f0d}},
 /*.y =*/{/*.val =*/{0xfecadbe, 0x3194d8ef, 0x2d13d958, 0x8178b0e, 0x3a6e0b1e, 0x172c3a11, 0x3dc445e, 0x1b08fca3, 0xfbd7}}},
{/*.x =*/{/*.val =*/{0x2c1f98cd, 0x2ff26722, 0x17f0308c, 0xd224153, 0x6602152, 0x362a7073, 0x34870fae, 0x66a1291, 0x9c39}},
 /*.y =*/{/*.val =*/{0x14fc599d, 0x39f9780f, 0x64c8e6b, 0x14c9bddb, 0x20e64190, 0x3c112fc9, 0x1dd57584, 0x13c3d293, 0xddb8}}},
{/*.x =*/{/*.val =*/{0x294a09ec, 0xd7beded, 0x28535f04, 0x34c9a94f, 0x92aa40c, 0xbf1a757, 0x1d80f0a4, 0x14c9895, 0x2e3c}},
 /*.y =*/{/*.val =*/{0x8c7327e, 0x14d21a06, 0x7b66512, 0x12294f1c, 0x2fc1abe0, 0x2b8902e0, 0x6fb5bdd, 0x3e24595b, 0x1f}}},
{/*.x =*/{/*.val =*/{0x2b9c7ce6, 0x17c668a, 0x19089342, 0x1c40c5a8, 0x24dda433, 0x17edf8f8, 0x1587ae1, 0x289333e9, 0xe8e2}},
 /*.y =*/{/*.val =*/{0x836267c, 0xb007ada, 0x1c27a73b, 0x27980ed, 0x2e20596e, 0x3cacacef, 0x35d1b4ca, 0x20f3831b, 0x46c9}}},
{/*.x =*/{/*.val =*/{0xac7b3c2, 0x2c34e59a, 0x3d5b5f5, 0x2b2be48e, 0x32a212, 0x28e2c5c, 0x173c2b2f, 0x26ab1761, 0xa754}},
 /*.y =*/{/*.val =*/{0x1287eaef, 0x283245c6, 0x37116dff, 0x1ad44554, 0x147d2b5d, 0x2875c306, 0x2415335, 0x346e4347, 0xbd17}}},
{/*.x =*/{/*.val =*/{0x20a959e5, 0x2884e084, 0x391d4cc5, 0x38524ea2, 0xe06bb91, 0x17ca076, 0x12fdf8de, 0x5c2c774, 0x6057}},
 /*.y =*/{/*.val =*/{0x2385a2a8, 0x2266fa4c, 0x2e24c65e, 0x1454af0f, 0x1df26246, 0x268b6bdc, 0x24807add, 0x3c2c9a9a, 0x9a1a}}},
{/*.x =*/{/*.val =*/{0x2fd545c, 0x22672976, 0xa28e661, 0x4cfe375, 0x1c85df7c, 0x1044291b, 0x2e064039, 0x3f59df14, 0x6773}},
 /*.y =*/{/*.val =*/{0x147eb1ae, 0x231fc0d2, 0x1c6cf98e, 0x35e03d68, 0x2b246bea, 0x3c972774, 0x3652f0f0, 0x2db63365, 0x444e}}},
{/*.x =*/{/*.val =*/{0xb86f021, 0x1cf185ac, 0x4680503, 0x1d390e04, 0xc87c203, 0x31e6ab38, 0xe565237, 0x1b65345f, 0xe0f8}},
 /*.y =*/{/*.val =*/{0x35bf325a, 0x2dade732, 0x15fc45b3, 0x202f3004, 0x89a2c9a, 0x7a0cbc7, 0x2bcf47a9, 0x71cdcc2, 0xc57}}},
{/*.x =*/{/*.val =*/{0x2da6e03, 0x2b41dcb0, 0xcad6038, 0x9df7e42, 0x296f4f4c, 0x247864f5, 0x5041ce9, 0x56ae7c9, 0x42ca}},
 /*.y =*/{/*.val =*/{0xc347793, 0xda227ea, 0x106bea78, 0x1ba169a0, 0x3800eed6, 0x339347f2, 0x57c9647, 0x3bc9b207, 0x68d2}}},
{/*.x =*/{/*.val =*/{0x2cb94266, 0x69a5cfb, 0x3d4df12b, 0x33bc3ee9, 0xda31880, 0x10e69146, 0x8411421, 0x37e388e8, 0xa576}},
 /*.y =*/{/*.val =*/{0x21b28ec8, 0x3a2f846b, 0x114d9f3e, 0xb8429fd, 0xcd82c43, 0x2e5ebf96, 0x240b2c92, 0x2fc839d9, 0x40a6}}},
{/*.x =*/{/*.val =*/{0x1a704896, 0x3b15c96f, 0x1acfb8dc, 0xee818f2, 0x271bae6f, 0x148219ef, 0x35a3b546, 0x3318bbce, 0x9e5d}},
 /*.y =*/{/*.val =*/{0xa82c835, 0x23c9da77, 0x30f5124, 0x18174618, 0x7612279, 0x34e88553, 0x25f3ea5f, 0x344b76e4, 0x6fed}}},
{/*.x =*/{/*.val =*/{0x4bf7ea0, 0x14fb561d, 0xef58339, 0xd896817, 0x303b20e3, 0x1ba7e5db, 0x345adf8d, 0x20dd6e1, 0xa7de}},
 /*.y =*/{/*.val =*/{0x1bbcabaa, 0x130154e, 0x2bc5aa2e, 0x1691f03f, 0x88e9a64, 0x1282ccd2, 0x1a5e5210, 0x25ac15eb, 0xa63d}}},
{/*.x =*/{/*.val =*/{0xad916fb, 0x27e3e841, 0x149e4a3a, 0x20197f7a, 0xff4cbe6, 0x30d6b007, 0x80c9c13, 0x19639a24, 0xc266}},
 /*.y =*/{/*.val =*/{0x20887814, 0x1abbd4ae, 0x36113885, 0x23fb37fa, 0x627ab6b, 0x2605c2c9, 0x3daab0f7, 0x164e1539, 0xe7e8}}},
{/*.x =*/{/*.val =*/{0x3e58ad71, 0x3dd8e226, 0x39a3a208, 0xc347d73, 0x1e8c38bb, 0x17fa58a7, 0x2c3e30a0, 0x29e30a37, 0x7778}},
 /*.y =*/{/*.val =*/{0x3d9f43ac, 0x2d44ff07, 0x324ac563, 0x2ce1047f, 0x3f580087, 0x26384bcb, 0x1b22ff70, 0x1b66ad69, 0x3462}}},
{/*.x =*/{/*.val =*/{0x1073e879, 0x1fa87094, 0x104eea7a, 0x3c5a96b8, 0xfe3932c, 0x3d20b5fc, 0x6d1632, 0x1e5ad728, 0xe7b9}},
 /*.y =*/{/*.val =*/{0x3aa89d98, 0x239c4226, 0x1a98af33, 0x2d6fc97b, 0x3cc1ca9c, 0x840a9cd, 0x29e2fdf4, 0x26230645, 0x12b8}}},
{/*.x =*/{/*.val =*/{0x32628f0f, 0x1975c8af, 0x2aee9198, 0x108f6abc, 0x209a7365, 0x2456892f, 0x36203c2c, 0x3c061421, 0x71b}},
 /*.y =*/{/*.val =*/{0x5a1c334, 0x15f172f5, 0x31c80bbb, 0x23e71a88, 0x84ce209, 0x1802f070, 0x1cf4ae33, 0x28575413, 0x527a}}},
{/*.x =*/{/*.val =*/{0x239620e1, 0x3d8ddb7e, 0x1213786, 0x6447214, 0x3c39e5b, 0xcb96530, 0x3e56833a, 0xd0eb2e6, 0x218}},
 /*.y =*/{/*.val =*/{0x106998b5, 0x380667d9, 0x343c9ec5, 0xca6690b, 0x2fbfc044, 0x3c93f580, 0x250beaf3, 0x75225c2, 0xbea8}}},
{/*.x =*/{/*.val =*/{0x6d903ac, 0x27b6a70, 0x1ad7e5cb, 0x3e589d39, 0x3afd2ed5, 0xa7f4c39, 0x3a844637, 0x2557b98d, 0x928}},
 /*.y =*/{/*.val =*/{0x1bcd091f, 0x14603a4d, 0xa8d83fc, 0xf49bbea, 0x3a95eeac, 0x1e284c24, 0x342a827b, 0x8400f4f, 0xc256}}},
{/*.x =*/{/*.val =*/{0xf59dd9e, 0xc411e98, 0x358f0e72, 0x397a7156, 0x318ad67c, 0x58ec132, 0x1d350dad, 0x2f7b8ddc, 0x4f89}},
 /*.y =*/{/*.val =*/{0x156b049, 0x5ab8c8, 0x238df5c1, 0x12209419, 0x3bb2471e, 0x2ebd3010, 0x21f695c4, 0x14b5489e, 0xca79}}},
{/*.x =*/{/*.val =*/{0x3ff01197, 0xa70c533, 0x1a245bf5, 0x2d9a3c1e, 0x3c4c994, 0x25aeb28b, 0x3c5a80c3, 0x20c132b8, 0xcb9e}},
 /*.y =*/{/*.val =*/{0x3b989c1d, 0xcd381d8, 0x15e0a24c, 0x2cb46300, 0x8891741, 0x96337fc, 0xe6a127, 0x34a007ae, 0x62c7}}},
{/*.x =*/{/*.val =*/{0x108d2cc2, 0x17e7ff09, 0x48c58c1, 0x2fbb51c, 0x330dc58e, 0x33ca9041, 0x69bd3c8, 0x126c3e27, 0xe2f3}},
 /*.y =*/{/*.val =*/{0x20d4c04f, 0x38d1ef63, 0x9cbdb37, 0xd12fa38, 0x215ba42, 0x182bb1d8, 0x27237818, 0xbca03e0, 0x1feb}}},
{/*.x =*/{/*.val =*/{0x23d82751, 0x1eab9d45, 0x3ad35452, 0x116d2a41, 0x23b28556, 0x193ce83, 0x1b109399, 0x3fbcfb1b, 0x85d0}},
 /*.y =*/{/*.val =*/{0xeb1f962, 0xb08de89, 0x7733158, 0x21d47a5a, 0x2cf5663e, 0x3525b960, 0x38c0be29, 0x192104e8, 0x1f03}}},
{/*.x =*/{/*.val =*/{0x1d5fcade, 0x18d5b450, 0x1711ff75, 0x2d20b802, 0x11df0468, 0x1e9b3f34, 0xc4f4f60, 0x3d2c669, 0x6b79}},
 /*.y =*/{/*.val =*/{0x338d3ff, 0x1bffe1bf, 0x3e26b0ab, 0xfe96d1e, 0x2e09cba8, 0x19987e72, 0x1eb3ef29, 0x2606cbfe, 0xd03a}}},
{/*.x =*/{/*.val =*/{0x23a3e0cb, 0x2c3336af, 0x1978be0b, 0x91e77a1, 0x4f8fe3d, 0xb0d9eb3, 0x2bed3c16, 0x26cb0b5f, 0x4114}},
 /*.y =*/{/*.val =*/{0x339033a8, 0x3a4ba60, 0x3490f247, 0x3b1e017b, 0x2cf28b3, 0x5726e64, 0x30542b4, 0x16e4b6df, 0xc90d}}},
{/*.x =*/{/*.val =*/{0x23f3d3fc, 0x237774a3, 0x1c29cebf, 0x12a6e081, 0x32a7ba66, 0x30f7f8a1, 0x849dfae, 0x353e939f, 0xd1fa}},
 /*.y =*/{/*.val =*/{0x10f3704d, 0x3488d0f1, 0x3f37326e, 0x34dc4c7b, 0xb7818ba, 0xfdc3a16, 0xfdfe547, 0x25c528d2, 0x8fe1}}},
{/*.x =*/{/*.val =*/{0x526087e, 0x3d501209, 0x2da20308, 0x3edb6220, 0x18b85dfd, 0x26d8105e, 0x2ce97c1c, 0x373a5fb, 0xff2b}},
 /*.y =*/{/*.val =*/{0x30c29907, 0x32547807, 0x10e2ceb2, 0x2dfb5bee, 0x107936c7, 0x13137153, 0xba188af, 0x4ffbd49, 0x493d}}},
{/*.x =*/{/*.val =*/{0x3149f8ef, 0x2f4ea6bc, 0x238b4583, 0x3ad713b9, 0x31bb223d, 0xa7aefb2, 0x26c9f78e, 0x36ef17cd, 0x2982}},
 /*.y =*/{/*.val =*/{0x16c7a248, 0x1b9c9ac0, 0x2e3ed845, 0x176e6504, 0x35bc9d09, 0x294ce71e, 0x2220ab9f, 0x16fa6bd9, 0xa61b}}},
{/*.x =*/{/*.val =*/{0x2380441b, 0x14a27d84, 0xe176588, 0x47d160, 0x17db5860, 0x1bad6412, 0xc0f6b43, 0x39410abc, 0x1a28}},
 /*.y =*/{/*.val =*/{0x452af25, 0x17d81aa, 0x2ee67aeb, 0x2cf9d6d1, 0x36f0ed04, 0x20ca6a25, 0x19dab7c7, 0x269e65b1, 0x5577}}},
{/*.x =*/{/*.val =*/{0x221e30a7, 0x3bbc38e5, 0x5d83242, 0x3757ade6, 0x3f20142e, 0x143302f4, 0x330601d2, 0x20fa54d7, 0xc8b}},
 /*.y =*/{/*.val =*/{0x1ff688de, 0x3afdefae, 0x187134db, 0x32b48dee, 0x3dc854aa, 0x38fc5fb, 0x3dac7b85, 0x1c1dc197, 0xdcc}}},
{/*.x =*/{/*.val =*/{0x3856e241, 0x203978b3, 0xd6dd287, 0x3c7b8523, 0x1b212b57, 0xacb98c0, 0x80ea9ed, 0x2ef92c7a, 0x827f}},
 /*.y =*/{/*.val =*/{0x2ec293ec, 0x1816da2e, 0x2903166d, 0x3de98c61, 0x1d12687f, 0x3bcb19f4, 0x27b0b71b, 0x27248f1c, 0xc60f}}},
{/*.x =*/{/*.val =*/{0xcb1815d, 0x3db912dc, 0xb87461e, 0x11c2a486, 0x2e6b3660, 0x35f2355d, 0x16b973e2, 0x4a9f739, 0xb77f}},
 /*.y =*/{/*.val =*/{0xe57dbc5, 0x2e8f4af2, 0x244816d6, 0x10bc3e46, 0xc2e654c, 0x33becdcf, 0x2acc43f0, 0x216c53e1, 0x4b6f}}},
{/*.x =*/{/*.val =*/{0x45565ec, 0x3f976b4b, 0x177c5970, 0x163637d2, 0x39f956d8, 0xc22cb2d, 0xbf1247b, 0xee50c06, 0x4897}},
 /*.y =*/{/*.val =*/{0x3aed07e9, 0x2e1e41d7, 0x477b83, 0x6cd6596, 0x45af151, 0x1eece805, 0xdc1b643, 0x1d5a13cf, 0x761f}}},
{/*.x =*/{/*.val =*/{0x3bfd71fa, 0x13535d0a, 0x34527d4a, 0x1dd68996, 0x304c170b, 0x25c9ca29, 0x1559c6d6, 0x963a3ad, 0xe931}},
 /*.y =*/{/*.val =*/{0x174d3307, 0x366f434c, 0x35e35f33, 0x251b386e, 0x154b40b3, 0x3ad05a72, 0x3dee0e85, 0xccd930f, 0xfb1e}}},
{/*.x =*/{/*.val =*/{0x2120e2b3, 0x3ced63e8, 0x347f9aa7, 0x163f739f, 0x26e5217a, 0x392b8d33, 0x1bdbae7b, 0x127c87d4, 0xeaa6}},
 /*.y =*/{/*.val =*/{0x3a5ad93d, 0x11e94c16, 0x13f7e59d, 0x29ae597c, 0x39aa5a01, 0x2a03e261, 0x3b03ac69, 0x1e7b56ee, 0xbe32}}},
{/*.x =*/{/*.val =*/{0x1fc9b0a8, 0xf6f0730, 0x5f3db45, 0xcded71c, 0x2279ea9e, 0x8fa9400, 0x197eec26, 0x276cefae, 0x3adb}},
 /*.y =*/{/*.val =*/{0x305bbdda, 0x6b9e5d7, 0x30266cc6, 0x36723e61, 0x95ff6aa, 0x1d3781f0, 0x34e713c7, 0xb5b6bb9, 0x374e}}},
{/*.x =*/{/*.val =*/{0x10ae86f9, 0x153a7832, 0x23e7caf0, 0x3f7fd5a5, 0x5fc69fe, 0x255795b, 0x29cbb7e1, 0x14eb10a3, 0x129e}},
 /*.y =*/{/*.val =*/{0x1e89c85d, 0x8bbf734, 0x2b3e01b8, 0x288cbf45, 0x12183fb2, 0x288456dc, 0x29a29b2d, 0x32e562bb, 0x415e}}},
{/*.x =*/{/*.val =*/{0x2855b8da, 0x8890f57, 0x28947119, 0x15899f44, 0x210956c7, 0x17b2dabb, 0x294485b8, 0x1125323d, 0x6014}},
 /*.y =*/{/*.val =*/{0x334e4bbd, 0x35401643, 0x23f2a4ba, 0xe55709f, 0x32e65b54, 0x2f87f644, 0x1e6469e8, 0x359a7da0, 0x8bb5}}},
{/*.x =*/{/*.val =*/{0x1a34d24f, 0x388d8cb7, 0x1a137401, 0x2db63c32, 0x342ee541, 0x77db7b3, 0x3169d939, 0xb50f173, 0xe4a4}},
 /*.y =*/{/*.val =*/{0x1eba9414, 0x29fdc4c7, 0xd8e4f13, 0x21bbb7ea, 0xad34ce8, 0x326733ee, 0x1c73526f, 0x24b9c5b4, 0x4d9f}}},
{/*.x =*/{/*.val =*/{0x3e8f62bb, 0xfcba8c, 0x3ae4d2a3, 0x14f158bd, 0x4ef4d05, 0x2b3e15b, 0x3b18d3ef, 0x147ee133, 0xfd64}},
 /*.y =*/{/*.val =*/{0x132c0911, 0x2b64218, 0x200e83fd, 0xaad24b4, 0x344ccfa, 0x39e9706f, 0x31578b6f, 0x33acac61, 0xe745}}},
{/*.x =*/{/*.val =*/{0x15fe696b, 0x28747ee7, 0xf3c7a1f, 0x10b8b577, 0x1edbbb00, 0x3a0681be, 0x86bc716, 0x81f2c90, 0x1eee}},
 /*.y =*/{/*.val =*/{0x3429337b, 0x2d159c39, 0x2fd694eb, 0x818b82, 0x21c95f7a, 0x65b4491, 0x2269cd2b, 0x2f466bbd, 0x652c}}},
{/*.x =*/{/*.val =*/{0x2f94c0d5, 0x23503c67, 0x5725790, 0x303f005f, 0x2e2111e1, 0x16acb0d1, 0x1eb14d46, 0x28cfaa2a, 0xcc0e}},
 /*.y =*/{/*.val =*/{0x2f452fe6, 0x3aaf965e, 0x113f543d, 0x1d3c998, 0x3be663f6, 0x37480ed7, 0x8a2fb23, 0x1e8edc47, 0xf990}}},
{/*.x =*/{/*.val =*/{0x300bf19, 0x1c5cee75, 0x8fea494, 0x2d4d5daa, 0x352b6b92, 0x183eb6ac, 0xbdd9541, 0x3fbcd83, 0x1ec8}},
 /*.y =*/{/*.val =*/{0x107cefd, 0x1c737073, 0x295a07b6, 0x11b9dfd8, 0x2bbf5e01, 0x2925629e, 0x1340d2f3, 0x3a4dd5ad, 0xaeef}}},
{/*.x =*/{/*.val =*/{0x14ff9e4, 0x36ba0175, 0x3d890560, 0x2118bdba, 0x3c90bb8e, 0x3aa80d13, 0x4bc6cbe, 0x3a8d467c, 0x5be7}},
 /*.y =*/{/*.val =*/{0x7e0bdbb, 0xc2c1e1, 0x119a3094, 0x26718c08, 0x1ab7fe0e, 0x3e243d95, 0xe605477, 0xbb0fd8e, 0x32f3}}},
{/*.x =*/{/*.val =*/{0xddb7bb8, 0xfed517d, 0x3853991e, 0xa1927, 0x1f7f5cd5, 0xff21a63, 0x24e65081, 0x26445bab, 0x58f0}},
 /*.y =*/{/*.val =*/{0x2e5b2d6e, 0x37b1cd60, 0x1174302b, 0x1fb9018b, 0x23806650, 0xbfdd851, 0x2111a0d6, 0xaabff, 0x7e07}}},
{/*.x =*/{/*.val =*/{0xc9a8e2c, 0x4f0581b, 0xc1a1c14, 0xf634693, 0x20cb0f82, 0x33013f61, 0x390b633b, 0x392e6ca5, 0xb0f9}},
 /*.y =*/{/*.val =*/{0x1f3d0db4, 0x30819b13, 0x171cee76, 0x143300b0, 0x3de3f033, 0x2ec2e41b, 0x2de6d41c, 0xafc610e, 0x49e8}}},
{/*.x =*/{/*.val =*/{0x366642be, 0x376d64a0, 0x158ba889, 0xd241c5f, 0xdfa8bce, 0x2bd1a0, 0x30c2f91b, 0x1de30119, 0x146a}},
 /*.y =*/{/*.val =*/{0x3d83efd0, 0x2ca5d20, 0x37e5ed1d, 0x2aa5c74b, 0x14b2870a, 0x1a609fe7, 0x28add6, 0x383b0cd5, 0xb318}}},
{/*.x =*/{/*.val =*/{0x39de5cac, 0x6c8d955, 0x2cb26191, 0x3f260f1f, 0xd14cfee, 0x1c2d702f, 0x17e24e56, 0x3c33a296, 0x574e}},
 /*.y =*/{/*.val =*/{0x75a4805, 0x3966ba9b, 0x310008ca, 0x9829efb, 0x1b78451a, 0x1ab6815a, 0x319c73bd, 0x264c0a07, 0x9b9}}},
{/*.x =*/{/*.val =*/{0x260966d3, 0x230b5d0, 0x2ff86458, 0x29dc306b, 0xc835d10, 0x24e5ee6, 0x3f9f85d9, 0x1f9e6762, 0xd3d9}},
 /*.y =*/{/*.val =*/{0x33c2e52, 0x377ae142, 0x28dc4eeb, 0x3921c46f, 0x3ad3b5, 0x2a249d75, 0x2c95e6aa, 0x2d18ddae, 0x8ddb}}},
{/*.x =*/{/*.val =*/{0x168c6d4b, 0x103ee4e, 0x3494c120, 0x2f9e33e3, 0x3bee0ab2, 0x1d39e0b2, 0x318987b9, 0x194ca22c, 0xb1aa}},
 /*.y =*/{/*.val =*/{0x2891ac51, 0xf6798ab, 0x1623cc38, 0x2876427, 0x23a83b10, 0x12aa38b5, 0x10d71268, 0x1c71820, 0x7ed6}}},
{/*.x =*/{/*.val =*/{0x3180eef9, 0x35daa1e4, 0x228b9776, 0x48826, 0x207b128d, 0x2b3aec6a, 0x2e5f07e3, 0x303d8748, 0xfa50}},
 /*.y =*/{/*.val =*/{0x3f4f2811, 0x233635f4, 0x17a213b3, 0x1a0ca4e9, 0x1a68a5e, 0x334a1c8a, 0x3eba9b72, 0x31a488e5, 0x6b84}}},
{/*.x =*/{/*.val =*/{0x187f5048, 0x2716f88c, 0x8386d45, 0x8ca3491, 0x290836e7, 0x503f80b, 0x74e0780, 0x13bb9864, 0x6396}},
 /*.y =*/{/*.val =*/{0x9309df8, 0x20e8a136, 0x1de6c843, 0x1602e4d3, 0xbfbc93d, 0x3fe6c70d, 0x1cf41a39, 0x3ece9ae2, 0x3b6c}}},
{/*.x =*/{/*.val =*/{0x3adb2a65, 0x2052e87a, 0x3cbda31f, 0x35fc4ab4, 0x3c9f75af, 0x11a777c3, 0x1b7e22d1, 0x3896d345, 0x5a3c}},
 /*.y =*/{/*.val =*/{0x1d327f1d, 0x22c5c33c, 0x25fe8ed, 0x38a2f0f6, 0x3f99af3e, 0x29b6fefc, 0x5f63873, 0x496e4b8, 0x8b34}}},
{/*.x =*/{/*.val =*/{0xa9f44d0, 0x1a9ccdd5, 0x1a8fa001, 0x36f2db9a, 0x1e41ff85, 0x2f8d3c3, 0x13eda691, 0x16be63e, 0x5ce6}},
 /*.y =*/{/*.val =*/{0x9d30105, 0x3417cd2, 0x32eccc6c, 0xf2c6fe8, 0x76c58ab, 0x15af40c7, 0x26bfe7ba, 0x33e6fb08, 0x4cdd}}},
{/*.x =*/{/*.val =*/{0x1f067ec2, 0x394f4cad, 0x1bba5220, 0xa22ad75, 0x8e8421a, 0x16fdadf6, 0x21a11b1a, 0x1874329c, 0xda1d}},
 /*.y =*/{/*.val =*/{0x1ad836f1, 0x157ee83c, 0x279b48a6, 0x29ce2674, 0x91e2966, 0x1d98587, 0x1306c79c, 0x3d569f26, 0x8157}}},
{/*.x =*/{/*.val =*/{0x2cd3c369, 0xf084348, 0x1f8e934b, 0x181520f8, 0x1283a23, 0x1757d877, 0xc444df8, 0x3802d3bd, 0x9c7b}},
 /*.y =*/{/*.val =*/{0x22329515, 0x27b8ffae, 0x2769cbd2, 0xc454e85, 0x2401483e, 0x9b51573, 0x20d2052a, 0x30379d2c, 0x9220}}},
{/*.x =*/{/*.val =*/{0x3bb8c9e3, 0x1af364b5, 0x141178e7, 0x3741a9c1, 0xcc49174, 0x1992c8e3, 0x1263bb55, 0x20fd0a09, 0xfcd}},
 /*.y =*/{/*.val =*/{0x1f4aa9ad, 0x21b557ef, 0x1627bf4e, 0x2fabb37c, 0x3db683ad, 0x208cb797, 0x1fbced1d, 0x3073fab1, 0x6c0b}}},
{/*.x =*/{/*.val =*/{0x326b64f1, 0x33ce6512, 0x1476d995, 0x3b73ca3d, 0x11e59db7, 0x36931894, 0xf010d4c, 0x101fc6d6, 0x7175}},
 /*.y =*/{/*.val =*/{0x324234d5, 0x9b9fbea, 0x471d2a4, 0x7fa2ddd, 0xcc86eb0, 0x34d0044d, 0x3d550f36, 0x1550d138, 0x43b4}}},
{/*.x =*/{/*.val =*/{0xd064e13, 0x29cec184, 0x6f1e062, 0xc477811, 0x3d416615, 0x17fe63a3, 0x30690721, 0x20bfc325, 0xa8e2}},
 /*.y =*/{/*.val =*/{0x11f4cc0c, 0x3bdf1cc4, 0xdd6bd6c, 0x19e68f94, 0x2515888b, 0x2dfcf16c, 0x1c09abf, 0xd56e36e, 0x7f97}}},
{/*.x =*/{/*.val =*/{0x3f7653a1, 0x57ae7a9, 0x13d67c1c, 0x2fa7aa9d, 0x266e63ef, 0x1dbe017a, 0x3aecbcb8, 0x3cb9f89f, 0xcac6}},
 /*.y =*/{/*.val =*/{0x3ec5e556, 0x23042b43, 0x8103a06, 0x3a0eb95a, 0x2a345081, 0x2d976690, 0x26f194cd, 0x5b978aa, 0xf7d4}}},
{/*.x =*/{/*.val =*/{0x624003d, 0x327d2ac2, 0x238cb11c, 0x2dd9ca50, 0xe43254a, 0x3164cb96, 0x3d206efb, 0x3791bb8d, 0xe6df}},
 /*.y =*/{/*.val =*/{0x2216b93b, 0x15219438, 0x27fd7dd7, 0x7397a94, 0xf92203b, 0x3d23dee2, 0x139498f2, 0x2cedefa4, 0x8727}}},
{/*.x =*/{/*.val =*/{0x8dce109, 0x38440d5, 0xf211d3b, 0x1438c527, 0x96082e2, 0x1033f1eb, 0x2823d66a, 0x2273669, 0x3c4e}},
 /*.y =*/{/*.val =*/{0x3a19aeea, 0xafd9648, 0x17fe697e, 0x1e7850b6, 0x364d3795, 0x15ef2855, 0x191b4807, 0x2f99a7f8, 0x43fb}}},
{/*.x =*/{/*.val =*/{0x319497c, 0xbce0b7a, 0x12508c02, 0x166c7e94, 0x13cab15d, 0x2795b9a4, 0x285872d3, 0x14ee7268, 0x174a}},
 /*.y =*/{/*.val =*/{0x79afa73, 0xf684eb0, 0xb985438, 0x1ace8763, 0x7f9e664, 0x10557cb1, 0x9c1657b, 0x370deaff, 0xccc9}}},
{/*.x =*/{/*.val =*/{0x40dd273, 0x3d768dbe, 0x24501115, 0xf4a0383, 0x392ea3d5, 0x1c1c7bc6, 0x6bb630c, 0x38b9e5a5, 0x20e6}},
 /*.y =*/{/*.val =*/{0x3b46b593, 0x1f3f456, 0x1a8693cc, 0x7b25e4f, 0x7465581, 0x2e86b65e, 0x159e44a0, 0x1ebf93c5, 0xd3ad}}},
{/*.x =*/{/*.val =*/{0x1a077674, 0x1ed53cc0, 0xc24ca3e, 0x2b9a04db, 0x31db7035, 0xa0281f9, 0x351dba80, 0x2a0935e8, 0x8e0c}},
 /*.y =*/{/*.val =*/{0x12b7ed98, 0x2e132fb0, 0x2f910290, 0x3d810674, 0x22cf57cf, 0x1a749369, 0x12d41dc5, 0x1581d646, 0x4ec}}},
{/*.x =*/{/*.val =*/{0x28192441, 0x25abf17a, 0x321b4afe, 0x36d60868, 0x3d66c1af, 0x298d54f8, 0x182d1c5f, 0x14369472, 0xf7bb}},
 /*.y =*/{/*.val =*/{0x145165ae, 0x31903a87, 0x3c4c74bb, 0x33f707ee, 0x26485db1, 0x2f18ef77, 0xa526311, 0xef8c0cd, 0x93cc}}},
{/*.x =*/{/*.val =*/{0x1475b7ba, 0x213f7fc2, 0x918b3d8, 0xe79cc39, 0x18cdbe0, 0x395fb7d4, 0x3785c3d3, 0x25a60650, 0x9593}},
 /*.y =*/{/*.val =*/{0x3524f2fd, 0x26e2afe1, 0x709385e, 0x194fd932, 0x1cd6849c, 0xe1a92e, 0x331dd8ba, 0x154a2230, 0x2e7e}}},
{/*.x =*/{/*.val =*/{0xbc8f53b, 0x1c9d6a50, 0x11747c70, 0x889ace, 0x33d95ed7, 0xcb29f75, 0x1a7deafe, 0x5017fc3, 0xcbee}},
 /*.y =*/{/*.val =*/{0x38c87f45, 0x248b9ac9, 0x126f7282, 0x27fd3da0, 0x294cf0d, 0x3cf9a26e, 0x1f902b51, 0x7d3d39d, 0xf621}}},
{/*.x =*/{/*.val =*/{0x14b311dd, 0xddf222c, 0x3d71b9cf, 0x38efabbe, 0x2252e03d, 0x202fe82e, 0x2f5acdd5, 0x2eb4a3ea, 0xadd5}},
 /*.y =*/{/*.val =*/{0x9d6c38d, 0xbe60bcd, 0x29b9b890, 0x353879d9, 0x19814f52, 0x390d3e0d, 0x1c3a5974, 0xf3d368f, 0xe9c4}}},
{/*.x =*/{/*.val =*/{0xd7c0979, 0x17d90028, 0x5a8c96f, 0xa6cc52f, 0x1ced24a, 0x277cf7fd, 0x317143fa, 0x10caea05, 0x53f2}},
 /*.y =*/{/*.val =*/{0x137b36a2, 0x27dfa431, 0x1e8b845f, 0x35693d72, 0x1b07de4b, 0x138f8244, 0x79b7ccd, 0x3bfef07c, 0xbd52}}},
{/*.x =*/{/*.val =*/{0x1d82b151, 0x2d44d032, 0x21fba2db, 0x28290f55, 0x109a8fcc, 0x168454ec, 0x1e56d64, 0xe942b90, 0xd2a6}},
 /*.y =*/{/*.val =*/{0x1cf89405, 0x105085d3, 0x84ca52d, 0x3dd42bd, 0x148220a7, 0x2bb962ca, 0x3fcb7565, 0x21bed910, 0xe82d}}},
{/*.x =*/{/*.val =*/{0xa72da5f, 0x31b12eb3, 0x2c413497, 0x2e735acd, 0x3725f922, 0x31c8080c, 0x525e23b, 0x20e9d840, 0xbaf1}},
 /*.y =*/{/*.val =*/{0x28f2a0cf, 0x1df398a2, 0x27393613, 0x8cdb172, 0x29b1d18e, 0x22f56375, 0x34d33568, 0x27efa732, 0xdeac}}},
{/*.x =*/{/*.val =*/{0x56c3943, 0x296b2963, 0x2b76a5ff, 0x36f40b55, 0x8f6fd5a, 0xcca41b9, 0x40238f9, 0x3e29f8e1, 0xf7ae}},
 /*.y =*/{/*.val =*/{0x2cf442f1, 0xc7d89fe, 0xdcd0034, 0x30c0612a, 0x2b3fcfee, 0x10aef70e, 0x3da797c4, 0x2d1357f, 0x4e3b}}},
{/*.x =*/{/*.val =*/{0x11924459, 0x3eb2515c, 0x3c7a78c1, 0x3cbe8968, 0x1dbb1f7a, 0xb8a7c37, 0x19036c5a, 0x11f2c400, 0xdfb5}},
 /*.y =*/{/*.val =*/{0xc65fd9e, 0x28817837, 0x1c031dcf, 0x2bc24c39, 0x864cc22, 0xe273a77, 0x347088b8, 0x34aa6e83, 0x9acc}}},
{/*.x =*/{/*.val =*/{0x1617e073, 0x10dbe6d1, 0x39317b3, 0x2b2f6f4e, 0xfdc866b, 0x39e25b5f, 0x31eb890e, 0x1f88cd51, 0x6458}},
 /*.y =*/{/*.val =*/{0x1faf6589, 0x20a6797a, 0x33aeab35, 0x2e428e44, 0x299a185, 0x1b75911f, 0x102e2ae9, 0x33756fda, 0xd99f}}},
{/*.x =*/{/*.val =*/{0x384480d, 0x12f36231, 0x291f2ef4, 0x382da88a, 0x2f0c1294, 0xa2d5324, 0x3940f2cf, 0x35ac50b7, 0xb866}},
 /*.y =*/{/*.val =*/{0xc4cafa8, 0x39966d1c, 0x31d86d60, 0x3948a012, 0x1ad7ac24, 0x9e35faa, 0x2eb7089a, 0x2c2cd09a, 0x1914}}},
{/*.x =*/{/*.val =*/{0x1db20d6c, 0x8a736a0, 0x14fe455d, 0x354ab93b, 0x2ba87e2, 0x27459184, 0x2819ec4d, 0x2e242177, 0xec2b}},
 /*.y =*/{/*.val =*/{0x229cf4a0, 0x3a67135, 0x7efa98a, 0x288d92fa, 0x940c633, 0x3d9bc194, 0x13a1332, 0x305d9878, 0xccec}}},
{/*.x =*/{/*.val =*/{0x23b09d0f, 0x22983b2c, 0x350becf3, 0x141903, 0x145905e5, 0x35d7bd79, 0x296ced39, 0x29f8e278, 0x71c4}},
 /*.y =*/{/*.val =*/{0x320ddb62, 0xdec7c05, 0x262ffc76, 0x1bcac212, 0x3810aa78, 0xf828a4b, 0x2f3ba0af, 0x3eb6dcde, 0x1313}}},
{/*.x =*/{/*.val =*/{0x1d45e458, 0x1635b21b, 0x250e7fd3, 0x2a9b3a8, 0x9de042f, 0x151b4f95, 0xd885b3a, 0x2f783939, 0x8481}},
 /*.y =*/{/*.val =*/{0x1779057e, 0x3592c6d6, 0x3262e556, 0x29e710a, 0x2cb2ca90, 0x96fce73, 0x4dd84a, 0x1ee32e95, 0x38ee}}},
{/*.x =*/{/*.val =*/{0x2ce9f114, 0x1510cd49, 0x19561dde, 0xbb5814a, 0x1492bf39, 0x10f1b347, 0x3a8b9fd, 0x29142f4e, 0x9629}},
 /*.y =*/{/*.val =*/{0x224aa391, 0x28e5cb12, 0x56af8dc, 0x9564f97, 0xef64db9, 0x2fbf4883, 0x3b6d7576, 0x26ca0317, 0xbf43}}},
{/*.x =*/{/*.val =*/{0x26ca6cc3, 0xf4e3658, 0x187e1838, 0x1df5d1f8, 0x893df14, 0x1cc369f3, 0x24688eb1, 0x711fbc7, 0xb73b}},
 /*.y =*/{/*.val =*/{0x254fdba3, 0x2b0d75da, 0x1757f5af, 0x8a89482, 0x8050973, 0x1f592ef3, 0x122a90a5, 0x572ca52, 0x5843}}},
{/*.x =*/{/*.val =*/{0x138f93e0, 0x31b8864b, 0x276899f9, 0x16ca8eed, 0x22fef7d0, 0x2624801e, 0x180311f, 0x5acb6d0, 0xedfe}},
 /*.y =*/{/*.val =*/{0x229405ad, 0x3405e4f7, 0x6e227e3, 0xf544031, 0x5d0d25b, 0x1d3ea92c, 0x1db3694d, 0xbc7f29, 0xee69}}},
{/*.x =*/{/*.val =*/{0x2caf666b, 0x3358c0fd, 0xb1ce30b, 0x3f3fb4f1, 0x17f4637f, 0x1a5e6ba0, 0x102aa62b, 0x1295e9e0, 0x1346}},
 /*.y =*/{/*.val =*/{0x3f6ecc27, 0x3d256a41, 0x10942e13, 0x3cc02a07, 0xcb0ca48, 0x390cd14f, 0x14580ef7, 0x5640118, 0x69be}}},
{/*.x =*/{/*.val =*/{0x65084ae, 0x1d612718, 0x2abe577c, 0x20af9f73, 0x3e12d191, 0x17223217, 0x5362ec0, 0x3e3d4c89, 0xeb3c}},
 /*.y =*/{/*.val =*/{0x396b9480, 0x3d9f07ff, 0x3dbd2a66, 0xad17179, 0x1ca4a1f5, 0x398f73bf, 0x1d70043f, 0x31e088b6, 0xc833}}},
{/*.x =*/{/*.val =*/{0x2e9a5d0, 0x2396f2f3, 0xa201d9f, 0x1dbf3e61, 0x519b2a5, 0x2983c861, 0x199974f7, 0x299f424b, 0xbdf1}},
 /*.y =*/{/*.val =*/{0x562ff7b, 0x36d3dc06, 0x1626461c, 0xa02d879, 0x3f7baaa6, 0x2f952a1a, 0x1a1aaa80, 0x240aead9, 0x4095}}},
{/*.x =*/{/*.val =*/{0x3b27e771, 0x3797f05c, 0x37da62ab, 0xed06591, 0x483b48c, 0x2f899ed9, 0xec29cd5, 0x1a9bb771, 0x6885}},
 /*.y =*/{/*.val =*/{0x7bbdab6, 0x46358a8, 0x3b0733a6, 0x748bca4, 0x1f7b4a33, 0x1bf52706, 0x1a1fb13b, 0xf7c53de, 0x77a3}}},
{/*.x =*/{/*.val =*/{0x2d83f366, 0x2b68e834, 0x2f28588c, 0x36733b78, 0x1dc97a0c, 0x3d0c2f30, 0x3fe2e9ae, 0x277d6dc4, 0xbc4a}},
 /*.y =*/{/*.val =*/{0x181f33c1, 0x1d635999, 0x2547b16d, 0x3a2a7efe, 0x3798caa6, 0x24deb7d2, 0x5c06383, 0x20729b9e, 0xd3a}}},
{/*.x =*/{/*.val =*/{0x33fceb19, 0x20b79517, 0x385c4092, 0x226c887d, 0x27bab42e, 0x171d89b3, 0x2ccc0abc, 0xf578473, 0xda43}},
 /*.y =*/{/*.val =*/{0x26f5cc64, 0x2139c482, 0x227b2776, 0x1dff0b64, 0x15e5218e, 0x2ef712be, 0x10301de, 0x36f4c86a, 0xe498}}},
{/*.x =*/{/*.val =*/{0x1acf692a, 0x13789d71, 0x2207e065, 0x3120e29c, 0x16efdbc, 0x3045a607, 0xc7ec1c1, 0x2387ba7a, 0x31e}},
 /*.y =*/{/*.val =*/{0x316f667a, 0x330aa13a, 0x1bf73b09, 0x192609f1, 0x16743b70, 0x25c0a43, 0x3353dd9d, 0x1fd6d196, 0xad7e}}},
{/*.x =*/{/*.val =*/{0x1f488b6, 0xaef5ffe, 0x3c7a9159, 0x326fcd8f, 0x257f73e9, 0x38036189, 0x161155d3, 0x2181ea23, 0xa987}},
 /*.y =*/{/*.val =*/{0x31dab1d, 0x2569eeec, 0xad5c6d4, 0x343c0659, 0x157c2239, 0x18f9f208, 0x95d61c0, 0x286af562, 0xd181}}},
{/*.x =*/{/*.val =*/{0x25324caa, 0x152acc3f, 0x29472a39, 0x12d978c2, 0x12a32e69, 0x3631d251, 0x18bc0d23, 0x2a5efe0a, 0x8c28}},
 /*.y =*/{/*.val =*/{0xbef9482, 0x39c771cf, 0x11cb9459, 0x39e13c11, 0x3cc0eb7a, 0x3fb7cc7d, 0x5193378, 0x118e8cc, 0x40a3}}},
{/*.x =*/{/*.val =*/{0x3611d8e2, 0x37ec807d, 0x249fc4d5, 0x4c3fa37, 0x3f0da2c8, 0x3b569811, 0xa2f196b, 0x3061ca8e, 0xab1a}},
 /*.y =*/{/*.val =*/{0x429d15b, 0x69607cf, 0x21e545f0, 0x3be4f4cf, 0x2a42b6f7, 0x297ce76d, 0x117a1e9a, 0x28de8c93, 0x13f4}}},
{/*.x =*/{/*.val =*/{0x2651b3fa, 0x9abb990, 0x32df4342, 0x286cd95d, 0x3f31ef8e, 0xe981c94, 0x2f82d370, 0x3fa6d6fb, 0x2564}},
 /*.y =*/{/*.val =*/{0x1e5122d, 0x2e0b9a8c, 0x379816ed, 0x3cdf6ada, 0x3925f14, 0x2852b848, 0x389095f, 0x3de9819e, 0x8ad9}}},
{/*.x =*/{/*.val =*/{0x2e180068, 0x5e38f4e, 0xbd3103b, 0x28f55b08, 0xdc01a7e, 0x1b17030c, 0x5b0cbfc, 0x184dbfeb, 0xff3d}},
 /*.y =*/{/*.val =*/{0x188c6077, 0x29aedb8, 0x1f5e67, 0x1d9dbc90, 0x16adc154, 0xdcb376, 0xe40d, 0xe6fa139, 0x1332}}},
{/*.x =*/{/*.val =*/{0x1faccae0, 0x2312e844, 0x24bb3374, 0x22cd4316, 0x71fd23c, 0x3653393c, 0x127a8c1d, 0x259984e5, 0x8ea}},
 /*.y =*/{/*.val =*/{0xe62b945, 0x16bcd28c, 0xf0f8e95, 0x2de0efa7, 0x15c5d735, 0x39f033ee, 0x22782e24, 0x3eaef23b, 0x620e}}},
{/*.x =*/{/*.val =*/{0x2190b632, 0xa4c4c76, 0xab5ab9a, 0x33ca88e9, 0x159d8263, 0x19b7cc55, 0x20cd9f3a, 0x18dc5d88, 0xc25f}},
 /*.y =*/{/*.val =*/{0x3c9590cf, 0x3bafcf5b, 0x2027a1d6, 0x27c13fe7, 0x9d7980a, 0x12640e0, 0x12873989, 0x13fb7a53, 0x5315}}},
{/*.x =*/{/*.val =*/{0x1466d561, 0xb32cedf, 0x1978b4de, 0x1ed5770c, 0x8544c0c, 0xb60a95a, 0x26bab3e8, 0x237f8f33, 0x2a9e}},
 /*.y =*/{/*.val =*/{0x12e76373, 0x25b33d49, 0x3a02182f, 0x7abb05, 0xb96cf5e, 0x1ed6b582, 0x2651fbac, 0x3b69705b, 0x1df}}},
{/*.x =*/{/*.val =*/{0x3f8be384, 0x22f4c810, 0x31db6c3e, 0x3b02ab68, 0x1ef07271, 0x2b5b253f, 0x23e1b251, 0x24290af9, 0xb237}},
 /*.y =*/{/*.val =*/{0x2b19880e, 0x4291cf7, 0x9ecb58d, 0x3c013d05, 0x1f94517, 0x143e22aa, 0x15edbe8d, 0x1a524675, 0xfc6b}}},
};

const curve_point secp256k1_cp2[255] = {
{/*.x =*/{/*.val =*/{0x3ce036f9, 0x1807c44e, 0x36f99b08, 0xc721160, 0x1d5229b5, 0x113e17e2, 0xc310493, 0x22806496, 0xf930}},
 /*.y =*/{/*.val =*/{0x4b8e672, 0x32e7f5d6, 0xc2231b6, 0x2a664d, 0x37f35665, 0xcdf98a8, 0x1e8140fe, 0x1ec3d8cb, 0x388f}}},
{/*.x =*/{/*.val =*/{0x20297556, 0x3c15e851, 0x168a18b2, 0x3d91cbe1, 0x1235d382, 0x14e850d5, 0x2eea4204, 0x1ef55d57, 0xfff9}},
 /*.y =*/{/*.val =*/{0x3075f297, 0x321c30da, 0x18fe4a03, 0x203c3d94, 0x5c560de, 0x3a5805fd, 0x3b620f3b, 0x1ddeab3e, 0xae12}}},
{/*.x =*/{/*.val =*/{0x30afe85a, 0x16c3d1c1, 0x220095bc, 0x1f3d1065, 0x33463368, 0xe3c0135, 0x3561b15c, 0x5755239, 0xd011}},
 /*.y =*/{/*.val =*/{0x34062327, 0x2c146c4f, 0x1a86d526, 0x8e31776, 0x3bd81579, 0x1914df85, 0x1e0d7a8b, 0x13ff7205, 0xa9f3}}},
{/*.x =*/{/*.val =*/{0x3202e6ce, 0x140af6a2, 0x162b7940, 0xc8550e7, 0x3a8b0968, 0x2724586, 0x133d48ac, 0x310d504f, 0xfe72}},
 /*.y =*/{/*.val =*/{0xf58c5bf, 0x1e3b4bef, 0x34a9d229, 0x372238da, 0x32998101, 0x2d1f8275, 0x24a68d3a, 0x37819ffc, 0x6851}}},
{/*.x =*/{/*.val =*/{0x1118e5c3, 0x2f61c2a8, 0x12bebc19, 0x15e6c9d1, 0x265b4bfc, 0x595bbd3, 0x1307db44, 0xcd76591, 0x6eca}},
 /*.y =*/{/*.val =*/{0x5a08668, 0x2628bde0, 0x3f8ec344, 0x125a8e8e, 0x3875a03a, 0x3d5e41d2, 0x20710592, 0x8ed5e9e, 0xd501}}},
{/*.x =*/{/*.val =*/{0x3f8cb0e3, 0xe4ceb29, 0x1efe3a44, 0xbad4ff8, 0x2eb72ea2, 0x1938112c, 0x16d8f8fa, 0x20395d11, 0x3f0e}},
 /*.y =*/{/*.val =*/{0x2a5f404f, 0x2c0a278b, 0x25b53a4c, 0x494ea9, 0x1d01b395, 0x2e702121, 0xbc91e90, 0x35f5ca5b, 0xcb66}}},
{/*.x =*/{/*.val =*/{0x33ce1752, 0x1edd43dc, 0x3cd204ec, 0x20f1e5f5, 0x1c9aeae7, 0x377d9366, 0x1c635812, 0x36963407, 0xd7a0}},
 /*.y =*/{/*.val =*/{0x762cef4, 0x2f009ce0, 0x62b742b, 0x38102a30, 0x2284650b, 0xa4a0d03, 0x8032f6f, 0x1c381a00, 0x9127}}},
{/*.x =*/{/*.val =*/{0x35476085, 0x2422dc06, 0x2eb9f84a, 0x1c539de5, 0xed1afb5, 0xeab5a9e, 0xcd3e10d, 0x29c19e82, 0x3443}},
 /*.y =*/{/*.val =*/{0xb8f52d8, 0x34d212f6, 0xc2b67f6, 0x2292c9f4, 0x3e1da901, 0x3a312e31, 0x36f854f6, 0x1e97e0a6, 0x661a}}},
{/*.x =*/{/*.val =*/{0x257e8dfa, 0x33f032e7, 0x3c7e184f, 0x20246468, 0x298ca009, 0x28c3e2b2, 0x19c4c0d9, 0x33cbfc1e, 0x8262}},
 /*.y =*/{/*.val =*/{0x3bac376a, 0x173fe363, 0x314c4783, 0x2dbb4cca, 0x334f3457, 0x3b88bb16, 0x9e4e66f, 0x25788244, 0x83fd}}},
{/*.x =*/{/*.val =*/{0x3c70620c, 0x5f307c9, 0x3c288d9d, 0x26312faa, 0x27178049, 0x374c68ad, 0x236dc60, 0x2a29234b, 0x1653}},
 /*.y =*/{/*.val =*/{0x315b32cd, 0x328ba074, 0x3d3dc526, 0xabdd237, 0x3a701c01, 0x2a651d3b, 0x37f7aeaf, 0xa424d6b, 0x338}}},
{/*.x =*/{/*.val =*/{0x271dabcd, 0x1f50ae9b, 0x1e5cb4f4, 0x34ff9262, 0x35373f54, 0x22b8c982, 0x3f43c609, 0x393edad8, 0xd49e}},
 /*.y =*/{/*.val =*/{0x16603c2, 0x19aa433c, 0x2ff7031e, 0x271424c4, 0x1bf35612, 0x21fa9e98, 0x1490dd7c, 0x38e48269, 0x531}}},
{/*.x =*/{/*.val =*/{0xc8c828a, 0xfcc2ae4, 0x16ae41f5, 0xbac90b2, 0x281c7513, 0x1283605f, 0x9e750e4, 0x21472905, 0x5f94}},
 /*.y =*/{/*.val =*/{0x37344d80, 0x3fac28fc, 0x3c68b04b, 0x19b7dd53, 0x2f35e8c, 0x1e5f622, 0x1fee8e5f, 0x30ee2be8, 0x26b8}}},
{/*.x =*/{/*.val =*/{0x5041216, 0x16dfe3c7, 0x2b836a6, 0x1ccd7da1, 0x2fed523f, 0x2d67bf70, 0x3acf4128, 0xc5ec87d, 0xda75}},
 /*.y =*/{/*.val =*/{0x2e708572, 0x2bb4ca61, 0x37acedad, 0x2ab01eb9, 0x2d7fc6e9, 0x27886cd0, 0x2d5f0df1, 0x2811afdc, 0x73f8}}},
{/*.x =*/{/*.val =*/{0x3c62bac0, 0x1414c93c, 0x1f0ab069, 0x54377d4, 0x28b70e19, 0x12df4b0f, 0x3469c136, 0x3c3e408f, 0x9530}},
 /*.y =*/{/*.val =*/{0x3618e309, 0x1e2af6a5, 0x31fdc684, 0x16cca14b, 0x3333e0e2, 0x34bdfd66, 0x321e234d, 0xc16a3e7, 0x8f3c}}},
{/*.x =*/{/*.val =*/{0x1c3c9c8f, 0x19c10e17, 0x24367b20, 0x205bfb8f, 0x2332b0f2, 0x27fd0eaa, 0x298fd6f0, 0xb72f90, 0x67be}},
 /*.y =*/{/*.val =*/{0x193652d9, 0x14e12661, 0x388c2be5, 0x264efd82, 0x291693cd, 0x2516d820, 0x1ef84a2c, 0x1569cf93, 0x7a9b}}},
{/*.x =*/{/*.val =*/{0x10aaa33a, 0x7e6f2f8, 0x17b9ca51, 0x24b74a70, 0x1718368c, 0x1a404ef1, 0x3876adf5, 0x924bd3b, 0x893b}},
 /*.y =*/{/*.val =*/{0x11af3445, 0x1ee02e2b, 0x3ceeb426, 0xe7a2884, 0x107f32a4, 0xe801d99, 0x1c89ef41, 0x14ad9cb4, 0xcdb1}}},
{/*.x =*/{/*.val =*/{0x36e55dc8, 0x2e24485b, 0x2ca04394, 0x3e56adba, 0x1094426f, 0x12910301, 0x1ffb2ba8, 0x1011e431, 0x4431}},
 /*.y =*/{/*.val =*/{0x1be323b3, 0x76512bb, 0x2aa2e503, 0x1a8a6de7, 0x2fed7a6, 0x260dfd59, 0x366f8fe9, 0x3050b994, 0x96b0}}},
{/*.x =*/{/*.val =*/{0x33f0e9aa, 0x3ad78658, 0x11bd34b3, 0x449ddac, 0x138d268, 0x92b8356, 0x326adb79, 0x3fa15d7, 0xe538}},
 /*.y =*/{/*.val =*/{0x82720f, 0x12e904d9, 0x68318ec, 0x2e53977d, 0xc8e016f, 0x244d8e49, 0x3b41d5b6, 0x361ce421, 0xb97f}}},
{/*.x =*/{/*.val =*/{0x2ebc61d6, 0x2bb4d86f, 0x1ff42de1, 0x23f4e9f6, 0x2b1f518a, 0x17c34575, 0x19af0c39, 0x3cf928fb, 0x939f}},
 /*.y =*/{/*.val =*/{0x23f5cb70, 0x1d7a919a, 0x38c7f82e, 0x2fc9bad, 0x16c0498, 0x1bf13bbc, 0x3a90e9d4, 0xef3c22d, 0xdeab}}},
{/*.x =*/{/*.val =*/{0x497e0df, 0x5b84d37, 0xf76f530, 0xeed0dbb, 0x2029a04c, 0x161e17f9, 0x3293078, 0xf94ab8e, 0xfdc6}},
 /*.y =*/{/*.val =*/{0x1b9eb19f, 0x1811127, 0x335d9d5f, 0x2fac8bef, 0x22e8b87b, 0x3dc50a2b, 0x3bb52e3d, 0x2b59eb3a, 0x292d}}},
{/*.x =*/{/*.val =*/{0x355812dd, 0x28a960b, 0x12d30e2a, 0x1119c8d5, 0x18f78e3d, 0x2afb5b01, 0x3352f0b6, 0x2f5ea4bf, 0x7029}},
 /*.y =*/{/*.val =*/{0x1a2d2927, 0x87319ac, 0x3b2c73c7, 0x36ba1090, 0x683ac47, 0x19512b8c, 0xb3d27dd, 0x3eb6bf7a, 0xb0ee}}},
{/*.x =*/{/*.val =*/{0x3181fdc2, 0x336affe6, 0xc62364d, 0xbd8aed7, 0x234e7edd, 0x992e062, 0x26e474aa, 0x40abd1f, 0xf42c}},
 /*.y =*/{/*.val =*/{0x2485d7fd, 0x7c0024e, 0x22acf268, 0x5540b66, 0x2fe22a4c, 0x2b4172e1, 0x2806c78f, 0xead1b3f, 0x5750}}},
{/*.x =*/{/*.val =*/{0x2edd7dd6, 0x219b51f7, 0x1e1968c3, 0xddbf899, 0x3cfdec49, 0x29e103b9, 0x3524bca5, 0x33da8931, 0x32cf}},
 /*.y =*/{/*.val =*/{0x3e08e330, 0x17f512bb, 0x349a08b2, 0x3633480, 0x1f561e7a, 0x2025a902, 0x27748620, 0x1a8d25da, 0x2184}}},
{/*.x =*/{/*.val =*/{0x21231d11, 0x399d20c4, 0x2aaad7c, 0x2acdb18f, 0x37c39822, 0x455731d, 0x388e433d, 0x3507a2e4, 0x3514}},
 /*.y =*/{/*.val =*/{0x23855df5, 0xf5bed03, 0x2f79ebe5, 0x213cc742, 0x39eff93, 0x1344795a, 0x17eb8ef4, 0xc940580, 0x89a8}}},
{/*.x =*/{/*.val =*/{0x633cb1, 0x159f827a, 0x1d021132, 0x168892da, 0x181fcb57, 0x189cc848, 0x2cad400c, 0x273cc5ea, 0x6dde}},
 /*.y =*/{/*.val =*/{0x27ce6b34, 0x1f7526a9, 0x3859ef35, 0x2c9ff6b3, 0x3a66a880, 0x27be1a86, 0x3e41d5c9, 0x3ef9e9c1, 0x9188}}},
{/*.x =*/{/*.val =*/{0x4e5467d, 0x342f5da9, 0x1bbface4, 0x2422ae06, 0x970e940, 0x7d8b83b, 0x1a1222c2, 0x193c3f1a, 0x97d0}},
 /*.y =*/{/*.val =*/{0x1e9cb3fa, 0x25cc03f4, 0xf17ccd7, 0x17ecee15, 0x10861fda, 0x1f19bea1, 0x2cc03f, 0x13cbb4cd, 0x8997}}},
{/*.x =*/{/*.val =*/{0x13613bec, 0x32a072e4, 0x1cfe67c, 0x2d7f2744, 0xf972a8b, 0x6ccf71d, 0x137bdedf, 0x32ae324e, 0x2dcf}},
 /*.y =*/{/*.val =*/{0x1a039215, 0x39cc2492, 0x33f5f383, 0xcb3eeb4, 0x36c6f437, 0x222df5b, 0xa41265f, 0x3137651d, 0x46db}}},
{/*.x =*/{/*.val =*/{0x7fb9e1a, 0x1f345c21, 0x22a32961, 0x39d2dd37, 0x2b0e767f, 0xaf26ee, 0x2c5a8f1a, 0x1052a923, 0x1bec}},
 /*.y =*/{/*.val =*/{0x349c0443, 0x1fdb845d, 0xc9796e5, 0x4e176ba, 0x54b0f68, 0x26f15cc3, 0x266678a7, 0x19c11c04, 0xe358}}},
{/*.x =*/{/*.val =*/{0x3b7ceceb, 0xfd9e3fe, 0x97faf0f, 0x2967e4e2, 0x2e681473, 0x3ee049bd, 0x2d45036f, 0x2188109d, 0x437a}},
 /*.y =*/{/*.val =*/{0x16c181e1, 0xd8ef30d, 0x8f97827, 0x883f3f7, 0x1297ff87, 0x23fada67, 0x2c32f69b, 0x1ae84fba, 0xb91}}},
{/*.x =*/{/*.val =*/{0x1cbf00eb, 0x3276761f, 0x18d02274, 0x2d3a62f0, 0x230bc241, 0x385bda86, 0x2d4dc49b, 0x1c2ba5ba, 0xb890}},
 /*.y =*/{/*.val =*/{0x1b0e664e, 0x2dfc6f34, 0x2b96a671, 0x362c1ad, 0x4a766cb, 0xa539307, 0x2d88f472, 0x3230b228, 0x6f24}}},
{/*.x =*/{/*.val =*/{0x36fbe7b2, 0x275bfe6a, 0x18d65a3b, 0x2b7b7051, 0x2884605e, 0x1aeec6ca, 0x41f8f33, 0x21d9a72d, 0x2648}},
 /*.y =*/{/*.val =*/{0x21bc2a34, 0xca9e2f0, 0x20eb6039, 0xe36605a, 0x2ddf1856, 0x3cb72b40, 0x144988f2, 0x36ad2c80, 0x9e15}}},
{/*.x =*/{/*.val =*/{0x2b038315, 0x1a434c18, 0x1310e6f9, 0x2b310cda, 0x14b8629c, 0x1a038e5e, 0x312221e4, 0x15a1d59d, 0xaba5}},
 /*.y =*/{/*.val =*/{0x2e25fc0a, 0x26800fe6, 0xb63338f, 0x2fed4cb6, 0x130d6f3f, 0x15c3d894, 0x25edb63d, 0x1761ea8d, 0xa0e7}}},
{/*.x =*/{/*.val =*/{0x15bc15b4, 0x32e684d2, 0x25a2ee69, 0x1d40a391, 0x17ca8d92, 0x163ba73b, 0x2adc9ed8, 0x38b947b, 0x10e9}},
 /*.y =*/{/*.val =*/{0x18aa258d, 0x13af9825, 0x2bb6a883, 0x296258c0, 0x2d1f754c, 0x1ea3185a, 0x1e0424d5, 0xdc0e035, 0xc68a}}},
{/*.x =*/{/*.val =*/{0x3a1c0a80, 0x3d8aaf21, 0x25a9c740, 0x18945631, 0x2ff9c34d, 0x326f9c00, 0xcca5b17, 0x169a2985, 0xb6b1}},
 /*.y =*/{/*.val =*/{0x1ce0a03, 0x1b340441, 0x2e16eeb, 0x2684acc2, 0x2536d49c, 0x3888fbbd, 0x1b61ea54, 0xb8535b3, 0xfae6}}},
{/*.x =*/{/*.val =*/{0x12b062d4, 0x1f2a942a, 0x3b6a141a, 0x1739f966, 0x2a227a7a, 0x2c5c4a0f, 0x2eaca06f, 0xfa90c95, 0x3596}},
 /*.y =*/{/*.val =*/{0x3bb25302, 0x42a9346, 0xde59b1a, 0x1020ae59, 0x8a96d0, 0x33865be7, 0x1e5c9bfc, 0x38515254, 0xf65b}}},
{/*.x =*/{/*.val =*/{0x1d33fd27, 0x282fd714, 0x246cc62f, 0x17d5cf6d, 0x2361b44, 0x8e23b6a, 0x3e84cd02, 0xfc24898, 0x9ed7}},
 /*.y =*/{/*.val =*/{0x2716c458, 0x25cacb78, 0x2e449345, 0x2a08f96c, 0x6725494, 0x16d3cd09, 0x1eeeaee7, 0x2259faec, 0xb631}}},
{/*.x =*/{/*.val =*/{0x2f028d83, 0x1e588ebb, 0x27439615, 0x25649b6e, 0x1e69db61, 0x2af96857, 0x385ec6a5, 0x3df138f1, 0xa7eb}},
 /*.y =*/{/*.val =*/{0x19d0bed1, 0x1900e4ae, 0x30539199, 0x28e249d2, 0x4804b47, 0x271cddc1, 0x362d5cfd, 0x54beff8, 0x6205}}},
{/*.x =*/{/*.val =*/{0x3bb61ee5, 0xa21104d, 0x31f0c13f, 0x13c138be, 0x34ae6eda, 0x18e33625, 0x321b8662, 0xc8c3321, 0xd493}},
 /*.y =*/{/*.val =*/{0x25d694a8, 0x18b69343, 0x2438ddc6, 0x344b2316, 0xafb5e1a, 0x317a747b, 0x29d23edc, 0x26afd46, 0x21c}}},
{/*.x =*/{/*.val =*/{0x2c04554a, 0xc3772f3, 0x288cffe5, 0x373feed1, 0x10a2ecaa, 0x194b09e8, 0x3d1a0474, 0xdf2261c, 0x896f}},
 /*.y =*/{/*.val =*/{0x129138df, 0x1a3e7f86, 0xc417dcd, 0x216d86b, 0x11bf1e6, 0x8aec13a, 0x2c4acda6, 0x8f9c892, 0x3804}}},
{/*.x =*/{/*.val =*/{0x343fca26, 0x101df46a, 0x3bc23678, 0x3ee10768, 0x3578a27d, 0x308276fc, 0x36d6cca6, 0x2e5fddd2, 0x11b3}},
 /*.y =*/{/*.val =*/{0x1b679d58, 0xec9fabd, 0x39f9d42d, 0x2b88c712, 0x36d3bb3b, 0x159430bc, 0xc508cd, 0x7e7eb98, 0x6533}}},
{/*.x =*/{/*.val =*/{0x8dfd587, 0x1e4d86ed, 0x1b026560, 0x312e8e32, 0x35a12d5e, 0x19eaa8b3, 0x508b348, 0x2d06eb3d, 0x5084}},
 /*.y =*/{/*.val =*/{0x11470e89, 0x39e7a5fe, 0x91f5606, 0x2dbd581a, 0x2927475d, 0x2a9b2154, 0xd31619, 0x18c68766, 0x34a9}}},
{/*.x =*/{/*.val =*/{0x2c953fa9, 0x341655b5, 0xb8c3db4, 0x2ac98a7c, 0x118c0628, 0x3d21752f, 0x393233a5, 0x3443aaaa, 0xa49e}},
 /*.y =*/{/*.val =*/{0x6fb4c72, 0x1ecaf489, 0x28e181b6, 0x3a1d4d25, 0x1fddfb5a, 0x11db0283, 0x35398e03, 0x2e251983, 0xcc72}}},
{/*.x =*/{/*.val =*/{0x27a1d916, 0x3025b4ff, 0x11f1f3a3, 0x16c28e57, 0x1bb07031, 0x18562997, 0x19d0cbac, 0x3e6b2db5, 0x650e}},
 /*.y =*/{/*.val =*/{0x3068387b, 0x16127299, 0x36c26ba8, 0x2ed18229, 0x1b82c558, 0x2702e49e, 0x2b11870e, 0x47c8458, 0x85d}}},
{/*.x =*/{/*.val =*/{0x36fb2940, 0x37f07501, 0x2534042f, 0x7f01a6c, 0x2b8fbd71, 0x1d04e10a, 0x1c82fecb, 0x283bf680, 0x5083}},
 /*.y =*/{/*.val =*/{0x36ceee44, 0x378c0ed9, 0x2cdddf3b, 0x1a849b87, 0xdf19b08, 0x3ef7e189, 0x782bba8, 0x2bbe3ff9, 0xf064}}},
{/*.x =*/{/*.val =*/{0x15bc8a44, 0x3bf74194, 0x3e151a19, 0x10405df2, 0x1a5fc768, 0x159692e9, 0xeda3d38, 0x20160f3f, 0x4d01}},
 /*.y =*/{/*.val =*/{0x1adbc09e, 0x3c7e5324, 0x182da362, 0x250811a1, 0x16381396, 0x26ea001f, 0xf5d367e, 0x31b0632d, 0x3a33}}},
{/*.x =*/{/*.val =*/{0x135b4eb8, 0x14884f92, 0x38b5a3cf, 0x3d55fc6a, 0x2f2dce07, 0x3d528f32, 0x32256f0f, 0x1a390eb7, 0xc119}},
 /*.y =*/{/*.val =*/{0x2f911add, 0x11265b5, 0x2a7149b7, 0x3e2d2504, 0x366f8242, 0x27607f99, 0x2458f837, 0x39a4dde1, 0xbff5}}},
{/*.x =*/{/*.val =*/{0x19dffc96, 0x256e8425, 0x3ac58572, 0xa33696b, 0x17eb0192, 0x26ce5720, 0x3deaf6f, 0x1b2fb852, 0x161c}},
 /*.y =*/{/*.val =*/{0x1b492de4, 0x24ef3d84, 0x2af8621c, 0x258d324b, 0x3183059b, 0x964e472, 0x1ff985bd, 0x32a4a9ae, 0x8a26}}},
{/*.x =*/{/*.val =*/{0x369671d5, 0x35f9c967, 0x14eb83e3, 0xbbabd6d, 0x2bc96056, 0x7906af5, 0x39596d76, 0x3b1580f3, 0xa8c1}},
 /*.y =*/{/*.val =*/{0x333db746, 0xf22a034, 0x18f8b182, 0x2997eccc, 0x141c5924, 0x31cc9a4, 0x345ac755, 0x181447a7, 0x5fc3}}},
{/*.x =*/{/*.val =*/{0x8a2050e, 0x6b10bf9, 0x15f8a677, 0xbbd55d8, 0x79b8974, 0x1da731b9, 0x731896b, 0x93f492f, 0x6737}},
 /*.y =*/{/*.val =*/{0x61d3d70, 0x24326924, 0x3349cc2b, 0x1aeb3f50, 0x86b6dbe, 0x120b026a, 0x24a20203, 0x2095e25a, 0xe4cf}}},
{/*.x =*/{/*.val =*/{0x29a78179, 0x133d807e, 0x20d6afe3, 0x143a4149, 0x9ed9f6b, 0x291ccd88, 0x1b8dc905, 0x29fcdc20, 0x995c}},
 /*.y =*/{/*.val =*/{0x2fec1f47, 0xc7eed32, 0x2b64e529, 0x332155a6, 0x12863abb, 0xd362012, 0x3573ab5e, 0x167a5554, 0xd9a0}}},
{/*.x =*/{/*.val =*/{0x49135d3, 0xf636176, 0x2e431fc1, 0x80f3404, 0x30b16a74, 0x4d0a504, 0x2a85a65c, 0x2f1fbe0, 0x594}},
 /*.y =*/{/*.val =*/{0x162255d2, 0xb5d146, 0x1902391d, 0xa18ca32, 0x36687af1, 0x16c31eaa, 0x3ab612f7, 0x1e617ad3, 0x9053}}},
{/*.x =*/{/*.val =*/{0x39e68f51, 0x3de3a89e, 0x16b6e1d0, 0x1b87f2ae, 0xd870cf5, 0x301895ca, 0x26fcb74d, 0x116b276e, 0xc755}},
 /*.y =*/{/*.val =*/{0x38cfbbc1, 0x7120e25, 0x22ddf68d, 0x7246272, 0x168bf725, 0x163b6ca8, 0x855c2a7, 0xf11a8ef, 0x7c80}}},
{/*.x =*/{/*.val =*/{0x41ead4b, 0x3fa21e68, 0x11b03c1f, 0x1d7b7eda, 0x3e76be3a, 0x11cd3beb, 0x3337ec71, 0x3032323, 0xbfc9}},
 /*.y =*/{/*.val =*/{0x6fedaed, 0x114b1bc2, 0x2e0ae3e7, 0x11a3bfcc, 0x42d36fb, 0x29c63754, 0xded24db, 0x206c7827, 0x7a94}}},
{/*.x =*/{/*.val =*/{0x25b7ad0d, 0x253215bb, 0x1d0d1d36, 0x3b9d9f2a, 0x116c4476, 0x362925b, 0x1e00dc2d, 0x1a436aed, 0x3a55}},
 /*.y =*/{/*.val =*/{0x32e8c407, 0x1b261e42, 0x2c31218d, 0x32b2e2b2, 0x2f99f301, 0x7eeb25f, 0x657bfb2, 0x23865d68, 0xc3e2}}},
{/*.x =*/{/*.val =*/{0x19b2df82, 0x9e91ec2, 0x3104fb19, 0x179e8591, 0x232c04ec, 0xb463b33, 0x3b92ccc9, 0x191718af, 0x405a}},
 /*.y =*/{/*.val =*/{0x9307dbf, 0x368a0d28, 0x2dc462b5, 0x3ea76cb3, 0x37e7122f, 0x2b298788, 0x196e0f5c, 0x2d053d13, 0xbc3c}}},
{/*.x =*/{/*.val =*/{0x18f4033f, 0x9f0f311, 0x20ab6d3a, 0x12b3c96c, 0x28f817cc, 0x2c835e83, 0x3cfb3d2a, 0x51ad0e6, 0x10ba}},
 /*.y =*/{/*.val =*/{0x76d1fbf, 0x173dae53, 0x1c78b4ea, 0x6dacdfa, 0x129f3677, 0x283c19a8, 0xaef4b2a, 0x19b9747, 0xade1}}},
{/*.x =*/{/*.val =*/{0x36e2d9b3, 0x12f4c1aa, 0x338d6351, 0x36e4a0c6, 0xf845641, 0xba984e7, 0x305e75e1, 0x53ce5f1, 0x19a3}},
 /*.y =*/{/*.val =*/{0xbaaaf33, 0x154bb897, 0x4be56d, 0x874749, 0x3528b3a5, 0x2597e21f, 0x328dd234, 0x363d76b1, 0x6cac}}},
{/*.x =*/{/*.val =*/{0x23a52264, 0xb9cdf65, 0x1400b375, 0x2b7f00c5, 0x251cffd0, 0x1b8aa6ab, 0x7fe9a80, 0x37037a06, 0x85ff}},
 /*.y =*/{/*.val =*/{0x2da2082, 0x231f4a6a, 0x3179d049, 0x2060b24a, 0x14706c67, 0x15a3d415, 0x2948d0be, 0xc061eb8, 0x3fee}}},
{/*.x =*/{/*.val =*/{0x36a88c9c, 0x307fd692, 0x149df069, 0x1eda198c, 0x2caa2aa3, 0x766b25c, 0x391398b2, 0x24207951, 0x7865}},
 /*.y =*/{/*.val =*/{0x35a7d19b, 0x38164d15, 0x3ab6a155, 0x33e466c0, 0x28196112, 0x23e9c897, 0x30d2b69e, 0xc1de4a8, 0x59a2}}},
{/*.x =*/{/*.val =*/{0x1e8f7605, 0x374b71e3, 0x3ed2d35b, 0x13bde7d7, 0xff48bd4, 0x2ce44ba2, 0x159def16, 0x1100533a, 0x21ce}},
 /*.y =*/{/*.val =*/{0x955155f, 0xd791446, 0x46602c1, 0x38cd259a, 0x1da46ef4, 0x1bf5987c, 0xfaf75d9, 0x19c08e8b, 0x323a}}},
{/*.x =*/{/*.val =*/{0x121ce204, 0x13b5d7a3, 0x26763d52, 0x29c96390, 0x26f72fb2, 0x1d361672, 0x3c64fb83, 0x107458ac, 0x43ca}},
 /*.y =*/{/*.val =*/{0x134a8f6b, 0x1494113a, 0x2a4a468e, 0x2db1eccf, 0x1ba31f9a, 0x143e4863, 0x23fa1c6, 0x16a0b8dc, 0xdcea}}},
{/*.x =*/{/*.val =*/{0x14978583, 0x2ce90c80, 0x61613f5, 0x35ba6bbc, 0x392214cd, 0x21066643, 0x23137497, 0x3e26e73c, 0x30ab}},
 /*.y =*/{/*.val =*/{0x1dc75777, 0x118600d4, 0x3b584ac4, 0x483a88e, 0x21ab8063, 0x1ed3cb43, 0x37498cdf, 0x144551df, 0x4b03}}},
{/*.x =*/{/*.val =*/{0x2c288015, 0x268df98f, 0x2dc99cc3, 0x1cfe14fb, 0x1b6aa646, 0x3eb18681, 0x2de6f681, 0x13aab64d, 0xaa01}},
 /*.y =*/{/*.val =*/{0x6c1006f, 0x3e053999, 0x3cecad9d, 0x12e6c1d0, 0x3b0f63ef, 0xa9f90fd, 0x2be9ac3f, 0x4f0118d, 0x3de9}}},
{/*.x =*/{/*.val =*/{0x185bfe2, 0x34231245, 0xe5e42d3, 0x37e8ab9e, 0x2679cb5e, 0x2a82a0b3, 0xa0b0b56, 0x576fcdf, 0xe526}},
 /*.y =*/{/*.val =*/{0x2a0e5888, 0x33c042f, 0x245a9c44, 0x1dbfcb72, 0x32c1a284, 0x7e54a27, 0x488520f, 0xcd459b4, 0x5403}}},
{/*.x =*/{/*.val =*/{0x59ab499, 0x2f674fc8, 0x273c330a, 0x4ca671b, 0x3f01bc0b, 0x65acf19, 0x5ba5d2, 0x2bfcc057, 0x78ba}},
 /*.y =*/{/*.val =*/{0x3ee097fd, 0x20748c63, 0x11251996, 0x18cbbba3, 0x2082e91, 0x2a1383b6, 0x2c0afafc, 0x3736f6c1, 0xad4b}}},
{/*.x =*/{/*.val =*/{0x25cd5379, 0xc18ccc2, 0x70bcadc, 0x2de50e16, 0x24d2232d, 0x9206e2a, 0x11382a78, 0x1cb55af7, 0x17c0}},
 /*.y =*/{/*.val =*/{0x3108cd25, 0x1f2b8146, 0x25bad0df, 0x166b1d89, 0x1d034f89, 0x30491ebc, 0x1a064e77, 0x2f7d0a0f, 0xd901}}},
{/*.x =*/{/*.val =*/{0xa2d8dae, 0x1e4f0063, 0x3d25ea95, 0xca97e47, 0x32256eac, 0x2c97be72, 0x192f9ba6, 0x7009884, 0x8827}},
 /*.y =*/{/*.val =*/{0x3e1e77d9, 0x2d09b03c, 0x317d099f, 0x21db71, 0x2bf5acc3, 0x322ceb96, 0x176aa401, 0x3754d41c, 0xd719}}},
{/*.x =*/{/*.val =*/{0x1ee503a6, 0x2543ebf4, 0x124e1fba, 0x7a1493c, 0x2ec5ab43, 0x2a0c4661, 0x24a29aa6, 0x1fa04b8f, 0xceb6}},
 /*.y =*/{/*.val =*/{0xe98c4d1, 0x3ff50365, 0x269e2f31, 0x225b657b, 0x1cd86b4b, 0xf7de042, 0x10613b82, 0x21516b0e, 0x5e6a}}},
{/*.x =*/{/*.val =*/{0x3ba9000, 0x37c1c8ea, 0x25e8b6f, 0x21cbe71a, 0x143dc4, 0x21d81d61, 0x1d8c1684, 0x1d3e7ffc, 0xac38}},
 /*.y =*/{/*.val =*/{0x2f10cf0a, 0x368f1f65, 0x366e9fa4, 0x178d435f, 0x117f9308, 0xb77a250, 0x1c069b86, 0x3a48c228, 0xaa65}}},
{/*.x =*/{/*.val =*/{0x17ba402e, 0x39758c2c, 0x1042989a, 0x2e06970b, 0x8e3c3c3, 0x3ab43121, 0x3a02a58b, 0x6d73463, 0x8e89}},
 /*.y =*/{/*.val =*/{0x4fad9e0, 0x386d89e7, 0x157a7ee8, 0x19430908, 0x32a306af, 0x23439013, 0x2c6680b3, 0x3839aa7, 0xe5d3}}},
{/*.x =*/{/*.val =*/{0x136bcfe8, 0x187b5879, 0x29b7bb3e, 0x305e7b5, 0x2b319a0e, 0x32a3c8c1, 0x2999b472, 0x3e2f0731, 0x1332}},
 /*.y =*/{/*.val =*/{0x1ae78402, 0x6c374b3, 0x1a8c2145, 0x24ed0935, 0x1c0681ba, 0x19f114d7, 0x2ed713f, 0x31fb8a58, 0xc39d}}},
{/*.x =*/{/*.val =*/{0x2fddec6, 0x3fffb0cd, 0x111222c7, 0xb00f7df, 0x3f461492, 0x3678cde4, 0x220b4e9c, 0x7fead4f, 0x9f13}},
 /*.y =*/{/*.val =*/{0x9df8052, 0x3855dbc6, 0x3918eac6, 0x28c8d510, 0xec8d7d3, 0x34d25302, 0x326f4fef, 0x5302c, 0x3b21}}},
{/*.x =*/{/*.val =*/{0x38c8ac7f, 0xa0bf97e, 0x1e2aa527, 0x490bb99, 0x16f84964, 0xce5b481, 0x22bbcb5c, 0x2cbef8e0, 0x9945}},
 /*.y =*/{/*.val =*/{0x29aea3b0, 0x1b650e85, 0x2dacdfa9, 0xbde88fb, 0x28eff528, 0x36d13fec, 0x3282d607, 0x3b6092c3, 0x3eef}}},
{/*.x =*/{/*.val =*/{0x12fccf64, 0x2ea92662, 0x181318e3, 0x349e3789, 0x95dbf3b, 0x21dcb1df, 0x637db06, 0x45703ad, 0xc7d}},
 /*.y =*/{/*.val =*/{0x2878fee0, 0xfdb4ecc, 0x19ae68d5, 0x1e1760e5, 0xaf14548, 0x1092e11e, 0x1b0447aa, 0x1d1ec649, 0x4aa8}}},
{/*.x =*/{/*.val =*/{0x148d5622, 0x2d6baeb1, 0x251bd2e8, 0x36c1fbde, 0x33381be1, 0x161aa06f, 0x9535a39, 0x3047985a, 0x5fc6}},
 /*.y =*/{/*.val =*/{0x1ac1683, 0x34361004, 0x2c7bf300, 0x16b4239, 0x367acb0e, 0x26e8b6c0, 0x1d9db9c1, 0x39526a8, 0x10e8}}},
{/*.x =*/{/*.val =*/{0x33c85ecf, 0x1a5916ce, 0x15dacd7, 0x6e08398, 0xff0807d, 0xbd69fa, 0x23e20844, 0x22f56a48, 0x23dd}},
 /*.y =*/{/*.val =*/{0x274504ad, 0x1c2702ae, 0xec98f6f, 0x274c6013, 0x10d4b7fc, 0x7b4bf9c, 0x3d26f710, 0x26ef0094, 0x52d}}},
{/*.x =*/{/*.val =*/{0x1136602, 0x2c2e9195, 0x19e3a5bb, 0x311bd203, 0x333b3d38, 0x1624dfc8, 0x2dfc33d0, 0x9ca0120, 0x87d1}},
 /*.y =*/{/*.val =*/{0x18af6aac, 0x3da0f107, 0x3d3bf7c4, 0x2a211d1b, 0x27745387, 0x289db3fd, 0x203de926, 0x921c296, 0x71ce}}},
{/*.x =*/{/*.val =*/{0x30e74459, 0x1d28d722, 0x3ddb6dd6, 0x3c8dd8e1, 0x3c8a91fe, 0x3d1961c4, 0x5680590, 0x1e0753b0, 0x28df}},
 /*.y =*/{/*.val =*/{0x2f5e656f, 0x3781f303, 0x1ae6f0a8, 0x1e56e940, 0x322794a3, 0x36c5e243, 0x30f17cb0, 0x27a99a84, 0xf149}}},
{/*.x =*/{/*.val =*/{0x29c71143, 0x11b67714, 0xf057ea3, 0x1fab6b11, 0x23fa352e, 0x1f33e400, 0x3ea103ca, 0x17e588ae, 0xeb4}},
 /*.y =*/{/*.val =*/{0xb70b136, 0x22a33688, 0x22b1bf4c, 0x165a7a9a, 0x1e2857d6, 0x1807d640, 0xbd0f573, 0xbd6160e, 0x52c4}}},
{/*.x =*/{/*.val =*/{0x1507a7e6, 0x37cdaf22, 0x305f129b, 0x25896ebd, 0x310c41c0, 0xa1458cd, 0x1ad0d5f4, 0x142c15d1, 0x232d}},
 /*.y =*/{/*.val =*/{0x152b5892, 0x1c202084, 0x6459ccb, 0x18303bed, 0x2257f712, 0xe22b7c1, 0x33f6b086, 0xeb14d79, 0x780f}}},
{/*.x =*/{/*.val =*/{0x177e7775, 0x222a29b8, 0xed95f63, 0x385564e2, 0x1291aeb5, 0x150eeb3d, 0x233cee58, 0x1a8ebfe5, 0x9d89}},
 /*.y =*/{/*.val =*/{0x3a056691, 0x3f3db4ea, 0x299253be, 0x26735fb8, 0x10927de8, 0x2593b5c9, 0x1bf0b94e, 0x2a790fd2, 0xdd91}}},
{/*.x =*/{/*.val =*/{0xc904ed3, 0x1655fc7a, 0x5857841, 0xa9d1624, 0x272384df, 0x3e3990c4, 0x18dff97, 0x230b4b6e, 0xcf}},
 /*.y =*/{/*.val =*/{0x396f77c1, 0x2658ed, 0x32f6827b, 0x26475e74, 0x1bd81122, 0x35706f54, 0x1d44119d, 0x3a9e0, 0xaaad}}},
{/*.x =*/{/*.val =*/{0xcf8cffd, 0x2cad6622, 0x3a45ae61, 0xb9ac56d, 0x1bdd8943, 0x2bee23de, 0x38c1bd45, 0x26dfc7f9, 0x80}},
 /*.y =*/{/*.val =*/{0xdb5f32f, 0x24751686, 0x12b9f93d, 0x28d03eb6, 0x12fdc912, 0x2320db79, 0x1a863028, 0x3808afd0, 0xf817}}},
{/*.x =*/{/*.val =*/{0x2dc7a626, 0x11f741e6, 0x33cdcc02, 0x1772ade, 0x46b0734, 0x32bc48c9, 0x806bce4, 0x1b28b13e, 0x2f45}},
 /*.y =*/{/*.val =*/{0x25279532, 0x2b3ac002, 0x16eaea9e, 0x13236f70, 0x9f5302, 0x47ed991, 0x50544d2, 0x1c69e919, 0xf8cf}}},
{/*.x =*/{/*.val =*/{0x1a328d6a, 0x2eaa0623, 0x1adc18bd, 0x135dcea5, 0x308fa7b2, 0x1a264616, 0x34e00a34, 0x3016e988, 0xc663}},
 /*.y =*/{/*.val =*/{0x3ec9b8c0, 0xec2edaa, 0x12bf9cc2, 0x21547a94, 0x171317dd, 0x2bf73c9d, 0x21c38d39, 0x3a6357dc, 0x3331}}},
{/*.x =*/{/*.val =*/{0x22143fb0, 0x370d6995, 0x3c205dd6, 0x3ee4a0c2, 0x399597a9, 0x2bfcce51, 0x383790cf, 0x37070ceb, 0x292a}},
 /*.y =*/{/*.val =*/{0x236ad01c, 0x2a76d8f3, 0x35e9d4d8, 0xf998b5c, 0x4ecf6d8, 0x65a2833, 0xb647f3f, 0x1986f3b8, 0xa072}}},
{/*.x =*/{/*.val =*/{0x30b90e0b, 0x27b079b0, 0x3094a458, 0x3fc74e7e, 0x675b3d6, 0x32012967, 0x67d3fed, 0x1fe6b55, 0xa435}},
 /*.y =*/{/*.val =*/{0x3a1fdc20, 0x3c002e64, 0x3599b5a3, 0xa880d94, 0xbe8c0dc, 0x341f32d0, 0x3d71a142, 0xb72530f, 0x7c8f}}},
{/*.x =*/{/*.val =*/{0x188f4d82, 0x2e7474ad, 0x159204ac, 0x9937676, 0x21d6fcaf, 0x170c09b0, 0x1c515b0e, 0x1665c1b9, 0x6dd5}},
 /*.y =*/{/*.val =*/{0x14132ad3, 0x287aadab, 0x15927be5, 0x3db9c11b, 0x2d0f9478, 0x3346376d, 0x1233dd46, 0x109ff54d, 0xbc92}}},
{/*.x =*/{/*.val =*/{0x1e05dccc, 0xcb60046, 0x19a93e5, 0xfe8fb53, 0x13d172ae, 0x1b825ae5, 0x1a030954, 0x3db85d4f, 0xb8ce}},
 /*.y =*/{/*.val =*/{0xc6d5750, 0x52833f, 0x26b68133, 0x1d5ff0da, 0x12bd99df, 0x3529d393, 0x9bbf6a4, 0x229829b3, 0x302b}}},
{/*.x =*/{/*.val =*/{0x286df50d, 0x313bb405, 0x6f92bd0, 0x179e4a87, 0x82060cd, 0x361d10b0, 0x1f02d6f, 0x58c24d7, 0x3a57}},
 /*.y =*/{/*.val =*/{0x2859679b, 0x8562ca3, 0x3781a11d, 0x2abe07ae, 0x30a0dde0, 0x3cffcb95, 0x1f32f516, 0xe1ced66, 0x85e1}}},
{/*.x =*/{/*.val =*/{0x388f7e09, 0xaa8ad9f, 0x27d92cde, 0x280dde6e, 0x1dc0beb3, 0x384b9691, 0x5fcbbd8, 0x218f53c8, 0x5e6a}},
 /*.y =*/{/*.val =*/{0x8dfca97, 0x2f58a19d, 0x3b4cfe3b, 0x23940dc8, 0x140234a6, 0x12a347da, 0x8edfc44, 0x681e28e, 0xc257}}},
{/*.x =*/{/*.val =*/{0x1df66583, 0x3b2a229b, 0x25580609, 0x6433e68, 0x1ea87603, 0x38bdfbf, 0x2fd019c1, 0x1c6d48f0, 0x5281}},
 /*.y =*/{/*.val =*/{0x3f480c26, 0x3407b39, 0x3de01414, 0x8104f71, 0x1e8fb495, 0x2f3a351a, 0x27a6598, 0xe575ec3, 0x7b2c}}},
{/*.x =*/{/*.val =*/{0x2521b3ff, 0x38a61193, 0x1aa750ce, 0xf01c5fa, 0x2e24a523, 0x1134afa6, 0x1455c75e, 0x138c0432, 0x248}},
 /*.y =*/{/*.val =*/{0x269da7e, 0x306b92e4, 0x23ac8bbc, 0x1c01b7a4, 0x2d0eebad, 0x30acf0ac, 0x3e30d07e, 0x34282a88, 0x9619}}},
{/*.x =*/{/*.val =*/{0x692fd1, 0x2c982585, 0x3d90dfe2, 0x3d0f1b32, 0x1f190edc, 0x2ab7bd2c, 0x1ff800e0, 0x322d2640, 0x4e53}},
 /*.y =*/{/*.val =*/{0x328625e0, 0xd24c39c, 0x3fc97539, 0x1e943695, 0x219da1a8, 0x335c269c, 0x1a01e186, 0xf93d350, 0xdd6e}}},
{/*.x =*/{/*.val =*/{0x3549827b, 0x2338d5f6, 0x121bd614, 0x313dfcf8, 0x2ce311fc, 0x4b81b78, 0x375f3a82, 0x343d7834, 0xce47}},
 /*.y =*/{/*.val =*/{0x2faed097, 0xf32697f, 0x5769df4, 0x39964bfc, 0x39ad0f29, 0x244e7f96, 0x30d49d58, 0x263ee658, 0x15c6}}},
{/*.x =*/{/*.val =*/{0xc43da59, 0x3747b53a, 0x3a48ca2f, 0x6911b8a, 0x6cf9bc9, 0x1c4ebfe0, 0x21a3319b, 0x1f592302, 0x7115}},
 /*.y =*/{/*.val =*/{0x248d28ac, 0x1f7884ad, 0xcb6ad56, 0x33c28fe9, 0x11ab13fc, 0x28440e45, 0x303053f2, 0x35451759, 0x3d53}}},
{/*.x =*/{/*.val =*/{0x3e889756, 0x37606ba6, 0x3004bb25, 0x1ed9265e, 0x1899f3f2, 0x3365ec9c, 0x1fea8226, 0x22f0cc84, 0x762e}},
 /*.y =*/{/*.val =*/{0x3ca6b774, 0x17896781, 0x84fa5e2, 0x1cb6cc52, 0x2e34719, 0x3313c526, 0x3e97c3c7, 0x250982bc, 0xc028}}},
{/*.x =*/{/*.val =*/{0x26714560, 0x1d560296, 0x256c6c28, 0x1fc8409f, 0x25a85c24, 0x1fbd93c6, 0x2d36b9d4, 0xa9d55e6, 0x38b8}},
 /*.y =*/{/*.val =*/{0x2774299e, 0x36a1ccd2, 0x3716284a, 0x253c8efb, 0x2434597d, 0x3d58d185, 0x21ef428b, 0x29a5dbc9, 0xf9d8}}},
{/*.x =*/{/*.val =*/{0x1b720b26, 0x188bac12, 0xccfcd07, 0x3ca0d7e6, 0x39062026, 0x1aefb504, 0x168ee1f4, 0x316ba6b2, 0x3e10}},
 /*.y =*/{/*.val =*/{0x2dd92db5, 0x11ba631e, 0x3e09e433, 0x3fde6936, 0x215e28e2, 0x1996ca1c, 0x288915a8, 0x31b3ff90, 0xc735}}},
{/*.x =*/{/*.val =*/{0xc15cf94, 0x3710a097, 0x12082845, 0xff5aa0, 0x3569f8bd, 0x1bdc4615, 0xd97eb79, 0x2979dbec, 0x1dc5}},
 /*.y =*/{/*.val =*/{0x140ef8a2, 0x3e95399e, 0x25d97f94, 0xb6f12d6, 0x72d0c65, 0x1ccc46a4, 0x367d6019, 0x22b89d5f, 0x855b}}},
{/*.x =*/{/*.val =*/{0x78ee8d, 0x3c142473, 0x6919442, 0x2fc83394, 0x1b4ff64e, 0x3dc98eaa, 0x1a9be25f, 0x15eb6167, 0xd08e}},
 /*.y =*/{/*.val =*/{0x2da63e86, 0x265fd370, 0x22ed9de, 0xfbdf3e5, 0x3e6df412, 0x5cbb9d5, 0x88d72d6, 0x25e612ad, 0x852e}}},
{/*.x =*/{/*.val =*/{0xe9c22bc, 0x10eb950c, 0x1bcc42fd, 0x3699f5a4, 0x3c7be601, 0x2cd11366, 0x2eb23765, 0x33a97a67, 0x5335}},
 /*.y =*/{/*.val =*/{0xbdacb60, 0x30b099cb, 0xa1f19b3, 0x30c308db, 0xeb86ac8, 0x1fc203c3, 0x5224a06, 0x34081da7, 0x3bf8}}},
{/*.x =*/{/*.val =*/{0xff4de54, 0x2f079885, 0x1d3c2be5, 0x32af647a, 0xa2858a5, 0x100c73c5, 0x202a2c3b, 0x370d577c, 0x5716}},
 /*.y =*/{/*.val =*/{0x10100fa5, 0xfa93f55, 0x47e417d, 0x3cffb334, 0x1324c5eb, 0x2a9986a6, 0x383f391e, 0x1b100296, 0x985f}}},
{/*.x =*/{/*.val =*/{0x2336a875, 0x108cff13, 0x19d064c1, 0x3b71c748, 0x2f1b5099, 0x15be606, 0x2d4dd947, 0x16786af8, 0x24a6}},
 /*.y =*/{/*.val =*/{0x1112057c, 0x3cffa170, 0x1e0b96ab, 0x2911927a, 0x1cf34f69, 0xcc6f51f, 0x27240468, 0x2beb142f, 0xd3e1}}},
{/*.x =*/{/*.val =*/{0x761d58d, 0x12eabcce, 0xd60e2f3, 0x1326f902, 0x20df7aca, 0x9028d5c, 0x3614610a, 0x1849e08f, 0xb8c4}},
 /*.y =*/{/*.val =*/{0x1d1051a4, 0xe3a82ea, 0x2107c5b6, 0x1d411e17, 0x33c5053f, 0x1163da5f, 0xe37d14a, 0x365b145c, 0x8f9e}}},
{/*.x =*/{/*.val =*/{0x1166ff40, 0x537a868, 0x1fff36da, 0x3bafd290, 0x80a2eca, 0x20497639, 0x18d2b7c7, 0x100cc620, 0x6b00}},
 /*.y =*/{/*.val =*/{0x1d71b847, 0x2dd04c3a, 0x3f3ede9e, 0x1a20fdb9, 0xbf2f007, 0x250e8164, 0x2fac9968, 0x6ceba2a, 0x41cd}}},
{/*.x =*/{/*.val =*/{0xd6bf1f, 0x114841ae, 0x24fcbb0, 0x2f40cfa6, 0x3346b946, 0x87a49da, 0xb83ca35, 0x1cd0d147, 0xc333}},
 /*.y =*/{/*.val =*/{0x3cb01f48, 0x25796108, 0x2266162f, 0x2e8d9083, 0x2c315598, 0x3fcc6bdc, 0x12cda13d, 0x3a4e46e0, 0x2eef}}},
{/*.x =*/{/*.val =*/{0x34d9279c, 0x12d43f2a, 0x99a0075, 0x1e171e64, 0x3a845c28, 0x15c0bb20, 0x22c5776b, 0x38539f8a, 0x7121}},
 /*.y =*/{/*.val =*/{0x2f97b82e, 0x1c80a5f8, 0x1100d1ec, 0x3e8a0cd2, 0x35046e47, 0x2e865b4c, 0x105ca520, 0x30028c67, 0xf194}}},
{/*.x =*/{/*.val =*/{0x2127b756, 0x2ea1ffd, 0x3a097048, 0x10a2f92a, 0x20b41603, 0xd8b6941, 0x1f12672d, 0x1e0bdc5b, 0x6d8c}},
 /*.y =*/{/*.val =*/{0x3f172571, 0x1547dd2a, 0x17cdcca6, 0xea9b68b, 0x134daf4e, 0x26a0b4db, 0x1b911145, 0x37c225bf, 0x99ae}}},
{/*.x =*/{/*.val =*/{0x11a3c43c, 0x1312cb15, 0x2cee258e, 0x3dc072a3, 0x2e67140d, 0x307cad2a, 0x2cd5b48c, 0x36a519f2, 0x56c9}},
 /*.y =*/{/*.val =*/{0x20d7c9ed, 0x9362df4, 0x2edcaa18, 0x3503fe4c, 0xb685241, 0x31e59377, 0x39ec2f33, 0x1ab2d0b1, 0x38d4}}},
{/*.x =*/{/*.val =*/{0x2df771c8, 0x27892740, 0x2094c87b, 0x1694847b, 0x1f875033, 0xb0acf00, 0x1c9029d3, 0x151b648b, 0xb71e}},
 /*.y =*/{/*.val =*/{0x13f48c51, 0x114e89be, 0x1bba2862, 0x2f548ad5, 0x2288f426, 0x4a93333, 0x1f900789, 0x3bea33b2, 0xe7cc}}},
{/*.x =*/{/*.val =*/{0x2ee40896, 0x27f5e5b0, 0x1177f5bf, 0x2b8dea49, 0x261e6aa1, 0x1b819399, 0x36de46bb, 0x3c06c124, 0x7a0d}},
 /*.y =*/{/*.val =*/{0x44a7569, 0xb6393bc, 0x117da7f2, 0x8a28a35, 0x290e9aaa, 0x35abfd7a, 0x2fcd1b2a, 0x1d6038d5, 0xb446}}},
{/*.x =*/{/*.val =*/{0x6e1346b, 0x28661277, 0x5af1c5e, 0x2f9ec40e, 0x1152c05a, 0x31d87c53, 0x2d10be54, 0x1a3fc260, 0x690}},
 /*.y =*/{/*.val =*/{0x17226c13, 0x2ed62953, 0xc6026e7, 0x3da24e65, 0x6442aa4, 0x176caf42, 0x3de26da8, 0x38f8242f, 0xb863}}},
{/*.x =*/{/*.val =*/{0x3235c795, 0x2138aef1, 0x3d541d75, 0x362563a, 0x1c89d70b, 0x2c16cdf4, 0x3974b393, 0x11890d7b, 0x63c}},
 /*.y =*/{/*.val =*/{0x1b110258, 0x3ccb7025, 0x249a9bd3, 0x12b2eb3e, 0x1c85b69e, 0x3d98364c, 0x38404431, 0x26ee44c0, 0xe27f}}},
{/*.x =*/{/*.val =*/{0x2c1cbaab, 0x34de9fc5, 0x33d564cf, 0x32ae1e40, 0x30635c1a, 0x2adb0629, 0x16071598, 0x2ba63ecd, 0xd031}},
 /*.y =*/{/*.val =*/{0x5116b26, 0x30e411fe, 0x3d65fdc4, 0x3ed293f6, 0xb4dcf6d, 0x39301ab7, 0x584e8e6, 0x25ad3a55, 0x4151}}},
{/*.x =*/{/*.val =*/{0x1affca70, 0x3f44d85f, 0x14ce5fd1, 0x1addc21d, 0x12d1f999, 0x3565346a, 0x3861d3ff, 0x47bce91, 0xd4c0}},
 /*.y =*/{/*.val =*/{0x3d9c4777, 0x31fcb8a5, 0x256ebb09, 0xbd1ec15, 0x2b2906b2, 0x1d086400, 0x21566287, 0x12e620e9, 0x90b2}}},
{/*.x =*/{/*.val =*/{0x17592d55, 0x300d67b3, 0xe350192, 0x356e51d0, 0x3ce3b106, 0x3fbda58c, 0x1052608a, 0x31b6f128, 0x5d2e}},
 /*.y =*/{/*.val =*/{0x2f5183a7, 0x19b9743a, 0x11151742, 0xa9ef36b, 0xcd6950e, 0x1c43e89a, 0x245eb58f, 0x337e271b, 0xa92}}},
{/*.x =*/{/*.val =*/{0x255bf84c, 0x1d12e3e3, 0x30d9027a, 0x1931bb55, 0x3cae4fd9, 0x34f09488, 0x16cc8e5d, 0xa2673ae, 0x6278}},
 /*.y =*/{/*.val =*/{0x1f15fa2a, 0x3d473ead, 0x1d176ed6, 0x8379f7, 0x3267839a, 0x1525c8a5, 0x1a28901c, 0x2b290244, 0xd670}}},
{/*.x =*/{/*.val =*/{0x339715c2, 0x2651c743, 0x18a529a3, 0x19487e, 0x33fedd69, 0x7de33a8, 0x23d85b41, 0x27a23c66, 0x2f18}},
 /*.y =*/{/*.val =*/{0x171dfea, 0x1a98d611, 0x36854f06, 0xcccf8b0, 0x10f9f7eb, 0x211d7b4, 0x1d7cfdf7, 0xe7e3cf1, 0xc91a}}},
{/*.x =*/{/*.val =*/{0xa222636, 0xd7de0d8, 0x299b9d3, 0x1e81212d, 0x2f88e93a, 0x3ac63cd9, 0x8f0e572, 0x2fb8c76f, 0xe583}},
 /*.y =*/{/*.val =*/{0x36b01c43, 0x3ac98e19, 0x18800b01, 0xfa7944d, 0x1dc3ac25, 0x9d40507, 0x1ddd7416, 0x1479107b, 0x75b0}}},
{/*.x =*/{/*.val =*/{0x138011fc, 0x1c049c00, 0x17285626, 0x165a99eb, 0x200a4d83, 0x2c4cc208, 0x1eb11156, 0x4e8c205, 0x6e83}},
 /*.y =*/{/*.val =*/{0x3f15ab7d, 0x2b2da7e8, 0x1c51f9a6, 0x2be456ba, 0x1ac30426, 0x4b6c807, 0xf204c1a, 0x2062f709, 0xc147}}},
{/*.x =*/{/*.val =*/{0x195b6f7e, 0x25527d71, 0x38b2021f, 0x2ccad4f4, 0x1876cdbe, 0x14eab42, 0x1a30c83a, 0x1f474133, 0xa5ac}},
 /*.y =*/{/*.val =*/{0xab19c84, 0x236edcc2, 0x1818a484, 0x38e4583d, 0x19ee1b99, 0x30f2491f, 0xf55b36c, 0x2282ad50, 0xdf0b}}},
{/*.x =*/{/*.val =*/{0xe81c1bc, 0x24e92b93, 0x2bb5b33b, 0x14d97962, 0xce767d2, 0x2056e35a, 0x4635ad, 0x3c15197, 0x336}},
 /*.y =*/{/*.val =*/{0x166cbedd, 0x1b74a259, 0x8115017, 0x5ca3ad7, 0x30675323, 0x1a710944, 0x350014ff, 0x2d7e4315, 0x7e48}}},
{/*.x =*/{/*.val =*/{0x14bc0324, 0x2a208b00, 0x24d2cfc5, 0x21fc0a35, 0x2f119155, 0x198968d9, 0xe7c338e, 0x299908fa, 0xb96b}},
 /*.y =*/{/*.val =*/{0x36c2ee15, 0x2d3afff6, 0x25ba8374, 0x33948a51, 0x1876b383, 0x3119268a, 0x285dfbea, 0xb336cee, 0xe83c}}},
{/*.x =*/{/*.val =*/{0x30b7b678, 0x9d76cce, 0xf638166, 0xf10c46f, 0x2b6c76f1, 0x21af2909, 0x231ba19, 0x125ccd39, 0x186e}},
 /*.y =*/{/*.val =*/{0x38d91fc1, 0x1e81dbcb, 0x9535dca, 0x1dc8951, 0x37e67e11, 0x3f209702, 0x3bd84aa7, 0x18392601, 0xc0d4}}},
{/*.x =*/{/*.val =*/{0xbb9dc8f, 0x23226e1, 0x1edd333d, 0x2a7a4fbd, 0x2787d1ab, 0x3dc0d4d4, 0x26864248, 0x1073b870, 0xfd99}},
 /*.y =*/{/*.val =*/{0x259780d5, 0x10fab94f, 0x2fe938d7, 0x1cacbf7b, 0x859e678, 0x25f815e2, 0xe6f46de, 0x3b1d6f50, 0x7a41}}},
{/*.x =*/{/*.val =*/{0x3b963645, 0xfa50cb0, 0x271f1f8e, 0x336ca01f, 0x3132fb2d, 0x11e068b8, 0xa63e6e7, 0x2553ec6e, 0xc5f0}},
 /*.y =*/{/*.val =*/{0x8be2dd, 0x2fe21d3c, 0x47be4ed, 0xc140ac0, 0x20d7e6a3, 0xf2d1009, 0xb6fb18a, 0x34c4086c, 0xd552}}},
{/*.x =*/{/*.val =*/{0x3b6aa206, 0x370ed72e, 0x31c19bce, 0xd5807fd, 0x1ac744bd, 0x4e3fc55, 0x1f7d2ec7, 0x215da31f, 0x9dac}},
 /*.y =*/{/*.val =*/{0x13b30b86, 0x235f518a, 0x23ff64cc, 0x1aaae446, 0x3bde77fa, 0x90ceda, 0x37bba791, 0x32b82b93, 0xb23c}}},
{/*.x =*/{/*.val =*/{0x123809fa, 0x238ae3b7, 0x1d954be1, 0x21172cd4, 0x51f08fd, 0x24cd8fc9, 0x9f228ba, 0x76f8b94, 0x3838}},
 /*.y =*/{/*.val =*/{0x331fed52, 0x35c1d460, 0x2d8f24db, 0x207f32cc, 0xeb1cc36, 0x10169548, 0x117dcb09, 0xb4283ee, 0xe4a3}}},
{/*.x =*/{/*.val =*/{0x3663da4, 0x2059b064, 0x35d0b81f, 0x28d8a467, 0x4aa2ba5, 0x229bb5f1, 0x1705e680, 0x128d5aa9, 0x6a66}},
 /*.y =*/{/*.val =*/{0x33fc22c4, 0xa0c4fec, 0x26c04c9c, 0x2645849f, 0x3f0cd508, 0x21bb065a, 0x1e98b29f, 0x496553f, 0x449a}}},
{/*.x =*/{/*.val =*/{0x5ed815e, 0x3dc0b54, 0x1c017b47, 0x3d102af0, 0x147ad166, 0x17eb4865, 0x34a32ebb, 0x36b19e7d, 0x5568}},
 /*.y =*/{/*.val =*/{0x602df0, 0x26efd930, 0x2582151d, 0x17dfbb8, 0x73f2beb, 0x35bf8074, 0xba64580, 0x3e1d09e2, 0x7a85}}},
{/*.x =*/{/*.val =*/{0x1ee840f8, 0x105d4ebc, 0x13c98f26, 0x4070980, 0x325cbe11, 0x2752e0a5, 0x3be4ecfc, 0x16a03720, 0x8719}},
 /*.y =*/{/*.val =*/{0x27eed395, 0x8a09a41, 0xa8dfa80, 0x22709c24, 0x1a2138dd, 0x3db76d2a, 0xe3aeb15, 0x773265b, 0x603}}},
{/*.x =*/{/*.val =*/{0x2bf05bd6, 0xe67c139, 0x12a99465, 0x3d5b80c8, 0x70deca2, 0xbd47fad, 0x4fe9083, 0xc906fb9, 0x900c}},
 /*.y =*/{/*.val =*/{0x300d358b, 0x394ab4ef, 0x4efb15d, 0x2614d60f, 0xb2439d6, 0x31c8115c, 0x1f0f5f95, 0x3e7a3a2c, 0x6c31}}},
{/*.x =*/{/*.val =*/{0x272e294d, 0x39becbde, 0xd0dd5b, 0x163ae8fc, 0x37edc6f1, 0xa27abb7, 0x134b91a6, 0x39201735, 0x29df}},
 /*.y =*/{/*.val =*/{0x2c469b52, 0x104dc983, 0x129ee694, 0x3c65870e, 0x205e4dd1, 0xd39d622, 0x272e19b4, 0x3609b401, 0xbf66}}},
{/*.x =*/{/*.val =*/{0x33773f7, 0x31fc011b, 0x1b599953, 0x3513f4d1, 0x2372a150, 0x10430027, 0x1236d3e1, 0xc89bd77, 0x355b}},
 /*.y =*/{/*.val =*/{0x1887c182, 0x14f0ffc, 0xe251090, 0x977de33, 0x21fcb81e, 0x43bb774, 0x303ad49f, 0x29201c11, 0x8ec}}},
{/*.x =*/{/*.val =*/{0x141fcc76, 0x10109c92, 0x227146b3, 0x34d666d9, 0x278a558d, 0x2ca70c2, 0x2d4ad848, 0x30c91061, 0x2a1e}},
 /*.y =*/{/*.val =*/{0x2451553f, 0x2837c990, 0x382a3120, 0x1549d580, 0x3e3b61b2, 0x2fb05054, 0x1cacf4c1, 0x20b9a3d9, 0xe01e}}},
{/*.x =*/{/*.val =*/{0x2bfd913d, 0xfe5580f, 0x254c9eac, 0x29a039bb, 0x2a8d2050, 0x1e82130, 0x3ddf874d, 0xaa9fa41, 0x3636}},
 /*.y =*/{/*.val =*/{0x52e243d, 0x113e6bab, 0x2b2faafc, 0xc2ec435, 0x1a2a82d8, 0x18910dc3, 0xafd5341, 0x1e19db2e, 0x48f2}}},
{/*.x =*/{/*.val =*/{0x375732c0, 0x1661934d, 0x33777aa8, 0xbf979c8, 0x31096e20, 0x29746df2, 0x34b9b624, 0x33cc7e2d, 0x8f3c}},
 /*.y =*/{/*.val =*/{0x25b9415b, 0x1cef7979, 0x858825e, 0x39a1dd5, 0xe53d8a9, 0x3d1b665f, 0x1e53189e, 0x334f8b4e, 0x67f1}}},
{/*.x =*/{/*.val =*/{0x34889f3f, 0xa87e0e4, 0x1095da7f, 0x3faca2d1, 0x29b0ebc4, 0x28d1a6c5, 0x2119621e, 0x409bc6c, 0x8799}},
 /*.y =*/{/*.val =*/{0x3bb792b, 0x278b7e6f, 0x286037b4, 0xcbd86fc, 0x3f279de9, 0xbcb2dc5, 0x11d96213, 0x2e53296a, 0xddea}}},
{/*.x =*/{/*.val =*/{0x2fa4e07e, 0x37614061, 0x3423bec4, 0xb29d215, 0x337d9a49, 0x7040ffe, 0x35718422, 0x2be545f7, 0x37d7}},
 /*.y =*/{/*.val =*/{0x2e020165, 0x24db61da, 0x18a65a4c, 0x8faa25e, 0x19c556c4, 0xecd4b18, 0x133c8f47, 0x1ea4a06a, 0x35bc}}},
{/*.x =*/{/*.val =*/{0x3aee42db, 0x3e7f4af, 0x330714a7, 0x2eef16d1, 0x2cbfc1d9, 0x2dbb6e47, 0x19150fc7, 0x9f9f66d, 0xcc34}},
 /*.y =*/{/*.val =*/{0x15d87bdb, 0x188a7004, 0x272422dc, 0x3972eb63, 0x21520010, 0x38ff4fec, 0x1c6a1885, 0x26106948, 0xea24}}},
{/*.x =*/{/*.val =*/{0x2e96e4f1, 0x2c29c594, 0x2e80030c, 0x17c05802, 0x1efccaff, 0x1ddc20cd, 0x197e201, 0x523c066, 0x56bb}},
 /*.y =*/{/*.val =*/{0x2eb0582e, 0x2227c067, 0x4af0eb5, 0x4f47480, 0x30ea9f73, 0xfb62f8, 0xa33beb, 0x2129584c, 0xa095}}},
{/*.x =*/{/*.val =*/{0x1f23d1f, 0x1315fd66, 0xc036d8a, 0x2c97f5c8, 0x18a0a6b6, 0x3522787f, 0x30bbbbd3, 0x3a054f59, 0xb398}},
 /*.y =*/{/*.val =*/{0x32ff3fc, 0x160faffe, 0x26156cd1, 0x1e4762b4, 0xba52ea, 0x1ffacbec, 0x1f47f07f, 0x270895cb, 0x69f5}}},
{/*.x =*/{/*.val =*/{0x34fb6a39, 0x9f576c6, 0x2ac90ecd, 0x235ab493, 0x1e119b8b, 0x3f4a59c, 0x1ea6e43e, 0x25abd5e5, 0x459}},
 /*.y =*/{/*.val =*/{0x725bb62, 0x30ab6de8, 0x20010535, 0x388a2d03, 0x2eef0373, 0x218a0837, 0x26c33672, 0x2b8338e0, 0xd3f9}}},
{/*.x =*/{/*.val =*/{0x319888e9, 0xe73c9e4, 0x2448a8b4, 0x4ae9afc, 0x2681673d, 0x1834c0a5, 0x3a6e2dde, 0x3a9dceb0, 0x1f90}},
 /*.y =*/{/*.val =*/{0x2f113b79, 0x1bf7f25f, 0x19522e65, 0xdd47fb9, 0x2b96a821, 0x54f49c7, 0x2a10e958, 0xd9f0576, 0x89be}}},
{/*.x =*/{/*.val =*/{0x1bf6c42, 0xfaacf77, 0x19887539, 0x1e4f66c4, 0xee74ef7, 0x1195205b, 0x105c7ee7, 0x6cf35b0, 0xd02e}},
 /*.y =*/{/*.val =*/{0x7bc54cc, 0xcd8ca3e, 0x31b6aac1, 0x2961e6e4, 0x124526bc, 0xc89c343, 0x22258127, 0x1d3cf2a3, 0x9a0b}}},
{/*.x =*/{/*.val =*/{0xf6c15c2, 0x7bd1fc6, 0xf38f1ca, 0x39d90532, 0x1143483d, 0x1ce604e7, 0x1757fea1, 0x2a14af28, 0x8456}},
 /*.y =*/{/*.val =*/{0xb174134, 0x3c7bf0ca, 0x16fb671f, 0x3243c261, 0x79e7f4c, 0x127b0dc4, 0x2cdefd3, 0x3691b521, 0xe1b9}}},
{/*.x =*/{/*.val =*/{0x27df614a, 0x1d47ebb3, 0x24705eb2, 0x27f39a4c, 0x3e1804d7, 0x91aa7fa, 0x33049180, 0x3966340b, 0xa7d2}},
 /*.y =*/{/*.val =*/{0x159b4c8d, 0x3c32f0e5, 0x19bc8656, 0x3c01de54, 0x3fa2de53, 0x207bb042, 0x10172c79, 0x33512f0, 0x62a2}}},
{/*.x =*/{/*.val =*/{0xca1c4f9, 0x16d0aa86, 0x2b7e2823, 0x13bf8d32, 0x1f16f44f, 0x2e0f698, 0x1728c4c4, 0x3de3c8af, 0x7815}},
 /*.y =*/{/*.val =*/{0x3778bc15, 0x2ac7a8da, 0x177d1e19, 0x2d0b7985, 0x18c35d5c, 0x24f3cc51, 0x1af6a7dd, 0x7a334e, 0xc1c6}}},
{/*.x =*/{/*.val =*/{0x3ed5996, 0x37933a2d, 0x360af53b, 0xc7f9664, 0x1b92468, 0x3ef240ca, 0x1a4ea492, 0x2dfa7fa6, 0x1a46}},
 /*.y =*/{/*.val =*/{0x28c85cae, 0x3b93b447, 0x352745c2, 0x21e52a7b, 0x23ebf550, 0x3b821281, 0x1dc570e3, 0x3a07a8fc, 0x683c}}},
{/*.x =*/{/*.val =*/{0x2e2e607b, 0x3d34d673, 0xf36aa1, 0x2a87bb1b, 0x3fdd2b88, 0x447d595, 0x1772c20d, 0xfd9ff4c, 0x773}},
 /*.y =*/{/*.val =*/{0xc614763, 0x28bcc477, 0x3e017d26, 0x38ef7816, 0x3156f489, 0x18ea316e, 0x38285eae, 0x3a3eeb05, 0xfd9f}}},
{/*.x =*/{/*.val =*/{0x354d61d1, 0x3ecb8807, 0x30b99baf, 0x549d76f, 0x1bf21517, 0x23e67901, 0x3ed8b9c5, 0x4f91d89, 0x875e}},
 /*.y =*/{/*.val =*/{0x945747, 0x12a27470, 0x273c5309, 0x277543a5, 0x399e3601, 0x1b784f4d, 0x56e8f64, 0x37712a59, 0x2d8f}}},
{/*.x =*/{/*.val =*/{0x2fd53ed3, 0x17245d60, 0x1a56ccef, 0xfdd3ee7, 0x1f7c4916, 0x3d82e4c7, 0x372ad5b8, 0x2f56659, 0x2084}},
 /*.y =*/{/*.val =*/{0x1a7a7132, 0x1c50ff94, 0xe708998, 0x21f11ce5, 0x3afac254, 0x2f51da9a, 0x18243487, 0xd25f3b0, 0xf299}}},
{/*.x =*/{/*.val =*/{0x2032f9a2, 0x122e38a4, 0x21fc6ccc, 0x159bd43e, 0x3f8f63ce, 0xdd32cc7, 0x32640ed2, 0x31af669a, 0x25aa}},
 /*.y =*/{/*.val =*/{0x2b51d4f0, 0x1d88c284, 0x19f3d9e, 0x2620eef1, 0x3190f655, 0xcbd53d3, 0x546c16f, 0x318ee991, 0xf5a6}}},
{/*.x =*/{/*.val =*/{0x14445a7a, 0x4c72ea, 0x1cf1ec59, 0x254d7c20, 0x1c8d5df, 0x3c46db18, 0x2c6bfb12, 0x3bef27c1, 0xf82f}},
 /*.y =*/{/*.val =*/{0x242a7a98, 0x18eb3861, 0x240d1e59, 0x720ed91, 0xb4a4b5, 0xe50b065, 0x36b67550, 0xdef71be, 0x94bb}}},
{/*.x =*/{/*.val =*/{0x362b8df9, 0xcb7ede8, 0x1da21c57, 0x7f6d47d, 0x11c8bd49, 0xcb74b72, 0x1c0cd9a8, 0x37634fb7, 0x11c4}},
 /*.y =*/{/*.val =*/{0x296edd30, 0x60c9e79, 0x2ec5448f, 0x2df9f498, 0x10fb6417, 0xd810e22, 0xac2aae4, 0x361da2fd, 0x45b3}}},
{/*.x =*/{/*.val =*/{0x1def001d, 0x13c89769, 0x9ba27ef, 0x3e6ef5a6, 0x23b64b21, 0x2f47027, 0x22caf20e, 0x28cb6c9f, 0xa549}},
 /*.y =*/{/*.val =*/{0x30624783, 0x3576c69f, 0x2c9705ad, 0x5078a98, 0x259456eb, 0x330c3b62, 0x166cbdf4, 0x1e9e41b6, 0x799b}}},
{/*.x =*/{/*.val =*/{0x206e37a, 0x91de2b1, 0x504731a, 0x23062523, 0x1a274f4d, 0x3a0fd1ad, 0x28002cf4, 0x2ae1fca1, 0xb526}},
 /*.y =*/{/*.val =*/{0x30c5ccab, 0x3cd9e3ff, 0xfa392ab, 0x3394e6c0, 0x26f18d28, 0x2ab3b582, 0xd8ed5c, 0xd75de04, 0x641f}}},
{/*.x =*/{/*.val =*/{0x39d9123f, 0x3a4e0c7a, 0x388ba7d7, 0x3f1e46c7, 0x3d1e9129, 0x17e3b2be, 0x26a6f2f9, 0x14e3dcaa, 0x341b}},
 /*.y =*/{/*.val =*/{0x18bb9a40, 0x27a82abc, 0x12a26ed1, 0x37b9a9c1, 0x24d9ac72, 0x3cbc1044, 0x1c59eba6, 0x491c670, 0x5858}}},
{/*.x =*/{/*.val =*/{0x760cb4d, 0x25763239, 0x33a69b68, 0x21f81500, 0x30673803, 0x154bafb0, 0x9df521a, 0x1fb94e37, 0xbca3}},
 /*.y =*/{/*.val =*/{0x24e10d88, 0x29dc18da, 0x8df9cf3, 0x5d5563c, 0x2ffbad9f, 0x22e020ee, 0x2d4b2263, 0xec707ef, 0x3ce0}}},
{/*.x =*/{/*.val =*/{0xfb64db3, 0x1ee6354e, 0x1dd53841, 0x3b79328e, 0x13b8d6a7, 0x2ee0fef9, 0x1ccb740b, 0x8e48a6f, 0xc114}},
 /*.y =*/{/*.val =*/{0x3c0259be, 0x8c33a7f, 0x14567d1e, 0x1d602413, 0x178bd1a8, 0x3b3793fa, 0x6fc2a5c, 0x3db716d2, 0x1237}}},
{/*.x =*/{/*.val =*/{0x311349e2, 0x20cab77, 0x3524c058, 0x38fb3d05, 0x1ad78d60, 0x51fa690, 0x1c2e7e62, 0x20c931ae, 0xf805}},
 /*.y =*/{/*.val =*/{0x1b2025fc, 0x3eb11a79, 0x26de88d5, 0x25262d58, 0x21122350, 0x206a983a, 0x56cdcde, 0x39682a2, 0x95c6}}},
{/*.x =*/{/*.val =*/{0x2e548418, 0x1cdc7446, 0x9839231, 0x39221f62, 0x3a341adc, 0x1cac14d, 0x17e292fb, 0x2c327920, 0x2e6d}},
 /*.y =*/{/*.val =*/{0x10a2b918, 0x1a5e4b00, 0x1c3f5f1e, 0x23875cf8, 0x2911644b, 0xc5225e2, 0x36fbfa21, 0x1a90475d, 0x74eb}}},
{/*.x =*/{/*.val =*/{0x3ccbdf95, 0x2b8fa3b1, 0xa5853b4, 0x8ac7291, 0x22f5494, 0x360c0ab2, 0x313050f, 0xbb60387, 0xcea0}},
 /*.y =*/{/*.val =*/{0x324a006c, 0x39954baa, 0x2ecc53d9, 0x2e8a1483, 0x10b433b2, 0x3301f5b, 0x34a6f04e, 0x1b1b61df, 0xfc00}}},
{/*.x =*/{/*.val =*/{0x171c032b, 0x3536858a, 0x3afdc980, 0x1ad9a285, 0x766c5ff, 0x46d7f7f, 0x2603dd, 0x2a3f35b8, 0x71eb}},
 /*.y =*/{/*.val =*/{0x1668359f, 0x1ead6a38, 0x34b4755e, 0x24c6b45d, 0xcbb7f71, 0x18145bd5, 0x1d39def6, 0x49892d8, 0xd2ff}}},
{/*.x =*/{/*.val =*/{0x3aaa138b, 0x37c367dc, 0x3786cd66, 0x3bee82fb, 0x671ff63, 0xfaf0631, 0x3ae28794, 0x389274f0, 0x417f}},
 /*.y =*/{/*.val =*/{0xa1ae869, 0x7246ccd, 0x5566afd, 0x276bf7b0, 0x3a9e57c1, 0x2974a7c3, 0x23e38c20, 0x2275ef34, 0x235}}},
{/*.x =*/{/*.val =*/{0x307e636, 0x38562d04, 0x21611d97, 0x29df79cc, 0x2112c8b4, 0x2f0a6f68, 0x76443dd, 0x3c58058e, 0x2219}},
 /*.y =*/{/*.val =*/{0x31f15109, 0x1e86cb5, 0x373af55e, 0x35c8c34f, 0x230bd6d, 0x1b53c6e, 0x2a2f61b8, 0x212b172d, 0x4a9}}},
{/*.x =*/{/*.val =*/{0x377220dc, 0x14ca7db7, 0x16023891, 0x27c96229, 0xe83bbd4, 0x27b40409, 0x2a8ad6a5, 0x3e507c9e, 0xffb2}},
 /*.y =*/{/*.val =*/{0x1b32b3bc, 0x26083b0c, 0x35e5f9f3, 0x3948efcf, 0x59d2f2c, 0x3e5e242, 0x3be7a03c, 0x34ffe08a, 0xf97e}}},
{/*.x =*/{/*.val =*/{0xd9ed6c1, 0x1a2bad63, 0x3d593d6b, 0x139d16f0, 0x1edd0ec2, 0x3f061dc1, 0xf53e80b, 0xcdb72dd, 0x328}},
 /*.y =*/{/*.val =*/{0x38fafeee, 0x3b1baf9b, 0x1cb494ad, 0x16fd37c9, 0xd7c8c26, 0x35650e88, 0x19f28c46, 0x260e04bf, 0x71a8}}},
{/*.x =*/{/*.val =*/{0x26da57e4, 0x2dd59229, 0x1cdd9f86, 0x31265bbf, 0x31bc1e98, 0x3a8a9d18, 0x118b9dbd, 0x36b8e60e, 0x690c}},
 /*.y =*/{/*.val =*/{0x133f33bb, 0x2d8656d2, 0x295a3d42, 0x18f63ef3, 0x15894df8, 0x3f646fd6, 0x379a47a9, 0x371e59de, 0x840a}}},
{/*.x =*/{/*.val =*/{0x1cfb8036, 0x3e6262a9, 0xda35085, 0x3426a4b0, 0x167e833a, 0x45f747f, 0x247b48ae, 0x9d47ec5, 0xcff6}},
 /*.y =*/{/*.val =*/{0x24f59de0, 0x10fced68, 0x20328258, 0x2962763d, 0x2143c678, 0x38d2d621, 0x2d1ac5f, 0x3b49af55, 0xcdf4}}},
{/*.x =*/{/*.val =*/{0x20ebec47, 0x1da4a12b, 0x142ca23d, 0x381398c4, 0x3b4ea72e, 0x10de9936, 0x27df9761, 0xe5dc744, 0xe8b6}},
 /*.y =*/{/*.val =*/{0x2eb3d8a7, 0x32a7875c, 0x15fe035, 0x398b696, 0x3ff204be, 0x6555e5f, 0x32e11ae7, 0xb7e8107, 0x5f38}}},
{/*.x =*/{/*.val =*/{0x3319c869, 0x3df1bab8, 0x21eb2702, 0x2a7e575d, 0xcacdc18, 0x20e408bf, 0x33fc8d01, 0x1176605, 0x3018}},
 /*.y =*/{/*.val =*/{0x12b856f0, 0x3031db27, 0x23d9a7bf, 0xaa13292, 0x222e3bca, 0x1890c835, 0x3b7b6f86, 0x315e0940, 0xac5f}}},
{/*.x =*/{/*.val =*/{0x18953133, 0x11df726c, 0x8721ae6, 0x2ced0a9d, 0xcdfa97f, 0xa01b03f, 0x1dd23881, 0xad3fb43, 0xa0b}},
 /*.y =*/{/*.val =*/{0x34af0fc9, 0x2f0928dc, 0xed4ba94, 0x28e13a2c, 0x58c8d6f, 0x71b2a19, 0x2bf2f03c, 0x60b3ed6, 0xcda1}}},
{/*.x =*/{/*.val =*/{0x1f0a2a53, 0x3abc3b03, 0x16611e7, 0x772acfe, 0x29b892d5, 0xe515d0e, 0x3997c3a8, 0x146341f0, 0x6f86}},
 /*.y =*/{/*.val =*/{0x333bfeb2, 0x4e695d1, 0x2a05f351, 0x153ddcba, 0x309968bf, 0x1dbaa569, 0x182f29b7, 0x3d85bf51, 0xd50a}}},
{/*.x =*/{/*.val =*/{0x278b4a0d, 0x1e78672f, 0x8c9be06, 0x3ed83c9f, 0x1c73ace4, 0xf5d6ed2, 0x3db4e1cb, 0x10bae9a8, 0x2f98}},
 /*.y =*/{/*.val =*/{0x33f39758, 0xd4cafba, 0x3d54f320, 0x23bab9da, 0xbb8f48b, 0x32489c59, 0x355552a1, 0x35a4c2f7, 0x4774}}},
{/*.x =*/{/*.val =*/{0x3874b839, 0x444a1d5, 0x13d2b418, 0x10456ce5, 0x30b6aebe, 0x37c37ec8, 0x1e5a8053, 0x2e07f038, 0x3e03}},
 /*.y =*/{/*.val =*/{0x3c0594ba, 0x3073959, 0x1ab5b8da, 0x39717c3f, 0x198f667d, 0x3d981d5c, 0x7f42c44, 0x3858f7fc, 0xd13a}}},
{/*.x =*/{/*.val =*/{0x39a7d197, 0x2eba434e, 0xea59459, 0x20ea3062, 0x2c234b5e, 0x23ff8288, 0x1f639477, 0x22950a03, 0xc2c5}},
 /*.y =*/{/*.val =*/{0x9eeb5e9, 0x390732fe, 0x1ad82484, 0x11fb1151, 0x2d39a60a, 0x106ad8b, 0x20927573, 0xca20d9b, 0x72ea}}},
{/*.x =*/{/*.val =*/{0x23369217, 0x1d379b65, 0x6611ead, 0x70e5a40, 0x4eacdca, 0x289e3d50, 0xd624a21, 0x143ff2e9, 0x42dc}},
 /*.y =*/{/*.val =*/{0x3e2dbc57, 0x30c25f88, 0xe01e841, 0x284e7b2a, 0xba853a7, 0x1e3d7c58, 0x5b1d7ed, 0x2687d98e, 0xa5ba}}},
{/*.x =*/{/*.val =*/{0x19251fa2, 0x1e7e8b49, 0x3c26cc92, 0x337ea0ae, 0x13d5e1bb, 0x1d1678dc, 0x1a1202b0, 0x31d972a4, 0x417}},
 /*.y =*/{/*.val =*/{0x3ebc52fa, 0x24c1240a, 0x161ee899, 0x292c61dd, 0x6283ad9, 0x1a19d99f, 0x357f5349, 0x397544b1, 0x72d7}}},
{/*.x =*/{/*.val =*/{0x2cde4cf3, 0x26554187, 0x38a066ab, 0x10394d51, 0x1d9ae793, 0x30b49b45, 0x22c3be7, 0x2ad2b045, 0x384d}},
 /*.y =*/{/*.val =*/{0x252d0566, 0x1f1e5ac8, 0x351ba73b, 0x10c28ce5, 0x34c6f01f, 0x13b5b68a, 0x1ca43bfb, 0x316f346e, 0xd6e3}}},
{/*.x =*/{/*.val =*/{0xa972627, 0x290d9a82, 0x2521e1f8, 0x24858100, 0x441a0e1, 0x2307bf2f, 0x3e15c819, 0x21c2526f, 0x8a31}},
 /*.y =*/{/*.val =*/{0x6bb8af9, 0x1ed1ed59, 0x3efcbcce, 0x110d96b0, 0x7baa417, 0x1dfb4a16, 0x3a64d095, 0x1f21da3d, 0x64bb}}},
{/*.x =*/{/*.val =*/{0xa3a1550, 0x2951319f, 0x2ffdf279, 0x76a67e3, 0x38b75180, 0xc25db87, 0x157412dd, 0x1a6acd01, 0xebfc}},
 /*.y =*/{/*.val =*/{0x1362f6e, 0x7d0afd9, 0x28c0b195, 0x20f20639, 0x34fd0779, 0x3c6676df, 0xb540a3d, 0x3a336e67, 0xe2ff}}},
{/*.x =*/{/*.val =*/{0x14f24bf1, 0x3e2ba88c, 0x2c500d25, 0x15500782, 0xe78708e, 0x1cdd2f0d, 0x2d024ec7, 0xeaf6dad, 0x6299}},
 /*.y =*/{/*.val =*/{0x108d1b1d, 0x34eb50c5, 0x148c6775, 0x24d4c0b2, 0x3c429b1d, 0x34b2bf8c, 0x29b93a00, 0x1cac2bab, 0x86fb}}},
{/*.x =*/{/*.val =*/{0x39d681f9, 0x164153f9, 0x8feb9fc, 0x3383bbeb, 0x2c94b066, 0x1ffc9780, 0x3230888b, 0x3f7c9dd7, 0xc745}},
 /*.y =*/{/*.val =*/{0x3bbb1247, 0xc5cd0d, 0x27d45c76, 0x36f4cd71, 0x2818678c, 0x4e531c3, 0x1e5e78a7, 0x8bcbdae, 0x5902}}},
{/*.x =*/{/*.val =*/{0x249a2115, 0x1dff54d1, 0x3a565ebe, 0x1e580245, 0x981aec, 0x1ab2a759, 0xc6c6dd4, 0x3014ac65, 0xfd73}},
 /*.y =*/{/*.val =*/{0x26ba6cda, 0x1272adee, 0x29d421f0, 0x3d80558b, 0x37d6d904, 0x2aeac09b, 0x38844020, 0x1a307205, 0x6207}}},
{/*.x =*/{/*.val =*/{0x1b816b2f, 0x36e1b0d4, 0x228ee11f, 0x32de104, 0x2c5d5dee, 0x597f849, 0x11a676e8, 0x11b75965, 0x5a4d}},
 /*.y =*/{/*.val =*/{0x33e86c60, 0x3e5ebae1, 0x33ecceba, 0x39b317e, 0x3dfcd6b5, 0xf89fe3c, 0x260ab028, 0x8e5b283, 0x77c9}}},
{/*.x =*/{/*.val =*/{0x31ce59e7, 0x110131b, 0x2d9919f3, 0x1db4e753, 0x324e6906, 0x359f05b6, 0x1f964c25, 0xbde79a8, 0x1bbc}},
 /*.y =*/{/*.val =*/{0x379aa297, 0x14c8648, 0x3839618d, 0x2265bd03, 0x1bc5a36c, 0x36c5beb4, 0x1f1a8781, 0x32d32375, 0x281f}}},
{/*.x =*/{/*.val =*/{0x3bb80fa7, 0xd12172c, 0x30413886, 0x29f69aed, 0x20819f3a, 0x681af4c, 0xc2fbc0d, 0x38c7d8c2, 0x857}},
 /*.y =*/{/*.val =*/{0x9366b2d, 0x3660847c, 0xd7016ab, 0xb8dc10f, 0xb714717, 0x1f327477, 0x172092d, 0x24d08eb8, 0xf643}}},
{/*.x =*/{/*.val =*/{0x3b6d6cd3, 0xe802af9, 0x38937883, 0x5984740, 0x25239734, 0x1a6e1c15, 0x3818481a, 0x19859fca, 0xea12}},
 /*.y =*/{/*.val =*/{0x34f450be, 0x2b98a497, 0x3be1a88a, 0x325d4b7a, 0x145e25b1, 0x3844afc4, 0x2e3fdaac, 0x38b941e3, 0x21a4}}},
{/*.x =*/{/*.val =*/{0x1cff55c5, 0x1c48f509, 0x2275ec97, 0x13bf4a06, 0x2b4b635f, 0x4b079e0, 0x1442ca6c, 0x2b7f7ec9, 0xcf36}},
 /*.y =*/{/*.val =*/{0x21a0228e, 0x3289e214, 0xd2706a, 0x151fb097, 0x19f207a7, 0xbd62cef, 0x768649c, 0x4859ab8, 0xd16a}}},
{/*.x =*/{/*.val =*/{0x125cb53b, 0x17a9e02b, 0x365eb3d0, 0x23f15763, 0x6272dab, 0x994c755, 0x25414494, 0x728acf7, 0xf474}},
 /*.y =*/{/*.val =*/{0x295a4b7e, 0x39769e65, 0x1f86e5c1, 0x5aa3ad, 0x2c8f9c0d, 0x3ec3609e, 0x1f2f01c8, 0x1bd03c89, 0xc48d}}},
{/*.x =*/{/*.val =*/{0x3f2e070d, 0x160ff4e8, 0x12a6a98f, 0x2aadc731, 0x1047e229, 0x1cc70ee1, 0x34abff48, 0x297a410b, 0x4b72}},
 /*.y =*/{/*.val =*/{0x296dd780, 0x112ea0bb, 0x2948c3de, 0x2d197774, 0xf3c10b0, 0x1deecdb4, 0x2e1cf602, 0x753875a, 0x599e}}},
{/*.x =*/{/*.val =*/{0x385912ec, 0xa1c0283, 0x6091134, 0x3e728139, 0x2f054327, 0x1265a52a, 0x35b786ab, 0x87538fe, 0xaa71}},
 /*.y =*/{/*.val =*/{0xae35978, 0x4532c99, 0x2056cbdb, 0x384d2a33, 0x22edebfe, 0x1499ae5a, 0x9509c50, 0x3c1df6b4, 0xc690}}},
{/*.x =*/{/*.val =*/{0x3fd292dc, 0x2e01a893, 0x17714ce1, 0x1789a02c, 0x3d79d977, 0x201c34de, 0xf934ba4, 0x554cdc8, 0x4b99}},
 /*.y =*/{/*.val =*/{0x17095ca6, 0xce97ff9, 0x3376afd4, 0x20c8f116, 0x301f5793, 0x3029d2d7, 0x3a226df, 0x1d525844, 0xe327}}},
{/*.x =*/{/*.val =*/{0x384da233, 0x2a560e3a, 0x1f362cd4, 0x13c36a04, 0x336ed9cf, 0x26f4ce3f, 0x25316a20, 0x32d365c7, 0x1eb7}},
 /*.y =*/{/*.val =*/{0x17c43f18, 0x2e3a954c, 0x1cf0ae9c, 0xdb26660, 0x1ed0aba3, 0x3cef342f, 0x84ff826, 0xca2b91f, 0xd984}}},
{/*.x =*/{/*.val =*/{0x3bea0c68, 0x321042bc, 0x37b392b5, 0x10c048d9, 0x396faf09, 0x26f23a34, 0x2a3a2494, 0x258d3855, 0x3e41}},
 /*.y =*/{/*.val =*/{0x1a45edb6, 0x32edbfdc, 0x3cda1ab, 0x2846518c, 0x693062f, 0xf2ff8dc, 0x321f7f37, 0x31676492, 0x123}}},
{/*.x =*/{/*.val =*/{0x17d4b84a, 0x2a605310, 0x1f433e69, 0x777d23c, 0x5070462, 0xa924b4a, 0x32fcb0c6, 0x26796371, 0xf13a}},
 /*.y =*/{/*.val =*/{0x13fd1c81, 0x16643f15, 0xf2d9628, 0x38df51c4, 0x3fe06eb6, 0x2e473478, 0x3e995aa6, 0x323343c2, 0x33c2}}},
{/*.x =*/{/*.val =*/{0xe735a1e, 0x3c30ec51, 0x3e61fa05, 0xf8259a, 0x1202fc40, 0x23376b58, 0x356cb46b, 0x31f01e66, 0x678a}},
 /*.y =*/{/*.val =*/{0x12f7c055, 0xd8e97dc, 0x1371457a, 0x1fffeccf, 0x105e8e59, 0x3fcf55c, 0x1285b7a7, 0x138cf669, 0x851}}},
{/*.x =*/{/*.val =*/{0x14c426d5, 0x30e07974, 0x22adf265, 0x29543e1e, 0x1fa93ab7, 0x1210c7e3, 0x2b66bd4c, 0x1d467823, 0x364c}},
 /*.y =*/{/*.val =*/{0x1a5876c0, 0x21b51ca9, 0x7db7191, 0x231357c5, 0x2d95be16, 0x2c62c634, 0x1fa52f1e, 0x2d65d0b2, 0xfaa8}}},
{/*.x =*/{/*.val =*/{0x12fea1f9, 0x2c5f2ef1, 0x452b94, 0x3fc2d423, 0x106531c4, 0x3f76ad9c, 0x1f2e83bc, 0x22029574, 0xa6dc}},
 /*.y =*/{/*.val =*/{0x3bc345e9, 0x2c705391, 0x268f7e63, 0x1ee276df, 0x2cbc5005, 0x1a0e845a, 0x367c3038, 0x2a151f70, 0x7ef1}}},
{/*.x =*/{/*.val =*/{0x1c7985c4, 0x2d84f9dc, 0x39e2b108, 0x12ff1256, 0x374c3413, 0xa10a00b, 0x19b7ce54, 0x2d72bded, 0x2320}},
 /*.y =*/{/*.val =*/{0xc2c6d44, 0x3fd3c77d, 0xd9eb8d4, 0x1bc40847, 0x1bca93d9, 0x1c86e07e, 0x3e94318c, 0x250f7222, 0xc79f}}},
{/*.x =*/{/*.val =*/{0xa3a809c, 0x27f82c2f, 0x398346d7, 0x2d98bd75, 0x14a89eda, 0x33e5f909, 0x3df56bfb, 0x1fb20e4c, 0x125e}},
 /*.y =*/{/*.val =*/{0x149e70d9, 0x2a32402a, 0x7fca3dd, 0x138ecbbc, 0x321a371e, 0x1d1f2bd5, 0xcb38887, 0x3dbb7895, 0xe0d3}}},
{/*.x =*/{/*.val =*/{0x208a7b1f, 0x3215fe35, 0x2a1ee514, 0x162bea6d, 0x3bc587f7, 0x141eb357, 0x37eb0079, 0x20efd263, 0x5ac}},
 /*.y =*/{/*.val =*/{0x165ccb98, 0x2198dd7e, 0x75d0f82, 0x3bc0ecc4, 0x2ac6f5b3, 0x33d08917, 0x2e6fb0fa, 0x271b3dd5, 0xe379}}},
{/*.x =*/{/*.val =*/{0x27315443, 0x364e1ce0, 0x2e867299, 0x1e6ef552, 0x2142a13d, 0x32266082, 0x935ff42, 0x1b010198, 0xfc69}},
 /*.y =*/{/*.val =*/{0x17d28960, 0x1243582d, 0x9bd1b17, 0x1ffd2184, 0x1677b548, 0x387375a, 0x35892bbf, 0x9fafe0e, 0xe0ce}}},
{/*.x =*/{/*.val =*/{0x3c6b5b56, 0x3cd857f5, 0x1888b607, 0x21722abb, 0x3200e541, 0x161fb4ef, 0x34338cdf, 0x2195c03b, 0xa0e8}},
 /*.y =*/{/*.val =*/{0x3a1d7518, 0x5af7944, 0x858a51a, 0x1ae1c75c, 0x13dead52, 0x29ae26e1, 0x1ad50b99, 0x11a0e7ea, 0xf5ba}}},
{/*.x =*/{/*.val =*/{0x10cedd26, 0x35d977dd, 0x25715541, 0x322e677a, 0x239e2a3c, 0x360403e5, 0x1ebb2611, 0x120dca58, 0xaf88}},
 /*.y =*/{/*.val =*/{0x30e43f7f, 0x2db9eb4e, 0x3aa41708, 0x15279219, 0x2d2f9654, 0x32ee23af, 0x27030d28, 0x3efe5ec5, 0xdc57}}},
{/*.x =*/{/*.val =*/{0x10b36a01, 0x1d9fddfc, 0x320812b5, 0x11e9ec5f, 0x2ec63cfc, 0x39ea5901, 0x3177a68a, 0x25375386, 0x853c}},
 /*.y =*/{/*.val =*/{0x27fe4ebe, 0x1f971fa3, 0x72f4fcc, 0x2fe60a00, 0x25123a28, 0x274080f7, 0x1b19530e, 0x33a53b26, 0xa328}}},
{/*.x =*/{/*.val =*/{0x11da5e12, 0x7b838ce, 0x1cacb297, 0x31829005, 0x1ca2b6a9, 0xca7e4e8, 0x1e31bcda, 0xb8f10de, 0xf750}},
 /*.y =*/{/*.val =*/{0x385f4eb, 0x292e717a, 0x325cebc7, 0x21b4cbbd, 0x1672047b, 0x1c25170f, 0xfafd599, 0x3d7b759f, 0x3c57}}},
{/*.x =*/{/*.val =*/{0x3e32478e, 0xdcc481c, 0x29ba7ed2, 0x2acc63ca, 0x332b2024, 0x31adfcfc, 0x213880fe, 0x4758041, 0xd420}},
 /*.y =*/{/*.val =*/{0x104e88d4, 0x33815a07, 0x1508cc31, 0x2c92cbcd, 0x3f847b6f, 0x357d7d12, 0x14e0c1b2, 0x353a68df, 0xbae5}}},
{/*.x =*/{/*.val =*/{0x216ddcd3, 0x1a9c8dee, 0x1ea00355, 0x12c44008, 0x761af04, 0x16fadb2e, 0x299edf7b, 0x2b4dbd93, 0x1ae1}},
 /*.y =*/{/*.val =*/{0x2e7eb2b7, 0x33118674, 0xbb613c7, 0x185ab77f, 0x10448959, 0x1d3ddd48, 0x922059c, 0x15261e8, 0x7016}}},
{/*.x =*/{/*.val =*/{0x19158bab, 0x264fc10e, 0x12d06caa, 0x4c9b0c6, 0x5a0674c, 0x1f3cf7cb, 0x39b3c419, 0x3d2ec203, 0xe2c6}},
 /*.y =*/{/*.val =*/{0x2d7a27f2, 0x214f3c9e, 0x49fd3f5, 0x6d622e4, 0x3ef5c641, 0xaecd847, 0xb1eabd1, 0x1e18b4f0, 0xfa92}}},
{/*.x =*/{/*.val =*/{0x3a95a8db, 0x1761dccb, 0x39d36f61, 0xfb03111, 0x1b1723b8, 0x25991a64, 0x3dd0419e, 0x36918c0, 0xe3e9}},
 /*.y =*/{/*.val =*/{0x1b0d1cf9, 0x5b3dfc, 0x984d3d1, 0x2c7be5f3, 0x2e76afb, 0x3eaa431c, 0x178bb00, 0xef0015b, 0xfbe5}}},
{/*.x =*/{/*.val =*/{0x141d0ce6, 0x13f0f72d, 0x3598d41f, 0x2264a8b3, 0x205fb274, 0x53338ce, 0x1a9412ee, 0x168a4dfc, 0x1429}},
 /*.y =*/{/*.val =*/{0x1738bb86, 0xaa06a2b, 0x35d241a5, 0x2255806, 0x83b131, 0xc711211, 0x150711b0, 0x14d8f7c4, 0xfea7}}},
{/*.x =*/{/*.val =*/{0xb344f7f, 0x1c633e71, 0xce60c4c, 0x22e27f52, 0x26d410ee, 0x1f8cb2f4, 0x2e0ae0e9, 0x3212f65c, 0x354c}},
 /*.y =*/{/*.val =*/{0x25db82d6, 0x392c46ba, 0x202e0ec7, 0xdb18061, 0x3a88558e, 0x2d24fe6, 0x6b5d675, 0x2fca4a47, 0x9c04}}},
{/*.x =*/{/*.val =*/{0x1983ce4e, 0x2ecf54dc, 0x1578253f, 0x40f6279, 0x23024a60, 0xeee0d6a, 0x35975f0e, 0x3da7674c, 0x8704}},
 /*.y =*/{/*.val =*/{0x16572c0a, 0x1c256368, 0x302df498, 0x16e840b8, 0x296bac34, 0x231d35d6, 0x2ec26a3, 0x14817389, 0x6b0b}}},
{/*.x =*/{/*.val =*/{0x3a3979b5, 0xa8666c2, 0x27e829e2, 0xa23e379, 0x240e50ba, 0xdfc2c7b, 0x1e26327f, 0x1f1736b, 0xae22}},
 /*.y =*/{/*.val =*/{0x450fa6f, 0x23cf359a, 0x3d4f8896, 0x2a1edf4d, 0x2d7060fc, 0x3249148e, 0x39f71ad4, 0x3f944301, 0xea91}}},
{/*.x =*/{/*.val =*/{0x2ce4dd6a, 0x16784787, 0x3221cef5, 0x392728, 0x164c460a, 0x3b28dfa3, 0x12b64bc9, 0x393dec9e, 0x49db}},
 /*.y =*/{/*.val =*/{0x2a9e3eae, 0x4edca90, 0x205bb69b, 0xe154bf2, 0x12255a1c, 0x3f8cf6da, 0x81c72c5, 0x1ca611c1, 0xb8b5}}},
{/*.x =*/{/*.val =*/{0x34e5f03a, 0x3fa2d6f7, 0x21606d54, 0x1597fac7, 0x3dfe3596, 0x373eccf5, 0x1be33737, 0x13f740a2, 0x80c3}},
 /*.y =*/{/*.val =*/{0x3e3ca504, 0x5fd151b, 0x33245cb1, 0x2cabbc7, 0x1c9a03d3, 0x36d5c01f, 0x1ecd55e, 0x215a9e3, 0x247e}}},
{/*.x =*/{/*.val =*/{0x29565331, 0x20617fbe, 0x1a915abf, 0x17a2498b, 0xcf1ce93, 0xe7bed50, 0x30c22611, 0x1493240d, 0x9d32}},
 /*.y =*/{/*.val =*/{0x26f06930, 0x758c2a, 0x236934f9, 0x32544bb0, 0x6d2ae5c, 0x3b130b2f, 0x22ebfd7f, 0x15cf49df, 0x3766}}},
{/*.x =*/{/*.val =*/{0x354b8367, 0x25201cf5, 0x3d506bfe, 0x1d6ddf59, 0x36a5db7, 0x2a975161, 0x2526e40c, 0x252b911, 0x5e5a}},
 /*.y =*/{/*.val =*/{0x11ce85ca, 0x14ca6a76, 0x1e5ffa44, 0x1aaa7bcf, 0x2a4b7a79, 0x2407c55c, 0x15e05c2c, 0x3e32691e, 0xae8a}}},
{/*.x =*/{/*.val =*/{0xcbcad59, 0x2c17a0d8, 0xe0aaa07, 0x21168169, 0x3902f17c, 0x5f21697, 0x36007aa, 0x1b0454ab, 0x2ed7}},
 /*.y =*/{/*.val =*/{0x4ea66fe, 0x12b1ea27, 0xa7f9411, 0x1cb1804c, 0x1767ed5f, 0x29babb20, 0x5f222cd, 0x135010ee, 0x639f}}},
{/*.x =*/{/*.val =*/{0x24b84b48, 0xc3d15c7, 0x1e817ea8, 0x2b7d31e6, 0x17f7091, 0x43d5df5, 0x1a4f5419, 0x37c39f51, 0x5fb1}},
 /*.y =*/{/*.val =*/{0x37be8eb8, 0x1fb7a9a8, 0x33f21ad7, 0xa70e421, 0x2d258206, 0x3d191bf9, 0x4d49fbc, 0x3eef2f0f, 0x2152}}},
{/*.x =*/{/*.val =*/{0x2aa2a748, 0x15d87054, 0x378c403d, 0x2c99f85, 0x2835d8c9, 0x337e7d1a, 0x141486c5, 0x27edac70, 0x135a}},
 /*.y =*/{/*.val =*/{0x38a6cf84, 0xc41675b, 0x3f91ab2d, 0x19b84fa2, 0x9453a65, 0x18b97f9c, 0x15938e7, 0x778b2a8, 0xa869}}},
{/*.x =*/{/*.val =*/{0xfd69985, 0x2717764, 0x1df72aea, 0xc2732db, 0xccf149f, 0x3da437ef, 0x32f7e788, 0x1d9d73ad, 0xae9}},
 /*.y =*/{/*.val =*/{0x1409a003, 0x2723ad04, 0x2ee1aff8, 0x2e67505e, 0x1a54c5d0, 0x237fb814, 0x8d14e9b, 0x265cfdb9, 0x9121}}},
{/*.x =*/{/*.val =*/{0x2078afb0, 0x39d6b9e5, 0x1261974, 0x3fc4b1b1, 0x2d170714, 0x3511a319, 0x163b5248, 0x1af35d98, 0x209d}},
 /*.y =*/{/*.val =*/{0x2740b310, 0x1746ddd6, 0x1f4e3e38, 0x3b6de4ce, 0x98a5b01, 0x196eaea6, 0x33280a09, 0x4d0a79e, 0x1a2f}}},
{/*.x =*/{/*.val =*/{0x1f55a9bf, 0x2f2c0a63, 0x1ea5bf8e, 0x2c057bca, 0x17c578f6, 0xc1fd807, 0x23181810, 0x263ae71b, 0x7262}},
 /*.y =*/{/*.val =*/{0x3c3accae, 0x45be2c2, 0x673b4e, 0x1e5ef2f0, 0x1099e0be, 0xd68bbcf, 0x29bfda98, 0x22006a77, 0x38d4}}},
{/*.x =*/{/*.val =*/{0x3dbb04fa, 0x5c195a8, 0x118911f9, 0x29c145ac, 0x26b5e114, 0x2e090979, 0x26ed4d7c, 0xb7eecd1, 0x7fe4}},
 /*.y =*/{/*.val =*/{0x21908c89, 0x359d2447, 0x2c1b9c55, 0x3a28a234, 0x334cf0aa, 0x1b22c1e5, 0x5f4330f, 0x1e82d3d7, 0x2eec}}},
{/*.x =*/{/*.val =*/{0x2e4b3ba0, 0x2167d8d7, 0x18bf1f17, 0xaafbd7c, 0x3f245f5c, 0x385c3cc6, 0x3fb73bef, 0x4414887, 0x4108}},
 /*.y =*/{/*.val =*/{0x17525595, 0x21a58770, 0x1a064554, 0xd926159, 0x2b849813, 0x2996b875, 0x35668f2c, 0x3cda5dbf, 0xdc37}}},
{/*.x =*/{/*.val =*/{0xe5485, 0x22799a8, 0x1da5df02, 0x4c1a2fd, 0x320f1245, 0x31c2189c, 0x2bdff8e2, 0x1db5e4e8, 0x1cd2}},
 /*.y =*/{/*.val =*/{0x85fbd7f, 0x2973c146, 0x209a4ecc, 0x34389c2c, 0x2e977f99, 0x2cd35154, 0x2af738d4, 0x2f7462cb, 0x6615}}},
{/*.x =*/{/*.val =*/{0x290bc03e, 0x31d4f566, 0x1e015e33, 0x2c3ce4d4, 0x50f8084, 0x2a497dd1, 0x2072e9e5, 0x363b4b20, 0x2cee}},
 /*.y =*/{/*.val =*/{0x3ab82adc, 0x32dcae2d, 0xd53cd01, 0x77e73c8, 0x7daeb4a, 0x143adebf, 0x1de3ecd8, 0x1ae03a6e, 0xa427}}},
{/*.x =*/{/*.val =*/{0x3009ee3e, 0x2e71352e, 0x729ead5, 0x9a8799e, 0x272de237, 0x273af1, 0x22ac92b7, 0x216c0cba, 0xb17a}},
 /*.y =*/{/*.val =*/{0x296b911d, 0x18f947b, 0x446fa38, 0x85b29f2, 0x26eda65, 0x63f703, 0x29a65f5c, 0x9a749ac, 0x966e}}},
{/*.x =*/{/*.val =*/{0xe103dd6, 0x37dc51c8, 0x4859a, 0x1181301f, 0x12a17ac3, 0x84f3f16, 0x203f836a, 0x1ef55690, 0xbc47}},
 /*.y =*/{/*.val =*/{0x16f7c343, 0xe420b63, 0x23b44ac6, 0xa4d5cb1, 0x1ea6395d, 0x2b154b1b, 0xdd526cb, 0x7890a6a, 0xe31e}}},
{/*.x =*/{/*.val =*/{0x36695f94, 0xb602c60, 0x1627fa59, 0x285a71a4, 0x39a9cf62, 0x32e1a0eb, 0x18f5fd0c, 0x17546d15, 0xb1d2}},
 /*.y =*/{/*.val =*/{0x1ee32736, 0x16dfae69, 0x3863edca, 0x3dbc636a, 0x2ba81760, 0x3a82b066, 0x290b1f7b, 0x369c80c3, 0x706d}}},
{/*.x =*/{/*.val =*/{0x36f83231, 0x265c4062, 0x20425e34, 0x30c3639d, 0x33fdd0b7, 0x5609d96, 0x2ba26a8d, 0x23314d40, 0x850f}},
 /*.y =*/{/*.val =*/{0x1f2e8373, 0x280c6a75, 0x322d77f4, 0x216fe85d, 0x2cc7890a, 0x3dc21ae0, 0x39053d0b, 0x276f80a9, 0xbc4a}}},
{/*.x =*/{/*.val =*/{0x39343959, 0xb882f6f, 0x2c9ce78a, 0x28673cbe, 0x1bc1f617, 0x2bfa4c24, 0x651465d, 0x6e01743, 0x2d38}},
 /*.y =*/{/*.val =*/{0x1442fb00, 0x1c432ba8, 0x31e45a43, 0x14b57589, 0x31025f43, 0x2bcbce90, 0x361bf59a, 0x3782534a, 0x5451}}},
{/*.x =*/{/*.val =*/{0x152da17d, 0x18283e90, 0xd0646b1, 0x3704f6c2, 0x200bc811, 0x139ac17f, 0x18c5f089, 0x3b4783d4, 0x3bea}},
 /*.y =*/{/*.val =*/{0x2cc768d2, 0x39c12617, 0x1fec416c, 0x3379dee3, 0xe1b554, 0x12a2fafa, 0x37acdfef, 0x35fd56bf, 0xc3b0}}},
{/*.x =*/{/*.val =*/{0x1063e1be, 0x6e6b413, 0x3e39a75c, 0x90a68bd, 0x3cf027a9, 0x185494f6, 0x2b14722, 0x10744758, 0x1316}},
 /*.y =*/{/*.val =*/{0x21fec890, 0x3747fcf8, 0x1745b77f, 0x3ebb03e, 0x3d2bebbd, 0xb8c3f36, 0x39f06a4, 0x36985e58, 0x4c3b}}},
{/*.x =*/{/*.val =*/{0x3c46e079, 0x4a80d49, 0x1e9c78dd, 0x19a4c2e1, 0x2ba374ab, 0x3dd6b6c0, 0x3ac530fe, 0x30ab4ab3, 0xab86}},
 /*.y =*/{/*.val =*/{0x3636ffe1, 0x310a2f05, 0x50d7c0e, 0x1dca3a12, 0x3200c9ce, 0x311b535c, 0x329abcf5, 0x30a18067, 0x1209}}},
{/*.x =*/{/*.val =*/{0x17d37248, 0x227c6075, 0x117ceae4, 0x20d6d947, 0x2b2787bc, 0x1bac891a, 0x36d5aa4d, 0x946f0fb, 0xadc4}},
 /*.y =*/{/*.val =*/{0x2adcbc1b, 0x1811f2b3, 0x50bebc8, 0x37156ec5, 0x16f70b9, 0x18f8d8a4, 0x1e7eb5d0, 0x2dd8b8f1, 0xb0f3}}},
{/*.x =*/{/*.val =*/{0xeca5f51, 0x85ac826, 0xfc9aebf, 0x3a85c6e5, 0x5b5cfdd, 0x3b5acafc, 0x2e6962c6, 0x35453767, 0xdde9}},
 /*.y =*/{/*.val =*/{0x10c638f7, 0x2b5a69cf, 0x289571f9, 0x3fbafa37, 0x3f8f0950, 0x7cd2c29, 0x28111d89, 0x1a44cf38, 0xb84e}}},
{/*.x =*/{/*.val =*/{0x209b0cca, 0x3331a956, 0xa4d6f01, 0x115d6249, 0x28da59a3, 0x1153da28, 0xf4c8d5c, 0x232c76ec, 0xd53}},
 /*.y =*/{/*.val =*/{0xc929e05, 0xc6c51f8, 0x9134c97, 0xd336676, 0x2ed7cf85, 0x2a357103, 0x2c110cb0, 0x1aeb1e8f, 0xc819}}},
{/*.x =*/{/*.val =*/{0x2dd7e577, 0x2b8c0f3b, 0x136c4d56, 0x283c95a1, 0x2a2107d3, 0x1811c9c3, 0xf7b25ac, 0x3543e20a, 0xc352}},
 /*.y =*/{/*.val =*/{0x38d9b570, 0x3293fe23, 0x21217063, 0x2a2aecad, 0xe79fb00, 0x354c516f, 0x2b9b96ab, 0xa0e2e9d, 0xbe77}}},
{/*.x =*/{/*.val =*/{0x23868246, 0x22fcdeb0, 0x6dd2ded, 0x27db62bd, 0x2248ba8, 0x17641f4b, 0x11d600b5, 0x1f82acce, 0xfb9d}},
 /*.y =*/{/*.val =*/{0x2969605a, 0x2760f82b, 0x2a2606d2, 0x34ab4c16, 0x1475f4a6, 0x2a2e05a8, 0x3680cff2, 0x26f807d2, 0xb038}}},
{/*.x =*/{/*.val =*/{0x3712be3c, 0x1a8b8cb, 0x2146a66b, 0x257c63b6, 0x153472, 0x1c976eac, 0x1b378d3c, 0xd2764cc, 0x39d7}},
 /*.y =*/{/*.val =*/{0x1c6ff65c, 0x30c067d0, 0xa41644c, 0x17bde97b, 0x2812e8ef, 0x9d55319, 0x33bf7fb1, 0x26d3d5bb, 0x8f92}}},
{/*.x =*/{/*.val =*/{0x37829372, 0x3b02a929, 0xba4553d, 0x26cc0322, 0x5796bc4, 0x189ab94e, 0x20d3b313, 0x273243cf, 0xb431}},
 /*.y =*/{/*.val =*/{0xadd5427, 0x1ca73300, 0x23e11bb7, 0x1ec48572, 0x21c5a270, 0x1ebf8270, 0x3502bffb, 0x3512669b, 0x4707}}},
{/*.x =*/{/*.val =*/{0xdcbcb9e, 0x12fc449b, 0xd83c3df, 0x3e95a277, 0x143761d6, 0x30c911ff, 0x1337a9ec, 0x4b5c467, 0xcdcb}},
 /*.y =*/{/*.val =*/{0x961cfd1, 0x229616b, 0x18df340a, 0x266bc90d, 0x1e9949a1, 0x3efa825b, 0x1f11fbfe, 0x38b85eee, 0xe699}}},
{/*.x =*/{/*.val =*/{0xe90bc26, 0x1e074991, 0x364d3aa0, 0x22880f84, 0xacd88a9, 0xf195b1d, 0x27275f3d, 0x385bd96d, 0x5e4d}},
 /*.y =*/{/*.val =*/{0x252f79e, 0x5f546a, 0x1127f9c7, 0x194f732b, 0x3ad55207, 0xebea5e0, 0x1432904e, 0x3cb90d4f, 0x5ac5}}},
{/*.x =*/{/*.val =*/{0x754dd40, 0x18fa1c55, 0x3466cf8, 0x10898c7f, 0x32f6e9a2, 0x12107f35, 0xdfcf45b, 0x91c0cb0, 0x9729}},
 /*.y =*/{/*.val =*/{0x2aa36143, 0x212d24bc, 0x1acaf493, 0x36ba1495, 0x14df3690, 0x171d772f, 0x3ea1dcd1, 0x28910997, 0x91d1}}},
{/*.x =*/{/*.val =*/{0xc7a89ee, 0x15f0d4cc, 0x2b6d4f80, 0x36f1671e, 0x18658a4b, 0x182e23f2, 0x179e1128, 0x29389a90, 0x71ef}},
 /*.y =*/{/*.val =*/{0x1366a2e, 0x3d224ca7, 0x25e9a0b4, 0x2abeae23, 0x3294a22a, 0x2cb0cac5, 0x224ae9ef, 0x2a07e2ed, 0x145f}}},
{/*.x =*/{/*.val =*/{0xde0545f, 0x32c08d26, 0x106c74f5, 0x39897688, 0x3508ac80, 0x17a8012c, 0x7124a37, 0x16f31638, 0x5204}},
 /*.y =*/{/*.val =*/{0x106c3d91, 0x1ba8d301, 0x28fdaf23, 0xee743ca, 0xe312b79, 0x3b67083, 0x3123ad43, 0xc7f3af8, 0x1b3f}}},
{/*.x =*/{/*.val =*/{0x3ddaa5d5, 0x1873f311, 0x14d4b7ab, 0x27a034e9, 0x16607331, 0x3bf9159a, 0x28c4e4e8, 0x2646e4be, 0x4e9}},
 /*.y =*/{/*.val =*/{0x2cba1c91, 0x35f800ff, 0x255f570d, 0x3827db86, 0x957303c, 0x1ab47630, 0x327f1d9e, 0x577778a, 0x62fc}}},
{/*.x =*/{/*.val =*/{0x26a06f5e, 0x6902d65, 0x2a083702, 0x1064945b, 0x23b716a3, 0x2c350849, 0x253ac37, 0x93efa85, 0x383b}},
 /*.y =*/{/*.val =*/{0x13c6e772, 0x227d1e1b, 0x38c2b040, 0x3dab9d2e, 0x2a5a19e8, 0x3d59b553, 0x1ba2044c, 0x1c1ab13b, 0x54cf}}},
{/*.x =*/{/*.val =*/{0x1bcf2dce, 0x4e6d023, 0x1dc6c02, 0x4528417, 0x3f998068, 0x2793264b, 0x6218bd4, 0xb50a4b9, 0x95e6}},
 /*.y =*/{/*.val =*/{0x18c86594, 0xaf77f7d, 0x304d20e6, 0x1ecc180d, 0x28d52e5e, 0x289b8ad0, 0x2875183, 0x20610a5b, 0x6b6}}},
{/*.x =*/{/*.val =*/{0x17a6257f, 0x20149916, 0x27a6c40b, 0x1cf0ec68, 0x7e78918, 0x909d2ac, 0x14f25a64, 0xd72387d, 0x71e9}},
 /*.y =*/{/*.val =*/{0x11b1e582, 0x2c85d187, 0xf70f7a5, 0x948d503, 0x2e2a52ef, 0x361ae91e, 0x22513de, 0xf967d1f, 0x78d9}}},
};
#endif
