from gi.repository import *

class WelcomeScreen(Gtk.Fixed):
	def __init__(self, handler):
		super(WelcomeScreen, self).__init__()
		self.handler = handler
		self.set_layout()

	def set_layout(self):
		box = Gtk.Box()
		box.set_orientation(Gtk.Orientation.VERTICAL)
		box.set_spacing(15)
		title = Gtk.Label('No documents are active.')
		titlefont = Pango.FontDescription('Ubuntu 12')
		title.override_font(titlefont)
		desc = Gtk.Label('Select a file to start editing.')
		desc.override_font(Pango.FontDescription('Ubuntu 14'))
		desc.override_color(Gtk.StateFlags.NORMAL, Gdk.RGBA(0.4,0.4,0.4,1))
		#New Button
		newbutton = Gtk.Button()
		newbutton.set_can_focus(False)
		newbutton.set_relief(Gtk.ReliefStyle.NONE)
		newbutton.set_size_request(220, 48)
		image = Gtk.Image()
		image.set_from_stock(Gtk.STOCK_NEW, Gtk.IconSize.DIALOG)
		label = Gtk.Label('New file')
		label2 = Gtk.Label('Start a new document.')
		label2.override_font(Pango.FontDescription('Ubuntu 9'))
		label2.override_color(Gtk.StateFlags.NORMAL, Gdk.RGBA(0.4, 0.4, 0.4, 1))
		fixed = Gtk.Fixed()
		fixed.put(image, 10, 5)
		fixed.put(label, 80, 12)
		fixed.put(label2, 80, 29)
		newbutton.add(fixed)
		newbutton.connect('clicked', self.handler.on_click_new)
		#OpenButton
		button = Gtk.Button()
		button.set_can_focus(False)
		button.set_relief(Gtk.ReliefStyle.NONE)
		button.set_size_request(220, 48)
		image = Gtk.Image()
		image.set_from_stock(Gtk.STOCK_OPEN, Gtk.IconSize.DIALOG)
		label = Gtk.Label('Open file')
		label2 = Gtk.Label('Open a saved file.')
		label2.override_font(Pango.FontDescription('Ubuntu 9'))
		label2.override_color(Gtk.StateFlags.NORMAL, Gdk.RGBA(0.4, 0.4, 0.4, 1))
		fixed = Gtk.Fixed()
		fixed.put(image, 10, 5)
		fixed.put(label, 80, 12)
		fixed.put(label2, 80, 29)
		button.add(fixed)
		button.connect('clicked', self.handler.on_click_open)
		box.add(title)
		box.add(desc)
		box.add(newbutton)
		box.add(button)
		self.put(box, 320, 140)
