#!/usr/bin/env python

from distutils.core import setup

from platform import system

if system().lower() == 'linux':
    configdir = '/etc/upe'

setup(name='UPE',
    version='0.1.1',
    description='Universal Package Editor',
    long_description='Simple Package Manager',
    author='Victor G',
    author_email='vicgua@outlook.com',
    url='https://bitbucket.org/universalpackageeditor/upe',
    packages=['upe'],
    data_files=[(configdir, ['config.ini', 'pkgdb.json'])],
    license='GPLv2',
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Intended Audience :: Developers',
        'Intended Audience :: End Users/Desktop',
        'License :: OSI Approved :: GNU General Public License v2 (GPLv2)',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python :: 3 :: Only',
        'Topic :: System :: Software Distribution'],
    )