# Part of UPE


def _getrpath(path):
    import os
    ret = os.path.normpath(os.path.join(os.path.abspath(os.sep),
        os.path.relpath(path)))
    return ret


class DependencyError(Exception):
    pass


class NotCompatible(Exception):
    pass


def linstall(pkgfile):
    '''Install a package from a local file'''
    import json
    import shutil
    from tempfile import mkdtemp
    import os
    import filecmp
    from platform import system, machine
    from upe import config
    from upe import query
    tmpdir = mkdtemp()
    shutil.unpack_archive(pkgfile, tmpdir, format='bztar')
    currentdir = os.getcwd()
    os.chdir(tmpdir)
    with open('manifest.json', 'r') as manifest:
        data = json.load(manifest)
    if data['build']['os'] != system().lower() or data['build']['arch'] !=\
         machine().lower():
        raise NotCompatible
    package = data['package']
    deptest = query.pkgin(data['deps'])
    if not deptest[0]:
        raise DependencyError('Missing dependencies: {}'.format(deptest[1]))
    files = []
    for obj in os.walk(package):
        for directory in obj[1]:
            rpath = _getrpath(directory)
            if os.path.isdir(rpath) is False:
                os.mkdir(rpath, mode=oct(os.stat(directory).st_mode[-3:]))
                os.chown(rpath, os.stat(directory).st_uid,
                    os.stat(directory).st_gid)
            files.append(rpath)
        for file in obj[2]:
            rpath = _getrpath(file)
            if os.path.isfile(rpath) is True:
                if filecmp.cmp(file, rpath) is False:
                    copy = True
                else:
                    copy = False
            else:
                copy = True
            if copy is True:
                shutil.copy2(file, rpath)
                os.chown(rpath, os.stat(file).st_uid, os.stat(file).st_gid)
            files.append(rpath)
    newdata = {package: {}}
    for key in data:
        if key == 'package':
            continue
        newdata[package][key] = data[key]
    newdata[package]['files'] = files
    pkgdb = config.packages.database
    with open(pkgdb, 'r') as db:
        olddata = json.load(db)
    olddata.update(newdata)
    with open(pkgdb, 'w') as db:
        json.dump(olddata, db)
    os.chdir(currentdir)


def remove(package, ignore=[]):
    '''Uninstall an installed package. It will check if it's needed by
    another package as dependency (except for those in ignore).'''
    import json
    import os
    from upe import config
    from upe import query
    depchk = query.checkneeded(package, ignore)
    if depchk[0] is True:
        raise DependencyError('Needed by ' + depchk[1])
    pkgdb = config.packages.database
    with open(pkgdb, 'r') as db:
        data = json.load(db)
    for file in data[package]['files']:
        if os.path.isdir(file):
            try:
                os.rmdir(file)
            except OSError:
                pass
        elif os.path.isfile(file):
            os.remove(file)
    del(data[package])
    with open(pkgdb, 'w') as db:
        json.dump(data, db)