# Part of UPE
import configparser
from platform import system

if system().lower() == 'linux':
    cfgfile = '/etc/upe/config.ini'
    default_database = '/etc/upe/pkgdb.json'
# Mac not ready
# Windows not ready
config = configparser.ConfigParser(allow_no_value=True, delimiters=('=',),
    comment_prefixes=(';',), inline_comment_prefixes=(';',))

if config.read(cfgfile) == []:
    raise PermissionError("Can't read Config File")  # lint:ok


class packages:
    '''Get configuration under [packages]'''
    database = config['packages']['database']


class building:
    if config['building']['allowshell'] == 'yes':
        shell = True
        ask = False
    elif config['building']['allowshell'] == 'ask':
        shell = True
        ask = True
    elif config['building']['allowshell'] == 'no':
        shell = False
        ask = None
    else:
        raise ValueError('Values of building/allowshell must be yes | no | ask')


class logging: 
    '''Get logging settings'''
    from os import devnull
    enabled = config.getboolean('logging', 'enabled')
    if enabled is False:
        loglevel = 'CRITICAL'
        logfile = devnull
    else:
        loglevel = config['logging']['loglevel']
        logfile = config['logging']['logfile']
    defstyle = {'file': logfile,
        'format': '%(levelname)s:%(asctime)s> %(message)s'}
