# Part of UPE


def pkgin(*pkglist):
    '''Check if a package is installed. pkglist may contain several arguments,
    which will be all the packages to be checked, and it'll return False if
    one or more packages aren't found.'''
    import json
    from upe import config
    with open(config.packages.database, 'r') as f:
        db = json.load(f)
    found = True
    missing = []
    for pkg in pkglist:
        if pkg in db:
            found = found and True
        else:
            found = found and False
            missing.append(pkg)
    if found is True:
        return (True,)
    else:
        return (False, missing)


def getver(pkg):
    '''Get the version of an installed package.'''
    import json
    from upe import config
    with open(config.packages.database, 'r') as f:
        db = json.load(f)
    return [int(db[pkg]['version']), float(db[pkg]['release']),
        int(db[pkg]['pkgrel'])]


def checkneeded(pkg, ignore=[]):
    '''Check if a package is needed by any other package. Packages in ignore
    won't be checked. Will return (False,) if isn't required or (True, packages)
    if it's required by <packages>.'''
    import json
    from upe import config
    with open(config.packages.database, 'r') as f:
        db = json.load(f)
    requiring = []
    for package in db:
        if package in ignore:
            continue
        for dep in db[package]['deps']:
            if dep == pkg:
                requiring.append(dep)
    if len(requiring) > 0:
        return (True, tuple(requiring))
    else:
        return (False,)


def hasoptdeps(pkg):
    '''Check if a package has optional dependencies. Will return a tuple
    with (True, {'dependency1': 'feature', 'dependency2': 'feature'})
    or (False,)'''
    import json
    from upe import config
    with open(config.packages.database, 'r') as f:
        db = json.load(f)
    optd = db[pkg]['optd']
    if optd is None:
        return (False,)
    else:
        return (True, optd)