#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright (C) 2010  Michał Masłowski  <mtjm@mtjm.eu>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""
Script used to install URLReader.
"""


from setuptools import setup, find_packages


VERSION = "0.0"
RELEASE = "0.0a0"


setup(
    name="URLReader",
    version=RELEASE,
    author="Michał Masłowski",
    author_email="mtjm@mtjm.eu",
    url="http://hg.mtjm.eu/urlreader/",
    packages=find_packages(),
    description="Simple package for cached URL fetching",
    long_description=open("README.txt").read(),
    license="GNU Affero General Public License v3 or later",
    # TODO: add more
    classifiers=(
        "Development Status :: 3 - Alpha",
        "License :: OSI Approved :: GNU Affero General Public License v3",
        "Programming Language :: Python",
        "Programming Language :: Python :: 3",
        ),
    test_suite="tests_urlreader.__init__",
    package_data = {
        "tests_urlreader.htdocs": ["*.html"],
        },
    zip_safe=True,
    use_2to3=True,
    command_options={
        "build_sphinx": {
            "version": ("setup.py", VERSION),
            "release": ("setup.py", RELEASE),
            },
        },
    )
