# -*- coding: utf-8 -*-
# Copyright (C) 2010, 2011  Michał Masłowski  <mtjm@mtjm.eu>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""
Test code using HTTP requests.
"""


from __future__ import absolute_import

import time
import unittest
import random
import subprocess
import urllib2

import pkg_resources

from urlreader.exceptions import ReaderError, NotFoundError
from urlreader.urlreader import URLReader


__all__ = ("HTTPInteractionTestCase",)


class HTTPInteractionTestCase(unittest.TestCase):

    """Tests."""

    def setUp(self):
        """Prepare."""
        # Start an HTTP server.
        port = random.randrange(8000, 8100)
        self.host = "http://localhost:%d/" % port
        htdocs = pkg_resources.resource_filename("tests_urlreader",
                                                 "htdocs")
        self.httpd = subprocess.Popen(
            ("python2", "-m", "SimpleHTTPServer", str(port)),
            cwd=htdocs,
            stdout=subprocess.PIPE,
            stderr=subprocess.PIPE)
        # Wait until the server is ready.
        while True:
            try:
                urllib2.urlopen(self.host)
            except (urllib2.URLError, ValueError):
                time.sleep(0.1)
            else:
                break
        self.urlreader = URLReader()

    def tearDown(self):
        """Stop the server."""
        self.httpd.terminate()
        self.httpd.wait()

    def test_notfound(self):
        """Test that non-existent documents won't be found"""
        self.assertRaises(NotFoundError, self.urlreader,
                          self.host + "nil.html")

    def test_servererror(self):
        """Test that stopped server won't provide documents"""
        self.tearDown()
        self.assertRaises(ReaderError, self.urlreader,
                          self.host + "unicode.html")
        self.setUp()

    def test_twice(self):
        """Test that a single URL can be read twice."""
        first = self.urlreader(self.host + "unicode.html").content
        second = self.urlreader("%s%s" % (self.host,
                                          "unicode.html")).content
        self.assertEqual(first, second)
