# -*- coding: utf-8 -*-
# Copyright (C) 2012  Michał Masłowski  <mtjm@mtjm.eu>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""Private definitions for Python 3 compatibility."""


import sys


if sys.version_info[0] == 2:
    basestring = basestring
    xrange = xrange
    import anydbm
    from urllib2 import urlopen, build_opener, URLError, HTTPError
    assert basestring and xrange and anydbm and urlopen and build_opener \
        and URLError and HTTPError
else:
    basestring = str
    xrange = range
    import dbm as anydbm
    from urllib.request import urlopen, build_opener
    from urllib.error import URLError, HTTPError
    assert basestring and xrange and anydbm and urlopen and build_opener \
        and URLError and HTTPError


__all__ = ("basestring", "xrange", "anydbm",
           "build_opener", "URLError", "HTTPError")
