#!/usr/bin/env python
# -*- coding: utf-8 -*-

#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>
#
# Author: Francois Boulogne <fboulogne at sciunto dot org>, 2012

import tarfile
import os.path
import logging

logger = logging.getLogger('Vitalus.utils')

def compress(path):
    """ Compress the directory """

    head, tail = os.path.split(path)
    archive = str(path) + '.bz2'
    tar = tarfile.open(archive, "w:bz2")
    tar.add(path, arcname=tail)
    tar.close()


def get_folder_size(path):
    """
    Get the size of the content in path
    """
    size = 0
    for item in os.walk(path):
        for file in item[2]:
            try:
                size += os.path.getsize(os.path.join(item[0], file))
            except:
                logger.warn("error with file: %s", os.path.join(item[0], file))
    return size
