times = [
    '20090621T054511.2Z',
    '20090621 054511.2Z',
    '20090621T054511Z',
    '20090621T0545Z',
    '20090621T05Z',
    '20090621Z',
    '20090621',
    '2009-06-21T054511.2Z',
    '2009-06-21 054511.2Z',
    '2009-06-21T054511Z',
    '2009-06-21T05Z',
    '2009-06-21Z',
    '2009-06-21',
    '20090621T05:45:11.2Z',
    '20090621 05:45:11.2Z',
    '20090621T05:45:11Z',
    '2009-06-21T05:45:11.2Z',
    '2009-06-21 05:45:11.2Z',
    '2009-6-1T05:45:11.2Z',
    '2009-6-1T5:45:11.2Z',
    '2009-06-21T05:45:11.2+01:30',
    '2009-06-21T05:45:11.2+0130',
    '20090621T054511.2+0130',
    '2009-06-21T05:45:11.2+01',
    '2009-06-21T05:45:11.2-01:30'
    ]

expected = [
    '2009-06-21 05:45:11.200000+00:00',
    '2009-06-21 05:45:11.200000+00:00',
    '2009-06-21 05:45:11+00:00',
    '2009-06-21 05:45:00+00:00',
    '2009-06-21 05:00:00+00:00',
    '2009-06-21 00:00:00',
    '2009-06-21 00:00:00',
    '2009-06-21 05:45:11.200000+00:00',
    '2009-06-21 05:45:11.200000+00:00',
    '2009-06-21 05:45:11+00:00',
    '2009-06-21 05:00:00+00:00',
    '2009-06-21 00:00:00',
    '2009-06-21 00:00:00',
    '2009-06-21 05:45:11.200000+00:00',
    '2009-06-21 05:45:11.200000+00:00',
    '2009-06-21 05:45:11+00:00',
    '2009-06-21 05:45:11.200000+00:00',
    '2009-06-21 05:45:11.200000+00:00',
    '2009-06-01 05:45:11.200000+00:00',
    '2009-06-01 05:45:11.200000+00:00',
    '2009-06-21 05:45:11.200000+01:30',
    '2009-06-21 05:45:11.200000+01:30',
    '2009-06-21 05:45:11.200000+01:30',
    '2009-06-21 05:45:11.200000+01:00',
    '2009-06-21 05:45:11.200000-01:30'
    ]

def parse_times(parser):
    for i in range(len(times)):
        try:
            test = str(parser(times[i]))
            expect = expected[i]
            if test != expect:
                print expect, '  :  ', test
            else:
                print '.'
        except Exception as e:
            print str(e) + ": " + times[i]

def test_dateutil():
    from dateutil.parser import parse as p
    parse_times(p)

def test_isodate():
    from isodate import parse_datetime as p
    parse_times(p)

def test_chrono():
    from chrono import Date as p
    parse_times(p)

def test_mx():
    from mx.DateTime.ISO import ParseDateTimeUTC as p
    parse_times(p)

if __name__ == '__main__':
    print 'dateutil :'
    test_dateutil()
    #print ' '
    #print ' '
    #print 'isodate :'
    #test_isodate()
    #print ' '
    #print ' '
    #print 'chrono :'
    #test_chrono()
    #print ' '
    #print ' '
    #print 'mxDateTime :'
    #test_mx()
