# -*- python -*-

## Copyright 2011 Daniel J. Popowich
##
## Licensed under the Apache License, Version 2.0 (the "License");
## you may not use this file except in compliance with the License.
## You may obtain a copy of the License at
##
##     http://www.apache.org/licenses/LICENSE-2.0
##
## Unless required by applicable law or agreed to in writing, software
## distributed under the License is distributed on an "AS IS" BASIS,
## WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
## See the License for the specific language governing permissions and
## limitations under the License.

from TutorialBase import *

class helloworld(HTMLPage):
    'Classic "Hello, World!" example to kick-off the tutorial.'

    title = 'Hello, World!'

    def write_content(self):
        
        self.writeln(OVERVIEW)




# -*-*- DOC -*-*-

OVERVIEW =  make_overview('''
Do not all tutorials start with:

> ### Hello, World!

How it works:

  * Define a class that is a subclass of `HTMLPage`.
  * In your class, override the `write_content` method.
  * Make calls to the `writeln` method which sends output to the
    client browser.


In the case of this servlet, we have a class named `helloworld` which
subclasses `HTMLPage`[^1].  There is only one method, `write_content`
which makes a single call to `writeln` with this text.

This servlet also sets a single attribute, `title`, which sets the
title of this page.

After viewing the python source (click on the link above) you may be
wondering how the big, centered title got on this page, as well as the
horizontal rules and the navigation links, etc.  The import statement
at the top of the source:

        from TutorialBase import *

employs some *magic* to hide much of the tutorial machinery.  After
you become familiar with WSGIServlets, reading the code in
[TutorialBase.py](TutorialBase.py) may prove instructive for advanced
users.  For now, know that if you cut and paste the code you see when
viewing the source of each tutorial servlet and replace the import
line with:

        from wsgiservlets import *

you would see everything between the top and bottom horizontal rules
of each page.

If you view the HTML that is generated by the servlet you will notice
that all the content sent to the browser by `write_content` is placed
inside &lt;BODY&gt;...&lt;/BODY&gt; tags.  How the rest of the HTML is
generated and how you can control it will be shown throughout this
tutorial.

In the next example, you will see what happens when you do not
override `write_content`.  Click on view source in the next tutorial
to see what is happening inside the servlet.

[^1]:
    Which in turn is a subclass of `WSGIServlet`, the abstract base
    class of all WSGIServlets, instances of which are WSGI
    applications.  This will be discussed in detail in a later
    tutorial page.

''')

