<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <!-- Ensure proper structure of items. -->

  <xsl:template match="*[parent::item]">
    <xsl:element name="{local-name()}">
      <xsl:apply-templates select="@*"/>
      <xsl:apply-templates select="*[local-name() != 'organizer' and local-name() != 'attendee']"/>
      <dtstart-time>
        <xsl:call-template name="dt">
          <xsl:with-param name="datetime" select="dtstart/@datetime"/>
        </xsl:call-template>
      </dtstart-time>
      <dtend-time>
        <xsl:call-template name="dt">
          <xsl:with-param name="datetime" select="dtend/@datetime"/>
        </xsl:call-template>
      </dtend-time>
      <organizers>
        <xsl:apply-templates select="organizer"/>
      </organizers>
      <attendees>
        <xsl:apply-templates select="attendee"/>
      </attendees>
    </xsl:element>
  </xsl:template>

  <xsl:template match="dtstart|dtend">
    <xsl:copy>
      <xsl:attribute name="date"><xsl:value-of select="substring(@datetime, 1, 8)"/></xsl:attribute>
    </xsl:copy>
  </xsl:template>

  <xsl:template name="dt">
    <xsl:param name="datetime"/>
    <xsl:variable name="time" select="substring($datetime, 9)"/>
    <xsl:choose>
      <xsl:when test="$time != ''">
        <xsl:variable name="hour" select="substring($datetime, 10, 2)"/>
        <xsl:variable name="minute" select="substring($datetime, 12, 2)"/>
        <xsl:variable name="second" select="substring($datetime, 14, 2)"/>
        <xsl:attribute name="use-time">true</xsl:attribute>
        <hour>
          <xsl:attribute name="value"><xsl:value-of select="$hour"/></xsl:attribute>
        </hour>
        <minute>
          <xsl:attribute name="value"><xsl:value-of select="$minute"/></xsl:attribute>
        </minute>
        <second>
          <xsl:attribute name="value"><xsl:value-of select="$second"/></xsl:attribute>
        </second>
      </xsl:when>
      <xsl:otherwise>
        <xsl:attribute name="use-time">false</xsl:attribute>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- Copy in useful attributes from person definitions. -->

  <xsl:template match="organizer|attendee">
    <xsl:copy>
      <xsl:apply-templates select="@*"/>
      <xsl:attribute name="fn">
        <xsl:value-of select="/item/cards/card[uid/@details=current()/@uri]/fn/@details"/>
      </xsl:attribute>
      <xsl:attribute name="email">
        <xsl:value-of select="/item/cards/card[uid/@details=current()/@uri]/email/@details"/>
      </xsl:attribute>
    </xsl:copy>
  </xsl:template>

  <!-- Replicate unknown nodes. -->

  <xsl:template match="*" priority="0">
    <xsl:element name="{local-name()}">
      <xsl:apply-templates select="@*|*|node()"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="@*|node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|*|node()"/>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
