#!/usr/bin/env python3
"""Exceptions generated by the xsls.Tokenizer"""

class TokenizerException(Exception):
    """Exception generated when the Tokenizer encounters an error"""
    def __init__(self, offset, message=''):
        self.offset = offset
        self.message = message
        Exception.__init__(self, message)

class UnexpectedCharacter(TokenizerException):
    """Exception generated when the Tokenizer is unable to identify a token"""
    def __init__(self, offset):
        TokenizerException.__init__(self, offset, 'unexpected character')

class InvalidSelector(TokenizerException):
    """Exception generated when the Tokenizer is unable to identify a
    selector"""
    def __init__(self, offset):
        TokenizerException.__init__(self, offset, 'invalid selector')

class UnableToConvertCSSSelector(TokenizerException):
    """Exception generated when the Tokenizer is unable to convert CSS
    selector into XPath expression"""
    def __init__(self, offset):
        TokenizerException.__init__(
            self,
            offset,
            'unable to convert CSS selector to XPath expression'
        )

