#!/usr/bin/env python3
"""Exceptions generated by the xsls.Compiler"""

class CompilerException(Exception):
    """Exception generated when the Compiler encounters a syntax error"""
    def __init__(self, message, offset):
        self.offset = offset
        self.message = message
        Exception.__init__(self, message)

class UnexpectedToken(CompilerException):
    """Exception generated when the Compiler was expecting something
    different"""
    def __init__(self, offset, unexpected, expected):
        self.unexpected = unexpected
        self.expected = expected
        message = "Unexpected {unexpected}, was expecting {expected}".format(
            unexpected=self.unexpected[0],
            expected=self.expected
        )
        CompilerException.__init__(self, message, offset)

class UnknownIdentifier(CompilerException):
    """Exception generated when the Compiler encounters an unknown
    identifier"""
    def __init__(self, offset, identifier):
        self.identifier = identifier
        message = "Unknown identifier {identifier}".format(
            identifier=self.identifier
        )
        CompilerException.__init__(self, message, offset)

class UnknownAttribute(CompilerException):
    """Exception generated when the Compiler encounters an unknown
    attribute"""
    def __init__(self, offset, attribute):
        self.attribute = attribute
        message = "Unknown attribute {attribute}".format(
            attribute=self.attribute
        )
        CompilerException.__init__(self, message, offset)

class AmbiguousIdentifier(CompilerException):
    """Exception generated when the Compiler encounters an ambiguous
    identifier"""
    def __init__(self, offset, identifier):
        self.identifier = identifier
        message = "Ambiguous identifier {identifier}".format(
            identifier=self.identifier
        )
        CompilerException.__init__(self, message, offset)

class NoMoreTokenException(Exception):
    """Exception generated when the Compiler excpected another token
    but there was none available"""
    pass
