import amara
from Ft.Xml.XPath import Conversions
from Ft.Xml.Domlette import NonvalidatingReader
from datetime import datetime, date

XHTML_NS = u'http://www.w3.org/1999/xhtml'

def date_selection(context):
    doc = amara.create_document(u'select', XHTML_NS, attributes={u'name' : u'month'})
    for x in range(1, 12):
        gen = date(2007, x, 1)
        abbr, full = gen.strftime('%b'), gen.strftime('%B')
        option = doc.xml_create_element(u'option', XHTML_NS,
                                             attributes={u'value' : unicode(abbr)},
                                             content=unicode(full))
        doc.select.xml_append(option)
    month = NonvalidatingReader.parseString(doc.xml(), XHTML_NS)
    del doc

    doc = amara.create_document(u'select', XHTML_NS, attributes={u'name' : u'day'})
    for x in range(1, 31):
        option = doc.xml_create_element(u'option', XHTML_NS,
                                           attributes={u'value' : unicode(x)},
                                           content=unicode(x))
        doc.select.xml_append(option)
    day = NonvalidatingReader.parseString(doc.xml(), XHTML_NS)
    del doc

    gen = datetime.now()
    doc = amara.create_document(u'select', XHTML_NS, attributes={u'name' : u'year'})
    for x in range(gen.year - 20, gen.year + 20):
        option = doc.xml_create_element(u'option', XHTML_NS,
                                        attributes={u'value' : unicode(x)},
                                        content=unicode(x))
        if x == gen.year:
            option.xml_set_attribute(u'selected', u'true')
        doc.select.xml_append(option)
    year = NonvalidatingReader.parseString(doc.xml(), XHTML_NS)
    del doc
    
    return [month, day, year]

def state_selection(content):
    states = """<select name="state" xmlns="%s">
	<option value="AL">Alabama</option>
	<option value="AK">Alaska</option>
	<option value="AZ">Arizona</option>
	<option value="AR">Arkansas</option>
	<option value="CA">California</option>
	<option value="CO">Colorado</option>
	<option value="CT">Connecticut</option>
	<option value="DE">Delaware</option>
	<option value="DC">District of Columbia</option>
	<option value="FL">Florida</option>
	<option value="GA">Georgia</option>
	<option value="HI">Hawaii</option>
	<option value="ID">Idaho</option>
	<option value="IL">Illinois</option>
	<option value="IN">Indiana</option>
	<option value="IA">Iowa</option>
	<option value="KS">Kansas</option>
	<option value="KY">Kentucky</option>
	<option value="LA">Louisiana</option>
	<option value="ME">Maine</option>
	<option value="MD">Maryland</option>
	<option value="MA">Massachusetts</option>
	<option value="MI">Michigan</option>
	<option value="MN">Minnesota</option>
	<option value="MS">Mississippi</option>
	<option value="MO">Missouri</option>
	<option value="MT">Montana</option>
	<option value="NE">Nebraska</option>
	<option value="NJ">New Jersey</option>
	<option value="NH">New Hampshire</option>
	<option value="NV">Nevada</option>
	<option value="NM">New Mexico</option>
	<option value="NY">New York</option>
	<option value="NC">North Carolina</option>
	<option value="ND">North Dakota</option>
	<option value="OH">Ohio</option>
	<option value="OK">Oklahoma</option>
	<option value="OR">Oregon</option>
	<option value="PA">Pennsylvania</option>
	<option value="RI">Rhode Island</option>
	<option value="SC">South Carolina</option>
	<option value="SD">South Dakota</option>
	<option value="TN">Tennessee</option>
	<option value="TX">Texas</option>
	<option value="UT">Utah</option>
	<option value="VT">Vermont</option>
	<option value="VA">Virginia</option>
	<option value="WA">Washington</option>
	<option value="WV">West Virginia</option>
	<option value="WI">Wisconsin</option>
	<option value="WY">Wyoming</option>
</select>""" % XHTML_NS
    return [NonvalidatingReader.parseString(str(states), XHTML_NS)]

extensions = [
    (u'http://ionrock.org/ns/xsltemplate', u'date-selection', date_selection),
    (u'http://ionrock.org/ns/xsltemplate', u'state-selection', state_selection), 
]
