import sys, json, codecs
infile = json.load(codecs.open(sys.argv[1], "r", "utf-8"))
outfile = codecs.open(sys.argv[1] + ".po", "w", "utf-8")
out = []

out.append("""# LANGUAGE FILE FOR SVG-EDIT, AUTOGENERATED BY TOPO.PY

msgid ""
msgstr ""
"Content-Type: text/plain; charset=utf-8\\n"
"Content-Transfer-Encoding: 8bit\\n"

# ---

""")

def printstr(flag, i, s):
    out.append('\n')
    if flag == '-x-svg-edit-both':
        out.append("# Enter the title first, then the contents, seperated by a pipe char (|)\n")
    out.append("#, " + flag + '\n')
    out.append("msgid \"" + i + "\"" + '\n')
    out.append("msgstr \"" + s.replace('\n', '\\n') + "\"" + '\n')

for line in infile:
    if line.has_key('title') and line.has_key('textContent'):
        printstr('-x-svg-edit-both', line['id'], "|".join(((line['title'], line['textContent']))))
    elif line.has_key('title'):
        printstr('-x-svg-edit-title', line['id'], line['title'])
    elif line.has_key('textContent'):
        printstr('-x-svg-edit-textContent', line['id'], line['textContent'])
    elif line.has_key('js_strings'):
        for i, s in line['js_strings'].items():
            printstr('-x-svg-edit-js_strings', i, s)
    else:
        pass # The line wasn't really a string

outfile.writelines(out)
outfile.close()