"""
Yak
---

Yak is a static blog generator, colloquially known as a blog baking engine.

Quickstart
``````````

To get started, run the following command::
    
    yak --build-base

And Yak will build a basic Yak blog structure with a single blog post in the current working directory. Edit the '_config.py' file to configure Yak.

You can now 'bake' a blog from the result of the command above::

    yak

Because no arguments are passed, Yak will use the current working directory as the blog source directory and write the baked blog in the '_site' directory.

All you have to do now is just serve the contents of that directory with the web server of your choice.

Usage
`````

::

    yak [SOURCE_DIR] [OUTPUT_DIR]

If no SOURCE_DIR is passed, the current working directory will be used as the SOURCE_DIR.

If no OUTPUT_DIR is passed, '_site' will be used as the OUTPUT_DIR.

As of the current version, Yak will remove the contents of OUTPUT_DIR before writing the baked blog to OUTPUT_DIR.

Links
`````

* `The making of Yak <http://yak.limelog.net/>`_
* `Author's homepage <http://limeburst.net/>`_

"""

from setuptools import setup

setup(
    name='Yak',
    version='0.1',
    author='Jihyeok Seo',
    author_email='me@limeburst.net',
    url='http://yak.limelog.net/',
    description='A blog baking engine.',
    long_description=__doc__,
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Environment :: Console',
        'License :: OSI Approved :: GNU General Public License (GPL)',
        'Programming Language :: Python',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Software Development :: Libraries :: Python Modules'
    ],
    license='GPL',
    packages=['yak'],
    package_data={'yak': ['data/*']},
    install_requires=['Jinja2', 'Markdown', 'BeautifulSoup'],
    scripts=['bin/yak']
)
