import os
from tests import YozuchTestCase
from yozuch import config

ROOT_DIR = os.path.dirname(__file__)


class ConfigTest(YozuchTestCase):

    def test_merge(self):
        config.merge_from_directory(os.path.join(ROOT_DIR, 'data'))
        self.assertEqual(config.THEME_CONFIG['foo'], 'bar')

        config.merge_from_object({'FOO': 'baz'})
        self.assertEqual(getattr(config, 'FOO'), 'baz')

        config.merge_from_directory(os.path.join(ROOT_DIR, 'data', 'themes', 'test'), ('THEME_CONFIG',))
        self.assertEqual(getattr(config, 'FOO'), 'baz')
        self.assertEqual(config.THEME_CONFIG['foo'], 'bar')
        self.assertEqual(config.THEME_CONFIG['baz'], 'qux')
        self.assertTrue(config.DEBUG)
        self.assertEqual(config.THEME_NAME, 'test')

        self.assertRaises(NameError, lambda: config.merge_from_directory(os.path.join(ROOT_DIR, 'data-invalid')))