import os
from yozuch.rstloader import load_documents
from tests import YozuchTestCase

ROOT_DIR = os.path.dirname(__file__)


class LoaderTest(YozuchTestCase):

    def test_posts(self):
        posts = load_documents(os.path.join(ROOT_DIR, 'data', 'posts'), '*.*')
        self.assertEqual(len(posts), 2)
        self.assertEqual(len(self.logger_handler.messages['error']), 1)

    def test_posts_subdirectory_as_category(self):
        posts = load_documents(os.path.join(ROOT_DIR, 'data', 'posts'), '*.*', subdirectory_as_category=True)
        self.assertEqual(len(posts), 3)
        self.assertEqual(len(self.logger_handler.messages['error']), 1)

    def test_posts_empty(self):
        posts = load_documents(os.path.join(ROOT_DIR, 'data'), '*.*')
        self.assertEqual(len(posts), 0)
        self.assertFalse(self._is_logger_errors())

    def test_page(self):
        page = load_documents(os.path.join(ROOT_DIR, 'data', 'documents'), 'page.rst')[0]
        self.assertFalse(self._is_logger_errors())
        self.assertEqual(page.slug, 'page')