"""
Command line processor.
"""

import argparse
import sys
import os
from yozuch import __version__ as version, __doc__ as description
from yozuch.site import build as build_site
from yozuch.validator import validate
from yozuch.server import serve
from yozuch.project_init import init


def parse_args():
    parser = argparse.ArgumentParser(description=description)
    parser.add_argument('command', choices=['init', 'build', 'version', 'serve'])
    parser.add_argument('project_directory', nargs='?', default=os.getcwd(),
                        help='directory which contains your config.py and content')
    parser.add_argument('-d', '--debug', action='store_true', help='enable debug mode')
    parser.add_argument('-v', '--validate', action='store_true', help='check output for broken internal URLs')
    if len(sys.argv) == 1:
        parser.print_help()
        sys.exit(1)
    return parser.parse_args()


def build(args):
    output_dir = build_site(args.project_directory, {'DEBUG': args.debug})
    if args.validate:
        validate(output_dir)
    return output_dir


def run(args):
    if args.command == 'init':
        init(args.project_directory)
    elif args.command == 'build':
        build(args)
    elif args.command == 'version':
        print(version)
    elif args.command == 'serve':
        serve(args.project_directory, lambda: build(args))


def main():
    run(parse_args())


if __name__ == '__main__':
    main()