import os
from yozuch import logger, rstloader
from yozuch.generators import content_generator, TemplatePageGenerator, TemplateEntryWriter
from yozuch.generators.document import RSTDocumentPublisher
from yozuch.entries import linkitems
from yozuch.utils import format_url_from_object


@content_generator('posts')
class PostGenerator(TemplatePageGenerator):

    def load(self, context, url_template, project_dir, source='*.*', template=None, default_category=None,
             subdirectory_as_category=True, id=None, **kwargs):
        posts_path = os.path.join(project_dir, 'posts')
        if os.path.isdir(posts_path):
            posts = rstloader.load_documents(posts_path, source, default_category=default_category,
                                             subdirectory_as_category=subdirectory_as_category)
            posts = sorted(posts, key=lambda p: p.date)
            linkitems(posts)
            posts = list(reversed(posts))
            if 'posts' not in context['site']:
                context['site']['posts'] = posts
            else:
                context['site']['posts'].extend(posts)
            logger.info('Loaded {} posts'.format(len(posts)))
            for post in posts:
                post.url = format_url_from_object(url_template, post)
                post.template = template
                self._register_document_reference(context, post, project_dir)
                yield post, RSTDocumentPublisher(), TemplateEntryWriter(id, 'post')
        else:
            logger.warning("'post' route is specified but posts directory is not exists")