"""
Generator route helper.
"""


def route(url, generator_name, **kwargs):
    if 'id' not in kwargs:
        kwargs['id'] = generator_name
    return url, generator_name, kwargs


def blog_index(url, **kwargs):
    return route(url, 'blog_index', **kwargs)


def posts(url, **kwargs):
    return route(url, 'posts', **kwargs)


def tags_index(url, **kwargs):
    return route(url, 'tags_index', **kwargs)


def tags(url, **kwargs):
    return route(url, 'tags', **kwargs)


def categories_index(url, **kwargs):
    return route(url, 'categories_index', **kwargs)


def categories(url, **kwargs):
    return route(url, 'categories', **kwargs)


def archive_index(url, **kwargs):
    return route(url, 'archive_index', **kwargs)


def atom(url, **kwargs):
    return route(url, 'atom', **kwargs)


def pages(url, **kwargs):
    return route(url, 'pages', **kwargs)


def documents(url, **kwargs):
    return route(url, 'documents', **kwargs)


def assets(url, directory='assets', **kwargs):
    return route(url, 'assets', directory=directory, **kwargs)