"""
Preview server.
"""

import os
from yozuch import logger
from yozuch.watcher import watch
from yozuch.ttt import SimpleHTTPServer
from yozuch.ttt import SocketServer


class Server(SocketServer.TCPServer):
    allow_reuse_address = True


def serve(directory, build_command):

    os.chdir(build_command())

    stop_watcher = watch(directory, build_command)

    port = 8000
    handler = SimpleHTTPServer.SimpleHTTPRequestHandler
    httpd = Server(('', port), handler)

    logger.info('Serving at port {}'.format(port))
    logger.info('Press "Ctrl+C" to exit')

    try:
        httpd.serve_forever()
    except KeyboardInterrupt:
        logger.info('Shutting down server...')
        httpd.socket.close()

    stop_watcher()