from yozuch.route import blog_index, posts, tags_index, tags, archive_index, categories_index, categories, atom, assets, documents

# Base settings
TITLE = 'Blog title'
URL = 'http://localhost:8000'
DESCRIPTION = 'Blog description'
AUTHOR = 'Name Surname'

THEME_NAME = 'foundation'
THEME_CONFIG = {
    'disqus_shortname': None,     # example
    'google_analytics_id': None,  # UA-xxxxxxxx-x
    'navigation': [
        ('Blog', 'blog_index'),
        ('Tags', 'tags_index'),
        ('Archive', 'archive_index'),
        ('About', '/about/'),
        ('RSS', 'atom')
    ],
    'logo_url': '/'
}

# Routes
ROUTES = (
    blog_index('/'),
    posts('/blog/{date:%Y}/{date:%m}/{date:%d}/{slug}/'),
    tags_index('/tags/'),
    tags('/tag/{slug}/'),
    archive_index('/archive/'),
    atom('/atom.xml'),
    documents('/{slug}/'),
    assets('/{filename}'),
)