"""
Python 2 to 3 compatibility helpers.
"""

import sys

PY2 = sys.version_info[0] == 2


if PY2:
    from cStringIO import StringIO
    from urlparse import urljoin
    import SimpleHTTPServer
    import SocketServer

    iteritems = lambda d: d.iteritems()
    unicode_strip = lambda s: unicode.strip(s)
else:
    from io import StringIO
    from urllib.parse import urljoin
    import http.server as SimpleHTTPServer
    import socketserver as SocketServer

    iteritems = lambda d: iter(d.items())
    unicode_strip = lambda s: s.strip()