"""
Default configuration and configuration related helpers.
"""

import imp
import os
from yozuch.route import blog_index, posts, tags_index, tags, archive_index, categories_index, categories,\
    atom, assets

DEBUG = False

# Base settings
TITLE = 'Site title'
URL = 'http://localhost:8000'
DESCRIPTION = 'Site description'
AUTHOR = 'Name Surname'

THEME_NAME = None
THEME_CONFIG = {}
THEME_DEFAULT_TEMPLATES = {
    'blog_index': 'blog_index.html',
    'posts': 'post.html',
    'tags_index': 'tags_index.html',
    'tags': 'tag.html',
    'categories_index': 'categories_index.html',
    'categories': 'category.html',
    'archive_index': 'archive_index.html',
    'atom': 'atom.xml',
    'documents': 'document.html'
}

# RST parser settings
RST_META_DATE_FORMAT = '%Y-%m-%d'
FILENAME_META_FORMATS = ['(?P<date>\d{4}-\d{2}-\d{2})-(?P<slug>.*)', '(?P<slug>.*)']
FILENAME_META_DATE_FORMAT = '%Y-%m-%d'
DOCUMENT_FILE_EXTENSIONS = ['.rst']
ADD_HEADING_PERMALINK = False
PERMALINK_TEXT = '&#x00b6;'

# Page loader
PAGE_FILE_EXTENSIONS = ['.html', '.xml']

# Routes
ROUTES = (
    blog_index('/'),
    posts('/blog/{date:%Y}/{date:%m}/{date:%d}/{slug}/'),
    tags_index('/tags/'),
    tags('/tag/{slug}/'),
    categories_index('/categories/'),
    categories('/category/{slug}/'),
    archive_index('/archive/'),
    atom('/atom.xml'),
    assets('/{filename}'),
)

# Internal
PACKAGE_DIR = os.path.dirname(__file__)


def merge_from_directory(source_dir, merge_props=None):
    try:
        fp, pathname, description = imp.find_module('config', [source_dir])
        try:
            module = imp.load_module('user_config', fp, pathname, description)
            module_props = dir(module)
            if merge_props is None:
                globals().update({
                    prop: getattr(module, prop) for prop in module_props if prop.isupper()
                })
            else:
                for prop in merge_props:
                    if prop in module_props:
                        val = getattr(module, prop)
                        val.update(globals()[prop])
                        globals()[prop].update(val)
        finally:
            fp.close()
    except ImportError:
        pass


def merge_from_theme_directory(source_dir):
    merge_from_directory(source_dir, ('THEME_CONFIG', 'THEME_DEFAULT_TEMPLATES'))


def merge_from_object(props):
    globals().update(props)