import os
import shutil
import fnmatch
from yozuch import logger, utils
from yozuch.generators import content_generator, ContentGeneratorBase, WriterBase
from yozuch.entries import AssetSiteEntry


def fnmatch_patterns(name, patterns):
    return any([fnmatch.fnmatch(name, pattern) for pattern in patterns])


@content_generator('assets')
class AssetGenerator(ContentGeneratorBase):

    DEFAULT_IGNORE_PATTERNS = ('.DS_Store',)

    class AssetWriter(WriterBase):

        def write(self, entry, context, env, output_dir):
            path = os.path.join(output_dir, utils.path_from_url(entry.url))
            utils.makedirs(os.path.dirname(path))
            shutil.copyfile(entry.source_path, path)

    def load(self, context, url_template, project_dir, directory=None, ignore=DEFAULT_IGNORE_PATTERNS, **kwargs):
        source_dir = directory
        if not os.path.isdir(source_dir):
            source_dir = os.path.join(project_dir, directory)
        if os.path.isdir(source_dir):
            logger.info('Processing assets directory {}...'.format(directory))
            for root, _, files in os.walk(source_dir):
                for filename in files:
                    source_path = os.path.join(root, filename)
                    relpath = os.path.relpath(source_path, source_dir)
                    if ignore is None or (not fnmatch_patterns(filename, ignore) and not fnmatch_patterns(relpath, ignore)):
                        url = url_template.format(filename=relpath)
                        yield AssetSiteEntry(source_path, url), None, self.AssetWriter()