import os
from yozuch import logger, rstparser, rstloader
from yozuch.generators import content_generator, TemplatePageGenerator, TemplateEntryWriter, PublisherBase
from yozuch.utils import format_url_from_object


class RSTDocumentPublisher(PublisherBase):

    def _publish_document(self, parser, entry, context):
        config = context['config']
        rooturl = config.URL if not config.DEBUG else None
        permalink_text = config.PERMALINK_TEXT if config.ADD_HEADING_PERMALINK else None
        parser.publish(entry, context.get('references', None), rooturl, permalink_text)

    def publish(self, entry, context):
        self._publish_document(rstparser, entry, context)


@content_generator('documents')
class DocumentGenerator(TemplatePageGenerator):

    def _load_document(self, context, url_template, project_dir, template, id, entry):
        logger.info('Loaded document {}...'.format(entry.source_path))
        entry.url = format_url_from_object(url_template, entry)
        entry.template = template
        self._register_document_reference(context, entry, project_dir)
        return entry, RSTDocumentPublisher(), TemplateEntryWriter(id, 'document')

    def load(self, context, url_template, project_dir, source='*.*', template=None, id=None, **kwargs):
        content_dir = os.path.join(project_dir, 'documents')
        if os.path.isdir(content_dir):
            for doc in rstloader.load_documents(content_dir, source):
                yield self._load_document(context, url_template, project_dir, template, id, doc)
        else:
            logger.warning("'document' route is specified but documents directory is not exists")